/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_clienthandler_AudioRouteMgr_AudioFunc.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA client-handler for the service AudioRouteMgr_AudioFunc.
*
* AUTHOR:       Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define STR_STR_STR
#include "../FC_StreamRouter/FC_StreamRouter_routingtable.h"
#include "../FC_StreamRouter/FC_StreamRouter_ucid_defs.h"
#include "../FC_StreamRouter/FC_StreamRouter_fwdtable.h"

#include "../fc_audioroutemgr_main.h"
#include "../ResourceMgmt/fc_audioroutemgr_audiosource.h"
#include "fc_audioroutemgr_clienthandler_audiofunc.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

                                          //Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO

#include "midw_fi_if.h"
#define COMP_MUTE_NONE 0

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../Trace/fc_audioroutemgr_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOFUNC
#include "trcGenProj/Header/fc_audioroutemgr_clienthandler_audiofunc.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

                                             // Version defines for used service
#define AUDIOROUTEMGR_AUDIOFUNC_FI_MAJOR_VERSION  1
#define AUDIOROUTEMGR_AUDIOFUNC_FI_MINOR_VERSION  0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_AUDIOSOURCE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleAudioSource_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_SET_MUTE_RAMP, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSetMuteRamp_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_MUTE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleMute_MethodResult)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_MUTE, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleMute_Error)

ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleAmpDevAudioRoute_MethodResult)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*             fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(fc_audioroutemgr_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
  fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(fc_audioroutemgr_tclApp* poMainAppl,fc_audioroutemgr_tclresourcemanager* poResourceMgr)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_AUDIOFUNC,
      /* MajorVersion of used Service */ AUDIOROUTEMGR_AUDIOFUNC_FI_MAJOR_VERSION,
      /* MinorVersion of used Service */ AUDIOROUTEMGR_AUDIOFUNC_FI_MINOR_VERSION
                                       )
{
    ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc() entered."));
    m_u8Channel = (tU8)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;
    m_u8Source = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
    m_u16SubSource = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
    m_u8MuteState = (tU8)midw_fi_tcl_e8_MuteState::FI_EN_MUTE;
    m_poResourceManager = poResourceMgr;
    m_poMainAppl = poMainAppl;

  memset(m_u8CompMuteState,COMP_MUTE_NONE, sizeof(m_u8CompMuteState) );
  memset(m_bComponentMuteFlag,FALSE, sizeof(m_u8CompRequestingSource) );
  memset(m_u8CompRequestingSource,(tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE, sizeof(m_u8CompRequestingSource) );

    #define EXT_FI_AUD_SOURCE_TO_EDTYPE
    #define addData(a,b) m_MapSrcToEDType.insert(make_pair(a,b));
    #include "../Config/SourceToEDtypeConverter.conf"
    #undef addData
    #undef EXT_FI_AUD_SOURCE_TO_EDTYPE
}

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*             ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
  ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(tVoid)
{
  ETG_TRACE_USR4(("~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc() entered."));

  m_poResourceManager = OSAL_NULL;
  m_poMainAppl = OSAL_NULL;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vOnServiceAvailable()
{
  ETG_TRACE_USR1(("vOnServiceAvailable() entered. AppID = %u.",
                  u16GetServerAppID()));
  // tell the own service about this
  if((_poMainAppl != NULL) && (m_poMainAppl != NULL))
  {
    //Send all pending mute messages

    for(std::map<midw_fi_tcl_e8_AudioChannel::tenType, midw_fi_tcl_e8MuteAction::tenType>::iterator it = m_pendingmute.begin();it!=m_pendingmute.end();it++)
    {
      bSendARMMuteMessage(it->second,it->first);
    }

    // FC_AudioManager became available
    m_poMainAppl->vAudioManagerAvailable();
  }
  else
  {
    // FATAL, pointer to MainAppl is NULL
    ETG_TRACE_ERR(("_poManAppl or m_poMainAppl is NULL"));
  }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                  u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

  if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vTraceRx(tU32 size, tPCUChar pcu8Data)
*
* DESCRIPTION: Receives TTFis Trace Commands.
*
* PARAMETER:   tU16 size, tPCUChar pcu8Data.
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
     ETG_TRACE_USR4(("AudioRouteMgr_AudioFunc::vTraceRx() entered."));

     if(pcu8Data == OSAL_NULL) return;
     // pcu8Data[0] == my file number
     // pcu8Data[1] == the command
     // pcu8Data[2] == the 1. parameter
     // rest is defined here

     ETG_TRACE_USR4(("vTraceRx() size=%u", size));
     if (size > 1)
     {
      ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
        switch ( pcu8Data[1] )
        {
        case TRC::NotifyMute:
           ETG_TRACE_USR4(("TTFis Rx NotifyMute"));
           if (size > 4)
              {
                if(m_poResourceManager != OSAL_NULL)
                {
                  m_poResourceManager->vNotifyMute(pcu8Data[1],pcu8Data[2], pcu8Data[3], pcu8Data[4]);
                }
              }
           else
             ETG_TRACE_USR4(("NotifyMute too few params %u",size));
        break;
        case TRC::TestSpeakerDiagnosisStart:
           vPerformSpeakerTest();
        break;
        default:
          ETG_TRACE_USR4(("default"));
          break;
        }
     }
}


/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vHandleAudioSource_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Audio Source Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vHandleAudioSource_MethodResult(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR4(("vHandleAudioSource_MethodResult() entered"));

   if(poMessage)
   {
     fi_tclVisitorMessage oVisitorMsg(poMessage);

     midw_mascffi_tclMsgAudioSourceMethodResult oMethodResult;

     if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_AUDIOFUNC_FI_MAJOR_VERSION) != OSAL_ERROR)
      {
        ETG_TRACE_USR4(("received oMethodResult.ServiceStatus.enType = %x",oMethodResult.ServiceStatus.enType));
      }
     oMethodResult.vDestroy();
   }
   else
    {
         //My message is a NULL Pointer
      ETG_TRACE_ERR(("vHandleAudioSource_MethodResult() message is NULL"));
       NORMAL_M_ASSERT_ALWAYS();
    }
}


/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vHandleSetMuteRamp_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the MuteRamp Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vHandleSetMuteRamp_MethodResult(amt_tclServiceData* poMessage) const
{
   ETG_TRACE_USR4(("vHandleSetMuteRampMethodResult() entered"));
   if(poMessage)
    {
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    midw_mascffi_tclMsgSet_Mute_RampMethodResult oMethodResult;

     if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_AUDIOFUNC_FI_MAJOR_VERSION) != OSAL_ERROR)
      {
        ETG_TRACE_USR4(("received oMethodResult.ServiceStatus.enType = %x",oMethodResult.ServiceStatus.enType));
      }
     oMethodResult.vDestroy();
     }
     else
     {
        //My message is a NULL Pointer
          ETG_TRACE_ERR(("vHandleSetMuteRamp_MethodResult() message is NULL"));
        NORMAL_M_ASSERT_ALWAYS();
     }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vHandleMute_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Mute Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vHandleMute_MethodResult(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vHandleMute_MethodResult() entered"));

   if(poMessage)
   {
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    midw_mascffi_tclMsgMuteMethodResult oMethodResult;

    if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_AUDIOFUNC_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
      ETG_TRACE_USR4(("received oMethodResult.State.enType = 0x%x",ETG_CENUM(source::enSrcMuteState,(tU8)oMethodResult.State.enType)));
      ETG_TRACE_USR4(("received oMethodResult.Channel.enType = 0x%x",ETG_ENUM(Audio_Channel,(tU8)oMethodResult.Channel.enType)));
      ETG_TRACE_USR4(("received oMethodResult.Resource.enType = 0x%x",ETG_ENUM(Audio_Channel,(tU8)oMethodResult.Resource.enType)));
    }

    midw_fi_tcl_e8_MuteState ::tenType MuteState = oMethodResult.State.enType;
    tU8 Channel = (tU8)oMethodResult.Channel.enType;
    source* poSourcePtr = OSAL_NULL;

    //Clear it from pending queue
    m_pendingmute.erase(oMethodResult.Channel.enType);

    if(OSAL_NULL != poSourceFactory() && (OSAL_NULL != m_poResourceManager))
    {
    poSourcePtr = poSourceFactory()->poSourcePtr(m_u8CompRequestingSource[Channel]);

    /*
      ETG_TRACE_USR4(("ADDED: Check ComponentMuteValues"));
      ETG_TRACE_USR4(("ADDED: m_bComponentMuteFlag[Channel] = %d, with Channel %d",m_bComponentMuteFlag[Channel],Channel));
      ETG_TRACE_USR4(("ADDED: m_u8CompMuteState[Channel] = %d, with Channel %d",m_u8CompMuteState[Channel],Channel));
      ETG_TRACE_USR4(("ADDED: poSourcePtr->isComponentMuteActive(Resource) = %d for Resource %d",poSourcePtr->isComponentMuteActive(oMethodResult.Resource.enType),oMethodResult.Resource.enType));
   */

      if(!(m_bComponentMuteFlag[Channel] && poSourcePtr->isComponentMuteActive(oMethodResult.Resource.enType)))
      {
         ETG_TRACE_USR4(("ComponentMuteValues are not active"));
         m_poResourceManager->vNotifyMute(m_u8Source, m_u16SubSource,(tU8)MuteState, Channel,(tU16)oMethodResult.Resource.enType);
      }
      if(OSAL_NULL != poSourcePtr)
      {
        if(m_bComponentMuteFlag[Channel] && m_u8CompMuteState[Channel] == (tU8)MuteState)
        {   /* Handling for Component Mute */
          if(OSAL_NULL != poSourceFactory()->getClientHandler(poSourcePtr->u16GetAppID()))
          {
          poSourceFactory()->getClientHandler(poSourcePtr->u16GetAppID())->vPerformSetMuteState(m_u8CompRequestingSource[Channel],(tU8)MuteState);
          m_bComponentMuteFlag[Channel] = FALSE;
          m_u8CompMuteState[Channel] = COMP_MUTE_NONE;
          ETG_TRACE_USR4(("Setting Component Mute Set to FALSE"));
          poSourcePtr->vSetisComponentMuteActive(oMethodResult.Resource.enType,false);
          //RTC1-2444855 To Avoid Entering NotifyMute if ComponentMute is Active.
          }
          }
        }
      oMethodResult.vDestroy();
     }

     else
       {
       //My message is a NULL Pointer
    ETG_TRACE_ERR(("vHandleMute_MethodResult() message is NULL"));
      NORMAL_M_ASSERT_ALWAYS();
       }
    }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vHandleMute_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Mute Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vHandleMute_Error(amt_tclServiceData* poMessage) const
{
  ETG_TRACE_USR4(("vHandleMute_Error() entered."));

   amt_tclServiceDataError oErrorMsg( poMessage );
   tU16 u16ErrorCode = oErrorMsg.u16GetErrorData();

   ETG_TRACE_ERR(("vHandleMute_Error::Error Code:%d",u16ErrorCode));
   if(m_poResourceManager != OSAL_NULL)
   {
    /* On Mute Error, Self trigger for MuteResult according to Error Handling concept */
    m_poResourceManager->vNotifyMute(m_u8Source, m_u16SubSource, m_u8MuteState, m_u8Channel);
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vPerformMute(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Mute the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMute(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMute set Sink to 1"));
  vPerformMute(CurSrc,PosNextSrc, SubSource, 1);
}

/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMute(tU8 CurSrc,tU8 PosNextSrc, tU16 /*SubSource*/, tU16 Sink)
{

  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMute for Sink %d", Sink));

  (tVoid)PosNextSrc;  // Lint
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
    poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

    if(_poMainAppl != OSAL_NULL && OSAL_NULL != poSourcePtr && m_poResourceManager != OSAL_NULL)
     {
      midw_mascffi_tclMsgMuteMethodStart oMute;
      oMute.Requester.enType = midw_fi_tcl_e8_MuteRequester::FI_EN_AUDIOROUTINGMANAGER;
      //oMute.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oMute.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Sink;
      oMute.State.enType = midw_fi_tcl_e8MuteAction::FI_EN_MUTE;
      oMute.Reason.u32Value =  midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL;

      midw_fi_tcl_e8_AudioChannel::tenType u8SrcSupportedChannel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;

      u8SrcSupportedChannel = (midw_fi_tcl_e8_AudioChannel::tenType)poSourcePtr->u8GetSourceSupportedStream();

      oMute.Channel.enType = u8SrcSupportedChannel;


        m_u8MuteState = (tU8) midw_fi_tcl_e8MuteAction::FI_EN_MUTE;
      m_u8Channel = (tU8)oMute.Channel.enType;

        ETG_TRACE_USR4(("First MuteState: %d, Channel: %d , CurSrc = %d",(tU8)oMute.State.enType,(tU8)oMute.Channel.enType,(tU8)CurSrc));

        fi_tclVisitorMessage oCCaMsg(oMute);
        oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),   // Source AppID
                      CCA_C_U16_APP_AUDIO,        // Target AppID
                      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                      0,
                      u16GetRegID(),
                      0,
                      CCA_C_U16_SRV_AUDIOFUNC,
                      MIDW_MASCFFI_C_U16_MUTE,
                      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                        );

         if(bIfServiceAvailable())
         {
             if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
            {
              ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Mute"));
              NORMAL_M_ASSERT_ALWAYS();
              }
            else
            {
              ETG_TRACE_USR4(("Sending Mute Successfull"));
            }
           }
         else
         { /* On service unavailability, Self trigger for MuteResult accrding to Error Handling concept */
           m_poResourceManager->vNotifyMute(m_u8Source, m_u16SubSource, (tU8)oMute.State.enType, (tU8)oMute.Channel.enType,Sink);
           ETG_TRACE_ERR(("Audio Function service not available"));
         }
      //Copy the mute request here
      m_pendingmute[oMute.Channel.enType]= oMute.State.enType;

         oMute.vDestroy();
        }
       else
      {
        ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
        ETG_TRACE_ERR(("Sending Mute ERROR !!!!"));
      }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vPerformMute_Ramp(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to perform MuteRamp based on Possible Next Source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMute_Ramp(tU8 CurSrc,tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered AudioFunc::vPerformMute_Ramp set Sink 1"));
  vPerformMute_Ramp(CurSrc, PosNextSrc, 1);
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMute_Ramp(tU8 /*CurSrc*/,tU8 PosNextSrc, tU16 Sink)
{
    ETG_TRACE_USR4(("Entered AudioFunc::vPerformMute_Ramp"));

    (tVoid)PosNextSrc; // Lint
    source* poSourcePtr = OSAL_NULL;

    if(OSAL_NULL != poSourceFactory())
    poSourcePtr = poSourceFactory()->poSourcePtr(PosNextSrc);

    if(OSAL_NULL != _poMainAppl && OSAL_NULL != poSourcePtr)
     {
      tU16 Mute_Ramp;
      Mute_Ramp = poSourcePtr->u16GetMuteRamp();

      midw_mascffi_tclMsgSet_Mute_RampMethodStart oMuteRamp;
      //oMuteRamp.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oMuteRamp.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Sink;
      oMuteRamp.State.enType = (midw_fi_tcl_e8MuteSpeed::tenType)Mute_Ramp;
      oMuteRamp.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType)poSourcePtr->u8GetSourceSupportedStream();

      fi_tclVisitorMessage oCCaMsg(oMuteRamp);
      oCCaMsg.vInitServiceData(  _poMainAppl->u16GetAppId(),   // Source AppID
                   CCA_C_U16_APP_AUDIO,        // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_AUDIOFUNC,
                   MIDW_MASCFFI_C_U16_SET_MUTE_RAMP,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                     );

       if(bIfServiceAvailable())
       {
            if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
            {
              ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Mute Ramp "));
              NORMAL_M_ASSERT_ALWAYS();
              }
            else
            {
              ETG_TRACE_USR4(("Sending Mute Ramp Successful"));
            }
       }
       else
       {
         ETG_TRACE_ERR(("Audio Function service not available"));
       }
       oMuteRamp.vDestroy();
    }
   else
    {
       ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
       ETG_TRACE_ERR(("Sending Mute Ramp ERROR !!!!"));
    }
}

/*******************************************************************************
*
* FUNCTION: vPerformSpeakerTest()
*
*
* DESCRIPTION: Send MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART to Audiomanager
*              to trigger a Speaker Diagnosis for testing purpose
*
* PARAMETER:
*
* RETURNVALUE:
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformSpeakerTest()
{
     ETG_TRACE_USR4(("Entered AudioFunc::vPerformSpeakerTest"));
     if(_poMainAppl != OSAL_NULL && poSourceFactory() != OSAL_NULL)
     {
        midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart oSpeakerStart;

        oSpeakerStart.DC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_QUALIFIED;
        oSpeakerStart.AC_Mode.enType = midw_fi_tcl_e8_DiagMode::FI_EN_OFF;

        fi_tclVisitorMessage oCCaMsg(oSpeakerStart);
        oCCaMsg.vInitServiceData(  _poMainAppl->u16GetAppId(),    // Source AppID
                            CCA_C_U16_APP_AUDIO,         // Target AppID
                            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                            0,
                            u16GetRegID(),
                            0,
                            CCA_C_U16_SRV_AUDIOFUNC,
                            MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART,
                            AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                           );

         if(bIfServiceAvailable())
         {
                  if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
                  {
                     ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Speaker Diagnosis Test "));
                     NORMAL_M_ASSERT_ALWAYS();
                   }
                  else
                  {
                     ETG_TRACE_USR4(("Sending Speaker Diagnosis Test Successful"));
                  }
         }
         else
         {
            ETG_TRACE_ERR(("Audio Function service not available"));
         }
         oSpeakerStart.vDestroy();
     }
    else
     {
         ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
         ETG_TRACE_ERR(("Sending Speaker Diagnosis Test ERROR !!!!"));
     }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vPerformMute(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Mute the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMuteOnAppStateChange()
{

  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMuteOnAppStateChange() entered"));

  if(_poMainAppl != OSAL_NULL && poSourceFactory() != OSAL_NULL && m_poResourceManager != OSAL_NULL)
  {
    midw_mascffi_tclMsgMuteMethodStart oMute;
    oMute.Requester.enType = midw_fi_tcl_e8_MuteRequester::FI_EN_AUDIOROUTINGMANAGER;
    oMute.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oMute.State.enType = midw_fi_tcl_e8MuteAction::FI_EN_MUTE;
    oMute.Reason.u32Value =  midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL;

    vMuteRequestonChannel(oMute, midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
    vMuteRequestonChannel(oMute, midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX);
    vMuteRequestonChannel(oMute, midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX2);

    oMute.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
    ETG_TRACE_ERR(("Sending Mute ERROR !!!!"));
  }

}

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformMuteRampOnAppStateChange()
{
    midw_mascffi_tclMsgSet_Mute_RampMethodStart oMuteRamp;

    oMuteRamp.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;

    oMuteRamp.State.enType = midw_fi_tcl_e8MuteSpeed::FI_EN_SLOW;

    fi_tclVisitorMessage oCCaMsg(oMuteRamp);
    oCCaMsg.vInitServiceData(  _poMainAppl->u16GetAppId(),   // Source AppID
      CCA_C_U16_APP_AUDIO,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUDIOFUNC,
      MIDW_MASCFFI_C_U16_SET_MUTE_RAMP,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
      if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Mute Ramp "));
        NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
        ETG_TRACE_USR4(("Sending Mute Ramp Successful"));
      }
    }
    else
    {
      ETG_TRACE_ERR(("Audio Function service not available"));
    }
    oMuteRamp.vDestroy();
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vMuteRequestonChannel(midw_mascffi_tclMsgMuteMethodStart oMute, midw_fi_tcl_e8_AudioChannel oChannel)
*
* DESCRIPTION: Sends the CCA Message to Mute the active streams
*
* PARAMETER:   midw_mascffi_tclMsgMuteMethodStart oMute, midw_fi_tcl_e8_AudioChannel oChannel
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vMuteRequestonChannel(midw_mascffi_tclMsgMuteMethodStart oMute, midw_fi_tcl_e8_AudioChannel::tenType oChannel)
{
    m_u8MuteState = (tU8) midw_fi_tcl_e8MuteAction::FI_EN_MUTE;
    oMute.Channel.enType = oChannel;
    m_u8Channel = (tU8)oChannel;

    fi_tclVisitorMessage oCCaMsg(oMute);
    oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),   // Source AppID
      CCA_C_U16_APP_AUDIO,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUDIOFUNC,
      MIDW_MASCFFI_C_U16_MUTE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
      if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Mute"));
        NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
        ETG_TRACE_USR4(("Sending Mute Successful"));
      }
    }
    else
    {
      ETG_TRACE_USR4(("Service is not available"));
    }
    m_pendingmute[oMute.Channel.enType]= oMute.State.enType;
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vPerformDeMute(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Demute the New Source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformDeMute(tU8 CurSrc,tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered AudioFunc::vPerformDeMute set Sink to 1"));
  vPerformDeMute(CurSrc,PosNextSrc, 1);
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformDeMute(tU8 CurSrc,tU8 PosNextSrc,tU16 Sink)
{
  ETG_TRACE_USR4(("Entered AudioFunc::vPerformDeMute for SInk %d",Sink));
  (tVoid)PosNextSrc;  // Lint

  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
     poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

  if(_poMainAppl != OSAL_NULL)
    {
    midw_mascffi_tclMsgMuteMethodStart oDeMute;
    oDeMute.Requester.enType = midw_fi_tcl_e8_MuteRequester::FI_EN_AUDIOROUTINGMANAGER;
    //oDeMute.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oDeMute.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Sink;
    oDeMute.State.enType = midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE;
    oDeMute.Reason.u32Value = midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL;

    if(OSAL_NULL != poSourcePtr)
     oDeMute.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType)poSourcePtr->u8GetSourceSupportedStream();

        m_u8MuteState = (tU8) midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE;
      m_u8Channel = (tU8)oDeMute.Channel.enType;

    fi_tclVisitorMessage oCCaMsg(oDeMute);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                  CCA_C_U16_APP_AUDIO,    // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_AUDIOFUNC,
                   MIDW_MASCFFI_C_U16_MUTE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                 );

      if(bIfServiceAvailable())
        {
            tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg);
          if(u16ErrCode == (tU16)AIL_EN_N_NO_ERROR)
          {
             ETG_TRACE_USR4(("Sending Demute Successful"));
             if(m_poResourceManager != OSAL_NULL)
             {
                ETG_TRACE_ERR(("ADDED: Notify Demute immediately"));//Bug 2195887-Abnormal behaviour during source switch between media and tuner sources
                m_poResourceManager->vNotifyMute(m_u8Source, m_u16SubSource, (tU8)oDeMute.State.enType, (tU8)oDeMute.Channel.enType,Sink);
             }

          }
          else
          {
            ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Demute. Error:%d",u16ErrCode));
          }
        }
      m_pendingmute[oDeMute.Channel.enType]= oDeMute.State.enType;
      oDeMute.vDestroy();
    }
    else
    {
      ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
      ETG_TRACE_ERR(("Sending DeMute ERROR !!!!"));
    }
}
/**
* Helper function to sendout a mute message
*/
tBool fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::bSendARMMuteMessage(midw_fi_tcl_e8MuteAction::tenType action,const midw_fi_tcl_e8_AudioChannel::tenType channel)
{
  tBool bret = false;
  if(_poMainAppl != OSAL_NULL)
    {
    midw_mascffi_tclMsgMuteMethodStart oMute;
    oMute.Requester.enType = midw_fi_tcl_e8_MuteRequester::FI_EN_AUDIOROUTINGMANAGER;
    oMute.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    oMute.State.enType = action;
    oMute.Reason.u32Value = midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL;
    oMute.Channel.enType = channel;

    fi_tclVisitorMessage oCCaMsg(oMute);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                  CCA_C_U16_APP_AUDIO,    // Target AppID
                   AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                   0,
                   u16GetRegID(),
                   0,
                   CCA_C_U16_SRV_AUDIOFUNC,
                   MIDW_MASCFFI_C_U16_MUTE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                 );

      if(bIfServiceAvailable())
        {
            tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg);
          if(u16ErrCode != (tU16)AIL_EN_N_NO_ERROR)
          {
            ETG_TRACE_ERR(("FAILED SENDING CCA MSG: ARM mute. Error:%d",u16ErrCode));
          }
          else
          {
            bret = true;
          }
        }
        else
        {
          ETG_TRACE_ERR(("Audio Function service not available"));
        }
      oMute.vDestroy();
    }
    else
    {
      ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
    }
  return bret;
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vStartAudioSource(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to set the Audio Source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/


tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vStartAudioSource(tU8 CurSrc,tU8 PosNextSrc)
{
  ETG_TRACE_USR4(("Entered AudioFunc::vStartAudioSource set Sink to 1"));
  vStartAudioSource(CurSrc, PosNextSrc, 1);
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vStartAudioSource(tU8 CurSrc,tU8 PosNextSrc, tU16 Sink)
{
  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
     poSourcePtr = poSourceFactory()->poSourcePtr(CurSrc);

      ETG_TRACE_USR4(("Entered AudioFunc::vStartAudioSource Source %d, NextSrc %d, Sink %d",CurSrc,PosNextSrc,Sink));

      (tVoid)CurSrc;

      if(_poMainAppl != OSAL_NULL)
      {
      midw_mascffi_tclMsgAudioSourceMethodStart oaudiosource;

      //oaudiosource.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oaudiosource.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Sink;
      oaudiosource.Source.enType = (midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;

  if(OSAL_NULL != poSourcePtr)
      oaudiosource.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType)poSourcePtr->u8GetSourceSupportedStream();

    ETG_TRACE_USR4(("Source : %d, Resource : %d, Channel : %d", oaudiosource.Source.enType, oaudiosource.Resource.enType, oaudiosource.Channel.enType));

      fi_tclVisitorMessage oCCaMsg(oaudiosource);
      oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
                    CCA_C_U16_APP_AUDIO,  // Target AppID
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                     0,
                     u16GetRegID(),
                     0,
                     CCA_C_U16_SRV_AUDIOFUNC,
                     MIDW_MASCFFI_C_U16_AUDIOSOURCE,
                     AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                    );

        if(bIfServiceAvailable())
        {
          if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) != AIL_EN_N_NO_ERROR)
          {
            ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Audio source "));
            NORMAL_M_ASSERT_ALWAYS();
            }
          else
          {
            ETG_TRACE_USR4(("Setting Audio source Successful"));
          }
        }
        else
        {
          ETG_TRACE_ERR(("Audio Function service not available"));
        }
        oaudiosource.vDestroy();
     }

    else
    {
      ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
      ETG_TRACE_ERR(("Sending Mute ERROR !!!!"));
    }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vPerformComponentMute(tU8 Requester,tU8 Resource,tU8 State,tU32 Reason)
*
* DESCRIPTION: Sends the CCA Message to Mute the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformComponentMute(tU8 requestingSource,tU8 State,tU32 Reason,tU8 Channel, tU8 Requester,tU8 Resource)
{

  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vPerformComponentMute"));
  ETG_TRACE_USR4(("Requester: %d,Resource:%d,State:%d,Reason:%d",Requester,Resource,State,Reason));

  source* poSourcePtr = OSAL_NULL;

  if(OSAL_NULL != poSourceFactory())
     poSourcePtr = poSourceFactory()->poSourcePtr(requestingSource);

    if(_poMainAppl != OSAL_NULL)
     {
        midw_mascffi_tclMsgMuteMethodStart oMute;
        oMute.Requester.enType = (midw_fi_tcl_e8_MuteRequester::tenType)Requester;
        oMute.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Resource;
        oMute.State.enType = (midw_fi_tcl_e8MuteAction::tenType)State;
        oMute.Reason.u32Value = Reason;
        oMute.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType)Channel;
        m_u8CompMuteState[Channel] = (tU8)State;

        ETG_TRACE_USR4(("Requester: %d,Resource:%d,State:%d,Reason:%d",oMute.Requester.enType,oMute.Resource.enType,
                                                                 oMute.State.enType,oMute.Reason.u32Value));
        fi_tclVisitorMessage oCCaMsg(oMute);
        oCCaMsg.vInitServiceData(   _poMainAppl->u16GetAppId(),   // Source AppID
                  CCA_C_U16_APP_AUDIO,        // Target AppID
                  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                  0,
                  u16GetRegID(),
                  0,
                  CCA_C_U16_SRV_AUDIOFUNC,
                  MIDW_MASCFFI_C_U16_MUTE,
                  AMT_C_U8_CCAMSG_OPCODE_METHODSTART
                  );
        if(bIfServiceAvailable())
        {
           if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
           {
              ETG_TRACE_ERR(("FAILED SENDING CCA MSG: Mute"));
              NORMAL_M_ASSERT_ALWAYS();
           }
           else
           {
              ETG_TRACE_USR4(("Setting Component Mute Successful"));
              m_bComponentMuteFlag[Channel] = TRUE;
              m_u8CompRequestingSource[Channel] = requestingSource;
              /*Setting Component Mute state*/

              if(OSAL_NULL != poSourcePtr)
	      {
                 poSourcePtr->vSetCompMuteState((source::enSrcMuteState)State);
                 ETG_TRACE_USR4(("Setting Component Mute Set to TRUE"));
                 //RTC1-2444855 To Avoid Entering NotifyMute if ComponentMute is Active.
                 poSourcePtr->vSetisComponentMuteActive(oMute.Resource.enType,true);
	      }
	   }
        }
        else
        {
           ETG_TRACE_ERR(("Audio Function service not available"));
        }
        oMute.vDestroy();
     }
     else
     {
        ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
        ETG_TRACE_ERR(("Sending Mute ERROR !!!!"));
     }
}

/*!***********************************************************************
* METHOD:      fc_audioroutemgr_tclsourcefactory*
*                    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*                                                    poSourceFactory() const
* DESCRIPTION:     Returns SourceFactory class Pointer
*
* PARAMETER  :     None.
*
* RETURNVALUE:     fc_audioroutemgr_tclsourcefactory
*************************************************************************/
fc_audioroutemgr_tclsourcefactory* fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::poSourceFactory() const
{
    fc_audioroutemgr_tclsourcefactory *poSrcFactry = OSAL_NULL;

  if(m_poMainAppl != OSAL_NULL)
     {
    return m_poMainAppl->poGetSourceFactory();
   }
  else
  {
    return poSrcFactry;
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*               vSendSourceIputGainToFCAM(tU8 Source, tS32 Offset)
*
* DESCRIPTION: Sends the CCA Message to set the InputGain in FC_AM
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vSendAudioPropertyDataToFCAM(tU8 Source, tU8 Type, tS32 Offset)
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vSendAudioPropertyDataToFCAM"));

    midw_mascffi_tclMsgSetAudioPropertySet oSetAudioProperty;

  oSetAudioProperty.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)Source;
  oSetAudioProperty.u8Property.enType = (midw_fi_tcl_e8_AudioProperty::tenType)Type;
  oSetAudioProperty.s32PropValue = Offset;

  ETG_TRACE_USR4(("Source : %d, Type : %d, Offset : %d", oSetAudioProperty.u8Source.enType, oSetAudioProperty.u8Property.enType, oSetAudioProperty.s32PropValue));

  fi_tclVisitorMessage oCCaMsg(oSetAudioProperty);

  if(_poMainAppl != OSAL_NULL)
  {
       oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),   // Source AppID
                CCA_C_U16_APP_AUDIO,        // Target AppID
                AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                0,
                u16GetRegID(),
                0,
                CCA_C_U16_SRV_AUDIOFUNC,
                MIDW_MASCFFI_C_U16_SETAUDIOPROPERTY,
                AMT_C_U8_CCAMSG_OPCODE_SET
                );

      if(bIfServiceAvailable())
       {
          if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
          {
            ETG_TRACE_ERR(("FAILED SENDING CCA MSG: InputGain"));
            NORMAL_M_ASSERT_ALWAYS();
            }
          else
          {
            ETG_TRACE_USR4(("Setting Input Gain Successful"));
          }
             }
       else
       {
        ETG_TRACE_ERR(("Audio Function service not available"));
       }

      oSetAudioProperty.vDestroy();
       }
   else
     {
      ETG_TRACE_ERR(("Fatal Error: poCcaMainApp = NULL"));
      ETG_TRACE_ERR(("Setting Input Gain ERROR !!!!"));
     }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::
*                          vSetVolumeLock(source::enVolumeLockType Locktype)
*
* DESCRIPTION: Sends the CCA Message to set the VolumeLock in FC_AM
*
* PARAMETER:   source::enVolumeLockType Locktype
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vSetVolumeLock(source::enVolumeLockType Locktype)
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vSetVolumeLock"));

  midw_mascffi_tclMsgVolumeLockSet oVolLockSet;
  oVolLockSet.VolumeLockType.enType = (midw_fi_tcl_e8_VolumeLock::tenType)Locktype;
  oVolLockSet.Requester.enType = midw_fi_tcl_e8_Requester::FI_EN_AUDIOROUTINGMANAGER;

  fi_tclVisitorMessage oCCaMsg(oVolLockSet);
  if(_poMainAppl != OSAL_NULL)
  {
       oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),   // Source AppID
                CCA_C_U16_APP_AUDIO,        // Target AppID
                AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                0,
                u16GetRegID(),
                0,
                CCA_C_U16_SRV_AUDIOFUNC,
                MIDW_MASCFFI_C_U16_VOLUMELOCK,
                AMT_C_U8_CCAMSG_OPCODE_SET
                );

      if(bIfServiceAvailable())
       {
          if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
          {
            ETG_TRACE_ERR(("FAILED SENDING CCA MSG: vSetVolumeLock"));
            NORMAL_M_ASSERT_ALWAYS();
            }
          else
          {
            ETG_TRACE_USR4(("Setting vSetVolumeLock Successful"));
          }
             }
       else
       {
        ETG_TRACE_ERR(("Audio Function service not available"));
       }
      oVolLockSet.vDestroy();
       }
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vSendAmpDeviceAudioRoute(tU8 CurSrc, tU16 SubSource, tU16 Sink)
{
   static unsigned int handle = 1;


  tsAmpDevAudioRouteParam ampDevParam;
  ampDevParam.u16AmpDevSink =Sink;
  ampDevParam.u8AmpDevSource=CurSrc;
  ampDevParam.u16AmpDevSubSource=SubSource;

  m_AmpDevAudioRouteParamMap[handle]=ampDevParam;


  //ETG_TRACE_USR4(("Entered AudioFunc::vSendAmpDeviceAudioRoute"));
    //ToDo: daw2hi Sink is missing
  midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart oAmpDevAudioRoute;
  //oAmpDevAudioRoute.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
  oAmpDevAudioRoute.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)Sink;

  oAmpDevAudioRoute.Action.enType = midw_fi_tcl_e8_OnGoingAction::FI_EN_ALLOCATE; //daw2hi 18.10.2017 added parameter
   if(poSourceFactory()->poSourcePtr(CurSrc) !=NULL ) //coverity fix
  {
  tU16 ucid = poSourceFactory()->poSourcePtr(CurSrc)->u16GetUCID();

    ETG_TRACE_USR4(("Entered AudioFunc::vSendAmpDeviceAudioRoute CurSrc %d, Sink %d, got ucid %x, (oAmpDevAudioRoute.Resource %d)",
        CurSrc,Sink,ucid,oAmpDevAudioRoute.Resource.enType));

  FwdTable oTable;
  int strid = oTable.get_strid(ucid);
  if(strid!=STRID_INVALID)
  {
     STRIDENTRY* pEntry = oTable.get_strid_entry(strid);
     oAmpDevAudioRoute.Source.enType   = (midw_fi_tcl_e8_RouteNo::tenType)pEntry->adr.adrsrcnr;
     oAmpDevAudioRoute.Channel.enType  = (midw_fi_tcl_e8_AudioChannel::tenType)pEntry->adr.adrstreamnr;

     //New
     oAmpDevAudioRoute.AudProcAdev = (midw_fi_tclString((pEntry->adr).audprocAdev));
     oAmpDevAudioRoute.MsgHandle = (tU32)handle++;

     ETG_TRACE_USR4(("Entered AudioFunc::vSendAmpDeviceAudioRoute AdrSrcNr =%d, AdrStrNr =%d, handle=%d, audprocAdev = %s",
           pEntry->adr.adrsrcnr, pEntry->adr.adrstreamnr, oAmpDevAudioRoute.MsgHandle, (pEntry->adr).audprocAdev));
  }

  }

  fi_tclVisitorMessage oCCaMsg(oAmpDevAudioRoute);
  oCCaMsg.vInitServiceData(  _poMainAppl->u16GetAppId(),   // Source AppID
               CCA_C_U16_APP_AUDIO,        // Target AppID
               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
               0,
               u16GetRegID(),
               0,
               CCA_C_U16_SRV_AUDIOFUNC,
               MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE,
               AMT_C_U8_CCAMSG_OPCODE_METHODSTART
              );

  if(bIfServiceAvailable())
  {
        if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
        {
          ETG_TRACE_ERR(("FAILED SENDING CCA MSG: AmpDevAudioRoute "));
          NORMAL_M_ASSERT_ALWAYS();
        }
        else
        {
          ETG_TRACE_USR4(("Sending AmpDevAudioRoute Successful"));
        }
  }
  else
  {
    ETG_TRACE_ERR(("Audio Function service not available"));
  }
  oAmpDevAudioRoute.vDestroy();
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc::vHandleAmpDevAudioRoute_MethodResult(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vHandleAmpDevAudioRoute_MethodResult() entered."));
   (void)poMessage;  //LINT

#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
   fi_tclVisitorMessage oVisitorMsg(poMessage);
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult oMethodResult;

   if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_AUDIOFUNC_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      ETG_TRACE_USR4(("received oMethodResult.ServiceStatus.enType = 0x%x", oMethodResult.ServiceStatus.enType));
      ETG_TRACE_USR4(("received oMethodResult.MsgHandle = 0x%x",oMethodResult.MsgHandle));
   }

   auto it = m_AmpDevAudioRouteParamMap.find(oMethodResult.MsgHandle);
   if(it!=m_AmpDevAudioRouteParamMap.end())
   {
      m_poResourceManager->vNotifyAmpDevAudioRouteResult(it->second.u8AmpDevSource,it->second.u16AmpDevSubSource,it->second.u16AmpDevSink,oMethodResult.MsgHandle);
      m_AmpDevAudioRouteParamMap.erase(it);
   }
   else
   {
      ETG_TRACE_ERR(("Could not find AmpDeviceAudioRoute Parameter in Map"));
   }

#endif
}
