/************************************************************************FA*
 *File          :  ARM_Proxy.h
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :  7/9/2012   7:21:54 PM   Anu Sebastian       Initial version
 ************************************************************************/

#if !defined(ARM_PROXY_H_)
#define ARM_PROXY_H_

#include "StreamMuteNotify_IF.h"
#include "StreamMute_IF.h"

/*******************************************************************************
 *
 * CLASS: ARM_Proxy
 *
 *******************************************************************************/
class ARM_Proxy: public IF_MessageObserver<PO_MessageConfig::enID>, public StreamMuteNotify_IF

{
public:
   InternalCommunicationAdapter* pPO; // Pointer for post office access
   StreamMute_IF* pStreamMute;

   tU8 muteRegId;

   ARM_Proxy();
   ARM_Proxy(StreamMute_IF* pStreamMute);
   tU8 u8getMuteRegId()const;

   virtual ~ARM_Proxy()
   {
     InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
     delete(pPO);
     delete(pStreamMute);
   }

   void addObserver();
   void demuteMixStream(tU16 resource=1); //resource is the sink

   virtual void MessageNotification(PO_MessageConfig::enID MsgId);
   virtual void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink);
private:
   tBool bLowVoltageActive;
};


#endif // ARM_Proxy
