/*
 * MuteOnAppStateChange.h
 *
 *  Created on: SEP 12th, 2013
 *      Author: PAJ5KOR
 */

#ifndef MUTEONAPPSTATECHANGE_H_
#define MUTEONAPPSTATECHANGE_H_


#include "../../InternalComponentCommunication/DataTypes/MessageDataTypes/ApplicationStateData.h"
#include "../../InternalComponentCommunication/DataTypes/MessageDataTypes/ApplicationTriggerData.h"

#include "../../mute/stream/StreamMuteNotify_IF.h"

class fc_audiomanager_tclService_Audio_Function;
class StreamMute_IF;

/*******************************************************************************
 *
 * CLASS: MuteOnAppStateChange
 *
 *******************************************************************************/
//class fc_audiomanager_tclService_Audio_Function;
class MuteOnAppStateChange: public IF_MessageObserver<PO_MessageConfig::enID>, public StreamMuteNotify_IF

{
public:
   MuteOnAppStateChange(StreamMute_IF* m_pStreamMute, fc_audiomanager_tclService_Audio_Function* poAudSrvAudFunc);
   virtual ~MuteOnAppStateChange();

   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

   virtual tVoid StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink);
   tVoid vPerformMute(unsigned int muteType=1); //by default set it to mute all streams
   tVoid vPerformDeMute();

   fc_audiomanager_tclService_Audio_Function* m_poAudSrvAudFunc;
   StreamMute_IF* pStreamMute;
   tU8 muteRegId;

private:
   tVoid notifyAboutApplicationState(ApplicationStateData* pDataSet);
   tVoid notifyAboutApplicationTrigger(ApplicationTriggerData* pDataSet);
};




#endif /* MUTEONAPPSTATECHANGE_H_ */
