
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

// from InternalComponentCommunication
#include "InternalCommunicationAdapter.h"
#include "Messages/power/ID_ApplicationStatus.h"
#include "Messages/power/ID_ApplicationTrigger.h"

#include "MuteOnAppStateChange.h"
#include "../../fc_audiomanager_service_Audio_Function.h"


#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#include "../../mute/stream/StreamMute.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/MuteOnAppStateChange.cpp.trc.h"
#endif

#define MUTE_ALL 1
#define MUTE_ALL_EXCEPT_MIX3 2
/*******************************************************************************
*
* FUNCTION: MuteOnAppStateChange::MuteOnAppStateChange()
*
* DESCRIPTION: Constructor
*
* PARAMETER:None
*
* RETURN TYPE : None
*
*******************************************************************************/

MuteOnAppStateChange::MuteOnAppStateChange(StreamMute_IF* m_pStreamMute, fc_audiomanager_tclService_Audio_Function* poAudSrvAudFunc)
   : IF_MessageObserver<PO_MessageConfig::enID>("MuteOnAppStateChange")
{
  ETG_TRACE_USR4(("MuteOnAppStateChange Observer constructor"));

  m_poAudSrvAudFunc = poAudSrvAudFunc;
  pStreamMute = m_pStreamMute;
  muteRegId = pStreamMute->registerForStreamMute(StreamMute_IF::INTERNAL_BEH, this);

   InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_ApplicationStatus);
   InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_ApplicationTrigger);
}

MuteOnAppStateChange::~MuteOnAppStateChange()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  m_poAudSrvAudFunc = OSAL_NULL;
  pStreamMute = OSAL_NULL;
}

/**
 * This function is called by post office on new incoming messages.
 */
//
tVoid MuteOnAppStateChange::MessageNotification(PO_MessageConfig::enID MsgId)
{
   ETG_TRACE_USR2(("MuteOnAppStateChange: message received\n"));
   switch (MsgId)
   {
      case PO_MessageConfig::ID_ApplicationStatus:
      {
         const ID_ApplicationStatus* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_ApplicationStatus>(MsgId);

         AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

         ApplicationStateData Data (pMsg->value);
         ETG_TRACE_USR4(("MuteOnAppStateChange: MessageNotification: Application Status incomingData:"));
         Data.printData();

         notifyAboutApplicationState(&Data);
         break;
      }
      case PO_MessageConfig::ID_ApplicationTrigger:
      {
         const ID_ApplicationTrigger* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_ApplicationTrigger>(MsgId);

         AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

         ApplicationTriggerData Data (pMsg->value);
         ETG_TRACE_USR4(("ApplicationStateObserver: MessageNotification: Application Trigger incomingData:"));
         Data.printData();

         notifyAboutApplicationTrigger(&Data);
         break;
      }
      default:

         break;
   }
}


tVoid MuteOnAppStateChange::notifyAboutApplicationState(ApplicationStateData* pDataSet)
{
  ETG_TRACE_USR4(("MuteOnAppStateChange::notifyAboutApplicationState:"));
  switch (pDataSet->m_State)
  {
  case AUD_APP_PWR_EVENT_APP_OFF:
    {
      ETG_TRACE_USR4(("MuteOnAppStateChange::AUD_APP_PWR_EVENT_APP_OFF:"));
      vPerformMute();
    }
    break;
  case AUD_APP_PWR_EVENT_APP_PAUSE:
    {
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poAudSrvAudFunc);
      if(m_poAudSrvAudFunc->IsOEMRenault())
	  {
		   vPerformMute(MUTE_ALL_EXCEPT_MIX3);
		   ETG_TRACE_USR4(("MuteOnAppStateChange::Keep Mix3 Demuted for Renault in standby mode"));
	  }
	 else{ 
      ETG_TRACE_USR4(("MuteOnAppStateChange::AUD_APP_PWR_EVENT_APP_PAUSE:"));
      vPerformMute();
		 }
    }
    break;
  case AUD_APP_PWR_EVENT_APP_NORMAL:
    {
    ETG_TRACE_USR4(("MuteOnAppStateChange::AUD_APP_PWR_EVENT_APP_NORMAL:"));
      vPerformDeMute();
    }
    break;


  default:
  {
    //oStrategyAdmin.m_OnVolumeActive.setFlag(FALSE);
    ETG_TRACE_USR4(("MuteOnAppStateChange::DEFAULT !!!:"));
  }
    break;
  }
}

tVoid MuteOnAppStateChange::vPerformMute(unsigned int muteType)
{
  ETG_TRACE_USR4(("MuteOnAppStateChange::vPerformMute() entered"));
  StreamMute *ptrmute = dynamic_cast<StreamMute*>(pStreamMute);
  if(ptrmute != NULL)
  {
    //if(!ptrmute->checkAnyMute(EN_AUDIO_SOURCE_STREAM_MAIN))
    {
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_MUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MAIN);
      ETG_TRACE_USR4(("MuteOnAppStateChange::Mute requested for MAIN"));
    }
    //if(!ptrmute->checkAnyMute(EN_AUDIO_SOURCE_STREAM_MIX1))
    {
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_MUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX1);
      ETG_TRACE_USR4(("MuteOnAppStateChange::Mute requested for MIX1"));
    }
    //if(!ptrmute->checkAnyMute(EN_AUDIO_SOURCE_STREAM_MIX2))
    {
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_MUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX2);
      ETG_TRACE_USR4(("MuteOnAppStateChange::Mute requested for MIX2"));
    }
    //Mute mix3
    {
     if(muteType == MUTE_ALL_EXCEPT_MIX3)
	 {
		//do nothing
	 }

    else
      {
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_MUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX3);
      ETG_TRACE_USR4(("MuteOnAppStateChange::Mute requested for MIX3"));
      }
    }
//    else
//    {
//      ETG_TRACE_USR4(("MuteOnAppStateChange::all streams are muted already"));
//    }

  }
  else
  {
    ETG_TRACE_USR4(("MuteOnAppStateChange::vPerformMute: DYNAMIC CAST IS NULL!!!! BUG HERE"));
  }
}

tVoid MuteOnAppStateChange::vPerformDeMute()
{
  ETG_TRACE_USR4(("MuteOnAppStateChange::vPerformDeMute() entered"));
  StreamMute *ptrmute = dynamic_cast<StreamMute*>(pStreamMute);
  if(ptrmute != NULL)
  {
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_DEMUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MAIN);
      ETG_TRACE_USR4(("MuteOnAppStateChange::DeMute requested for MAIN"));
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_DEMUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX1);
      ETG_TRACE_USR4(("MuteOnAppStateChange::DeMute requested for MIX1"));
      ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_DEMUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX2);
      ETG_TRACE_USR4(("MuteOnAppStateChange::DeMute requested for MIX2"));
    ptrmute->muteStream(muteRegId, StreamMute_IF::MUTE_ACTION_DEMUTE , EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX3);
    ETG_TRACE_USR4(("MuteOnAppStateChange::DeMute requested for MIX3"));
  }
  else
  {
    ETG_TRACE_USR4(("MuteOnAppStateChange::vPerformMute: DYNAMIC CAST IS NULL!!!! BUG HERE"));
  }
}



tVoid MuteOnAppStateChange::notifyAboutApplicationTrigger(ApplicationTriggerData* pDataSet)
{
  (tVoid)pDataSet;
}

tVoid MuteOnAppStateChange::StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink)
{
  (tVoid)muteAck;
  (tVoid)stream;
  (tVoid)sink;
  ETG_TRACE_USR4(("MuteOnAppStateChange::StreamMuteNotify called from Thread: 0x%x", OSAL_ThreadWhoAmI()));
}
