///////////////////////////////////////////////////////////
//  TypeConverterMultiMap.h
//  Implementation of the Class TypeConverterMultiMap
//  Created on:      07.02.13
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(TypeConverterMultiMap__INCLUDED_)
#define TypeConverterMultiMap__INCLUDED_



//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>


#include <map>
#include <vector>
#include <algorithm>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



using namespace std;

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/**
 * Template class covers the interface for usage of stl map.
 * It's used to convert one enum type to another.
 */
template<typename IndexType, typename OutType>
class TypeConverterMultiMap {
private:
   multimap<IndexType, OutType> _TypeMultiMap;
public:
   TypeConverterMultiMap()
   {

   }

   OutType getSecond(IndexType Key)
   {
      OutType convertedType  = static_cast<OutType>(0x00);
      typename multimap<IndexType, OutType>::iterator tIterator;
      tIterator = _TypeMultiMap.find(Key);
      if (tIterator.operator!=(_TypeMultiMap.end()))
      {
         convertedType = (*tIterator).second;
      }
      return (convertedType);
   }

   /**
    * return the first matching element of the map
    * @param Entity
    * @return
    */
   IndexType getKey(OutType Entity)
   {
      IndexType convertedType = static_cast<IndexType>(0x00);
      typename multimap<IndexType, OutType>::iterator tIterator;

      tBool ExitWhileLoop = FALSE;
      tIterator = _TypeMultiMap.begin();
      while (FALSE == ExitWhileLoop)
      {
         if (Entity == (*tIterator).second)
         {
            convertedType = (*tIterator).first;
            ExitWhileLoop = TRUE;
         }

         if (tIterator == _TypeMultiMap.end())
           {
            ExitWhileLoop = TRUE;
             break;
           }

         tIterator++;

      }

      return (convertedType);
   }

   tBool isIndexTypeAttached(IndexType searchForType)
   {
      tBool EntityFound = FALSE;

      typename multimap<IndexType, OutType>::iterator tIterator;
      tIterator = _TypeMultiMap.find(searchForType);
      if (tIterator.operator!=(_TypeMultiMap.end()))
      {
         EntityFound = TRUE;
      }
      return (EntityFound);
   }

   tBool attachEntity(IndexType Key, OutType ConvertedType)
   {
      tBool EntityAttached = FALSE;

      _TypeMultiMap.insert(pair<IndexType, OutType>(Key, ConvertedType));
      EntityAttached = TRUE;

      return (EntityAttached);
   }
};
#endif // !defined(EA_5DF45D23_5552_481f_A436_D3811A05152E__INCLUDED_)
