///////////////////////////////////////////////////////////
//  TypeConverterMap.h
//  Implementation of the Class TypeConverterMap
//  Created on:      11-Aug-2012 08:32:01
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(EA_5DF45D23_5552_481f_A436_D3811A05152E__INCLUDED_)
#define EA_5DF45D23_5552_481f_A436_D3811A05152E__INCLUDED_


//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
//#include <stl_pif.h>


#include <map>
#include <vector>
#include <algorithm>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



using namespace std;

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

/**
 * Template class covers the interface for usage of stl map.
 * It's used to convert one enum type to another.
 */
template<typename IndexType, typename OutType>
class TypeConverterMap
{
private:
   map<IndexType, OutType> _TypeMap;
public:
   TypeConverterMap()
   {

   }

   OutType getSecond(IndexType Key)
   {
      OutType convertedType = static_cast<OutType>(0x00);

      typename map<IndexType, OutType>::iterator tIterator;
      tIterator = _TypeMap.find(Key);
      if (tIterator.operator!=(_TypeMap.end()))
      {
         convertedType = (*tIterator).second;
      }
      return (convertedType);
   }

   IndexType getKey(OutType Entity)
   {
      IndexType convertedType = static_cast<IndexType>(0x00);
      typename map<IndexType, OutType>::iterator tIterator;
      for (
            tIterator = _TypeMap.begin();
            tIterator != _TypeMap.end();
            tIterator++
            )
      {
         if(Entity == (*tIterator).second)
         {
            convertedType = (*tIterator).first;
         }
      }

      return (convertedType);
   }

   tBool isIndexTypeAttached(IndexType searchForType)
   {
      tBool EntityFound = FALSE;

      typename map<IndexType, OutType>::iterator tIterator;
      tIterator = _TypeMap.find(searchForType);
      if (tIterator.operator!=(_TypeMap.end()))
      {
         EntityFound = TRUE;
      }
      return (EntityFound);
   }

   tBool attachEntity(IndexType Key, OutType ConvertedType)
   {
      tBool EntityAttached = FALSE;

      if (FALSE == isIndexTypeAttached(Key))
      {
         _TypeMap[Key] = ConvertedType;
         EntityAttached = TRUE;
      }
      else
      {
        //ETG_TRACE_USR4(("Error: Entity for ID %d existing", Key));
      }
      //      ToDO: assert here

      return (EntityAttached);
   }
};
#endif // !defined(EA_5DF45D23_5552_481f_A436_D3811A05152E__INCLUDED_)
