#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_input.h"
#include "fc_audiomanager_trace_macros.h"
//#include "vd_adr3Msg_If.h" //#define AUD_GET_U16(...

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_TRACE
#include "trcGenProj/Header/fc_audiomanager_trace.cpp.trc.h"
#endif

// -- trace identifier ------- define this value for every class new

// -- trace identifier ------- define this value for every file new

// -- trace identifier ------- end

OSAL_tIODescriptor fc_audiomanager_tclTraceChannel::_fdTrace = OSAL_ERROR;
fc_audiomanager_tclTraceInput* fc_audiomanager_tclTraceChannel::_paReceiver[TRC::enMAX_INTRACE_NAMES];

/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTrace
 * FUNCTION    : constructor
 * CREATED     : 2007-09-10
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : initialization to no action
 * SYNTAX      :
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       : -
 *******************************************************FunctionHeaderEnd******/
fc_audiomanager_tclTraceChannel::fc_audiomanager_tclTraceChannel(tVoid)
{
   ETG_TRACE_USR4(("fc_audiomanager_tclTraceChannel entered."));

   _eChannel = NO_CHAN_SELECTED;
   // check if channel was opened already by another instance
   if(_fdTrace != OSAL_ERROR)
   {
      vUnregisterTraceCallBack();
   }
   _fdTrace = OSAL_ERROR;
   for (tInt i = 0; i < (tInt)TRC::enMAX_INTRACE_NAMES; i++)
   {
      _paReceiver[i] =0;
   }
}

fc_audiomanager_tclTraceChannel::~fc_audiomanager_tclTraceChannel(tVoid)
{
   ETG_TRACE_USR4(("~fc_audiomanager_tclTraceChannel entered."));
   if(_fdTrace != OSAL_ERROR)
   {
      vUnregisterTraceCallBack();//lint !e1551 prio3 reviewed: the macro TRACE_FLOW_DEF in this function cannot throw an exception
   }
   _fdTrace = OSAL_ERROR;
}

tVoid  fc_audiomanager_tclTraceChannel::vTrace_Rx_Callback (tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vTrace_Rx_Callback entered. Redirecting to vTrace_Rx()."));
   vTrace_Rx(pcu8Data[0], &pcu8Data[1]);
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vTrace_Rx
 * CREATED     : 2007-09-10
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : handles received messages from TTFIS
 * SYNTAX      : tVoid vdclk_Trace_vRx( tU8* pcu8Data )
 * ARGUMENTS   : -
 *               pcu8Data
 * RETURN VALUE: -
 *               none
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid  fc_audiomanager_tclTraceChannel::vTrace_Rx (tU32 size, tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("vTrace_Rx entered."));

   // pcu8Data[0] == tenTrcTrcClassName
   // pcu8Data[1] == tenTrcFuncInput
  // pcu8Data[2] == the 1. parameter
  // pcu8Data[3] == the 2. parameter
  ETG_TRACE_USR4(("vTrace_Rx()\n length of TTFis message=%u,\n pcu8Data=0x%02x",size,ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));



  if(pcu8Data == NULL) return;
  ETG_TRACE_USR4(("vTrace_Rx pcu8Data != NULL."));
  ETG_TRACE_USR4(("[(pcu8Data[0])] = 0x%x", (pcu8Data[0])));
  ETG_TRACE_USR4(("[(pcu8Data[1])] = 0x%x", (pcu8Data[1])));
  ETG_TRACE_USR4(("_paReceiver[(pcu8Data[0])] = 0x%x", _paReceiver[(pcu8Data[0])]));
  ETG_TRACE_USR4(("_paReceiver[(pcu8Data[1])] = 0x%x", _paReceiver[(pcu8Data[1])]));


  if ( size > 2 )
  {
    // the router forwards the message to that call backs as defined by tclApp
    if(_paReceiver[pcu8Data[0]] &&  pcu8Data[0] < TRC::enMAX_INTRACE_NAMES)
    {
      // _paReceiver[(pcu8Data[1])]->vTraceRx(pcu8Data);
      _paReceiver[(pcu8Data[0])]->vTraceRx(size, pcu8Data);
    } else
    {
       ETG_TRACE_USR4(("vRegisterTraceService Trace Channel this service is not initialized."));
         //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel this service is not initialized", pcu8Data[1]);
      }
   } else
   {
      ETG_TRACE_USR4(("vRegisterTraceService Trace Channel service number unknown."));
      //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel service number unknown", pcu8Data[1]);
   }
   return;
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vRegisterTraceService
 * CREATED     : 2008-03-15
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : adds the given trace input interface into the function array
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid fc_audiomanager_tclTraceChannel::vRegisterTraceService(tU32 uInputNum,
                                                  fc_audiomanager_tclTraceInput* pclInput) const
{
   ETG_TRACE_USR4(("vRegisterTraceService entered."));
   if(uInputNum < sizeof(_paReceiver)/sizeof(_paReceiver[0]))
   {
      _paReceiver[uInputNum] = pclInput;
    ETG_TRACE_USR4(("vRegisterTraceService Trace Channel service registered for :%u",uInputNum));
   }
}



/******************************************************FunctionHeaderBegin******
 * CLASS       : ipod_tclTraceChannel
 * FUNCTION    : vUnregisterTraceCallBack
 * CREATED     : 2008-03-15
 * AUTHOR      : Matthias Hessling
 * DESCRIPTION : unregister the call back at trace interface
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid fc_audiomanager_tclTraceChannel::vUnregisterTraceCallBack(tVoid) const
{
   ETG_TRACE_USR4(("vUnregisterTraceCallBack entered."));
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;

   tVoid (*pCallbackFunction)(tPCUChar);
   pCallbackFunction = vTrace_Rx_Callback; // To ensure function pointer type safety

   oTraceChannel.enTraceChannel = _eChannel;
   oTraceChannel.pCallback = (OSAL_tpfCallback)pCallbackFunction;

   if(_fdTrace != OSAL_ERROR)
   {
      s32Error = OSAL_s32IOControl( _fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t)&oTraceChannel );
   }
   if( OSAL_OK != s32Error )
   {
      ETG_TRACE_ERR(("vUnregisterTraceCallBack ErrCouldntUnregisterTraceChannel."));
   }
   OSAL_s32IOClose( _fdTrace );
}
