
/*******************************************************************************
*
* FILE:          fc_audiomanager_tclClientHandler_VehicleData.cpp
*
* SW-COMPONENT:  FC_Audiomanager application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service Vehicle data.
*
* AUTHOR:        Medha Manjunath Hegde
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/


#include "fc_audiomanager_main.h"
#include "fc_audiomanager_tclClientHandler_VehicleData.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>
// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of used service
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_TYPES
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_FUNCTIONIDS
#define VEHICLE_FI_S_IMPORT_INTERFACE_VEHICLE_MAINFI_SERVICEINFO
#include "vehicle_fi_if.h"

//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_audiomanager_trace.h"
#include "InternalCommunicationAdapter.h"
#include "fc_audiomanager_service_Audio_Function.h"
/*#include "InternalComponentCommunication/DataTypes/TypeDefines/VoltageState.h"*/
#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"
#include "util/Macro.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "aud_sinkmgr_pwramp.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SOUND
#include "trcGenProj/Header/fc_audiomanager_tclClientHandler_VehicleData.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audiomanager_tclClientHandler_VehicleData, ahl_tclBaseWork)
ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_PARTIALMUTE,AMT_C_U8_CCAMSG_OPCODE_STATUS,vOnPartialMute)
ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_MUTEDEV,AMT_C_U8_CCAMSG_OPCODE_STATUS,vOnFullCanMute)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audiomanager_tclClientHandler_VehicleData::
*             fc_audiomanager_tclClientHandler_VehicleData(fc_audiomanager_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audiomanager_tclClientHandler_VehicleData::
  fc_audiomanager_tclClientHandler_VehicleData(fc_audiomanager_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_VEHICLE_DATA,
      /* MajorVersion of used Service */ VEHICLE_MAINFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */ VEHICLE_MAINFI_C_U16_SERVICE_MINORVERSION)
{
  poMainApplInstance = poMainAppl;
  ETG_TRACE_USR4(("fc_audiomanager_tclClientHandler_VehicleData() entered."));
  m_AttenuationDBMAp.insert(make_pair(0, 0));
  m_AttenuationDBMAp.insert(make_pair(1, -4));
  m_AttenuationDBMAp.insert(make_pair(2, -8));
  m_AttenuationDBMAp.insert(make_pair(3, -12));
  m_AttenuationDBMAp.insert(make_pair(4, -18));
  m_AttenuationDBMAp.insert(make_pair(5, -24));
  m_AttenuationDBMAp.insert(make_pair(6, -32));
  m_AttenuationDBMAp.insert(make_pair(7, -40));
  m_AttenuationDBMAp.insert(make_pair(8, -56));
  m_AttenuationDBMAp.insert(make_pair(9, -80));
  m_AttenuationDBMAp.insert(make_pair(10, -480));
}

/*******************************************************************************
*
* FUNCTION: fc_audiomanager_tclClientHandler_VehicleData::
*             ~fc_audiomanager_tclClientHandler_VehicleData(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audiomanager_tclClientHandler_VehicleData::
  ~fc_audiomanager_tclClientHandler_VehicleData(tVoid)
{
  ETG_TRACE_USR4(("~fc_audiomanager_tclClientHandler_VehicleData() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_VehicleData::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_VehicleData::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
                  u16GetServerAppID()));

 vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_PARTIALMUTE);
 
 vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_MUTEDEV);							  
							  
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_VehicleData::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_VehicleData::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                 u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_VehicleData::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_VehicleData::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));
  (tVoid)u16TimerId;
 /* if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }*/
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_VehicleData::
*             vOnPartialMute(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called when Partial mute received.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_VehicleData::vOnPartialMute(amt_tclServiceData* poMessage)
{
if(NULL != poMessage)
{
vehicle_mainfi_tclMsgPartialMuteStatus oMsg;
(void)fi_tclVisitorMessage(poMessage).s32GetData(oMsg);
bool flag=TRUE;
bool PartialMuteFlag=TRUE;
ETG_TRACE_USR4(("Partial Mute Value received is %u",
                oMsg.PartialMuteValue));
tS16 dbVal = 0;
if(oMsg.PartialMuteValue<=10)
  {
   if(oMsg.PartialMuteValue == 0)
   {
  flag = FALSE;
  PartialMuteFlag=FALSE;
   }
   if(m_AttenuationDBMAp.find(oMsg.PartialMuteValue) != m_AttenuationDBMAp.end())
        {
         dbVal = m_AttenuationDBMAp.find(oMsg.PartialMuteValue)->second;
        }
   ID_CAN_PARTIAL_MUTE_Attenuation oCanAttenuation(flag,dbVal,PartialMuteFlag);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCanAttenuation);
   ETG_TRACE_USR4(("DB Value sent is %d",
                dbVal));
   }
else
{
  ETG_TRACE_USR4(("Erroneous Partial mute value received, Cannot Attenuate!"));
}
}
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_VehicleData::
*             vOnFullCanMute(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called when Full CAN mute received.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_VehicleData::vOnFullCanMute(amt_tclServiceData* poMessage)
{
if(NULL != poMessage)
{
 vehicle_mainfi_tclMsgMuteDevStatus oMsg;
 (void)fi_tclVisitorMessage(poMessage).s32GetData(oMsg);
 ETG_TRACE_USR4(("Full CAN Mute Value received is %u",
                 oMsg.MuteDevStatus));
 if(oMsg.MuteDevStatus == 1)
 {
	if (poMainApplInstance && poMainApplInstance->pGetSinkMgrptr() && poMainApplInstance->pGetSinkMgrptr()->poGetPowerAmp())
	 poMainApplInstance->pGetSinkMgrptr()->poGetPowerAmp()->vSetSpecialMute(1);
 }
 else if(oMsg.MuteDevStatus == 0)
 {
	if (poMainApplInstance && poMainApplInstance->pGetSinkMgrptr() && poMainApplInstance->pGetSinkMgrptr()->poGetPowerAmp())
	 poMainApplInstance->pGetSinkMgrptr()->poGetPowerAmp()->vSetSpecialMute(0);
 }
 else
 {
	 //do nothing
	 ETG_TRACE_USR4(("Erroneous Full CAN mute value received, Cannot Mute or Unmute"));
 }
}
}
