/*******************************************************************************
 *
 * FILE:          fc_audiomanager_service_Client_Handler_Tel_Fi
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service handler for all clients fc_audiomanager need to register for.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _fc_audiomanager_service_Client_Handler_Tel_Fi_H_
#define _fc_audiomanager_service_Client_Handler_Tel_Fi_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "ahl_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

using namespace std;

#include "ExternItf/CCA/MessageHandler/PhoneTypeHandler.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Loop back message defines to be processed by vOnLoopbackService().
/* Definition of internal Function IDs (iFIDs) and message        */
/* content IDs (MSGID) which are not public and therefore are     */
/* not in the public FI of our service. Such internal function    */
/* and message content IDs are necessary for 'loopback' messages, */
/* i.e. messages the application sends itself. These internal     */
/* function IDs must be different to the ones from the public FI. */
/* The developer has to take care about that. To have a maximum   */
/* separation of the public and the internal FIDs we start the    */
/* definition for the internal ones nearly at the end of the      */
/* possible range and then count downwards.*/

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;
class fc_audiomanager_tclApp;

class fc_audiomanager_service_Client_Handler_Tel_Fi: public ahl_tclBaseOneThreadClientHandler
{
public:

   fc_audiomanager_service_Client_Handler_Tel_Fi();
   fc_audiomanager_service_Client_Handler_Tel_Fi(fc_audiomanager_tclApp* poMainAppl);
   virtual ~fc_audiomanager_service_Client_Handler_Tel_Fi();

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   tVoid vHandle_ActivePhoneDevice_Status(amt_tclServiceData* poMessage);
private:
   PhoneTypeHandler* m_PhoneTypeHandler;
protected:

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

   // Add your CCA message handler function prototypes here.

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP (fc_audiomanager_service_Client_Handler_Tel_Fi)

};

#endif
