/*******************************************************************************
 *
 * FILE:          fc_audiomanager_service_Client_Handler_Tel_Fi
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Audio_Diagnosis.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "fc_audiomanager_main.h"
#include "fc_audiomanager_service_Client_Handler_Tel_fi.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_TELFI_SERVICEINFO

#include "conn_most_fi_if.h"

#include "etrace_if.h"
#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_macros.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/fc_audiomanager_service_Client_Handler_Tel_fi.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/
// this comment is for Eclispe formatting issues only
BEGIN_MSG_MAP(fc_audiomanager_service_Client_Handler_Tel_Fi, ahl_tclBaseWork)
// this comment is for Eclispe formatting issues only
ON_MESSAGE_SVCDATA( MOST_TELFI_C_U16_ACTIVEPHONEDEVICE , AMT_C_U8_CCAMSG_OPCODE_STATUS , vHandle_ActivePhoneDevice_Status )
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_service_Client_Handler_Tel_Fi::fc_audiomanager_service_Client_Handler_Tel_Fi(fc_audiomanager_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *              Create an object of the base class
 *              ahl_tclBaseOneThreadClientHandler with a pointer to this
 *              application, the to be used service identifier and the service
 *              version as parameters.
 * PARAMETER  : [IN] poMainAppl = Pointer to the object of this application.
 * RETURNVALUE: None.
 *******************************************************************************/
fc_audiomanager_service_Client_Handler_Tel_Fi::fc_audiomanager_service_Client_Handler_Tel_Fi(fc_audiomanager_tclApp* poMainAppl) :
ahl_tclBaseOneThreadClientHandler(
    /* Application Pointer              */poMainAppl,
    /* ID of offered Service            */CCA_C_U16_SRV_FB_TELEPHONE,
    /* MajorVersion of offered Service  */MOST_TELFI_C_U16_SERVICE_MAJORVERSION,
    /* MinoreVersion of offered Service */MOST_TELFI_C_U16_SERVICE_MINORVERSION)
{
  ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Tel_fi() entered."));
  m_PhoneTypeHandler = OSAL_NEW PhoneTypeHandler(poMainAppl);
  vAddAutoRegisterForProperty(MOST_TELFI_C_U16_ACTIVEPHONEDEVICE);
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_service_Client_Handler_Tel_Fi::~fc_audiomanager_service_Client_Handler_Tel_Fi(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_audiomanager_service_Client_Handler_Tel_Fi::~fc_audiomanager_service_Client_Handler_Tel_Fi(tVoid)
{
  ETG_TRACE_USR4(("~fc_audiomanager_service_Client_Handler_Tel_fi() entered."));
  OSAL_DELETE (m_PhoneTypeHandler);
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_service_Client_Handler_Tel_Fi::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              which is offered by this server has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
 *******************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Tel_Fi::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Tel_fi vOnServiceAvailable() entered. AppID = %u.",u16GetServerAppID()));

}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_service_Client_Handler_Tel_Fi::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              which is offered by this server has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
 *******************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Tel_Fi::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Tel_fi vOnServiceUnavailable() entered. AppID = %u.",u16GetServerAppID()));
}

/**********************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Tel_Fi::vHandle_ActivePhoneDevice_Status(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Tel_fi: ActivePhoneDevice_Status\n"));

  if ( poMessage != OSAL_NULL )
    {
      fi_tclVisitorMessage oVisitorMsg( poMessage );
      most_telfi_tclMsgActivePhoneDeviceStatus inActivePhoneDeviceStatus;
      if(oVisitorMsg.s32GetData(inActivePhoneDeviceStatus)!= OSAL_ERROR)    //coverity fix
      {
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_PhoneTypeHandler);
      m_PhoneTypeHandler->vHandle_ActivePhoneDeviceStatus(inActivePhoneDeviceStatus.u8DeviceHandle);
      }
    }
}

