/*******************************************************************************
 *
 * FILE:          fc_audiomanager_service_Client_Handler_Phone
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service handler for all clients fc_audiomanager need to register for.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _fc_audiomanager_service_Client_Handler_Phone_H_
#define _fc_audiomanager_service_Client_Handler_Phone_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "ahl_if.h"

//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>



#include <map>
#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

using namespace std;

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;
class fc_audiomanager_tclApp;

class fc_audiomanager_service_Client_Handler_Phone: public ahl_tclBaseOneThreadClientHandler
{
public:

   fc_audiomanager_service_Client_Handler_Phone();
   fc_audiomanager_service_Client_Handler_Phone(fc_audiomanager_tclApp* poMainAppl);
   virtual ~fc_audiomanager_service_Client_Handler_Phone();

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   tVoid vHandle_DeviceList_Status(amt_tclServiceData* poMessage);
   tVoid vInitDeviceListMap();
private:

   map<tU8 , tBool >  m_DeviceAvailMap;
protected:

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   // inbox for TTFis

   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

   // Add your CCA message handler function prototypes here.

   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP (fc_audiomanager_service_Client_Handler_Phone)

};

#endif
