/*******************************************************************************
 *
 * FILE:          fc_audiomanager_service_Audio_Function.h
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Audio_Function.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_H_
#define _FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "util/Macro.h"
// Include Application Help Library.
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

// Include message framework interface (AMT, msgfw).
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#include "ExternItf/CCA/FI_Message/FI_Includes.h"

//Include public FI interface of this service.
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGNOSTICSFI_SERVICEINFO

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include "midw_fi_if.h"

#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "ExternItf/CCA/msgtypes.h"
#include "Messages/Source/IDCCAStartAmpDeviceAudioRoute.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAStartBeep.h"
#include "InternalComponentCommunication/Messages/mute/IDMuteStateHandleVoltage.h"
#include "Messages/Source/IDCCAStartAudioSource.h"
#include "Messages/Diag/IDCCAStartAudDiagMode.h"
#include "Messages/Diag/IDDiagAudioGain.h"
#include "Messages/Diag/IDDiagRemoteControl.h"
#include "Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "Messages/Volume/VolumeManager/ID_CCA_Start_VolumeLock.h"
#include "Messages/Volume/VolumeManager/ID_SPIMixVolume.h"
#include "Messages/CarSetting/IDCarSetting.h"
#include "VolumeOffset/VolOffset_Manager.h"
#include "config/dp/AudioUserDpIfSelect.h"

#include "Fading/Fading.h"
#include "Fading/Fading_IF.h"
#include "ExternItf/CCA/aud_CCAMsg.h"
#include "fc_audiomanager_trace.h"

#include "mute/stream/ARM_Proxy.h"
#include "mute/stream/SinkMute.h"
#include "ExternItf/CCA/MessageHandler/PowerStateHandler.h"
#include "LinearSettings/DiagAudMode.h"
#include "aud_sinkmgr_trace_input.h"
#include "mute/stream/StreamMute_IF.h"
#include "mute/Actions/MuteOnAppStateChange.h"
#include "InternalComponentCommunication/Messages/mute/IDCCAResultMute.h"
#include "InternalComponentCommunication/Messages/mute/IDCCAStartMute.h"
#include "InternalComponentCommunication/Messages/VolumeOffset/IDCCACueState.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/VolOffset_CueType.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/VolumeLockTypes.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAStartAudioTestTone.h"
#include "InternalComponentCommunication/Messages/Startup/ID_NotifyRegular100msTicks.h"
#include "fc_audiomanager_PropertyStatus.h"
#include "aud_sinkmanager/aud_sinkmgr_main.h"
#include "fc_audiomanager_componentfactory_if.h"
#include "Diagnosis/fc_audiomanager_DiaglogClientHandler_Speaker.h"
#include "Diagnosis/fc_audiomanager_Speaker_Diagnosis.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#include "vd_amp_MCANBose_MasterAmplifier_Defines.h"
#endif
using namespace std;

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION  1
#define FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MINOR_VERSION  0
#define FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_PATCH_VERSION  0

// Loop back message defines to be processed by vOnLoopbackService().
/* Definition of internal Function IDs (iFIDs) and message        */
/* content IDs (MSGID) which are not public and therefore are     */
/* not in the public FI of our service. Such internal function    */
/* and message content IDs are necessary for 'loopback' messages, */
/* i.e. messages the application sends itself. These internal     */
/* function IDs must be different to the ones from the public FI. */
/* The developer has to take care about that. To have a maximum   */
/* separation of the public and the internal FIDs we start the    */
/* definition for the internal ones nearly at the end of the      */
/* possible range and then count downwards.*/

#define SURROUNDLEVEL_MIN_VALUE midw_fi_tcl_e8_SurroundSetting::FI_EN_AUDIO_SURROUND_OFF
#define SURROUNDLEVEL_MAX_VALUE midw_fi_tcl_e8_SurroundSetting::FI_EN_AUDIO_SURROUND_MAX

#define AUDIO_GENERATED_TOKEN_INVALID  (tU32(0))
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class fc_audiomanager_tclTraceChannel;
class ahl_tclBaseOneThreadService;
class fc_audiomanager_tclApp;
class SoundHandler;
class SoundToolClient;
class MuteOnAppStateChange;
class VehicleDomainHandlerMain;
class Beep_ExtAmpHandlerMain;

class fc_audiomanager_tclClientHandler_DiagLog;

//#ifndef VARIANT_S_FTR_ENABLE_G3G
class fc_audiomanager_tclMicrophone_Diagnosis;
//#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
class AmplifierSoundHandler;
class AmplifierVolumeModeHandler;
class vd_amp_MCANBose_Main;
class AmplifierVolumeHandler;
class vd_amp_MasterAmplifierMCANUnit;
#endif
namespace VolumeManager  { class VolumeManager; }

class fc_audiomanager_tclSpeaker_Diagnosis;

struct tOverTempAmpLevel
{
  tU8 u8AmpTemperatureLevel;
  inline /* constructor */ tOverTempAmpLevel()
  : u8AmpTemperatureLevel(0)
  {};
};
struct tAudioProperty
{
  tU8 u8PropertyType;
  tS32 s32PropValue;
  inline /* constructor */ tAudioProperty()
  : u8PropertyType(0),s32PropValue(0)
  {};
};

union AvailSettings
{
  tU32 AvailSettingsValue;
  struct AvailSettingsBits
  {
      tBool Bass : 1;
      tBool Middle: 1;
      tBool Treble: 1;
      tBool Balance: 1;
      tBool Fader: 1;
      tBool AmpDownMix: 1;
      tBool SurroundVol: 1;
      tBool AudioPilot: 1;
      tBool Gala: 1;
      tBool SurroundMode: 1;
      tBool RearSoundMode: 1;
      tBool DrivenSoundMode: 1;
      tBool ANC:1;
      tBool ASC:1;
      tBool SoundAmbiance:1;//only for premium2
      tBool ESE:1;//only for premium2
  }AvailSettingsBits_obj;

};

class fc_audiomanager_tclService_Audio_Function: public ahl_tclBaseOneThreadService, public fc_audiomanager_tclTraceInput, public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   tVoid vOnMsMCANBose_VersionInfo();
   tVoid vOnMsAudioSource(amt_tclServiceData* poMessage);
   tVoid vOnMsAmpDeviceAudioRoute(amt_tclServiceData* poMessage);
   tVoid vOnMsBeep(amt_tclServiceData* poMessage);
   tVoid vOnMsFading(amt_tclServiceData* poMessage);
   tVoid vOnMsCueType(amt_tclServiceData* poMessage);
   tVoid vOnPsEngineeringData(amt_tclServiceData* poMessage);
   tVoid vOnPsSetAudioProperty(amt_tclServiceData* poMessage);
   tBool bSendEngineeringDataStatus(amt_tclServiceData& roOutMsg) const;
   tVoid vOnMsDiagnosisSpeakerStart(amt_tclServiceData* poMessage);

   //VVD
   tBool bSendUserProfileChangeStatus(amt_tclServiceData& poMessage) const;

   fc_audiomanager_tclService_Audio_Function();
   fc_audiomanager_tclService_Audio_Function(fc_audiomanager_tclApp* poMainAppl);
   virtual ~fc_audiomanager_tclService_Audio_Function();
   InternalCommunicationAdapter* pPO; // Pointer for post office access
   StreamMute_IF* m_pStreamMute;
   Fading_IF* m_pFading;
   amt_tclServiceData* poMuteMessage;

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   // inbox for TTFis
   virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
   tVoid vOnMsMute(amt_tclServiceData* poMessage);
   tVoid vOnMsSystemMute(amt_tclServiceData* poMessage);
   tVoid vOnMsEntertainmentMute(amt_tclServiceData* poMessage);

   tVoid vOnLoadSettings();

   tVoid vOnMsAudioTestTone(amt_tclServiceData* poMessage);
   tVoid vOnMsAudioBeepFile(amt_tclServiceData* poMessage);
   tVoid vOnMsWelcomeSoundAudioBeepFile(amt_tclServiceData* poMessage);

   ail_tenCommunicationError updateClients(tU16 u16FunctionId);
   tVoid vSendAudioTestToneStatus(tU8 tChannelSelect, tU8 tStatus);

//#ifndef VARIANT_S_FTR_ENABLE_G3G
   inline fc_audiomanager_tclMicrophone_Diagnosis * poGetMicrophoneDiagnosis(tVoid) { return m_poMicrophoneDiagnosis; }
//#endif
   virtual void MessageNotification(PO_MessageConfig::enID MsgId);
   tU16 u16GetAudioRegID()const;
   tVoid vSetAudioRegID(tU16 u16RegID);
   tVoid vOnLoopbackService(amt_tclServiceData* poMessage);
   tVoid vOnGetDiagResultReady();
   tBool IsPremium2Connected();

   tVoid vRequestDiagResult(tenErrorSite errorSite);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   tU8 u8CheckTweeterAvailability();
   tU8 bCheckFaderAvailability();
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   //AmplifierVolumeModeHandler* m_AmplifierVolumeModeHandler;
   AmplifierSoundHandler* m_AmplifierSoundHandler;
   AmplifierVolumeHandler* m_AmplifierVolumeHandler;
#endif
#endif
   bool bIsUPAUserMuteActive();
   bool bIsTweeterConfigured(tenErrorSite enErrorSite);
   void HFPDisplay_Active(bool value);
   bool bIsHFPActive();
   VolumeManager::VolumeManager* GetVolumeManagerPtr()
   {
       if(m_pVolumeManager != NULL)
         return m_pVolumeManager;
    return NULL;
   }
   tBool bIsSpeakerModeACoff();

   protected:

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadService methods.
    ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16Error);
   virtual tVoid vOnMethodStart(tU16 u16FunctionId, amt_tclServiceData* poMessage);

   //Trace Handling Functions
   //tVoid traceInputAudioSource(tU16 Resource, tU16 Source);
   tVoid traceInputSPIMIX(tPCUChar pcu8Data);
   tVoid traceInputBeepLevel(tPCUChar pcu8Data);
  // tVoid traceInputAmpDEviceAudioRoute(tU16 Resource, tU16 Source);
   tVoid traceInputGainOffset(tPCUChar pcu8Data);
   //Set On Ent Volume
   tVoid traceInputSetOnEntVol(tPCUChar pcu8Data);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   tBool bIsHandsfreeOrECNRSource(tenInternalSource inSource);
   tVoid vCheckSourceAndSetTelModeGPIO(tenInternalSource inSource);
#endif
   tVoid vHandleTRCArkamysSetParam(tPCUChar pcu8Data);
   tVoid vHandleTRCArkamysFeature(tPCUChar pcu8Data);
   tVoid vHandleTRCArkamysDebug(tU32 size,tPCUChar pcu8Data);
   tVoid vHandleTRCSpeakerDiagnosisStart(tPCUChar pcu8Data);
   tVoid vHandleTRCenAudLinSetting(tPCUChar pcu8Data);
   tVoid vHandleTRCBeepFromFile(tPCUChar pcu8Data);
   tVoid vHandleTRCAudioTestTone(tPCUChar pcu8Data);
   tVoid vHandleTRCSetBeep(tPCUChar pcu8Data);
   tVoid vHandleTRCSetAudioSource(tU32 size,tPCUChar pcu8Data);
   tVoid vHandleTRCADRnARMMute(tPCUChar pcu8Data);
   tVoid vHandleTRCDiagAudioGain(tPCUChar pcu8Data);
   tVoid vHandleTRCRemoteSession(tPCUChar pcu8Data);
   tVoid vHandleTRCSetAuxInLevel(tPCUChar pcu8Data);
   tVoid vHandleTRCCCA_Cue(tPCUChar pcu8Data);
   tVoid vHandleTRCSpeedStatus(tPCUChar pcu8Data);
   tVoid vHandleTRCSetCCAAudioSource(tU32 size,tPCUChar pcu8Data);
   tVoid vHandleTRCSetSource(tU32 size,tPCUChar pcu8Data);
   tVoid vHandleTRCSetAmpDevAudioRoute(tU32 size,tPCUChar pcu8Data);
   tVoid vHandleTRCSoundProperty(tPCUChar pcu8Data);
   tVoid vHandleTRCSetSoundSystemConfig(tPCUChar pcu8Data);
   tVoid vHandleTRCAdasBeep(tPCUChar pcu8Data);
   tVoid vHandleTRCGetDiagResult(tPCUChar pcu8Data);
   template <typename T>
   tBool bPostTRCLoopback(T &obj ,tU16 Property_type);
   /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

   // Add your CCA message handler function prototypes here.
   /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_audiomanager_tclService_Audio_Function)
 #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   vd_amp_MCANBose_Main* m_poMCANBoseAppl;
   tVoid vHandleTRCSelfDiag(tPCUChar pcu8Data);
   tVoid vHandleTRCANCASCActiveTest(tPCUChar pcu8Data);
   tVoid vHandleTRCGeneralSpeakerTest(tPCUChar pcu8Data);
   tVoid vHandleTRCBoseCommErrorTest(tPCUChar pcu8Data);
   tVoid vHandleTRCANCASCActivation(tPCUChar pcu8Data);
#endif
private:
   aud_CCAMsg m_CCATransport;
   VolumeManager::VolumeManager* m_pVolumeManager;
   SoundHandler* m_SoundHandler;
   //SoundToolClient* m_SoundToolClient;
   fc_audiomanager_IClientHandler_Soundtool* m_SoundToolClient;
   Fading* m_Fading;
   PowerStateHandler* m_PowerState;
   VolOffset_Manager *m_VolOffset_Manager;
   // trace input channel
   static fc_audiomanager_tclTraceChannel* _poTrace;
   fc_audiomanager_tclApp * m_poMainAppInstance;
   ARM_Proxy* m_ARM_Proxy;
   SinkMute* m_poSinkMute;
   tU16 m_u16AudioRegID;
   PropertyStatus* m_PropertyStatus;
   DiagAudMode* m_DiagAudMode;
   MuteOnAppStateChange* m_muteOnAppStateChange;
    AudioUserDpIf*    pAudUsrDpIf;
   Beep_ExtAmpHandlerMain*  m_Beep_ExtAmpHandlerMain;
   tU8 m_updatestatus;
   tU16 m_u16AudioTestToneRegID;
   tU16 m_u16AudioTestToneAppID;


//#ifndef VARIANT_S_FTR_ENABLE_G3G
   fc_audiomanager_tclMicrophone_Diagnosis* m_poMicrophoneDiagnosis;
//#endif
   fc_audiomanager_tclSpeaker_Diagnosis* m_poDiagnosisSpeaker;
   tU8 m_activeSource;
   tAudioProperty m_AudioProperty;
   tenSpeakerModeAC m_ACSpeakerMode;
   bool m_bUPAUserMuteStatus;
   bool m_bPrevUPAMuteStatus;
   tU8 m_PrevParkAssitVol;
   bool m_HFPDisplay_status;
   tU8 m_ParkAssitVol;
   bool m_bflag;
   //VVD
   bool m_bUserProfileChangeStatus;

   tVoid vStoreAudioProperty(tU8 sourceIndex, tU8 type, tS32 value);
   std::map<tU8, tAudioProperty>StoreAudioProperty;
   tVoid vSetAudioProperty(tU8 source);

   std::queue<tenErrorSite> m_DiagResultQueue;
   tBool m_bDiagResultQueueProcessing;
   tBool m_bIsSystemMuteActive;
   tBool m_bIsExtAmpConnected;
   tU8 m_u8SoundConfigItem;
   AvailSettings AvailSettingsUnion_Obj;
   virtual tVoid vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState);
   tBool bSendSurroundModeStatus(amt_tclServiceData& roOutMsg) const;
   tVoid callPOIDIntSource (tPCUChar pData)const;

   //CCA Message handling functions
   tVoid vHandleCCAMsgAudioSource(PO_MessageConfig::enID MsgId);
   tVoid vHandleCCAMsgAmpDeviceAudioRoute(PO_MessageConfig::enID MsgId);
   tVoid vHandleCCAMsgNotifyMute(PO_MessageConfig::enID MsgId);
   tVoid vHandleCCAMsgResultMute(PO_MessageConfig::enID MsgId);

   tBool bSendAdas_UpaSoundStatus(amt_tclServiceData& roOutMsg) const;
   tBool bSendAdas_ParkAssitVolStatus(amt_tclServiceData& roOutMsg) const;
   tBool bSendAdas_UpaMuteStatus(amt_tclServiceData& roOutMsg) const;
   tBool bSendAdas_LDWUserVolStatus(amt_tclServiceData& roOutMsg) const;
   tBool bSendAdas_SRSoundNotificationStatus(amt_tclServiceData& roOutMsg) const;

   tVoid vOnSetAdas_UpaSoundSet(amt_tclServiceData* poMessage);
   tVoid vOnSetAdas_ParkAssitVol(amt_tclServiceData* poMessage);
   tVoid vOnSetAdas_LDWUSerVol(amt_tclServiceData* poMessage);
   tVoid vOnSetAdas_UpaMute(amt_tclServiceData* poMessage);
   tVoid vOnMsAdas_SettingSound(amt_tclServiceData* poMessage);
   tVoid vOnSetAdas_SRSoundNotification(amt_tclServiceData* poMessage);

   tU32 u32GenerateToken();
   public :
   bool diag_gala_avail(bool availability);
   bool bIsExtAmpConnected();
   tBool m_bBoseAmplifierStatus;
   bool bIsBoseAmpConnected();
   bool IsSBRVariant();
   tS8 m_s8MainAudioAttenuation;
   tVoid vSetRemoveWelcomeSound(tU8 u8Status);
   tBool IsOEMRenault();
   tU8 u8GetOEMType();
   tVoid u8GetvehicleType(tU8* u8VehicleType);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   tVoid vCheckAmplifierStatus();
   tBool bSendAvailSettingsStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg );
   tBool bSendPremium2AmpAvailSettingsStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg);
#endif
   tVoid vOnNewACCState(tBool bACCState);
};



#endif // _FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_H_
