/*******************************************************************************
 *
 * FILE:          fc_audiomanager_service_Audio_Function.cpp
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Audio_Function.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_GENERIC
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_MSG

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

#include "fc_audiomanager_if.h"
#include "fc_audiomanager_main.h"
#include "fc_audiomanager_service_Audio_Function.h"
#include "Beep/Beep_Main.h"

#include "AudioProxy/aud_gio_dbus_handler.h"
#include "AudioProxy/aud_gio_dbus_audproc_proxy.h"


#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/fc_audiomanager_service_Audio_Function.cpp.trc.h"
#endif
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_MSG
#include "fc_audiomanager_if.h"
#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"
#include "ExternItf/CCA/aud_CCAMsg.h"
//#include "ExternItf/CCA/msgtypes.h"
#include "InternalComponentCommunication/Messages/Fading/IDCCAStartSetMuteRamp.h"
#include "InternalComponentCommunication/Messages/Beep/IDNotifyBeepState.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAStartBeepFile.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAStartADASBeep.h"
#include "InternalComponentCommunication/Messages/Beep/IDNotifyAudioTestToneStatus.h"
#include "InternalComponentCommunication/Messages/Beep/IDNotifyBeepFileStatus.h"
#include "InternalComponentCommunication/Messages/Beep/ID_NotifyLDWUserVolume.h"
#include "InternalComponentCommunication/Messages/Beep/ID_NotifyParkAssistVolume.h"
#include "InternalComponentCommunication/Messages/Beep/ID_UpdateAmpValList.h"
#include "InternalComponentCommunication/Messages/Beep/IDCCAUPATempMute.h"
#include "InternalComponentCommunication/Messages/Beep/ID_ADASSoundCollection.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"

#include "InternalComponentCommunication/Messages/Beep/ID_NotifyBeepName.h"
#include "InternalComponentCommunication/Messages/settings/IDSettings.h"
#include "InternalComponentCommunication/Messages/Sound/ID_ArkamysFeature.h"
#include "InternalComponentCommunication/Messages/Source/IDIntSource.h"
#include "InternalComponentCommunication/Messages/Surround/IDSurroundSetting.h"
#include "InternalComponentCommunication/Messages/Source/IDSetAudioRoute.h"
#include "InternalComponentCommunication/Messages/Source/IDSequenceCtrl.h"
#include "InternalComponentCommunication/Messages/VolumeOffset/IDAudioPropertyOffset.h"
#include "InternalComponentCommunication/Messages/Diag/IDGetDiagResult.h"
#include "InternalComponentCommunication/Messages/mute/IDNotifySystemMute.h"
#include "InternalComponentCommunication/Messages/SoundConfig/IDSetSoundSystemConfig.h"
#include "InternalComponentCommunication/Messages/power/ID_AudioState.h"
#include "InternalComponentCommunication/Messages/settings/IDProfileDataChanged.h"
#include "InternalComponentCommunication/Messages/Volume/ID_Amp_SetVolume.h"

#include "aud_sinkmgr_Gpio_If.h"

#include "util/Macro.h"
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"
#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"
#include "mute/stream/StreamMute.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SPIMixModes.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/EDTypeDefines.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSourceData.h"
#include "InternalComponentCommunication/DataTypes/MessageDataTypes/VolumeSPIMixData.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/PowerState.h"
#include "Sound/SoundHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
#include "VehicleDomainHandler/VehicleDomainHandlerMain.h"
#endif

#include "Sound/SoundToolClient.h"
#include "InternalComponentCommunication/Messages/Source/IDIntSource.h"
#include "InternalComponentCommunication/DataTypes/TypeConverter/SourceTypeConverter.h"
#include "Beep/Beep_defines.h"
#include "aud_sinkmanager/vd_amp_Msg/vd_amp_msg_surround.h"


#include "Diagnosis/Microphone/fc_audiomanager_Microphone_Diagnosis_main.h" //The new concept for all projects.


#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#include "aud_sinkmanager/aud_sinkmgr_main.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_VolumeMode.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_SPIMixVolume.h"

#include "Volume/VolumeManager.h"
#include "fc_audiomanager_componentfactory_if.h"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#include "Arkamys/ArkamysFeatInterface.h"


#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
#include "Arkamys/RNAIVI/ArkamysFeatureHandlerRNAIVI.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
#include "Arkamys/PSA/ArkamysFeatureHandler.h"
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA

#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
#include "EngineSound/RNAIVI/EngineSoundHandlerIVI.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI

#include "fc_audiomanager_clienthandler_DiagLog.h"
//#include "../../../../fc_audiomanager/InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "Beep_defines.h"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#include "vd_amp_MCANBose_Main.h"
#include "vd_amp_MasterAmplifierMCANUnit.h"
#include "AmplifierSound/AmplifierSoundHandler.h"
#include "AmplifierVolume/AmplifierVolumeHandler.h"
//#include "AmplifierVolume/AmplifierVolumeModeHandler.h"
#include "vd_amp_MCANBose_VolumeHandler.h"
#include "vd_amp_AudioAmplifierMCANUnit.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_Bose_Amplifier_DiagnosisStart.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_CommunicationError.h"
#endif
#include "vd_adr3Msg_If.h"
//#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_Bose_Amplifier_DiagnosisStart.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_AvailSettings.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_AudioOffState.h"
#include "InternalComponentCommunication/Messages/BOSE_Amp/ID_MainAudioAttenuation.h"
#include "config/dp/AudioUserDpIfSelect.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "Beep/Beep_ExtAmpHandlerMain.h"
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define MAX_PAYLOAD 16
#define ADR_RESOLUTION 4
#define FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION  1
#define FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MINOR_VERSION  0
#define FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_PATCH_VERSION  0

#define AUDIO_GENERATED_TOKEN_INVALID  (tU32(0))
#define PREMIUM_2 3

#define SINK_DEV_WITHOUT_ADR (tU8)42
#define SINK_DEV_PASSTHRU_ADR (tU8)43

#define BEEP_SKIP 3
#define SET_WELCOMESOUND_UPADTE_STATUS 1
#define RESET_WELCOMESOUND_UPADTE_STATUS 0
#define OEM_TYPE_RENAULT 0x08

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
enum tenTweeterSite
{
  NO_TWEETER    = 0x00,
  FRONT_TWEETER  = 0x01,
  REAR_TWEETER  = 0x02
  //FRONT_REAR_TWEETER = 0x03 // not used now
};
#endif

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/
/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/
//this comment is for eclipse auto format issues
BEGIN_MSG_MAP(fc_audiomanager_tclService_Audio_Function, ahl_tclBaseWork)

// Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
// method should be called on receiving a specific message.
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_AUDIOSOURCE,CCA_C_U8_OPCODE_METHODSTART, vOnMsAudioSource)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE,CCA_C_U8_OPCODE_METHODSTART, vOnMsAmpDeviceAudioRoute)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_MUTE,CCA_C_U8_OPCODE_METHODSTART, vOnMsMute)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ENTERTAINMENTMUTE,CCA_C_U8_OPCODE_METHODSTART, vOnMsEntertainmentMute)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_SYSTEMMUTE,CCA_C_U8_OPCODE_METHODSTART, vOnMsSystemMute)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_SET_MUTE_RAMP,CCA_C_U8_OPCODE_METHODSTART, vOnMsFading)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_BEEP, CCA_C_U8_OPCODE_METHODSTART, vOnMsBeep)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_AUDIOTESTTONE, CCA_C_U8_OPCODE_METHODSTART, vOnMsAudioTestTone)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_BEEPFILE, CCA_C_U8_OPCODE_METHODSTART, vOnMsAudioBeepFile)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_WELCOMESOUNDBEEPFILE,CCA_C_U8_OPCODE_METHODSTART,vOnMsWelcomeSoundAudioBeepFile) // used by SPM for welcomesound(Renault feature as of 10/09/2019)
//ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_BEEPSTATUS, CCA_C_U8_OPCODE_UPREG, vOnMsBeep)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_CUESTATE, CCA_C_U8_OPCODE_METHODSTART, vOnMsCueType)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_SPEAKERDIAGNOSISSTART, CCA_C_U8_OPCODE_METHODSTART, vOnMsDiagnosisSpeakerStart)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ENGINEERINGDATA, CCA_C_U8_OPCODE_SET, vOnPsEngineeringData)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_SETAUDIOPROPERTY, CCA_C_U8_OPCODE_SET, vOnPsSetAudioProperty)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE, CCA_C_U8_OPCODE_SET, vOnSetAdas_UpaSoundSet)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME, CCA_C_U8_OPCODE_SET, vOnSetAdas_ParkAssitVol)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME, CCA_C_U8_OPCODE_SET, vOnSetAdas_LDWUSerVol)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ADAS_UPAMUTE, CCA_C_U8_OPCODE_SET, vOnSetAdas_UpaMute)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE, CCA_C_U8_OPCODE_SET, vOnSetAdas_SRSoundNotification)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_ADAS_SETTINGSOUND, CCA_C_U8_OPCODE_METHODSTART, vOnMsAdas_SettingSound)
ON_MESSAGE_SVCDATA(MIDW_MASCFFI_C_U16_MCANBOSEAMP_VERSIONINFO,CCA_C_U8_OPCODE_METHODSTART, vOnMsMCANBose_VersionInfo)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::fc_audiomanager_tclService_Audio_Function(fc_audiomanager_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *
 *              Create an object of the base class ahl_tclBaseOneThreadService
 *              with a pointer to this application, the service identifier,
 *              the application identifier and the service version as parameters.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_audiomanager_tclService_Audio_Function::fc_audiomanager_tclService_Audio_Function(fc_audiomanager_tclApp* poMainAppl) :
      ahl_tclBaseOneThreadService(
      /* Application Pointer              */poMainAppl, /* ID of offered Service            */CCA_C_U16_SRV_AUDIOFUNC,
            /* MajorVersion of offered Service  */FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION,
            /* MinoreVersion of offered Service */FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MINOR_VERSION,
            /* PatchVersion of offered Service  */FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_PATCH_VERSION)
   , IF_MessageObserver<PO_MessageConfig::enID>("audio-manager service")
         // member initializers
         , pPO(InternalCommunicationAdapter::getInstance())
   , m_pStreamMute(NULL)
   , m_pFading(NULL)  // provide some testable response to ramp queries
   , poMuteMessage(NULL)
   , m_CCATransport()
   , m_pVolumeManager(NULL)
   , m_SoundHandler(NULL)
   , m_SoundToolClient(NULL)
   , m_Fading(NULL)
   , m_PowerState(NULL)
   , m_VolOffset_Manager(NULL)
   , m_poMainAppInstance(fc_audiomanager_tclApp::theServer())
   , m_ARM_Proxy(NULL)
   , m_poSinkMute(NULL)
   , m_u16AudioRegID(0)
   , m_PropertyStatus(NULL)
   , m_DiagAudMode(NULL)
   , m_muteOnAppStateChange(NULL)
   , m_Beep_ExtAmpHandlerMain(NULL)
   , m_updatestatus(0)
   , m_u16AudioTestToneRegID(0)
   , m_u16AudioTestToneAppID(0)
   , m_poMicrophoneDiagnosis(NULL)
   , m_poDiagnosisSpeaker(NULL)
   , m_activeSource((tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE)
   , m_AudioProperty()
   , m_bUPAUserMuteStatus(false)
   , m_bPrevUPAMuteStatus(false)
   , m_PrevParkAssitVol(3)
   , m_HFPDisplay_status(false)
   , m_bflag(0)
   , m_bUserProfileChangeStatus(false)
   , StoreAudioProperty()
   , m_bIsExtAmpConnected(false)
   , m_u8SoundConfigItem(0)
   , m_s8MainAudioAttenuation(0)
  // ,m_poMCANBoseAppl(NULL)
{
   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function() entered."));


   ETG_TRACE_USR4(("CCA mute result Observer"));

   m_poMainAppInstance = poMainAppl;

   m_Fading = OSAL_NEW Fading;
   m_pFading = static_cast<Fading_IF*>(m_Fading);  // public interface
   m_VolOffset_Manager = OSAL_NEW VolOffset_Manager;
   m_pStreamMute = StreamMute::getInstance();
   m_pStreamMute->vInitFading(m_Fading);
   //m_pFading= Fading::getInstance();

   m_ARM_Proxy = OSAL_NEW ARM_Proxy(m_pStreamMute);

   m_PropertyStatus = OSAL_NEW PropertyStatus(poMainAppl);
   //m_SoundToolClient = OSAL_NEW SoundToolClient(poMainAppl, this);
   m_SoundToolClient = fc_audiomanager_IClientHandler_Soundtool::poGetInstance(poMainAppl, this);
   m_poSinkMute= OSAL_NEW SinkMute(m_pStreamMute);
   m_PowerState = OSAL_NEW PowerStateHandler(poMainAppl, this);
   m_DiagAudMode = OSAL_NEW DiagAudMode(this);
   m_muteOnAppStateChange = OSAL_NEW MuteOnAppStateChange(m_pStreamMute,this);
   m_u16AudioTestToneRegID = 0x00;
   m_u16AudioTestToneAppID = 0x00;
//#ifndef VARIANT_S_FTR_ENABLE_G3G
   m_poMicrophoneDiagnosis = OSAL_NEW fc_audiomanager_tclMicrophone_Diagnosis(poMainAppl, this);
//#endif
   m_poDiagnosisSpeaker = OSAL_NEW fc_audiomanager_tclSpeaker_Diagnosis(this);

   m_bDiagResultQueueProcessing = false;
   m_bIsSystemMuteActive = false;

   m_ACSpeakerMode = EN_AUDIO_DIAG_AC_OFF;
  //pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyDiagResult);
  m_bBoseAmplifierStatus = false;
  AvailSettingsUnion_Obj.AvailSettingsValue = 0;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    vCheckAmplifierStatus();
  m_poMCANBoseAppl = NULL;
  m_AmplifierSoundHandler = NULL;
  m_AmplifierVolumeHandler = NULL;
  m_pVolumeManager = NULL;
  m_SoundHandler = NULL;
   if(m_bBoseAmplifierStatus)
   {
    m_poMCANBoseAppl = new vd_amp_MCANBose_Main(this);
    // m_AmplifierVolumeModeHandler = OSAL_NEW AmplifierVolumeModeHandler();
       m_AmplifierVolumeHandler = OSAL_NEW AmplifierVolumeHandler(this);
         m_AmplifierSoundHandler = OSAL_NEW AmplifierSoundHandler(this);
   }
   else
   {
      m_pVolumeManager = OSAL_NEW VolumeManager::VolumeManager(*this);
    m_SoundHandler = OSAL_NEW SoundHandler(poMainAppl, this);
   }
#else
     m_pVolumeManager = OSAL_NEW VolumeManager::VolumeManager(*this);
   m_SoundHandler = OSAL_NEW SoundHandler(poMainAppl, this);
#endif

pAudUsrDpIf   = AudioUserDpIfSelect::pGetAudUsrDpIf();
pAudUsrDpIf->s32GetParkAssistVolume(m_ParkAssitVol);

 if(IsPremium2Connected())
   m_Beep_ExtAmpHandlerMain= OSAL_NEW Beep_ExtAmpHandlerMain(this);

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->POMessages);

   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAResult_Mute);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyAudioTestToneStatus);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::IDSetSoundSystemConfig);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AudioState);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AvailSettings);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyMute);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_AudioSource);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_AmpDeviceAudioRoute);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ProfileDataChanged);
   pPO->POMessages->AddObserver(this,PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_MainAudioAttenuation);
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::~fc_audiomanager_tclService_Audio_Function(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_audiomanager_tclService_Audio_Function::~fc_audiomanager_tclService_Audio_Function(tVoid)
{
  ETG_TRACE_USR4(("~fc_audiomanager_tclService_Audio_Function() entered."));

    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  OSAL_DELETE (m_pVolumeManager);
  //OSAL_DELETE(m_pStreamMute);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_pStreamMute);
  m_pStreamMute->vDeleteMuteResponseTimer();
  m_pStreamMute = NULL;
  OSAL_DELETE(m_ARM_Proxy);
  OSAL_DELETE (m_Fading);
  m_pFading = NULL;  //  don't OSAL_DELETE(m_pFading); it's only a public, restricted duplicate
  OSAL_DELETE(m_SoundHandler);
  if(m_SoundToolClient != NULL)
  {
  OSAL_DELETE(m_SoundToolClient);
    m_SoundToolClient=NULL;
  }
  OSAL_DELETE(m_PropertyStatus);
  OSAL_DELETE (m_PowerState);
  OSAL_DELETE(m_VolOffset_Manager);
  OSAL_DELETE(m_poSinkMute);
  OSAL_DELETE(m_muteOnAppStateChange);
  pPO = NULL;
  m_poMainAppInstance = NULL;
  OSAL_DELETE(poMuteMessage);
  OSAL_DELETE(m_DiagAudMode);
//#ifndef VARIANT_S_FTR_ENABLE_G3G
  OSAL_DELETE(m_poMicrophoneDiagnosis);
//#endif
  OSAL_DELETE(m_poDiagnosisSpeaker);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
  OSAL_DELETE(m_poMCANBoseAppl);
  if (m_AmplifierVolumeHandler != NULL)
  {
    OSAL_DELETE m_AmplifierVolumeHandler;
    m_AmplifierVolumeHandler = NULL;
  }
  if (m_AmplifierSoundHandler != NULL)
  {
    OSAL_DELETE m_AmplifierSoundHandler;
    m_AmplifierSoundHandler = NULL;
  }
  //if (m_AmplifierVolumeModeHandler != NULL)
  //{
  //  OSAL_DELETE m_AmplifierVolumeModeHandler;
  //  m_AmplifierVolumeModeHandler = NULL;
  //}
#endif

   AudioUserDpIfSelect::vDeleteAudUsrDpIf();
  if(IsPremium2Connected())
  {
   OSAL_DELETE(m_Beep_ExtAmpHandlerMain);
   m_Beep_ExtAmpHandlerMain=NULL;
  }
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclService_Audio_Function::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              which is offered by this server has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
 *******************************************************************************/
//
tVoid fc_audiomanager_tclService_Audio_Function::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclService_Audio_Function::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              which is offered by this server has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
 *******************************************************************************/
//
tVoid fc_audiomanager_tclService_Audio_Function::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclService_Audio_Function::vOnLoopbackService()
 *
 * DESCRIPTION: Overrides method ahl_tclBaseOneThreadService::vOnLoopbackService().
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************/

 tVoid fc_audiomanager_tclService_Audio_Function::vOnLoopbackService(
      amt_tclServiceData* poMessage)
{

   tU16 u16FunctionId = poMessage->u16GetFunctionID();
   ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%4x",
               u16FunctionId));

   tBool dummyProperty = TRUE;
   tU16 dummyError = 0;
   switch (u16FunctionId)
   {
      case MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION:
        bProcessSet(poMessage, dummyProperty, dummyError);
      break;
      case MIDW_MASCFFI_C_U16_GALA:
    case MIDW_MASCFFI_C_U16_TREBLE:
      case MIDW_MASCFFI_C_U16_MIDRANGE:
      case MIDW_MASCFFI_C_U16_BASS:
      case MIDW_MASCFFI_C_U16_BALANCE:
    case MIDW_MASCFFI_C_U16_OPTIMIZATION:
      case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
    case MIDW_MASCFFI_C_U16_FADER:
    case MIDW_MASCFFI_C_U16_ROOMEFFECT:
    {
      fi_tclVisitorMessage oVisitorMsg(poMessage);
       if (m_SoundHandler && m_SoundHandler->bProcessSet(u16FunctionId, oVisitorMsg, dummyProperty, dummyError))
      {
        if (updateClients(u16FunctionId) != AIL_EN_N_NO_ERROR)
          {
            ETG_TRACE_ERR(("eUpdateClients():-> Updating the clients failed"));
          }
        else
          {
            ETG_TRACE_USR4(("eUpdateClients():-> Updating the clients passed"));
          }
      }
      else
        ETG_TRACE_ERR(("bProcessSet(). failed"));
    }
    break;
      default:
      {
         ETG_TRACE_ERR(("vOnLoopbackService(). Unknown iFID %u.", u16FunctionId));
         break;
      }
   }
}
/*******************************************************************************
 *
 * FUNCTION: tBool fc_audiomanager_tclService_Audio_Function
 *                 ::bStatusMessageFactory(tU16 u16FunctionId,
 *                                         amt_tclServiceData& roOutMsg,
 *                                         amt_tclServiceData* poInMsg)
 *
 * DESCRIPTION: This function is called by the CCA framework to request ANY
 *              property which is offered by this service. For each property
 *              accessed via parameter 'u16FunctionId' the user has to prepare
 *              the corresponding FI data object and to copy it to the
 *              referenced service data object 'roOutMsg'.
 *
 * PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
 *            [OUT] roOutMsg = Reference to the service data object to which the
 *                             content of the prepared FI data object should be
 *                             copied to.
 *            [IN] poInMsg = Selector message which is used to select dedicated
 *                           content to be copied to 'roOutMsg' instead of
 *                           updating the entire FI data object.
 *
 * RETURNVALUE: TRUE = For the requested property the FI data object was
 *                     successfully created and copied to the referenced service
 *                     data object 'roOutMsg'. The CCA framework sends a 'STATUS'
 *                     message of the updated property to each registered
 *                     clients.
 *              FALSE = Failed to create the FI data object for the requested
 *                      property and to update the referenced service data object
 *                      'roOutMsg' with the new property content. The CCA
 *                      framework sends an error message to the requesting
 *                      client.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
 *******************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg,
      amt_tclServiceData* poInMsg)
{
   (tVoid) poInMsg; // These lines are added to avoid LINT warnings. Please
   (tVoid) roOutMsg; // remove as soon as the variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.",
               u16FunctionId));

  // AUD_POINTER_CHECK_CALL (m_SoundHandler);
   AUD_POINTER_CHECK_CALL (m_PropertyStatus);

   AUD_POINTER_CHECK_CALL (m_DiagAudMode);
//#ifndef VARIANT_S_FTR_ENABLE_G3G
   AUD_POINTER_CHECK_CALL (m_poMicrophoneDiagnosis);
//#endif
   AUD_POINTER_CHECK_CALL (m_poDiagnosisSpeaker);

   switch (u16FunctionId)
   {
      // Handle creation of the FI data object for this function ID and the
      // handover to the referenced service data object 'roOutMsg' here ...
   case MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP:
      {
        dp_tclAudioManagerDPEntOnVolumeSet limitvolume;
        tU8 Onvolumelimit = 0;
        limitvolume.s32GetData(Onvolumelimit);

        midw_mascffi_tclMsgEntOnVolumeSetupStatus ostatus;
        ostatus.LimitValue = Onvolumelimit;

     bSuccess = fi_tclVisitorMessage(ostatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
                   .bHandOver(&roOutMsg);
     ostatus.vDestroy();
    }
      break;

      // delegate volume-related queries to volume management

      case MIDW_MASCFFI_C_U16_VOLUMELIST:
  {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
      if(m_AmplifierVolumeHandler != NULL)
      {
        bSuccess = m_AmplifierVolumeHandler->sendCCAVolumeListStatusMessage(roOutMsg, poInMsg);
      }
      else
      {
      AUD_POINTER_CHECK_CALL (m_pVolumeManager);
      bSuccess = m_pVolumeManager->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
      }
#else
      AUD_POINTER_CHECK_CALL (m_pVolumeManager);
      bSuccess = m_pVolumeManager->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
#endif
      break;
  }

      case MIDW_MASCFFI_C_U16_VOLUME:
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
      if(m_AmplifierVolumeHandler != NULL)
      {
        bSuccess = m_AmplifierVolumeHandler->sendCCAStatusMessage(roOutMsg, poInMsg);
      }
      else
      {
      AUD_POINTER_CHECK_CALL (m_pVolumeManager);
      bSuccess = m_pVolumeManager->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
      }
#else
      AUD_POINTER_CHECK_CALL (m_pVolumeManager);
      bSuccess = m_pVolumeManager->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
#endif
      break;
    case MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS:
      case MIDW_MASCFFI_C_U16_VOLUMELOCK:
      case MIDW_MASCFFI_C_U16_PDCATTENUATION:
      case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL:
      case MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION:
      case MIDW_MASCFFI_C_U16_OVERTEMPAMPLIFIERSTATUS:
      case MIDW_MASCFFI_C_U16_LSVALUESTATUS:  // for historical reasons
      if(m_pVolumeManager)
      bSuccess = m_pVolumeManager->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
    break;

     case MIDW_MASCFFI_C_U16_READMEASUREMENTRESULT:
     {
        midw_mascffi_tclMsgReadMeasurementResultStatus oDiagSpeakerResult_fi;

        m_poDiagnosisSpeaker -> GetTestResult(&oDiagSpeakerResult_fi);

         // stream to new CCA message and hand over to calling function
         bSuccess = fi_tclVisitorMessage(oDiagSpeakerResult_fi, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
               .bHandOver(&roOutMsg);

         //clean-up FI object
         oDiagSpeakerResult_fi.vDestroy();
     }
     break;

      case MIDW_MASCFFI_C_U16_TREBLE:
      case MIDW_MASCFFI_C_U16_MIDRANGE:
      case MIDW_MASCFFI_C_U16_BASS:
      case MIDW_MASCFFI_C_U16_BALANCE:
      case MIDW_MASCFFI_C_U16_GALA:
      case MIDW_MASCFFI_C_U16_LOUDNESS:
      case MIDW_MASCFFI_C_U16_FADER:
      case MIDW_MASCFFI_C_U16_AUXINLEVEL:
      case MIDW_MASCFFI_C_U16_BEEPLEVEL :
      case MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION:
      case MIDW_MASCFFI_C_U16_MEMSOUND:
      case MIDW_MASCFFI_C_U16_OPTIMIZATION:
      case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
      case MIDW_MASCFFI_C_U16_ROOMEFFECT:

    case MIDW_MASCFFI_C_U16_REAR_MUTE:
    case MIDW_MASCFFI_C_U16_GEOMETRY_MODE:
    case MIDW_MASCFFI_C_U16_FMENHANCERMODE:
    case MIDW_MASCFFI_C_U16_DIAGDEFSETPHASE:
    case MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL:
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    if(NULL != (m_AmplifierSoundHandler))
      bSuccess = m_AmplifierSoundHandler->bGetAmplifierStatusMessage(u16FunctionId, roOutMsg, poInMsg);
    else
    {
     AUD_POINTER_CHECK_CALL (m_SoundHandler);
         bSuccess = m_SoundHandler->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
    }
#else
    AUD_POINTER_CHECK_CALL (m_SoundHandler);
     bSuccess = m_SoundHandler->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
#endif
         break;
    }
    case MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION:
      {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
        if(NULL != (m_AmplifierSoundHandler))
        {
        bSuccess = bSendAvailSettingsStatus(roOutMsg,poInMsg);
        }
        else if((m_u8SoundConfigItem == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM8 ))
        {
          bSuccess = bSendPremium2AmpAvailSettingsStatus(roOutMsg,poInMsg);
        }
        else
        {
           AUD_POINTER_CHECK_CALL (m_SoundHandler);
           bSuccess = m_SoundHandler->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
        }

#else
     AUD_POINTER_CHECK_CALL (m_SoundHandler);
     bSuccess = m_SoundHandler->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
#endif
      }
      break;
      case MIDW_MASCFFI_C_U16_DIAGAUDMODE:
         bSuccess = m_DiagAudMode->bSendDiagAudModeStatus(roOutMsg, poInMsg);
         break;

      case MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE:
      {
          bSuccess = bSendAdas_UpaSoundStatus(roOutMsg);
      }
      break;
      case MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME:
      {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
      if(m_AmplifierVolumeHandler != NULL)
      {
          bSuccess = m_AmplifierVolumeHandler->bSendCCASonarVolumeStatusMessage(roOutMsg);
      }
      else
        bSuccess = bSendAdas_ParkAssitVolStatus(roOutMsg);
#else
        bSuccess = bSendAdas_ParkAssitVolStatus(roOutMsg);
#endif
      }
      break;
      case MIDW_MASCFFI_C_U16_ADAS_UPAMUTE:
      {
        bSuccess = bSendAdas_UpaMuteStatus(roOutMsg);
      }
      break;
    case MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE:
      {
        bSuccess = bSendAdas_SRSoundNotificationStatus(roOutMsg);
      }
      break;
    case MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME:
    {
      bSuccess = bSendAdas_LDWUserVolStatus(roOutMsg);
    }
    break;
      /*case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
         bSuccess = m_PropertyStatus->bSendEquPresetStatus(roOutMsg, poInMsg);
         break;*/

      case MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS:
         bSuccess = m_PropertyStatus->bSendFaderActivationStatus(roOutMsg, poInMsg);
         break;

//#ifndef VARIANT_S_FTR_ENABLE_G3G
      case MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS:
         bSuccess = m_poMicrophoneDiagnosis->bSendMicrophoneConnectionStatus(roOutMsg, poInMsg);
         break;
//#endif

   case MIDW_MASCFFI_C_U16_AUDIODEVICESTATUS:
         bSuccess = aud_sinkmgr_main::bSendAdr3Status(roOutMsg, poInMsg);
       break;

   case MIDW_MASCFFI_C_U16_USERPROFILECHANGE:
       bSuccess = bSendUserProfileChangeStatus(roOutMsg);
       break;

   case MIDW_MASCFFI_C_U16_BEEPSTATUS:

     if(!IsPremium2Connected())
     {
     bSuccess = m_poMainAppInstance->m_poBeepMain->bSendCCAStatusMessage(roOutMsg,poInMsg );
     }
     else {

       bSuccess = m_Beep_ExtAmpHandlerMain->bSendCCAStatusMessage(roOutMsg,poInMsg );


     }
     break;

   case MIDW_MASCFFI_C_U16_ENGINEERINGDATA:
     bSuccess = bSendEngineeringDataStatus(roOutMsg);
     break;
   case MIDW_MASCFFI_C_U16_SURROUNDSETTING:

     bSuccess = bSendSurroundModeStatus(roOutMsg);
     break;
   case MIDW_MASCFFI_C_U16_CENTER:
     {
      midw_mascffi_tclMsgCenterStatus oCenterGain_fi;

         if(AudioUserDpIfSelect::pGetAudUsrDpIf())
            AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetCenterGain(oCenterGain_fi.Center);

      oCenterGain_fi.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oCenterGain_fi.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

      // stream to new CCA message and hand over to calling function
      bSuccess = fi_tclVisitorMessage(oCenterGain_fi, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
               .bHandOver(&roOutMsg);

      //clean-up FI object
      oCenterGain_fi.vDestroy();
    }
     break;

    case MIDW_MASCFFI_C_U16_SUBWOOFER:
     {
       midw_mascffi_tclMsgSubWooferStatus oSubWoofer_fi;

         if(AudioUserDpIfSelect::pGetAudUsrDpIf())
            AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetSubwoofer(oSubWoofer_fi.SubWoofer);

      oSubWoofer_fi.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
      oSubWoofer_fi.Channel.enType = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;

      // stream to new CCA message and hand over to calling function
      bSuccess = fi_tclVisitorMessage(oSubWoofer_fi, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
               .bHandOver(&roOutMsg);

      //clean-up FI object
      oSubWoofer_fi.vDestroy();
     }
     break;
    case MIDW_MASCFFI_C_U16_AUDIOMODE:
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
      midw_mascffi_tclMsgAudioModeStatus oAudioModeStatus;

      oAudioModeStatus.AudioMode.enType =
          (midw_fi_tcl_e8_AudioMode::tenType)ArkamysFeatInterface::getInstance()->enGetAudioMode();

      // stream to new CCA message and hand over to calling function
      bSuccess = fi_tclVisitorMessage(oAudioModeStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
               .bHandOver(&roOutMsg);

      //clean-up FI object
      oAudioModeStatus.vDestroy();
#else
      bSuccess = TRUE;
#endif
    }
      break;
    case MIDW_MASCFFI_C_U16_AUDIOPILOTMODE:
    case MIDW_MASCFFI_C_U16_AUDIOPILOTINTENSITY:
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
        if(NULL != (m_AmplifierSoundHandler))
          bSuccess = m_AmplifierSoundHandler->bGetAmplifierStatusMessage(u16FunctionId, roOutMsg, poInMsg);
        else
        {
           AUD_POINTER_CHECK_CALL (m_SoundHandler);
           bSuccess = m_SoundHandler->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
        }
#else
        bSuccess = TRUE;
#endif
    }
    break;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
      case MIDW_MASCFFI_C_U16_ESESOUNDTYPE:
      case MIDW_MASCFFI_C_U16_ESEVOLUME:
      case MIDW_MASCFFI_C_U16_ESEDRIVEMODE:
      case MIDW_MASCFFI_C_U16_RSOUNDONOFF:
      case MIDW_MASCFFI_C_U16_RSOUNDSOUNDTYPE:
      case MIDW_MASCFFI_C_U16_RSOUNDVOLUME:
    case MIDW_MASCFFI_C_U16_RSOUNDACTIVATION:
         bSuccess = EngineSoundHandlerIVI::getInstance()->bGetStatusMessage(u16FunctionId, roOutMsg, poInMsg);
         break;
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   case MIDW_MASCFFI_C_U16_SURROUNDVOL:
   case MIDW_MASCFFI_C_U16_SURROUNDMODE:
   case MIDW_MASCFFI_C_U16_AMPDOWNMIXMODE:
   case MIDW_MASCFFI_C_U16_DRIVERSOUNDMODE:
   case MIDW_MASCFFI_C_U16_REARSOUNDMODE:
     {
       if(NULL != (m_AmplifierSoundHandler))
        bSuccess = m_AmplifierSoundHandler->bGetAmplifierStatusMessage(u16FunctionId, roOutMsg, poInMsg);
       break;
     }
   case MIDW_MASCFFI_C_U16_ANCSWVERSION:
   case MIDW_MASCFFI_C_U16_ASCSWVERSION:
   case MIDW_MASCFFI_C_U16_AMPSOFTWAREVERSION:
   case MIDW_MASCFFI_C_U16_AMPPARAMETERVERSION:
   case MIDW_MASCFFI_C_U16_AMPHARDWAREVERSION:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
       bSuccess = m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->bSendVersionInfoStatusMessage(u16FunctionId, roOutMsg, poInMsg);

     break;
   }
   case MIDW_MASCFFI_C_U16_AUDIOOFFMUTESTATE:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poAudioAmplifier_MCANUnit);
     bSuccess = m_poMCANBoseAppl->_poAudioAmplifier_MCANUnit->m_poModeMain->bSendAudioOffMuteStatus(roOutMsg, poInMsg);

     break;
   }
   case MIDW_MASCFFI_C_U16_EXTERNALAMPLIFIERCONNECTIONSTATE:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
     bSuccess = m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->bSendAmplifierConnectStatusMessage(roOutMsg);
     bSuccess = true;
        break;
   }

   case MIDW_MASCFFI_C_U16_CONNECTION:
   {
     if(m_poMCANBoseAppl !=NULL)
        (void)m_poMCANBoseAppl->bSendConnectionStatusMessage(roOutMsg);
     bSuccess = true;
      break;
   }

   case MIDW_MASCFFI_C_U16_GENERALSPEAKERTEST:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_GeneralSpeakerTest);
     bSuccess = m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_GeneralSpeakerTest->sendCCAStatusMessage(roOutMsg, poInMsg);
     break;
   }
   case MIDW_MASCFFI_C_U16_ANCASCSELFDIAGNOSTICSTATUS:
   case MIDW_MASCFFI_C_U16_ANCASCACTIVETEST:
   case MIDW_MASCFFI_C_U16_ANCASCSETTING:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings);
     bSuccess = m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings->bGetCCAStatusMessage(u16FunctionId, roOutMsg, poInMsg);
     break;
   }
#endif
   case MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP:
        {
        dp_tclAudioManagerDPMinimumOnVolLimit limitvolume;
        tU8 Onvolumelimit = 0;
        limitvolume.s32GetData(Onvolumelimit);

        midw_mascffi_tclMsgMinimumOnVolumeSetupStatus ostatus;
        ostatus.LimitValue = Onvolumelimit;

         bSuccess = fi_tclVisitorMessage(ostatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
                       .bHandOver(&roOutMsg);
         ostatus.vDestroy();
        }
      // delegate volume-related queries to volume management
    break;
   case MIDW_MASCFFI_C_U16_MAINAUDIOATTENUATION:
   {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
     midw_mascffi_tclMsgMainAudioAttenuationStatus oMainAudioAttenuationStatus;
     oMainAudioAttenuationStatus.Attenuation_Value = m_s8MainAudioAttenuation;
     // stream to new CCA message and hand over to calling function
     bSuccess = fi_tclVisitorMessage(oMainAudioAttenuationStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
                     .bHandOver(&roOutMsg);

     //clean-up FI object
     oMainAudioAttenuationStatus.vDestroy();
#else
     bSuccess = TRUE;
#endif
     break;
   }
   case MIDW_MASCFFI_C_U16_REMOVEWELCOMESOUND:
   {
     ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function:: MIDW_MASCFFI_C_U16_REMOVEWELCOMESOUND case."));
     midw_mascffi_tclMsgRemoveWelcomeSoundStatus oRemoveWelcomeSoundStatus;
     oRemoveWelcomeSoundStatus.updatestatus = m_updatestatus;
        bSuccess = fi_tclVisitorMessage(oRemoveWelcomeSoundStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
                 .bHandOver(&roOutMsg);
       oRemoveWelcomeSoundStatus.vDestroy();
       m_updatestatus = RESET_WELCOMESOUND_UPADTE_STATUS;
    break;
   }
      default:
         break;

   }

   if (FALSE == bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = 0x%4x' failed.", u16FunctionId));

      // NORMAL_M_ASSERT_ALWAYS(); //#Ma.o, because of anoying trace output
   }

   return (bSuccess);
}

ail_tenCommunicationError fc_audiomanager_tclService_Audio_Function::updateClients(tU16 u16FunctionId)
{
   return eUpdateClients(u16FunctionId);
}

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI

tBool fc_audiomanager_tclService_Audio_Function::bSendAvailSettingsStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg )
 {
   (tVoid)poInMsg;
   (tVoid)roOutMsg;


   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::bSendAvailSettingsStatus called."));
   midw_mascffi_tclMsgAmpAvailFunctionStatus oAmpAvailFunctionStatus;
   tBool bRetVal = false;

   oAmpAvailFunctionStatus.Bass = AvailSettingsUnion_Obj.AvailSettingsBits_obj.Bass;
   oAmpAvailFunctionStatus.Middle = AvailSettingsUnion_Obj.AvailSettingsBits_obj.Middle;
   oAmpAvailFunctionStatus.Treble = AvailSettingsUnion_Obj.AvailSettingsBits_obj.Treble;
   oAmpAvailFunctionStatus.Balance = AvailSettingsUnion_Obj.AvailSettingsBits_obj.Balance;
   oAmpAvailFunctionStatus.Fader = AvailSettingsUnion_Obj.AvailSettingsBits_obj.Fader;
   oAmpAvailFunctionStatus.AudioPilot = AvailSettingsUnion_Obj.AvailSettingsBits_obj.AudioPilot;
   oAmpAvailFunctionStatus.ANC = AvailSettingsUnion_Obj.AvailSettingsBits_obj.ANC;
   oAmpAvailFunctionStatus.AmpDownMix = AvailSettingsUnion_Obj.AvailSettingsBits_obj.AmpDownMix;
   oAmpAvailFunctionStatus.SurroundVol = AvailSettingsUnion_Obj.AvailSettingsBits_obj.SurroundVol;
   oAmpAvailFunctionStatus.Gala = AvailSettingsUnion_Obj.AvailSettingsBits_obj.Gala;
   oAmpAvailFunctionStatus.SurroundMode= AvailSettingsUnion_Obj.AvailSettingsBits_obj.SurroundMode;
   oAmpAvailFunctionStatus.RearSoundMode = AvailSettingsUnion_Obj.AvailSettingsBits_obj.RearSoundMode;
   oAmpAvailFunctionStatus.DriverSoundMode = AvailSettingsUnion_Obj.AvailSettingsBits_obj.DrivenSoundMode;
   oAmpAvailFunctionStatus.ASC = AvailSettingsUnion_Obj.AvailSettingsBits_obj.ASC;



  fi_tclVisitorMessage oCCaMsg(oAmpAvailFunctionStatus);

  oAmpAvailFunctionStatus.vDestroy();
   bRetVal = oCCaMsg.bHandOver(&roOutMsg);
   return bRetVal;
 }

tBool fc_audiomanager_tclService_Audio_Function::bSendPremium2AmpAvailSettingsStatus(amt_tclServiceData& roOutMsg, amt_tclServiceData* poInMsg )
 {
   (tVoid)poInMsg;
   (tVoid)roOutMsg;

#define ESE_MASK_BIT 0x0001
#define ANC_MASK_BIT 0x0002
#define SOUNDAMBIANCE_MASK_BIT 0x0004
#define AUDIOPILOT_MASK_BIT 0x0008

#define FADER_MASK_BIT 0x0200
#define BALANCE_MASK_BIT 0x0400
#define TREBLE_MASK_BIT 0x0800
#define MIDDLE_MASK_BIT 0x1000
#define BASS_MASK_BIT 0x2000

   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::bSendPremium2AmpAvailSettingsStatus called. %d", AvailSettingsUnion_Obj.AvailSettingsValue));
   midw_mascffi_tclMsgAmpAvailFunctionStatus oAmpAvailFunctionStatus;
   tBool bRetVal = false;

   oAmpAvailFunctionStatus.Bass = ((AvailSettingsUnion_Obj.AvailSettingsValue & BASS_MASK_BIT) >> 13);
   oAmpAvailFunctionStatus.Middle = ((AvailSettingsUnion_Obj.AvailSettingsValue & MIDDLE_MASK_BIT) >> 12);
   oAmpAvailFunctionStatus.Treble = ((AvailSettingsUnion_Obj.AvailSettingsValue & TREBLE_MASK_BIT)>>11);
   oAmpAvailFunctionStatus.Balance = ((AvailSettingsUnion_Obj.AvailSettingsValue & BALANCE_MASK_BIT)>>10);
   oAmpAvailFunctionStatus.Fader = ((AvailSettingsUnion_Obj.AvailSettingsValue & FADER_MASK_BIT)>>9);
   oAmpAvailFunctionStatus.AudioPilot = ((AvailSettingsUnion_Obj.AvailSettingsValue & AUDIOPILOT_MASK_BIT)>>3);
   oAmpAvailFunctionStatus.ANC = ((AvailSettingsUnion_Obj.AvailSettingsValue & ANC_MASK_BIT)>>1);
   oAmpAvailFunctionStatus.SoundAmbiance = ((AvailSettingsUnion_Obj.AvailSettingsValue & SOUNDAMBIANCE_MASK_BIT)>>2);
   oAmpAvailFunctionStatus.ESE = ((AvailSettingsUnion_Obj.AvailSettingsValue & ESE_MASK_BIT));


  fi_tclVisitorMessage oCCaMsg(oAmpAvailFunctionStatus);

  oAmpAvailFunctionStatus.vDestroy();
   bRetVal = oCCaMsg.bHandOver(&roOutMsg);
   return bRetVal;
 }

#endif
/*******************************************************************************
 *
 * FUNCTION: tBool fc_audiomanager_tclService_Audio_Function
 *                 ::bProcessSet(amt_tclServiceData* poMessage,
 *                               tBool& bPropertyChanged,
 *                               tU16& u16ErrorCode)
 *
 * DESCRIPTION: This function is called by the CCA framework when it has
 *              received a message for a property with Opcode 'SET' or 'PURESET'
 *              and there is no dedicated handler function defined in the
 *              message map for this pair of FID and opcode. The user has to
 *              set the application specific property to the requested value
 *              and the CCA framework then cares about informing the requesting
 *              client as well as other registered clients.
 *
 * PARAMETER: [IN] poMessage = Property to be set.
 *            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
 *                                     if property has changed. Otherwise to be
 *                                     set to FALSE (default).
 *            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
 *                                 otherwise don't touch.
 *
 * RETURNVALUE: TRUE = Property successfully set to the passed value. The CCA
 *                     framework sends a 'STATUS' message to the requesting
 *                     client if the opcode was 'SET'. Othwerwise if opcode
 *                     was 'PURESET' there is no 'STATUS' message sent to the
 *                     requesting client. The CCA framework will send a 'STATUS'
 *                     message to other registered clients as well if the [OUT]
 *                     parameter 'bPropertyChanged' is set to TRUE.
 *             FALSE = Failed to set the property to the passed value. The CCA
 *                     framework sends an error message to the requesting client.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::bProcessSet().
 *******************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bProcessSet(amt_tclServiceData* poMessage, tBool& bPropertyChanged, tU16& u16ErrorCode)
{
   tBool bSuccess = FALSE;

   if (NULL == poMessage)
   {
      ETG_TRACE_FATAL(("bProcessSet(): NULL-message received"))
      return bSuccess;
   }

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
// Handle property setting for this function ID here ...

// Set local variable 'bSuccess' to TRUE if setting the propery to the new
// value was successfull.

// Set [OUT] parameter 'bPropertyChanged' to TRUE if the value of the just
// set property has changed.

   // delegate volume-related queries to volume management
   case MIDW_MASCFFI_C_U16_VOLUMELIST:
   case MIDW_MASCFFI_C_U16_VOLUME:
   {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    if(m_AmplifierVolumeHandler)
     bSuccess = m_AmplifierVolumeHandler->bVolumeProcessSet(*poMessage, bPropertyChanged, u16ErrorCode);
  else
  {
    if (m_pVolumeManager)
      bSuccess = m_pVolumeManager->bProcessSet (*poMessage, bPropertyChanged, u16ErrorCode);
  }

#else
   if (m_pVolumeManager)
            bSuccess = m_pVolumeManager->bProcessSet (*poMessage, bPropertyChanged, u16ErrorCode);
         else
            ETG_TRACE_ERR(("ERROR m_pVolumeManager is NULL"));
#endif
   }
      break;
   case MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS:
   case MIDW_MASCFFI_C_U16_VOLUMELOCK:
   case MIDW_MASCFFI_C_U16_PDCATTENUATION:
   case MIDW_MASCFFI_C_U16_PDCATTENUATIONLEVEL:
   case MIDW_MASCFFI_C_U16_OVERTEMPREDUCTION:
   case MIDW_MASCFFI_C_U16_ENTONVOLUMESETUP:
   case MIDW_MASCFFI_C_U16_MINIMUMONVOLUMESETUP:
   case MIDW_MASCFFI_C_U16_OVERTEMPAMPLIFIERSTATUS:
      {
         if (m_pVolumeManager)
            bSuccess = m_pVolumeManager->bProcessSet (*poMessage, bPropertyChanged, u16ErrorCode);
         else
            ETG_TRACE_ERR(("ERROR m_pVolumeManager is NULL"));
      }
      break;

   case MIDW_MASCFFI_C_U16_BASS :
   case MIDW_MASCFFI_C_U16_MIDRANGE :
   case MIDW_MASCFFI_C_U16_TREBLE:
   case MIDW_MASCFFI_C_U16_BALANCE  :
   case MIDW_MASCFFI_C_U16_GALA  :
   case MIDW_MASCFFI_C_U16_LOUDNESS :
   case MIDW_MASCFFI_C_U16_FADER :
   case MIDW_MASCFFI_C_U16_AUXINLEVEL :
   case MIDW_MASCFFI_C_U16_BEEPLEVEL :
   case MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION :
   case MIDW_MASCFFI_C_U16_MEMSOUND :
   case MIDW_MASCFFI_C_U16_OPTIMIZATION:
   case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
   case MIDW_MASCFFI_C_U16_ROOMEFFECT:
   case MIDW_MASCFFI_C_U16_REAR_MUTE:
   case MIDW_MASCFFI_C_U16_GEOMETRY_MODE:
   case MIDW_MASCFFI_C_U16_FMENHANCERMODE:
   case MIDW_MASCFFI_C_U16_AUTOMATICGAINCONTROL:
      {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
     if (NULL != (m_AmplifierSoundHandler))
      bSuccess = m_AmplifierSoundHandler->bAmplifierProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
         else
     {
      AUD_POINTER_CHECK_CALL (m_SoundHandler);
            bSuccess = m_SoundHandler->bProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
     }
#else
      AUD_POINTER_CHECK_CALL (m_SoundHandler);
     bSuccess = m_SoundHandler->bProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
#endif
      }
      break;

   case MIDW_MASCFFI_C_U16_DIAGAUDMODE:
      {
         midw_mascffi_tclMsgDiagAudModeSet Ms;
         (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

         ID_CCAStart_AudDiagMode oAudDiagMode((midw_fi_tcl_e8_DiagAudMode::tenType)Ms.DiagAudMode.enType,
             (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Ms.OnVolLimiterMode.enType,
             (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Ms.MuteRampMode.enType,
             (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Ms.VolumeRampMode.enType,
             (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Ms.clippingMode.enType,
             (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Ms.PresetMode.enType);
         InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAudDiagMode);
     bSuccess = TRUE;
     Ms.vDestroy();
      }
      break;
#if defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV) || defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
  case MIDW_MASCFFI_C_U16_PRIVATEMODEMIXVOLUME:
      {
         midw_mascffi_tclMsgPrivateModeMixVolumeSet Ms;
         (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);
     ETG_TRACE_USR4(("bProcessSet():: Ms.PMMixVolume = %d.", Ms.PMMixVolume));
     if(0 == Ms.PMMixVolume)
     {
       ID_CANAttenuation objCANattenuation(FALSE, Ms.PMMixVolume);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&objCANattenuation);
     }else
     {
       ID_CANAttenuation objCANattenuation(TRUE, Ms.PMMixVolume);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&objCANattenuation);
     }
     bSuccess = TRUE;
     Ms.vDestroy();
      }
      break;
#endif
  case MIDW_MASCFFI_C_U16_SURROUNDSETTING:
      {
         midw_mascffi_tclMsgSurroundSettingSet Ms;
         (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);
         midw_fi_tcl_e8_SurroundSetting SurroundLevel = Ms.Surround;

         ETG_TRACE_USR4(("SUrround Level = %d" , SurroundLevel.enType));
         Ms.vDestroy();

         if((SurroundLevel.enType >= SURROUNDLEVEL_MIN_VALUE)&&(SurroundLevel.enType < SURROUNDLEVEL_MAX_VALUE))
         {
            if(AudioUserDpIfSelect::pGetAudUsrDpIf())
               AudioUserDpIfSelect::pGetAudUsrDpIf()->s32SetSurroundLevel(SurroundLevel.enType);

            ETG_TRACE_USR4(("SurroundLevel stored in datapool and Message Posted"));
            ID_SurroundSetting oSurroundSetting(SurroundLevel);
            InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSurroundSetting);
         }

         else
         {
           ETG_TRACE_ERR(("SUrround Level out of range!!!!!!!!!!!!!"));
         }

       bSuccess = TRUE;
       bPropertyChanged = TRUE;
      }
      break;

   /*case MIDW_MASCFFI_C_U16_EQUALISERPRESET:
      {
         if (m_PropertyStatus)
            bSuccess = m_PropertyStatus->bSetEquPreset(oVisitorMsg, bPropertyChanged, u16ErrorCode);
         else
            ETG_TRACE_ERR(("ERROR m_PropertyStatus is NULL"));
      }
      break;*/

    case MIDW_MASCFFI_C_U16_CENTER:
      {
     ETG_TRACE_USR4(("bProcessSet():CENTERGAIN"));
     if(m_VolOffset_Manager!=NULL)
     m_VolOffset_Manager->vCalcCenterGain(oVisitorMsg);
     bSuccess = TRUE;
     bPropertyChanged = TRUE;
    }
      break;
    case MIDW_MASCFFI_C_U16_SUBWOOFER:
      {
     ETG_TRACE_USR4(("bProcessSet():SUBWOOFER"));
    //feature switch added to re-use the property for virtual subwoofer in A-IVI, rest of the projects use the actual subwoofer
    #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
     if (m_SoundHandler)
            bSuccess = m_SoundHandler->bProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
         else
            ETG_TRACE_ERR(("ERROR m_SoundHandler is NULL"));
    #else
     if(m_VolOffset_Manager!=NULL)
        m_VolOffset_Manager->vCalcSubWoofer(oVisitorMsg);
     bSuccess = TRUE;
     bPropertyChanged = TRUE;
    #endif
      }
      break;

    case MIDW_MASCFFI_C_U16_AUDIOPILOTMODE:
    case MIDW_MASCFFI_C_U16_AUDIOPILOTINTENSITY:
    {
      ETG_TRACE_USR4(("bProcessSet():Audio Pilot"));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
      if (NULL != (m_AmplifierSoundHandler))
        bSuccess = m_AmplifierSoundHandler->bAmplifierProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
      else
      {
        AUD_POINTER_CHECK_CALL (m_SoundHandler);
        bSuccess = m_SoundHandler->bProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
      }
#else
        bSuccess = TRUE;
        bPropertyChanged = TRUE;
#endif
    }
    break;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
   case MIDW_MASCFFI_C_U16_ESESOUNDTYPE:
   case MIDW_MASCFFI_C_U16_ESEVOLUME:
   case MIDW_MASCFFI_C_U16_ESEDRIVEMODE:
   case MIDW_MASCFFI_C_U16_RSOUNDONOFF:
   case MIDW_MASCFFI_C_U16_RSOUNDSOUNDTYPE:
   case MIDW_MASCFFI_C_U16_RSOUNDVOLUME:
   case MIDW_MASCFFI_C_U16_RSOUNDACTIVATION:
      bSuccess = EngineSoundHandlerIVI::getInstance()->bProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
      break;
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   case MIDW_MASCFFI_C_U16_SURROUNDVOL:
   case MIDW_MASCFFI_C_U16_SURROUNDMODE:
   case MIDW_MASCFFI_C_U16_AMPDOWNMIXMODE:
   case MIDW_MASCFFI_C_U16_DRIVERSOUNDMODE:
   case MIDW_MASCFFI_C_U16_REARSOUNDMODE:
     {
       if(NULL != (m_AmplifierSoundHandler))
         bSuccess = m_AmplifierSoundHandler->bAmplifierProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
       break;
     }

   case MIDW_MASCFFI_C_U16_AUDIOOFFMUTESTATE:
   {
     midw_mascffi_tclMsgAudioOFFMuteStateSet inmsg;
         tU8 AudioOffState = 0;
      if(oVisitorMsg.s32GetData(inmsg, FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION_FI_MAJOR_VERSION) != OSAL_ERROR)
       {
        ETG_TRACE_USR4(("Process Set has received the Audio Off state 0x%x", inmsg.MuteState));
        AudioOffState = inmsg.MuteState;
       }

     ID_AudioOffState oAudioOffState(AudioOffState);
     InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAudioOffState);

     bSuccess = TRUE;
     break;
   }

   case MIDW_MASCFFI_C_U16_GENERALSPEAKERTEST:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_GeneralSpeakerTest);
     bSuccess = m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_GeneralSpeakerTest->handleSet(oVisitorMsg);
     break;
   }
   case MIDW_MASCFFI_C_U16_ANCASCSELFDIAGNOSTICSTATUS:
   case MIDW_MASCFFI_C_U16_ANCASCACTIVETEST:
   case MIDW_MASCFFI_C_U16_ANCASCSETTING:
   {
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
     AUD_POINTER_CHECK_CALL (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings);
     bSuccess = m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings->bANCASCProcessSet(u16FunctionId, oVisitorMsg, bPropertyChanged, u16ErrorCode);
     break;
   }
#endif
   case MIDW_MASCFFI_C_U16_AUDIOSOURCE:
   case MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE:
   case MIDW_MASCFFI_C_U16_MUTE:
   case MIDW_MASCFFI_C_U16_SET_MUTE_RAMP:

   case MIDW_MASCFFI_C_U16_BEEP :
   case MIDW_MASCFFI_C_U16_AUDIOTESTTONE:

   case MIDW_MASCFFI_C_U16_BEEPSTATUS :
   case MIDW_MASCFFI_C_U16_AUDIODEVICESTATUS:
   case MIDW_MASCFFI_C_U16_CUESTATE  :

   default:
      ETG_TRACE_ERR(("bProcessSet() entered for unknown FID"));
      break;
   }

   if (FALSE == bSuccess)
   {
      u16ErrorCode = CCA_C_U16_ERROR_UNKNOWN_FCT_ID;

      ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return (bSuccess);
}

tVoid fc_audiomanager_tclService_Audio_Function::callPOIDIntSource (tPCUChar pData)const
{
   ETG_TRACE_USR4(("SetInternalSource: "));
   ETG_TRACE_USR4(("pData=0x%02x",ETG_LIST_LEN((1+pData[0])), ETG_LIST_PTR_T8(pData)));

   VolumeSourceData Data;
   Data.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType) pData[2]);
   Data.m_Channel = (midw_fi_tcl_e8_AudioChannel::tenType) pData[3];
   Data.m_Source =  (tenInternalSource) pData[4];
   Data.m_ClientSource = (tU8) pData[5];
   Data.printData();

   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
   IDIntSource oIntSource(Data);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oIntSource);
}


/********************************************************************************
 * vOnMethodStart()
 *******************************************************************************/
//
/* virtual */  tVoid fc_audiomanager_tclService_Audio_Function:: vOnMethodStart (tU16 u16FunctionId, amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
   switch (u16FunctionId)
   {
      case MIDW_MASCFFI_C_U16_VOLUMEMODE:
      case MIDW_MASCFFI_C_U16_PERFORMONVOLUMELIMIT:
         AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_pVolumeManager);
         m_pVolumeManager->vOnMethodStart(poMessage->u16GetFunctionID(), *poMessage);
         break;

      default:
         // iterate through message map defined above
         ahl_tclBaseOneThreadService::vOnMethodStart(u16FunctionId, poMessage);
         break;
   }
}

/********************************************************************************
 * vOnLoadSettings()
 *******************************************************************************/
//
tVoid fc_audiomanager_tclService_Audio_Function::vOnLoadSettings()
{
   // just forward this to anyone who needs it
   if(!m_bBoseAmplifierStatus)
   {
   if (m_pVolumeManager)
      m_pVolumeManager->vOnLoadSettings();

   if (m_SoundHandler != NULL)
      m_SoundHandler->vOnLoadSettings();
   }
   if(m_VolOffset_Manager != NULL)
      m_VolOffset_Manager->vOnLoadSettings();

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   if(m_bBoseAmplifierStatus && (NULL != (m_AmplifierSoundHandler)))
     m_AmplifierSoundHandler->vOnLoadSettings();
#endif
}

/********************************************************************************
 * vTraceRx(tPCUChar pcu8Data)
 *******************************************************************************/
//
tVoid fc_audiomanager_tclService_Audio_Function::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
  //AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_PowerState);
  //AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poDiagnosisSpeaker);

   ETG_TRACE_USR4((" fc_audiomanager_tclService_Audio_Function::vTraceRx entered."));
// Eclipse Auto Formatter can't handle ETG define. Without this comment it'll merge both ETG together.
   ETG_TRACE_USR4(("vTrace_Rx()\n length of TTFis message=%u,\n pcu8Data=0x%02x",size,ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));
  //tU8 u8Data[6];

   if (pcu8Data == NULL)
      return;

  if (size > 2)
  {
    ETG_TRACE_USR4(("vTrace_Rx(): Processing %i", ETG_CENUM(TRC::tenTrcFuncIn_AudSrvFun, pcu8Data[1])));
    switch (pcu8Data[1]) // tenTrcFuncInput
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
      case TRC::ArkamysSetParameter: // Compare to fc_audiomanager.trc
        vHandleTRCArkamysSetParam(pcu8Data);
        break;
      case TRC::ArkamysDebug:
        vHandleTRCArkamysDebug(size,pcu8Data);
        break;
      case TRC::ArkamysFeature:
        vHandleTRCArkamysFeature(pcu8Data);
        break;
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
      case TRC::EngineSoundFeature:
        EngineSoundHandlerIVI::getInstance()->vHandleTTFisCmd(size, pcu8Data);
        break;
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
      case TRC::DiagnosisSpeaker:
        ETG_TRACE_USR4(("Received DiagnosisSpeaker"));
        if(m_poDiagnosisSpeaker)
        m_poDiagnosisSpeaker->deliverTTFisMessage (size, pcu8Data);
        break;
      case TRC::SpeakerDiagnosisStart:
        vHandleTRCSpeakerDiagnosisStart(pcu8Data);
        break;
      case TRC::enSetAudioSource:
      case TRC::enSetCCAAudioSource:
      case TRC::enSetSource:
      case TRC::enIntSource:
      case TRC::enSetAmpDeviceAudioRoute:
        vHandleTRCSetAudioSource(size, pcu8Data);
        break;
      case TRC::enSetVolume:
      case TRC::enSetVolumeMode:
      case TRC::VolumeLock:
      case TRC::PerformOnVolumeLimit:
      case TRC::PDCAttenuation:
      case TRC::PDCAttenuationLevel:
      case TRC::OverTempReduction:
        if(m_pVolumeManager)
        m_pVolumeManager->vHandleTTFisCommand(size, pcu8Data);
        break;
      case TRC::enDiagAudioGain:
       vHandleTRCDiagAudioGain(pcu8Data);
        break;
      case TRC::RemoteSession:
      vHandleTRCRemoteSession(pcu8Data);
        break;
      case TRC::SetAuxInLevel:
        vHandleTRCSetAuxInLevel(pcu8Data);
        break;
      case TRC::CCA_Cue:
        vHandleTRCCCA_Cue(pcu8Data);
        break;
      case TRC::SpeedStatus:
        vHandleTRCSpeedStatus(pcu8Data);
        break;
      case TRC::NotifyADRMute:
      case TRC::ARMMute:
        vHandleTRCADRnARMMute(pcu8Data);
        break;
      case TRC::SetBeep:
        vHandleTRCSetBeep(pcu8Data);
        break;
      case TRC::AudioTestTone:
        vHandleTRCAudioTestTone(pcu8Data);
        break;
      case TRC::enSetPowerState:
        if(m_PowerState)
        m_PowerState->deliverTTFisMessage(size, pcu8Data);
        break;
      case TRC::enAudLinSetting_HMI:
      case TRC::enAudLinSetting_Diagnostics:
        vHandleTRCenAudLinSetting(pcu8Data);
        break;
      case TRC::InputGainOffset:
        traceInputGainOffset(pcu8Data);
        break;
      case TRC::SpiAttenuation:
        traceInputSPIMIX(pcu8Data);
        break;
      case TRC::BeepLevel:
        traceInputBeepLevel(pcu8Data);
        break;
      case TRC::BeepFromFile:
        vHandleTRCBeepFromFile(pcu8Data);
        break;
     case TRC::SetAdasBeep:
        vHandleTRCAdasBeep(pcu8Data);
        break;
      case TRC::SetSoundProperty:
        vHandleTRCSoundProperty(pcu8Data);
        break;
          case TRC::SetSoundSystemConfig:
        vHandleTRCSetSoundSystemConfig(pcu8Data);
        break;
      case TRC::AmpAvailability:
        if(m_SoundHandler)
        m_SoundHandler->vTraceRx(size,pcu8Data);
        break;
                  case TRC::SetOnEntVol:
        traceInputSetOnEntVol(pcu8Data);
        break;
      case TRC::GetDiagResult:
      vHandleTRCGetDiagResult(pcu8Data);
      break;
           case TRC::SpeakerTestRequest:
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
           vHandleTRCGeneralSpeakerTest(pcu8Data);
  #endif
              break;
           case TRC::SelfTestRequest:
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
           vHandleTRCSelfDiag(pcu8Data);
  #endif
              break;
           case TRC::ANCASCActiveTest:
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
           vHandleTRCANCASCActiveTest(pcu8Data);
  #endif
              break;
           case TRC::BoseCommError:
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
           vHandleTRCBoseCommErrorTest(pcu8Data);
  #endif
              break;
           case TRC::ANCASCActivation:
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
             vHandleTRCANCASCActivation(pcu8Data);
  #endif
              break;
           case TRC::BoseVersionInfo:
  #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
           if(m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit)
              m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->vGetAmplifierVersionInfo();
  #endif
           break;
      default:
        ETG_TRACE_USR4(("default"));
        break;
    }
  }
}
//#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS


/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCArkamysSetParam(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the ArkamysSetParam Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCArkamysSetParam(tPCUChar pcu8Data)
{
  switch (pcu8Data[2]) // Compare to fc_audiomanager.trc
  {
  case 0x05: // SET_BALANCE
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
      tS16 value = ((tS16)pcu8Data[3]) - 17; // see fc_audiomanager.trc -> ARRAY Arkamys_Value = 0x0A: BALANCE_FADER_M7
      ArkamysFeatureHandler::getInstance()->setBalance(value);
#endif
      break;
    }
  case 0x06: // SET_FADER
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
      tS16 value = ((tS16)pcu8Data[3]) - 17;
      ArkamysFeatureHandler::getInstance()->setFader(value);
#endif
      break;
    }
  default:
    break;
  }
}


tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCArkamysFeature(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TRC::ArkamysFeature: %i Parameter: %i", pcu8Data[2], pcu8Data[3]));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
  ID_ArkamysFeature oMsg;
  oMsg.enArkamysFeature = static_cast<ArkamysConfig::tenArkamysFeature>(pcu8Data[2]);
  oMsg.u16ArkamysParameter = static_cast<tU16>(pcu8Data[3]);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMsg);
#endif

}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCArkamysDebug(tU32 size,tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the ArkamysDebug Trace Data
*
* PARAMETERS: tU32 size, tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCArkamysDebug(tU32 size, tPCUChar pcu8Data)
{
  ETG_TRACE_SYS_MIN(("TRC::ArkamysDebug: %i", pcu8Data[2]));
  switch (pcu8Data[2])
  {
  case 0x00: // READ_CAN
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_CSM_PSA_LINUX
                int iCANSteering = ArkamysFeatureHandler::getInstance() -> Debug_CheckCANSteering();
                ETG_TRACE_SYS_MIN(("Read CAN Steering: %i (1 == right, 2 == left)", iCANSteering));
#else
                ETG_TRACE_SYS_MIN(("CAN not implemented."));
#endif // VARIANT_S_FTR_ENABLE_FEAT_CSM_PSA_LINUX
                break;
             }
             case 0x01: // PRINT_STATUS
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
               ArkamysFeatInterface::getInstance() -> TraceStatus();
#endif
                break;
             case 0x02: // SET_HIFI
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
                if (size >= 4)
                {
                   ArkamysFeatureHandler::getInstance() -> Debug_SetHifi(static_cast<ArkamysConfig::tenArkamysHifiConfig>(pcu8Data[3]));
                }
                else
                {
                   ETG_TRACE_FATAL(("ArkamysDebug SET_HIFI: not enough parameter"));
                }
#else
                (void)size;
#endif
                break;
             case 0x03: // LINEAR_MODE_SET_ON
             case 0x04: // LINEAR_MODE_SET_OFF
             {
                ID_DiagLinearMode oDiagLinearMode(EN_LINEARMODE_SET);
                if (pcu8Data[2] == 0x04)
                {
                   oDiagLinearMode.enDiagLinearModePhase = EN_LINEARMODE_UNFREEZE;
                }
                pPO->POMessages->DeliverMsg(&oDiagLinearMode);
                break;
             }
             case 0x05: // LOAD_EOL
             {
               tBool bSuc = false;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
               bSuc = ArkamysEolInterfaceRNAIVI::getInstance() -> loadEolData();
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
               bSuc = ArkamysEolInterface::getInstance() -> loadEolData();
#endif

                ETG_TRACE_FATAL(("Load EOL %s", bSuc ? "SUCCESSFUL." : "FAILED."));
                break;
             }
             case 0x06: // WRITE_EOL
             {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_CLASSIC
               ArkamysEolInterfaceRNAIVI::getInstance() -> DebugWriteEol();
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS_PSA
               ArkamysEolInterface::getInstance() -> DebugWriteEol();
#endif
                break;
             }
             default:
                break;
             }

}
#endif

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCGeneralSpeakerTest(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the speaker test request - bose
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCGeneralSpeakerTest(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for General Speaker Test"));
    tU8 u8SpeakerTestRequest = pcu8Data[2];
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_GeneralSpeakerTest);
  m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_GeneralSpeakerTest->receiveTTFisMessage(u8SpeakerTestRequest);
}
#endif

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCANCASCActiveTest(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the ANC ASC Active test
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCANCASCActiveTest(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for ANC ASC Active Test"));
  tU8 u8TestRequest = pcu8Data[2];
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings);
  m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings->receiveANCASCActiveTestTTFisMessage(u8TestRequest);
}
#endif

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCANCASCActivation(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the ANC ASC Activation msgs
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCANCASCActivation(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for ANC ASC Activation"));
  tU8 u8ANCAvailability = pcu8Data[2];
  tU8 u8ASCAvailability = pcu8Data[3];
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings);
  m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->p_ANCASCSettings->receiveANCASCActivationTTFisMessage(u8ANCAvailability, u8ASCAvailability);
}
#endif

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSelfDiag(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the ANC ASC self diag
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSelfDiag(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for self diag req"));
   (void)pcu8Data;
  if(InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_BoseAmplifierDiagnosisStart oBoseAmpDiagStart;
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oBoseAmpDiagStart);
  }
}
#endif

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCBoseCommErrorTest(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Bose comm error test
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCBoseCommErrorTest(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for Bose comm error"));

  if(InternalCommunicationAdapter::getInstance() != NULL)
  {
       // Delivering message
      ID_CommunicationError oCommError((bose_TenMCAN_Unit)pcu8Data[2], (BOSE_tenTestResult)pcu8Data[3],(BOSE_tenTestType)pcu8Data[4]);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCommError);
  }
}
#endif
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSetSoundSystemConfig(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the soundsystem configuration
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetSoundSystemConfig(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for setsound system configuration"));
  tU8 soundconfig = pcu8Data[2];
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    IDSetSoundSystemConfig oSoundSys(soundconfig);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundSys);
  }
}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCDiagAudioGain(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Diag Audio Gain Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCDiagAudioGain(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for DiagAudioGain incoming\n"));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_DiagAudioGain VolumeGain((tS8) pcu8Data[2]);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeGain);
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCRemoteSession(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Remote session Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCRemoteSession(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("TTFIS command for Remote Session incoming\n"));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_DiagRemoteControl oDiagRemoteControl((tenDiagRemoteControlPhase) pcu8Data[2]);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oDiagRemoteControl);
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSetAuxInLevel(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Aux in level Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetAuxInLevel(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("SetAuxInLevel"));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    MSG_VolumeOffsetAux oVolumeOffsetAux((tenAuxInLevel)pcu8Data[2]) ;
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oVolumeOffsetAux);
    // InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&MSG_VolumeOffsetAux(tenAuxInLevel(pcu8Data[3])));
    ETG_TRACE_USR4(("SetAuxInLevel message delivered"));
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCCCA_Cue(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the CCA_due Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCCCA_Cue(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("CCA_Cue_Message"));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    MSG_CueState oCueState((tenCueType)pcu8Data[2],(tU16)pcu8Data[3]);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCueState);
    ETG_TRACE_USR4(("CCA_Cue_State message delivered"));
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSpeedStatus(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the speed status Trace Data
*
* PARAMETERS:  tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSpeedStatus(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("SpeedStatus"));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    tU8 SettingType = 0x00;//Car setting type hardcoded to Speed
    ID_CarSetting oCarSetting((tenCarSettingType)SettingType,(tS16)pcu8Data[2]);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCarSetting);
    // InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_CarSetting((tenCarSettingType)SettingType,(tS16)pcu8Data[3]));
    ETG_TRACE_USR4(("Speed status message delivered"));
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCADRnARMMute(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the ADR & ARM Mute Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCADRnARMMute(tPCUChar pcu8Data)
{
  tU8 u8regId = 0;
  tU8 u8Data[3];
  switch(pcu8Data[1])
  {
  case TRC::NotifyADRMute:
    ETG_TRACE_USR4(("ADR Notification"));
    u8Data[0] = pcu8Data[2];
    u8Data[1] = pcu8Data[3];
    StreamMute::getInstance()->vTTFisCmd(EN_AUDIO_TTFIS_CMD_MUTE_NOTIFY, u8Data);
    break;
  case TRC::ARMMute:
    ETG_TRACE_USR4(("ARM Mute"));
    if(m_ARM_Proxy != NULL)
    {
      u8regId = m_ARM_Proxy->u8getMuteRegId();
    }
    u8Data[0] = u8regId;
    u8Data[1] = pcu8Data[2];
    u8Data[2] = pcu8Data[3];
    StreamMute::getInstance()->vTTFisCmd(EN_AUDIO_TTFIS_CMD_MUTE, u8Data);
    break; //lint fix
  default:
    break;
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSetAudioSource(tU32 size,tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Audio source Trace Data
*
* PARAMETERS: tU32 size, tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetAudioSource(tU32 size,tPCUChar pcu8Data)
{
  switch(pcu8Data[1])
  {
    case TRC::enSetAudioSource:
    case TRC::enSetCCAAudioSource:
      vHandleTRCSetCCAAudioSource(size,pcu8Data);
      break;
    case TRC::enSetSource:
      vHandleTRCSetSource(size,pcu8Data);
      break;
    case TRC::enSetAmpDeviceAudioRoute:
      vHandleTRCSetAmpDevAudioRoute(size,pcu8Data);
      break;
    case TRC::enIntSource:
        callPOIDIntSource(pcu8Data);
        break;
    default:
      break;

  }

}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSetCCAAudioSource(tU32 size,tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Audio source Trace Data
*
* PARAMETERS: tU32 size, tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetCCAAudioSource(tU32 size,tPCUChar pcu8Data)
{
   tU16 uwResource = (tU16) pcu8Data[2];
  tU16 uwSource = (tU16) pcu8Data[3];

  ETG_TRACE_USR4(("SetAudioSource"));
  ETG_TRACE_USR4(("uwResource: 0x%4x", uwResource));
  ETG_TRACE_USR4(("uwSource  : 0x%4x", uwSource));
  ETG_TRACE_USR4(("pcu8Data=0x%02x",ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_CCAStart_AudioSource startAudioSource(uwResource, uwSource);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioSource);
    ETG_TRACE_USR4(("SetAudioSource- message delivered"));
  }

}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSetSource(tU32 size,tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Audio source Trace Data
*
* PARAMETERS: tU32 size, tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetSource(tU32 size,tPCUChar pcu8Data)
{
  tU16 uwResource = (tU16) pcu8Data[2];
  tU16 uwSource = (tU16) pcu8Data[3];

  ETG_TRACE_USR4(("SetSource (Stream, Source)"));
  ETG_TRACE_USR4(("incoming Stream: 0x%4x", uwResource));
  ETG_TRACE_USR4(("incoming Source  : 0x%4x", uwSource));
  ETG_TRACE_USR4(("pcu8Data=0x%02x",ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::getInstance());
  // daw2hi ToDo: consider original audio source. Currently hardcoded to 0.
  MSG_SetSource setSource((tenStream)uwResource, (tenSourceType) uwSource, 0, 0);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setSource);

}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSetAmpDevAudioRoute(tU32 size,tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Audio source Trace Data
*
* PARAMETERS: tU32 size, tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetAmpDevAudioRoute(tU32 size,tPCUChar pcu8Data)
{
     tU16 uwResource = (tU16) pcu8Data[2];
  tU16 uwSource = (tU16) pcu8Data[3];
  tU16 uwChannel = (tU16) pcu8Data[4];
  ETG_TRACE_USR4(("SetAmpDeviceAudioRoute"));
  ETG_TRACE_USR4(("pcu8Data=0x%02x",ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_CCAStart_AmpDeviceAudioRoute startAmpDeviceAudioRoute(uwResource, uwSource, uwChannel);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAmpDeviceAudioRoute);
    ETG_TRACE_USR4(("SetAmpDeviceAudioRoute- message delivered"));
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCSpeakerDiagnosisStart(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the SpeakerDiagnosisStart Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSpeakerDiagnosisStart(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("Received SpeakerDiagnosisStart: DC:0x%02x AC:0x%02x", pcu8Data[2], pcu8Data[3]));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poDiagnosisSpeaker);
  m_poDiagnosisSpeaker->SetDiagMode(static_cast<tenSpeakerModeDC>(pcu8Data[2]), static_cast<tenSpeakerModeAC>(pcu8Data[3]));

  tenSpeakerModeDC speakerModeDC;
  tenSpeakerModeAC speakerModeAC;

  speakerModeDC   = fc_audiomanager_tclSpeaker_Diagnosis::speakerModeFi2ADR_DC(static_cast<midw_fi_tcl_e8_DiagMode::tenType>(pcu8Data[2]));
  speakerModeAC   = fc_audiomanager_tclSpeaker_Diagnosis::speakerModeFi2ADR_AC(static_cast<midw_fi_tcl_e8_DiagMode::tenType>(pcu8Data[3]));
  m_ACSpeakerMode = speakerModeAC;
  m_poDiagnosisSpeaker->vStartDiagTest(speakerModeDC, speakerModeAC);
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCenAudLinSettingHMI(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the enAudLinSettingHMI Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCenAudLinSetting(tPCUChar pcu8Data)
{
  switch(pcu8Data[1])
  {
  case TRC::enAudLinSetting_HMI:

    ETG_TRACE_USR4(("Audio Linear Setting through HMI"));
    if (InternalCommunicationAdapter::getInstance() != NULL)
    {
      midw_fi_tcl_e8_DiagAudMode Data1;
      Data1.enType = (midw_fi_tcl_e8_DiagAudMode::tenType)pcu8Data[2];
      midw_fi_tcl_e8_GenericDiagAudMode Data2;
      Data2.enType = (midw_fi_tcl_e8_GenericDiagAudMode::tenType)pcu8Data[3];
      midw_fi_tcl_e8_GenericDiagAudMode Data3;
      Data3.enType = (midw_fi_tcl_e8_GenericDiagAudMode::tenType)pcu8Data[4];
      midw_fi_tcl_e8_GenericDiagAudMode Data4;
      Data4.enType = (midw_fi_tcl_e8_GenericDiagAudMode::tenType)pcu8Data[5] ;
      midw_fi_tcl_e8_GenericDiagAudMode Data5;
      Data5.enType =  (midw_fi_tcl_e8_GenericDiagAudMode::tenType)pcu8Data[6] ;
      midw_fi_tcl_e8_GenericDiagAudMode Data6;
      Data6.enType = (midw_fi_tcl_e8_GenericDiagAudMode::tenType)pcu8Data[7];

      ID_CCAStart_AudDiagMode oAudDiagMode((midw_fi_tcl_e8_DiagAudMode::tenType)Data1.enType, (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Data2.enType,
        (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Data3.enType,  (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Data4.enType,
        (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Data5.enType,  (midw_fi_tcl_e8_GenericDiagAudMode::tenType)Data6.enType)  ;
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAudDiagMode);

      ETG_TRACE_USR4(("ID_CCAStart_AudDiagMode message delivered"));
    }
    break; //lint fix
  case TRC::enAudLinSetting_Diagnostics:
    ETG_TRACE_USR4(("Audio Linear Setting through Diag"));
    if (InternalCommunicationAdapter::getInstance() != NULL)
    {
      ID_DiagLinearMode DiagLinearModeMsg((tenDiagLinearModePhase)pcu8Data[2]);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&DiagLinearModeMsg);

      ETG_TRACE_USR4(("ID_DiagLinearMode message delivered"));
    }
    break;
  default: //Nothing
    break;
  }

}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCBeepFromFile(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the BeepFromFile Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCBeepFromFile(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("Trace command received : BeepFrom file"));
  tU8 u8VolType  = pcu8Data[2];

  //Ignore positive values, always treat them as negative as dB range is 0 to -120 dB
  //tS16 volDB      = (tU16)0x8000| ((tU16)(pcu8Data[3]& 0x7f));
  tS16 volDB      = (tS16)((tS8)pcu8Data[3]);

  if(200 >= strlen((const char *)&pcu8Data[4]))
  {
    BeepFile_Config cnfg(u8VolType, volDB);
    string filepath    = (const char*)&pcu8Data[4];
    ETG_TRACE_USR4(("BeepFromfile Params: VolType:%d, VolumedB :%d,File path:%s ",u8VolType,volDB,&pcu8Data[4]));

    ID_CCAStart_BeepFile startAudioBeepFile(filepath, cnfg,u32GenerateToken());
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioBeepFile);
  }
  else
  {
    ETG_TRACE_USR4(("String too long ... !!! Ignored "));
  }
}
/*******************************************************************************
*
* FUNCTION: tU32 u32GenerateToken
*
* DESCRIPTION: Generates random unique tokens
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tU32 fc_audiomanager_tclService_Audio_Function::u32GenerateToken()
{
  static tU32 u32Token = AUDIO_GENERATED_TOKEN_INVALID;//Local variable

  u32Token++;//Next random value of token is the immediate value ;-). We have 2^32-1 possible values

  if(u32Token == AUDIO_GENERATED_TOKEN_INVALID)//Reserving value 0 to invalid token ID
  {
    u32Token++;
  }
  return u32Token;
}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::bPostTRCLoopback(T &oFiDataObject1,tU16 Property_type)
*
* DESCRIPTION: process soundproperty trace commands
*
* PARAMETERS: T &oFiDataObject1,tU16 Property_type
*
* RETURN TYPE: bool
*
*******************************************************************************/
template <typename T>
tBool fc_audiomanager_tclService_Audio_Function::bPostTRCLoopback(T &oFiDataObject1,tU16 Property_type)
{
  ETG_TRACE_USR4((">>> bPostTRCLoopback property type:%x<<<",Property_type));

  if(Property_type)
  {
    oFiDataObject1.Resource.enType = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS;
    AUD_POINTER_CHECK_FATAL_ON_NULL (m_poMainAppInstance);
    fi_tclVisitorMessage oCCaMsg(oFiDataObject1);
    oCCaMsg.vInitServiceData(m_poMainAppInstance->u16GetAppId(),  // Source AppID
           m_poMainAppInstance->u16GetAppId(),  // Target AppID
           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
           0,
           u16GetAudioRegID(),
           0,
           CCA_C_U16_SRV_AUDIOFUNC,
           Property_type,
           AMT_C_U8_CCAMSG_OPCODE_SET
            );

    ail_tenCommunicationError enResult = m_poMainAppInstance->enPostMessage(&oCCaMsg, TRUE);

    if(enResult != AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR4((">>> Answer sent successfully <<<"));
      return true;
    }
    else
    {
      ETG_TRACE_USR4((">>> Answer not sent successfully <<<"));
      return false;
    }
  }
  return false;

}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCBeepFromFile(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the BeepFromFile Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSoundProperty(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("Trace command received : vHandleTRCSoundProperty"));
  tU8 u8Pty  = pcu8Data[2];
  tS8 ivalue  = pcu8Data[3];

  tU16 Property_type= 0;
  switch(u8Pty)
  {
  case TRC::enBass:
    {
      midw_mascffi_tclMsgBassSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_BASS;
    oFiDataObject1.Bass = ivalue;
    oFiDataObject1.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
      break;

    case TRC::enTreble:
    {
    midw_mascffi_tclMsgTrebleSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_TREBLE;
    oFiDataObject1.Treble = ivalue;
    oFiDataObject1.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enMiddle:
    {
    midw_mascffi_tclMsgMidRangeSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_MIDRANGE;
    oFiDataObject1.MidRange = ivalue;
    oFiDataObject1.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enBalance:
    {
    midw_mascffi_tclMsgBalanceSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_BALANCE;
    oFiDataObject1.Balance = ivalue;
    oFiDataObject1.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enFader:
    {
    midw_mascffi_tclMsgFaderSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_FADER;
    oFiDataObject1.Fader = ivalue;
    oFiDataObject1.SoundType.enType = midw_fi_tcl_e8_AudioSoundType::FI_EN_AUDIO_SND_TYPE_ABS;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enEqualizer:
    {
    midw_mascffi_tclMsgEqualiserPresetSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_EQUALISERPRESET;
    oFiDataObject1.EquPreset.enType = (midw_fi_tcl_e8_EquPresets::tenType)ivalue;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enGala:
    {
    midw_mascffi_tclMsgGalaSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_GALA;
    oFiDataObject1.GalaLevel.enType = (midw_fi_tcl_e8_GalaLevel::tenType)ivalue;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enOptimization:
    {
    midw_mascffi_tclMsgOptimizationSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_OPTIMIZATION;
    oFiDataObject1.Optimization.enType = (midw_fi_tcl_e8_Optimization::tenType)ivalue;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  case TRC::enRoomEffect:
    {
    midw_mascffi_tclMsgRoomEffectSet oFiDataObject1;
    Property_type = MIDW_MASCFFI_C_U16_ROOMEFFECT;
    oFiDataObject1.RoomEffect.enType = (midw_fi_tcl_e8_RoomEffect::tenType)ivalue;
    bPostTRCLoopback(oFiDataObject1,Property_type);
    }
    break;
  default :
    ETG_TRACE_USR4(("invalid property"));
    Property_type= 0;
    break;
  }


}


/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCBeepFromFile(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the BeepFromFile Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCAudioTestTone(tPCUChar pcu8Data)
{

  ETG_TRACE_USR4(("AudioTestTone"));
  tU8 u8Data;
  u8Data = pcu8Data[2];

  tU32 tFrequency = (tU32) 1000; //1000 Hz
  tS16 tVolume = ((tS16) -40); //-160dB
  tU8 tVolType = (tU8)midw_fi_tcl_e8_VolumeType::FI_EN_DB_LEVEL; //dB level
  tU8 tRequester = TESTTONE_HMI;

  ETG_TRACE_USR4(("SpeakerType: %d", u8Data));
  ETG_TRACE_USR4(("Frequency: %d",tFrequency));
  ETG_TRACE_USR4(("VolType: %d", tVolType));
  ETG_TRACE_USR4(("Volume: %d", tVolume));
  ETG_TRACE_USR4(("Requester: %d", tRequester));
  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_CCAStart_AudioTestTone startAudioTestTone(u8Data, tFrequency, tVolType, tVolume, tRequester);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioTestTone);
    ETG_TRACE_USR4(("AudioTestTone message delivered"));
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCBeepFromFile(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the SetBeep Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCSetBeep(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("SetBeep"));
  tU8 u8Data[2];
  u8Data[0] = ((midw_fi_tcl_e8_AudioBeepType::tenType)pcu8Data[2]);
  u8Data[1] = ((midw_fi_tcl_e8_ResourceNo::tenType)pcu8Data[3]);
  ETG_TRACE_USR4(("BeepType: 0x%2x", u8Data[0]));
  ETG_TRACE_USR4(("Resource: 0x%2x", u8Data[1]));

  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_CCAStart_Beep startBeep(u8Data[0], u8Data[1]);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startBeep);
    ETG_TRACE_USR4(("SetBeep- message delivered"));
  }

}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCAdasBeep(tPCUChar pcu8Data)
*
* DESCRIPTION: Handler to process the Adas Beep Trace Data
*
* PARAMETERS: tPCUChar pcu8Data
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCAdasBeep(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("SetAdasBeep"));

  tU8 u8Data[2];
  u8Data[0] = (tU8)pcu8Data[2];
  u8Data[1] = (tU8)pcu8Data[3];

  tU8 u8channelZone = (tU8)pcu8Data[4];

  ETG_TRACE_USR4(("BeepType: 0x%2x, RecurrenceType : %d, u8channelZone : %d", u8Data[0], u8Data[1], u8channelZone));

  if (InternalCommunicationAdapter::getInstance() != NULL)
  {
    ID_CCAStart_ADASBeep startAdasBeep(u8Data[0],u8Data[1],u8channelZone);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAdasBeep);
    ETG_TRACE_USR4(("SetAdasBeep- message delivered"));
  }
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vOnMsMCANBose_VersionInfo()
 *
 * DESCRIPTION: This function is called when Method Start for MCAN Bose version info is received
 *
 *******************************************************************************/ //
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsMCANBose_VersionInfo()
{
  ETG_TRACE_USR4(("vOnMsMCANBose_VersionInfo"));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
  if(m_bBoseAmplifierStatus)
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE (m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit);
    m_poMCANBoseAppl->_poMasterAmplifier_MCANUnit->vGetAmplifierVersionInfo();
  }
#endif
}
/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vOnMsAudioSource(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called when Method Start for Audio Source is received
 *
 *******************************************************************************/ //
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsAudioSource(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   // dispatch message and send data to registered observer
   midw_mascffi_tclMsgAudioSourceMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   tU16 resource = Ms.Resource.enType;
   tU16 source = Ms.Source.enType;
   tU16 Channel =(tU16) Ms.Channel.enType;
   ETG_TRACE_USR4(("Message-Audio Source delivered from CCA handler to Source: source=%d,resource=%d,Channel=%d",source,resource,Channel));

   if(resource == 17)
   {
       AmpVolumeData ampData;
       ampData.m_enStream = EN_AUDIO_SOURCE_STREAM_MAIN;
       ampData.m_VolStep = 40;
       ampData.m_VoldB   = 0;
       ampData.m_RampLin = 0x578;
       ampData.m_RampdB = 0x64;
       ampData.m_Sink = 17;
       ID_Amp_SetVolume outMsg(ampData);

       AUD_POINTER_CHECK_CALL_NO_RET_VALUE(InternalCommunicationAdapter::POMessages);
       InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);

       ETG_TRACE_USR4(("Source change is not allowed on sink 17, only ADR will be set to maximum volume for sink 17"));
       return;
   }

   ID_CCAStart_AudioSource startAudioSource(resource, source,Channel);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioSource);

   SourceTypeConverter* pSourceConverter = SourceTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pSourceConverter);

   VolumeSourceData DataSet;
   DataSet.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType) Ms.Resource.enType);
   DataSet.m_Channel = (midw_fi_tcl_e8_AudioChannel::tenType) Ms.Channel.enType;
   DataSet.m_Source = pSourceConverter->getIntSource((midw_fi_tcl_e8_AudSource::tenType)  Ms.Source.enType);
   DataSet.m_ClientSource = (tU8) Ms.Source.enType;

   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsAudioSource: incoming source: %d, converted source: %d, client source: %d",
       ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, Ms.Source.enType),
       ETG_CENUM(tenInternalSource, DataSet.m_Source),
       DataSet.m_ClientSource
       ));
   Ms.vDestroy();
/*
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   if(m_bIsExtAmpConnected)
      vCheckSourceAndSetTelModeGPIO(DataSet.m_Source);       //NCG3D-24833
   else
     ETG_TRACE_USR4(("Bose Amp not Connected"));
#endif
*/
   IDIntSource VolumeSourcePOMessage(DataSet);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);

   // send method result message to client
   ETG_TRACE_USR4(("Message delivered back from CCA handler to the client"));
   midw_mascffi_tclMsgAudioSourceMethodResult oMethodResult;
   oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_RECEIVED;
   m_CCATransport.postCCAMessage<midw_mascffi_tclMsgAudioSourceMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
   m_activeSource = (tU8)(source);    //gen4 [-wcoversion] compiler warning fix
   ETG_TRACE_USR4(("active source : %d", m_activeSource));
   vSetAudioProperty((tU8)source);    //gen4 [-wcoversion] compiler warning fix
   //inform AudioPorcess via DBus
   if(m_poMainAppInstance->poDBus() && m_poMainAppInstance->poDBus()->poGetAudioProcProxy())
   {
      ETG_TRACE_USR4(("Invoking AudProc via DBus here with AudprocSourceActivity for source %d and AUDPROC_SA_ON",source));
      if(!m_poMainAppInstance->poDBus()->poGetAudioProcProxy()->AudprocSourceActivity_sync((tU8)source,AUDPROC_SA_ON)) //gen4 [-wcoversion] compiler warning fix
      {
         ETG_TRACE_USR4(("Audio Process : Error invoking method AudprocSourceActivity_sync()"));
      }
   }
}
/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bIsExtAmpConnected()
*
*
* DESCRIPTION: returns true, if external Amplifier is connected
*
* PARAMETER:   None
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
 bool fc_audiomanager_tclService_Audio_Function::bIsExtAmpConnected()
 {
   if(m_bIsExtAmpConnected)
     return true;
   return false;
 }

 bool fc_audiomanager_tclService_Audio_Function::bIsBoseAmpConnected()
 {
   return m_bBoseAmplifierStatus;
 }
/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vOnMsAmpDeviceAudioRoute(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called when Method Start for AmpDevice Audio Route is received
 *
 *******************************************************************************/ //
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsAmpDeviceAudioRoute(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   // dispatch message and send data to registered observer
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   tU16 resource = Ms.Resource.enType;
   tU16 source = Ms.Source.enType;
   tU16 channel = Ms.Channel.enType;
   const char* audProcAdev = Ms.AudProcAdev.szValue;
   tU32 handle = Ms.MsgHandle;

   tU8 action = 0;
   ETG_TRACE_USR4(("Message- AmpDevice Audio Route (handle p = %x) delivered to Source (src=%d, res=%d, chan=%d)",handle,source,resource,channel));

 #ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
  tU8 AmpConfig = bCheckFaderAvailability();
  if((AmpConfig == EXTERNALAMP_BOSE2CH_MCAN) ||(AmpConfig == EXTERNALAMP_BOSE_5_1CH_MCAN))
   {
     if((m_activeSource == midw_fi_tcl_e8_AudSource::FI_EN_IPA_TTS) || (m_activeSource == midw_fi_tcl_e8_AudSource::FI_EN_DRVASS_VIDEO))
       {
   channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC;
       }
     if(m_activeSource == midw_fi_tcl_e8_AudSource::FI_EN_TCU_TTS)
       {
   channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX;
       }
   }
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsAmpDeviceAudioRoute m_activeSource=%d,channel=%d",m_activeSource, channel));
#endif

   if(Ms.Action.enType == midw_fi_tcl_e8_OnGoingAction::FI_EN_ALLOCATE)
   {
      ETG_TRACE_USR4(("Message- AmpDevice Audio Route for Allocate (handle p = %x) delivered to Source",handle));
      action = AUDPROC_SA_ACTIVATE;
   }
   else if(Ms.Action.enType == midw_fi_tcl_e8_OnGoingAction::FI_EN_DEALLOCATE)
   {
      ETG_TRACE_USR4(("Message- AmpDevice Audio Route for Deallocate (handle p = %x) delivered to Source",handle));
      action = AUDPROC_SA_DEACTIVATE;
   }
   else
   {
      ETG_TRACE_ERR(("Error Message- AmpDevice Audio Route for Undef ?? (handle p = %x) delivered to Source",handle));
   }
   //ETG_TRACE_USR4(("ToDo: Need to call AudProc via DBus here with audProcAdev=%s",audProcAdev));

   if(m_poMainAppInstance->poDBus() && m_poMainAppInstance->poDBus()->poGetAudioProcProxy())
   {
     ETG_TRACE_USR4(("Invoking AudProc via DBus here with audProcAdev=%s",audProcAdev));
     if(!m_poMainAppInstance->poDBus()->poGetAudioProcProxy()->AudprocSourceSelect(AUDPROC_SELECT_SRC_PER_DEV,action,audProcAdev))
     {
       ETG_TRACE_USR4(("Audio Process : Error invoking method AudprocSourceSelect() "));
     }
   }
   else
   {
     ETG_TRACE_USR4(("Audio Process service not configured for this project"));
   }

   if(Ms.Action.enType == midw_fi_tcl_e8_OnGoingAction::FI_EN_ALLOCATE)
   {
     ID_CCAStart_AmpDeviceAudioRoute ampDeviceAudioRoute(resource, source, channel);
     InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ampDeviceAudioRoute);
   }

   //#ma.so redundant all requests are handled via AudioSource Message
   /*
   SourceTypeConverter* pSourceConverter = SourceTypeConverter::getInstance();
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pSourceConverter);

   VolumeSourceData DataSet;
   DataSet.m_Resource.setResource((midw_fi_tcl_e8_ResourceNo::tenType) Ms.Resource.enType);
   DataSet.m_Channel =  (midw_fi_tcl_e8_AudioChannel::tenType) Ms.Channel.enType;
   DataSet.m_Source = pSourceConverter->getIntSource((midw_fi_tcl_e8_RouteNo::tenType)  Ms.Source.enType);

   IDIntSource VolumeSourcePOMessage(DataSet);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);

   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsAmpDeviceAudioRoute: incoming src: %d, converted source: %d",
         ETG_ENUM(midw_fi_tcl_e8_RouteNo::tenType, Ms.Source.enType),
         ETG_ENUM(tenInternalSource, DataSet.m_Source)
         ));
   */
   //#ma.eo redundant all requests are handled via AudioSource Message

   Ms.vDestroy();

   // send method result message to client

   ETG_TRACE_USR4(("Message delivered back to client with handle p= %x",handle));
   midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult oMethodResult;
   oMethodResult.MsgHandle = handle;
   oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_PROCESSED;
   m_CCATransport.postCCAMessage<midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult>(poMessage, oMethodResult,
         AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}
/***************************************************************************************************/


#if 0
class CCA_Msg_MuteMethodResult: public ihl_tclXFiObjHandler<midw_mascffi_tclMsgMuteMethodResult> {
public:
   CCA_Msg_MuteMethodResult(amt_tclServiceData &rfoServData, tU16 u16FiMajVer FI_DEFAULT_VERSION) :
   ihl_tclXFiObjHandler<midw_mascffi_tclMsgMuteMethodResult>(rfoServData, u16FiMajVer)
   {};
};
#endif

tVoid fc_audiomanager_tclService_Audio_Function::vOnMsMute(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsMute() entered"));
   midw_mascffi_tclMsgMuteMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   ETG_TRACE_USR4(("Requ: %d, Resource %d, Channel %d, Reason %d",Ms.Requester.enType,Ms.Resource.enType,Ms.Channel.enType,Ms.Reason.u32Value));

   if(Ms.State.enType == midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE)
   {
     ETG_TRACE_USR4(("State Demute"));
   }
   else if (Ms.State.enType == midw_fi_tcl_e8MuteAction::FI_EN_MUTE)
   {
     ETG_TRACE_USR4(("State Mute"));
   }
   poMuteMessage = poMessage;

   vSetAudioRegID(poMessage->u16GetRegisterID());

   tU16 Requester = Ms.Requester.enType;
   tU16 Resource = Ms.Resource.enType;
   tU16 Channel = Ms.Channel.enType;
   tenMuteAction State = EN_AUDIO_MUTE_MUTEACTION_On;
   tU32 Reason = Ms.Reason.u32Value;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   if(Reason & (midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_OTHER))
   {
    if(m_poMainAppInstance->poDBus() && m_poMainAppInstance->poDBus()->poGetAudioProcProxy())
    {
      ETG_TRACE_USR4(("Invoking AudProc via DBus here with aplArkamysFlush(1) for Mute during tuner preset change"));
      if(!m_poMainAppInstance->poDBus()->poGetAudioProcProxy()->set_aplArkamysFlush(1))
      {
       ETG_TRACE_USR4(("Audio Process service not up and running !  ! ! "));
      }
    }
   }
#endif

   if (Ms.State.enType == midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE)
   {
     State = EN_AUDIO_MUTE_MUTEACTION_Off;
   }
   // this comment is for Eclipse auto format issues
   if(State == EN_AUDIO_MUTE_MUTEACTION_Off)
   {
     ETG_TRACE_USR4(("Delivering PO Message for mute %d (EN_AUDIO_MUTE_MUTEACTION_Off)",State));
   }
   else
   {
     ETG_TRACE_USR4(("Delivering PO Message for mute %d (EN_AUDIO_MUTE_MUTEACTION_On)",State));
   }

   Ms.vDestroy();

   ID_CCAStart_Mute startMute(Requester,Channel,State,Reason,Resource);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startMute);
}


/*
 * Function to Mute Entertainment channel (main stream) of External Amplifier connected (Ex: MCAN Bose Amplifier)
 */
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsEntertainmentMute(amt_tclServiceData* poMessage)
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsEntertainmentMute() entered"));
  midw_mascffi_tclMsgMuteMethodStart Ms;
  (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

  poMuteMessage = poMessage;
  tU8 u8_AudioState = 1;

  if(Ms.State.enType == midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE)
  {
    u8_AudioState = 0;
  }
  Ms.vDestroy();

  /*
   * Need to send mute/Demute command to MCAN BOSE Amplifier to mute Main stream
   */
  ETG_TRACE_USR4(("vOnMsEntertainmentMute,Delivering PO Message for mute %d",u8_AudioState));

  //Inform EntertainmentMute to BoseAmplifier Module
  ID_AudioOffState notifyAudioOffMute(u8_AudioState);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyAudioOffMute);
}

tVoid fc_audiomanager_tclService_Audio_Function::vOnMsSystemMute(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsSystemMute() entered"));
   midw_mascffi_tclMsgMuteMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   poMuteMessage = poMessage;

   tU16 Requester = Ms.Requester.enType;
   tU16 Resource = Ms.Resource.enType;
   //tU16 Channel = Ms.Channel.enType;
   tenMuteAction State = EN_AUDIO_MUTE_MUTEACTION_On;
   tU32 Reason = Ms.Reason.u32Value;
   m_bIsSystemMuteActive = true;

   if(Ms.State.enType == midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE)
   {
     State = EN_AUDIO_MUTE_MUTEACTION_Off;
     m_bIsSystemMuteActive = false;
   }
   Ms.vDestroy();

   //Inform systemMute to Beep Module
   ID_NotifySystemMute notifySystemMute(Requester,Resource,State,Reason);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifySystemMute);
}

/*******************************************************************************
 *
 * FUNCTION: void fc_audiomanager_muteNotification::MessageNotification(PO_MessageConfig::enID MsgId)
 *
 * DESCRIPTION: This function is called on receiving mute notification from ARM_Proxy
 *
 * PARAMETERS: PO_MessageConfig::enID MsgId
 *
 * RETURN TYPE: None
 *
 *******************************************************************************/

void fc_audiomanager_tclService_Audio_Function::MessageNotification(PO_MessageConfig::enID MsgId)
{
  switch(MsgId)
  {
  case PO_MessageConfig::ID_CCAStart_AudioSource:
    {
      vHandleCCAMsgAudioSource(MsgId);
      break;
    }
  case PO_MessageConfig::ID_CCAStart_AmpDeviceAudioRoute:
    {
      vHandleCCAMsgAmpDeviceAudioRoute(MsgId);
      break;
    }
  case PO_MessageConfig::ID_NotifyMute:
    {
      vHandleCCAMsgNotifyMute(MsgId);
      break;
    }
  case(PO_MessageConfig::ID_CCAResult_Mute):
    {
      vHandleCCAMsgResultMute(MsgId);
      break;
    }
  case(PO_MessageConfig::ID_NotifyAudioTestToneStatus):
    {
      const ID_NotifyAudioTestToneStatus* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_NotifyAudioTestToneStatus>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("ID_NotifyAudioTestToneStatus: MessageNotification: ChannelSelect: %d, TestToneStatus: %d",
        pMsg->ChannelSelect, pMsg->TestToneState));
      vSendAudioTestToneStatus(pMsg->ChannelSelect, pMsg->TestToneState);
      break;
    }
  case (PO_MessageConfig::IDSetSoundSystemConfig):
     {
    const IDSetSoundSystemConfig* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<IDSetSoundSystemConfig>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR4(("IDSetSoundSystemConfig: MessageNotification: SoundSystemConfig %d",pMsg->u8SoundConfig));
    m_u8SoundConfigItem = pMsg->u8SoundConfig;
    if(pMsg->u8SoundConfig == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM4 || pMsg->u8SoundConfig == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM3
        || pMsg->u8SoundConfig == SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM8)
      m_bIsExtAmpConnected = true;
    else
        m_bIsExtAmpConnected = false;

      break;
     }
     case PO_MessageConfig::ID_AudioState:
  {
    const ID_AudioState* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_AudioState>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
    ETG_TRACE_USR4(("AudioState status: 0x%4x.", pMsg->AudioState));
    if(pMsg->AudioState == EN_AUDIO_STATE_OFF)
      m_bUPAUserMuteStatus = false; //resetting UPA User Mute on Audiostate OFF received from SPM
    break;
  }
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    case(PO_MessageConfig::ID_AvailSettings):
    {
        const ID_AvailSettings* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_AvailSettings>(MsgId);
      AvailSettingsUnion_Obj.AvailSettingsValue = pMsg->u16value;

      ETG_TRACE_USR4(("Updating clients for AmpAvailSettings with value %x",AvailSettingsUnion_Obj.AvailSettingsValue));
          updateClients(MIDW_MASCFFI_C_U16_AMPAVAILFUNCTION);
        break;

  }

    case (PO_MessageConfig::ID_ProfileDataChanged):
    {


        const MSG_ProfileDataChanged* pMsgProfileData = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<MSG_ProfileDataChanged>(MsgId);
        if (pMsgProfileData)
        {
            if (MSG_ProfileDataChanged::DATA_CHANGE_PROFILE_CHANGED == pMsgProfileData->m_enDataChangedType)
            {
                m_bUserProfileChangeStatus = true;
                ETG_TRACE_USR4(("Updating clients for UserProfileChangeStatus with value %x",m_bUserProfileChangeStatus));
                updateClients(MIDW_MASCFFI_C_U16_USERPROFILECHANGE);
                updateClients(MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME);
                updateClients(MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME);

                updateClients(MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE);

      tU8 AmpConfig = bCheckFaderAvailability();

      if(AmpConfig == PREMIUM_AMP2)
      {      tS32 s32Res = 0;
      tU8 AdasUPASndtype;
      s32Res =  pAudUsrDpIf->s32GetUPASoundtype(AdasUPASndtype);
        ETG_TRACE_USR2(("Update AMP : ID_ADASSoundCollection received : %d", AdasUPASndtype));
      ID_ADASSoundCollection oSoundCollection(AdasUPASndtype);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundCollection);

        if (updateClients(MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE) != AIL_EN_N_NO_ERROR)
          {
            ETG_TRACE_ERR(("MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE: eUpdateClients():-> Updating the clients failed"));
          }
          else
          {
            ETG_TRACE_USR4(("MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE eUpdateClients():-> Updating the clients passed"));
          }

        tU8 bSRSoundActivationState;
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAudUsrDpIf);
        s32Res =pAudUsrDpIf->s32GetSRSoundState(bSRSoundActivationState);
        ETG_TRACE_USR2(("Update AMP : MSG_Settings oSettings received : %d", bSRSoundActivationState));
        MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_SR_SOUNDACTIVATION_STATE, (tS16)bSRSoundActivationState);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

        if (updateClients(MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE) != AIL_EN_N_NO_ERROR)
                {
                  ETG_TRACE_ERR(("MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE: eUpdateClients():-> Updating the clients failed"));
                }
                else
                {
                  ETG_TRACE_USR4(("MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE eUpdateClients():-> Updating the clients passed"));
                }

      }


      }
    }
    break;
        }


  case (PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus):
          {
    const ID_BOSE_Amplifier_ConnectionStatus* pBoMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pBoMsg);
    ETG_TRACE_USR4(("Beep_Controllers::MessageNotification:ID_BOSE_Amplifier_ConnectionStatus : %d",pBoMsg->connectionstate));
     tU8 u8AmpConnectionState;
    u8AmpConnectionState = pBoMsg->connectionstate;

    if(u8AmpConnectionState==AMP_CONNECTED){

      tS32 s32Res = 0;
      tU8 AdasUPASndtype;
      s32Res =  pAudUsrDpIf->s32GetUPASoundtype(AdasUPASndtype);
      ETG_TRACE_USR2(("Update AMP : ID_ADASSoundCollection received : %d", AdasUPASndtype));
      ID_ADASSoundCollection oSoundCollection(AdasUPASndtype);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundCollection);


      tU8 bSRSoundActivationState;
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pAudUsrDpIf);
      s32Res =pAudUsrDpIf->s32GetSRSoundState(bSRSoundActivationState);
      ETG_TRACE_USR2(("Update AMP : MSG_Settings oSettings received : %d", bSRSoundActivationState));
      MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_SR_SOUNDACTIVATION_STATE, (tS16)bSRSoundActivationState);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    }
    break;
          }
    case (PO_MessageConfig::ID_MainAudioAttenuation):
  {
      const ID_MainAudioAttenuation* pAudioAttenuation = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_MainAudioAttenuation>(MsgId);
      m_s8MainAudioAttenuation = pAudioAttenuation->s8AttenuationValue;
       ETG_TRACE_USR4(("Updating clients for Main Audio attenuation with value %x",m_s8MainAudioAttenuation));
      updateClients(MIDW_MASCFFI_C_U16_MAINAUDIOATTENUATION);
      break;
  }
      #endif

  default:
    break;
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgAudioSource(PO_MessageConfig::enID MsgId)
*
* DESCRIPTION: Handler to process the Audio Source CCA Message
*
* PARAMETERS: PO_MessageConfig::enID MsgId
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgAudioSource(PO_MessageConfig::enID MsgId)
{
  // Obtaining the Audiosource Message from CCA handler by Source
  const ID_CCAStart_AudioSource* pMsg = pPO->POMessages->QueryMessage<ID_CCAStart_AudioSource>(MsgId);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
  ETG_TRACE_USR4(("Audio source Observer has received Resource: %x, Source :%x and Channel :%x"
    , pMsg->Resource, pMsg->Source, pMsg->uChannel));

  tenSourceType sourcetype = EN_AUDIO_SOURCE_SOURCETYPE_NOSOURCE;
  if (SourceTypeConverter::getPOSourceTypeFromCCASource(static_cast<midw_fi_tcl_e8_AudSource::tenType>(pMsg->Source), sourcetype))
  {
    // Delivering the SetSource Message to ADR interface
    tenStream Resource = (tenStream)pMsg->uChannel;

    // suspend immediate command processing in ADR
    MSG_SequenceCtrl sequenceCtrl(EN_AUDIO_SOURCE_AutoParameterUpdate_OFF);
    pPO->POMessages->DeliverMsg(&sequenceCtrl);

    // forward new source to ADR (added also original audio source)
    MSG_SetSource setSource(Resource, sourcetype, pMsg->Source, pMsg->Resource); //pMsg->Resource is the sink. Fully confusing with above Resource which is used for the stream.
    pPO->POMessages->DeliverMsg(&setSource);
    ETG_TRACE_USR4(("Audio source = %d at Resource = %d  for Sink %d sent to ADR3"
      , ETG_CENUM(tenSourceType, sourcetype), ETG_CENUM(tenStream, Resource),pMsg->Resource));

    // resume immediate command processing
    MSG_SequenceCtrl oSequenceCtrl(EN_AUDIO_SOURCE_AutoParameterUpdate_ON);
    pPO->POMessages->DeliverMsg(&oSequenceCtrl);
  }
  else
  {
    ETG_TRACE_FATAL(("no matching ADR-AudioSource found for %d: !!!"
      , ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, pMsg->Source)));
  }
}

/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgAmpDeviceAudioRoute(PO_MessageConfig::enID MsgId)
*
* DESCRIPTION: Handler to process the Amplifier Device Route CCA Message
*
* PARAMETERS: PO_MessageConfig::enID MsgId
*
* RETURN TYPE: None
*
*******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgAmpDeviceAudioRoute(PO_MessageConfig::enID MsgId)
{
  /*Obtaining the AudioRoute Message from CCA handler by Source*/
  const ID_CCAStart_AmpDeviceAudioRoute* pMsg = pPO->POMessages->QueryMessage<ID_CCAStart_AmpDeviceAudioRoute>(MsgId);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
  tenSource source = SourceTypeConverter :: getPOSourceFromCCARoute(static_cast<midw_fi_tcl_e8_RouteNo::tenType>(pMsg->Source));

  ETG_TRACE_USR4(("AmpDevice Audio Route Observer has received Resource: %x, Source:%x and stream:%x"
    , pMsg->Resource, pMsg->Source, pMsg->Channel));

  tenStream stream = EN_AUDIO_SOURCE_STREAM_MAIN;
  if (pMsg->Channel == midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX)
    stream = EN_AUDIO_SOURCE_STREAM_MIX1;
  else if(pMsg->Channel == midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX2)
    stream = EN_AUDIO_SOURCE_STREAM_MIX2;
  else if(pMsg->Channel == midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_MIX3)
    stream = EN_AUDIO_SOURCE_STREAM_MIX3;

  /*Delivering SEtAudioRoute Message to ADR interface*/
  ETG_TRACE_USR4(("call MSG_SetAudioRoute for setting the stream in ADR3. Parameter: InstID: %x stream: %x and Source: %x"
    , pMsg->Resource, stream, source));//#ma.wka.NaviAnnoucementDeselct.n
  MSG_SetAudioRoute setAudioRoute(stream, source, pMsg->Resource);
  pPO->POMessages->DeliverMsg(&setAudioRoute);
}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgNotifyMute(PO_MessageConfig::enID MsgId)
*
* DESCRIPTION: Handler to process the Notify Mute CCA Message
*
* PARAMETERS: PO_MessageConfig::enID MsgId
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgNotifyMute(PO_MessageConfig::enID MsgId)
{
  const ID_NotifyMute* pMsg = pPO->POMessages->QueryMessage<ID_NotifyMute>(MsgId);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
  ETG_TRACE_USR4(("ADR mute notification received  with action: %x and Stream: %x Sink %d."
    , pMsg->enMuteResult, pMsg->enStream,pMsg->Sink));

  if(pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_MUTE)
    StreamMute::getInstance()->notifyMute(pMsg->enStream,pMsg->Sink);
  else if(pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_DEMUTE)
    StreamMute::getInstance()->notifyDemute(pMsg->enStream,pMsg->Sink);
  else if(pMsg->enMuteResult == EN_AUDIO_MUTE_MUTERESULT_DEMUTE_RUNNING)
    StreamMute::getInstance()->notifyDemuteRunning(pMsg->enStream,pMsg->Sink);
}
/*******************************************************************************
*
* FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgResultMute(PO_MessageConfig::enID MsgId)
*
* DESCRIPTION: Handler to process the Result Mute CCA Message
*
* PARAMETERS: PO_MessageConfig::enID MsgId
*
* RETURN TYPE: None
*
*******************************************************************************/

tVoid fc_audiomanager_tclService_Audio_Function::vHandleCCAMsgResultMute(PO_MessageConfig::enID MsgId)
{
  const ID_CCAResult_Mute* pMsg = pPO->POMessages->QueryMessage<ID_CCAResult_Mute>(MsgId);
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
  ETG_TRACE_USR4(("mute notification received  with State: %x and Channel : %d.",  ETG_ENUM(T_e8_MuteState,pMsg->State), ETG_ENUM(AUDIO_FI_CHANNEL, pMsg->Resource)));
  ETG_TRACE_USR4(("mute notification received for sink %d",pMsg->Sink));

  midw_mascffi_tclMsgMuteMethodResult outmsg;

  switch(pMsg->State)
  {
  case EN_AUDIO_MUTE_MUTERESULT_DEMUTE:
    outmsg.State.enType =  midw_fi_tcl_e8_MuteState::FI_EN_DEMUTE;
    break;

  case EN_AUDIO_MUTE_MUTERESULT_DEMUTE_RUNNING:
    outmsg.State.enType =  midw_fi_tcl_e8_MuteState::FI_EN_DEMUTERUNNING;
    break;

  case EN_AUDIO_MUTE_MUTERESULT_MUTE:
  default:
    outmsg.State.enType = midw_fi_tcl_e8_MuteState::FI_EN_MUTE;
    break;
  }
  //send CCA Message
  outmsg.Requester.enType = midw_fi_tcl_e8_MuteRequester::FI_EN_AUDIOROUTINGMANAGER;


  outmsg.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)pMsg->Sink;
  outmsg.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType)pMsg->Resource; //would be even better to not call it Resource


  fi_tclVisitorMessage oCCaMsg(outmsg);
  oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),  // Source AppID
    CCA_C_U16_APP_FC_AUDIO_ROUTE_MGR,  // Target AppID
    AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
    0,
    u16GetAudioRegID(),
    0,
    CCA_C_U16_SRV_AUDIOFUNC,
    MIDW_MASCFFI_C_U16_MUTE,
    AMT_C_U8_CCAMSG_OPCODE_METHODRESULT
    );

  ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oCCaMsg, TRUE);

  if(enResult != AIL_EN_N_NO_ERROR)
  {
    ETG_TRACE_FATAL((">>> ! ERR: Answer not sent (%d) ! <<<", (int)enResult));
  }
  else
  {
    ETG_TRACE_USR4((">>> Answer sent successfully for mute. <<<"));
  }
}

tVoid fc_audiomanager_tclService_Audio_Function::vSetAudioRegID(tU16 u16RegID)
{
   m_u16AudioRegID = u16RegID;
}

tU16 fc_audiomanager_tclService_Audio_Function::u16GetAudioRegID()const
{
   return m_u16AudioRegID;
}

tVoid fc_audiomanager_tclService_Audio_Function::vOnMsFading(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   // dispatch message and send data to registered observer
   midw_mascffi_tclMsgSet_Mute_RampMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   tU16 resource = Ms.Resource.enType;
   tU16 state = Ms.State.enType;
   tU8 channel = Ms.Channel.enType;
   Ms.vDestroy();

   ETG_TRACE_USR4(("Message-Fading delivered from CCA handler to Fading for Sink %d",resource));

   ID_CCAStart_SetMuteRamp setMuteRamp(resource, state, channel);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setMuteRamp);

   // send method result message to client
   ETG_TRACE_USR4(("Message delivered back from CCA handler to the client"));
   midw_mascffi_tclMsgSet_Mute_RampMethodResult oMethodResult;
   oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_RECEIVED;
   m_CCATransport.postCCAMessage<midw_mascffi_tclMsgSet_Mute_RampMethodResult>(poMessage, oMethodResult,
         AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vOnMsBeep(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called when Method Start for Beep is received
 *
 *******************************************************************************/ //
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsBeep(amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("Beep -  Has entered ServiceAudioFunction"));
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   // dispatch message and send data to registered observer
   midw_mascffi_tclMsgBeepMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   if(false == m_bIsSystemMuteActive)
   {
    tU8 BeepType;
    tU8 Resource;

    BeepType = (Ms.BeepType.enType);
    Resource = (Ms.Resource.enType);

    ETG_TRACE_USR4(("Message- Beep is being delivered to the beep module................................"));

    if(IsPremium2Connected())
    {

      ETG_TRACE_USR4(("Message- Beep is being sent to  external amplifier."));

      ID_NotifyBeepName  oBeepName(BeepType);
      m_Beep_ExtAmpHandlerMain->NotifyBeepState(BEEP_START_IP);

      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oBeepName);
    }
    else
    {
      ETG_TRACE_USR4(("Message- Beep is being sent to  internal amplifier amplifier."));

      ID_CCAStart_Beep startBeep(BeepType, Resource);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startBeep);

    }

    ETG_TRACE_USR4(("Message- Beep is delivered to beep module.....Has reentered ServiceAudioFunction"));
    // send method result message to client

    ETG_TRACE_USR4(("Message delivered back to client from ServiceAudioFunction"));
    midw_mascffi_tclMsgBeepMethodResult oMethodResult;
    oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_RECEIVED;
    m_CCATransport.postCCAMessage<midw_mascffi_tclMsgBeepMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
   }
   else //SystemMute is active, beep request are rejected
   {
       ETG_TRACE_USR4(("SystemMute is active, Beep request denied, Error Message returned back to client from ServiceAudioFunction"));
    midw_mascffi_tclMsgBeepMethodResult oMethodResult;
    oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_REJECTED;
    m_CCATransport.postCCAMessage<midw_mascffi_tclMsgBeepMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
   }
   Ms.vDestroy();
}

/*******************************************************************************/


/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vOnMsAudioTestTone(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called when Method Start for AudioTestTone is received
 *
 *******************************************************************************/ //
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsAudioTestTone(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
   midw_mascffi_tclMsgAudioTestToneMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   m_u16AudioTestToneRegID = poMessage->u16GetRegisterID();
   m_u16AudioTestToneAppID = poMessage->u16GetSourceAppID();

   tU8 channelselect = Ms.ChannelSelect.u8Value;
   tU32 frequency = Ms.Frequency;
   tU8 voltype = Ms.Volume.e8VolType.enType;
   tS16 volume = Ms.Volume.s16Volume;
   tU8 requester = TESTTONE_HMI;
   Ms.vDestroy();

   if(m_u16AudioTestToneAppID != CCA_C_U16_APP_UI)
   {
     requester = TESTTONE_DIAGNOSIS;
   }
   ID_CCAStart_AudioTestTone startAudioTestTone(channelselect, frequency, voltype, volume, requester);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioTestTone);

#if 0
   //send CCA Message
   midw_mascffi_tclMsgAudioTestToneMethodResult oMethodResult;
   oMethodResult.Status.enType = midw_fi_tcl_e8_Aud_TestToneControl::FI_EN_FC_AUDIO_TEST_TONE_OFF;

   if(speakertype>=0 && speakertype<=3)
   {
      oMethodResult.Status.enType = midw_fi_tcl_e8_Aud_TestToneControl::FI_EN_FC_AUDIO_TEST_TONE_ON;
   }

   m_CCATransport.postCCAMessage<midw_mascffi_tclMsgAudioTestToneMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
#endif
}


/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vOnMsAudioBeepFile(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called when Method Start for AudioBeepFile actuator test is received
 *
 *******************************************************************************/ //
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsAudioBeepFile(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   ETG_TRACE_USR4(("vOnMsAudioBeepFile > Received request to start Beep from File"));

   //Create a method result message and initialize it with invalid values

   midw_mascffi_tclMsgBeepFileMethodResult oMethodResult;
   oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_REJECTED;
   oMethodResult.u32Token = AUDIO_GENERATED_TOKEN_INVALID;

   midw_mascffi_tclMsgBeepFileMethodStart Ms;

  if(m_bIsSystemMuteActive)
  {
       ETG_TRACE_USR4(("vOnMsAudioBeepFile > SystemMute is active, Beep request denied, ERROR sent"));
  }
  else
  {
    (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

    if(Ms.sFilePath.szValue == NULL)
    {
      ETG_TRACE_USR4(("vOnMsAudioBeepFile > Beep File is NULL !! Beep request denied, ERROR sent"));
    }
    else
    {
      //Extract the info from the method
      std::string filepath(Ms.sFilePath.szValue);
      tU8 voltype = Ms.oConfig.e8VolType.enType;
      tS16 volume = Ms.oConfig.s16VoldB;

      ETG_TRACE_USR4(("vOnMsAudioBeepFile > BeepFileReq Data: VolumedB : %d, VolumeType: %d, FilePath: %s",volume,voltype,filepath.c_str()));

      //Assign token to this method result, so that the applications can use it for tracking
      oMethodResult.u32Token = u32GenerateToken();
      //Acknowledge the request is received
      oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_RECEIVED;

      //Create a post office message and send it for processing
      BeepFile_Config cnfg(voltype, volume);
      ID_CCAStart_BeepFile startAudioBeepFile(filepath, cnfg,oMethodResult.u32Token);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioBeepFile);
    }
  }
  Ms.vDestroy();//Clear memory
  //Send method result
  m_CCATransport.postCCAMessage<midw_mascffi_tclMsgBeepFileMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsWelcomeSoundAudioBeepFile(amt_tclServiceData* poMessage)
{
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
  midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult oMethodResult;
  oMethodResult.u32Token = u32GenerateToken();
  oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_RECEIVED;
  midw_mascffi_tclMsgWelcomeSoundBeepFileMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);
   ETG_TRACE_USR4(("BeepAction received is : %d",Ms.u8BeepAction));
    if(Ms.u8BeepAction == BEEP_SKIP)
    {
      ETG_TRACE_USR4(("vOnMsWelcomeSoundAudioBeepFile > Received request to skip Beep File"));
      m_updatestatus = SET_WELCOMESOUND_UPADTE_STATUS;
      if (updateClients(MIDW_MASCFFI_C_U16_REMOVEWELCOMESOUND) != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR3(("vOnMsWelcomeSoundAudioBeepFile::Updating clients for removeWelcomeSound status"));
      }
    }
    else
    {
      ETG_TRACE_USR4(("vOnMsWelcomeSoundAudioBeepFile > Received request to start Beep from File..."));
      if(Ms.sFilePath.szValue == NULL)
      {
        ETG_TRACE_USR4(("vOnMsWelcomeSoundAudioBeepFile > Beep File is NULL !! Beep request denied, ERROR sent"));
        oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_REJECTED;
        oMethodResult.u32Token = AUDIO_GENERATED_TOKEN_INVALID;
      }
      else
      {
        std::string filepath(Ms.sFilePath.szValue);
        tU8 voltype = Ms.oConfig.e8VolType.enType;
        tS16 volume = Ms.oConfig.s16VoldB;
        ETG_TRACE_USR4(("vOnMsWelcomeSoundAudioBeepFile > BeepFileReq Data: VolumedB : %d, VolumeType: %d, FilePath: %s",volume,voltype,filepath.c_str()));
        BeepFile_Config cnfg(voltype, volume);
        ID_CCAStart_BeepFile startAudioBeepFile(filepath, cnfg,oMethodResult.u32Token);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAudioBeepFile);
      }
    }
    Ms.vDestroy();//Clear memory
  m_CCATransport.postCCAMessage<midw_mascffi_tclMsgWelcomeSoundBeepFileMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}
/**
 * The CCA application state changed (e.g. pause). Call the handler for it.
 * @param u32OldAppState
 * @param u32AppState
 * @return
 *///this comment is for eclipse auto format issues
tVoid fc_audiomanager_tclService_Audio_Function::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_PowerState);
   ETG_TRACE_USR4(("vOnNewAppStateNotify entered."));
   m_PowerState->handleNewApplicationState(u32OldAppState, u32AppState);
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   if ( m_poMCANBoseAppl )
   {
    m_poMCANBoseAppl->vOnNewAppStateNotify( u32OldAppState, u32AppState );
   }
#endif
}


/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vSendAudioTestToneStatus
*                  (tU8 tChannelSelect, tU8 tStatus)
*
* DESCRIPTION: Sends the Status of Testtone to HMI
*
* PARAMETER:   tU8 tChannelSelect, tU8 tStatus
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vSendAudioTestToneStatus(tU8 tChannelSelect, tU8 tStatus)
{

//   ETG_TRACE_USR4(("vSendAudioTestToneStatus %d:", tStatus));

    midw_mascffi_tclMsgAudioTestToneMethodResult oMethodResult;

   oMethodResult.ChannelSelect.u8Value = tChannelSelect;
   oMethodResult.Status.enType = (midw_fi_tcl_e8_Aud_TestToneControl::tenType)tStatus;

   fi_tclVisitorMessage oCCaMsg(oMethodResult);
   oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),  // Source AppID
                      m_u16AudioTestToneAppID,  // Target AppID
                      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
                      0,
                      m_u16AudioTestToneRegID,
                      0,
                      CCA_C_U16_SRV_AUDIOFUNC,
                      MIDW_MASCFFI_C_U16_AUDIOTESTTONE,
                      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT
                       );

    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oCCaMsg, TRUE);

   if(enResult != AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_ERR(("Sending AudioTestToneMethodResult %d Failed Result: %d", tStatus, enResult));
      NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
      ETG_TRACE_USR3(("Sending AudioTestToneMethodResult %d Successful:", tStatus))
    }
}

/**************************************************************************************************************/



tVoid fc_audiomanager_tclService_Audio_Function::vOnMsCueType(
      amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

   // dispatch message and send data to registered observer
   midw_mascffi_tclMsgCueStateMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   tU8 cuestate = Ms.State.enType;
   tU16 source = Ms.Source.enType;
   ETG_TRACE_USR4(("Message-Cue delivered from CCa to Service Function"));
   Ms.vDestroy();

   MSG_CueState oCuestate((tenCueType)cuestate,(tU16)source);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCuestate);

   // send method result message to client
   ETG_TRACE_USR4(("Message delivered back from CCA handler to the client"));
   midw_mascffi_tclMsgCueStateMethodResult oMethodResult;
   oMethodResult.ServiceStatus.enType = midw_fi_tcl_e8_AudioServiceStatus::FI_EN_RECEIVED;
   m_CCATransport.postCCAMessage<midw_mascffi_tclMsgCueStateMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

}



/*
 * vOnMsDiagnosisSpeakerStart
 */
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsDiagnosisSpeakerStart(amt_tclServiceData* poMessage)
{
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poDiagnosisSpeaker);

   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodStart Ms;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(Ms);

   tenSpeakerModeDC speakerModeDC;
   tenSpeakerModeAC speakerModeAC;

   speakerModeDC   = fc_audiomanager_tclSpeaker_Diagnosis::speakerModeFi2ADR_DC(Ms.DC_Mode.enType);
   speakerModeAC   = fc_audiomanager_tclSpeaker_Diagnosis::speakerModeFi2ADR_AC(Ms.AC_Mode.enType);
   //speakerModePERM is not used

   ETG_TRACE_USR4(("vOnMsDiagnosisSpeakerStart: Starting Speaker Diagnosis: DC=0x%02x AC=0x%02x", speakerModeDC, speakerModeAC));

   m_poDiagnosisSpeaker->SetDiagMode(Ms.DC_Mode.enType, Ms.AC_Mode.enType);
   m_poDiagnosisSpeaker->vStartDiagTest(speakerModeDC, speakerModeAC);
   Ms.vDestroy();
   m_ACSpeakerMode = speakerModeAC;
   // send method result message to client
   midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult oMethodResult;

   if (speakerModeDC == EN_AUDIO_DIAG_DC_OFF &&
       speakerModeAC == EN_AUDIO_DIAG_AC_OFF)
   {
      ETG_TRACE_USR4(("     DiagnosisSpeakerStartMethodResult: FI_EN_OFF"));
      oMethodResult.Status.enType = midw_fi_tcl_e8_DiagState::FI_EN_OFF;
      m_CCATransport.postCCAMessage<midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
   }
   else
   {
      if (speakerModeDC != EN_AUDIO_DIAG_DC_OFF)
      {
         ETG_TRACE_USR4(("     DiagnosisSpeakerStartMethodResult: FI_EN_DC_STARTED"));
         oMethodResult.Status.enType = midw_fi_tcl_e8_DiagState::FI_EN_DC_STARTED;
         m_CCATransport.postCCAMessage<midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
      }
      if (speakerModeAC != EN_AUDIO_DIAG_AC_OFF)
      {
         ETG_TRACE_USR4(("     DiagnosisSpeakerStartMethodResult: FI_EN_AC_STARTED"));
         oMethodResult.Status.enType = midw_fi_tcl_e8_DiagState::FI_EN_AC_STARTED;
         m_CCATransport.postCCAMessage<midw_mascffi_tclMsgSpeakerDiagnosisStartMethodResult>(poMessage, oMethodResult, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
      }
   }
}


/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bIsSpeakerModeACoff()
*
*
* DESCRIPTION: returns true, Speaker Mode AC is off
*
* PARAMETER:   None
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bIsSpeakerModeACoff()
{
  if(m_ACSpeakerMode == EN_AUDIO_DIAG_AC_OFF)
    return true;
  return false;
}
/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnPsEngineeringData
*                                                         (amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the EngineeringData Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnPsEngineeringData(amt_tclServiceData* poMessage)
{
  midw_mascffi_tclMsgEngineeringDataSet inEngineeringDataSet;

  vector<midw_fi_tcl_Aud_EDStatus>::const_iterator EDIterator;

  fi_tclVisitorMessage oVisitorMsg(poMessage);

  dp_tclAudioManagerDPEngineeringData oDPEngineeringData;
  tS32 *s32EngineeringData = OSAL_NEW tS32[MAX_PAYLOAD];
  if (s32EngineeringData != OSAL_NULL)
  {

    oDPEngineeringData.s32GetData(s32EngineeringData, MAX_PAYLOAD);
  if(oVisitorMsg.s32GetData(inEngineeringDataSet, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
    for(EDIterator = inEngineeringDataSet.EngineeringDataList.EDStatusList.begin();
        EDIterator != inEngineeringDataSet.EngineeringDataList.EDStatusList.end();
        ++EDIterator)
    {
      tU8 Index = (tU8)(*EDIterator).AudEDType.enType;
      if((Index > 0) && (Index < MAX_PAYLOAD))
      s32EngineeringData[Index] = (tS32)(*EDIterator).EDValue * ADR_RESOLUTION;
    }

      oDPEngineeringData.s32SetData(s32EngineeringData, MAX_PAYLOAD);
      }
  }

  if (updateClients(MIDW_MASCFFI_C_U16_ENGINEERINGDATA) != AIL_EN_N_NO_ERROR)
  {
        ETG_TRACE_ERR(("EngineeringData::sendStatusMessage: eUpdateClients():-> Updating the clients failed"));
  }
  else
  {
        ETG_TRACE_USR4(("EngineeringData::sendStatusMessage: eUpdateClients():-> Updating the clients passed"));
  }

  ETG_TRACE_USR4(("vCalcTotalVolumeOffset"));

  if(m_VolOffset_Manager!=NULL)
  m_VolOffset_Manager->vCalcTotalVolumeOffset();

    OSAL_DELETE[] s32EngineeringData;
}
/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnPsEngineeringData
*                                                         (amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the EngineeringData Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnPsSetAudioProperty(amt_tclServiceData* poMessage)
{

  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnPsSetAudioProperty"));

  midw_mascffi_tclMsgSetAudioPropertySet iSetAudioProperty;

  fi_tclVisitorMessage oVisitorMsg(poMessage);

    if(oVisitorMsg.s32GetData(iSetAudioProperty, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
    {
      tU8 source = (tU8) iSetAudioProperty.u8Source.enType;
      tU8 Type = (tU8)iSetAudioProperty.u8Property.enType;
      tS32 Value = iSetAudioProperty.s32PropValue;
      ETG_TRACE_USR4(("Index : %d, Type : %d, Offset : %d", iSetAudioProperty.u8Source.enType, Type, Value));

      switch(Type)
      {
        case midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_INPUT_GAIN:
        {
          ETG_TRACE_USR4(("AUDIO_PROP_INPUT_GAIN"));

            if(source != (tU8) midw_fi_tcl_e8_AudSource::FI_EN_NONE)
            {
              vStoreAudioProperty(source, Type, (Value * ADR_RESOLUTION));
              vSetAudioProperty(source);
            }
            else
              ETG_TRACE_USR4(("No internal sources defined"));
          break;
        }
        case midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_IPOD_DUCKING:
        {
          VolumeSPIMixData data;
          ID_SPIMixVolume SPIMixVolume(data);
          tS16 dBlevel = ( ( (Value >> 16) & (0x00ff) ) & ~128 ) ;  //gen4 [-wcoversion] compiler warning fix
          SPIMixVolume.value.m_VolumeDbLevel = (tS16)-dBlevel; //gen4 [-wcoversion] compiler warning fix
          SPIMixVolume.value.m_SPIMixMode = (tenSPIMixMode) (Value >> 24);
          SPIMixVolume.value.m_RampTime = (tS16)(Value & (0x0000ffff)); //gen4 [-wcoversion] compiler warning fix

          ETG_TRACE_USR4(("SPIMixMode : %d dBLevel : %d RampTime : %d", SPIMixVolume.value.m_SPIMixMode,
                            SPIMixVolume.value.m_VolumeDbLevel, SPIMixVolume.value.m_RampTime ));
          InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SPIMixVolume);

          break;
        }
        default :
         ETG_TRACE_USR4(("default"));
         break;
      }
      }

}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vSetAudioProperty
*                                                         (void)
*
* DESCRIPTION: Handles the Audio Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vSetAudioProperty(tU8 source)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vSetAudioProperty"));


    std::map<tU8, tAudioProperty>::iterator it = StoreAudioProperty.find(source);
      if((it != StoreAudioProperty.end()) && (it->first == m_activeSource))
    {
        ETG_TRACE_USR4(("vSetAudioProperty : source is active, set the audio property"));

        tS32 OffsetVal = it->second.s32PropValue;

        ID_AudioPropertyOffset oAudioProperty(m_activeSource, OffsetVal);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAudioProperty);
    }
    else
      ETG_TRACE_USR4(("vSetAudioProperty : Not an active source"));

}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vStoreAudioProperty
*                                                         (tU8 sourceIndex, tU8 type, tS32 value)
*
* DESCRIPTION: Stores the audio property data
*
* PARAMETER:   tU8 sourceIndex, tU8 type, tS32 value
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vStoreAudioProperty(tU8 sourceIndex, tU8 type, tS32 value)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vStoreAudioProperty sourceIndex : %d, type : %d, value : %d", sourceIndex, type, value));

  m_AudioProperty.u8PropertyType = type;
  m_AudioProperty.s32PropValue = value;
  StoreAudioProperty[sourceIndex] = m_AudioProperty;

}
/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendEngineeringDataStatus
*                                                       (amt_tclServiceData& roOutMsg) const)
*
* DESCRIPTION: Sends the EngineeringData Property Status back to HMI
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendEngineeringDataStatus(amt_tclServiceData& roOutMsg) const
{

  midw_mascffi_tclMsgEngineeringDataStatus oEngineeringDataStatus;
  midw_fi_tcl_Aud_EDStatus oEDStatus;
  tBool bRetVal = TRUE;

  tS32 *s32EngineeringData = OSAL_NEW tS32[MAX_PAYLOAD];
  dp_tclAudioManagerDPEngineeringData oDPEngineeringData;
  if(s32EngineeringData != OSAL_NULL)
  {
    oDPEngineeringData.s32GetData(s32EngineeringData,MAX_PAYLOAD);

    for(tU8 Index = 0; Index < MAX_PAYLOAD; ++Index)
    {
      oEDStatus.AudEDType.enType = (midw_fi_tcl_e8_Aud_EDType::tenType)Index;
      oEDStatus.EDValue = s32EngineeringData[Index];
      oEngineeringDataStatus.EngineeringDataList.EDStatusList.push_back(oEDStatus);
    }

    bRetVal = fi_tclVisitorMessage(oEngineeringDataStatus).bHandOver(&roOutMsg);
    oEngineeringDataStatus.vDestroy();
    oEDStatus.vDestroy();
  }
  OSAL_DELETE[] s32EngineeringData;

  return bRetVal;
}
/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendEngineeringDataStatus
*                                                       (amt_tclServiceData& roOutMsg) const)
*
* DESCRIPTION: Sends the EngineeringData Property Status back to HMI
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendUserProfileChangeStatus(amt_tclServiceData& roOutMsg) const
{
    midw_mascffi_tclMsgUserProfileChangeStatus oProfileChangeStatus;

    tBool bRetVal = TRUE;
    oProfileChangeStatus.UserProfileChange = m_bUserProfileChangeStatus;

    fi_tclVisitorMessage oCCaMsg(oProfileChangeStatus);

    oProfileChangeStatus.vDestroy();
    bRetVal = oCCaMsg.bHandOver(&roOutMsg);

    return bRetVal;
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::traceInputGainOffset
*                                                       (tU8 InputGainSrc, tS32 value)
*
* DESCRIPTION: Trace Input command to set InputGainOFfset of each source.
*
* PARAMETER:   tU8 InputGainSrc, tS32 value
*
* RETURNVALUE: none.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::traceInputGainOffset(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("Trace command received : traceInputGainOffset"));
  tU8 InputGainSrc = pcu8Data[2];
  tS32 value = (tS32)pcu8Data[3];
  dp_tclAudioManagerDPEngineeringData oDPEngineeringData;
  tS32 *s32EngineeringData = OSAL_NEW tS32[MAX_PAYLOAD];
  if(s32EngineeringData != OSAL_NULL)
  {
    oDPEngineeringData.s32GetData(s32EngineeringData, MAX_PAYLOAD);
    s32EngineeringData[InputGainSrc] = value;
    ETG_TRACE_USR4(("Set InputGain Offset : %d", s32EngineeringData[InputGainSrc]));
    oDPEngineeringData.s32SetData(s32EngineeringData, MAX_PAYLOAD);
  }
  OSAL_DELETE[] s32EngineeringData;

  ETG_TRACE_USR4(("vCalcTotalVolumeOffset"));

  if(m_VolOffset_Manager!=NULL)
  m_VolOffset_Manager->vCalcTotalVolumeOffset();
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::traceInputSPIMIX
*                                                       (tU8 InputGainSrc, tS32 value)
*
* DESCRIPTION: Trace Input command to set InputSPIMIX of each source.
*
* PARAMETER:   tU8 InputGainSrc, tS32 value
*
* RETURNVALUE: none.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::traceInputSPIMIX(tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("Trace command received : traceInputGainOffset"));
  tU8 SPIMode = pcu8Data[2];
  tS8 DBLevel = (tS8)pcu8Data[3];
  tS16 Ramp = (tS16)pcu8Data[4];
  VolumeSPIMixData data;
  ID_SPIMixVolume SPIMixVolume(data);
  SPIMixVolume.value.m_VolumeDbLevel = (tS16)DBLevel ;
  SPIMixVolume.value.m_SPIMixMode = (tenSPIMixMode)SPIMode;
  SPIMixVolume.value.m_RampTime = Ramp;

  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&SPIMixVolume);
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::traceInputBeepLevel(tU8 level)
*
* DESCRIPTION: Trace Input command to set Beep Level in Fc_AudioManager
*
* PARAMETER:   tU8 level.
*
* RETURNVALUE: none.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::traceInputBeepLevel(tPCUChar pcu8Data)
{
  tU8 level = (tU8)pcu8Data[2];
  ETG_TRACE_USR4(("Trace command received : BeepLevel %d",level));
  tU8 u8Beeplevel = level;

   if(AudioUserDpIfSelect::pGetAudUsrDpIf())
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32SetBeepLevel(u8Beeplevel);
}


/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::traceInputSetOnEntVol(tU8 level)
*
* DESCRIPTION: Trace Input command to set On ENT Volumein Fc_AudioManager
*
* PARAMETER:   tU8 level.
*
* RETURNVALUE: none.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::traceInputSetOnEntVol(tPCUChar pcu8Data)
{
  tU8 limitval = (tU8)pcu8Data[2];
  dp_tclAudioManagerDPEntOnVolumeSet limitvolume;
  ETG_TRACE_USR4(("Trace command received : Set On ENT volume %d",limitval));
  limitvolume.s32SetData(limitval);
}











/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendSurroundModeStatus()
*
* DESCRIPTION: sends the surround status message
* PARAMETER:   none.
*
* RETURNVALUE: none.
*
**********************************************************************************************/

tBool fc_audiomanager_tclService_Audio_Function::bSendSurroundModeStatus(amt_tclServiceData& roOutMsg) const
{
  tBool bRetValue = false;
  tU8 u8SurroundMode = 255;

   if(AudioUserDpIfSelect::pGetAudUsrDpIf())
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetSurroundLevel(u8SurroundMode);

   midw_mascffi_tclMsgSurroundSettingStatus oSurroundSettingsStatus;
   oSurroundSettingsStatus.Surround.enType = (midw_fi_tcl_e8_SurroundSetting::tenType)u8SurroundMode;

   fi_tclVisitorMessage oCCaMsg(oSurroundSettingsStatus);
   // Always destroy the FI data object before leaving its creation scope
   oSurroundSettingsStatus.vDestroy();
   bRetValue = oCCaMsg.bHandOver(&roOutMsg);

   ETG_TRACE_USR4(("Return Value %d",bRetValue));
   ETG_TRACE_USR4(("SurroundMode Status sent as %d",u8SurroundMode));
   return bRetValue;
}


/**
 * FUNCTION: fc_audiomanager_tclService_Audio_Function::vRequestDiagResult(tenErrorSite errorSite)
 *
 * DESCRIPTION: Queues diagnosis result requests for different errorSites. Call this function
 *              instead of sending GetDiagResult to the ADR directly. Care is taken to serialize the requests
 *
 * PARAMETER:  tenErrorSite errorSite: The errorSite of the request
 *
 * AUTHOR:  wie1hi
 *
 */
tVoid fc_audiomanager_tclService_Audio_Function::vRequestDiagResult(tenErrorSite errorSite)
{
   ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vRequestDiagResult(%i) TID=%i", ETG_CENUM(tenErrorSite, errorSite), OSAL_ThreadWhoAmI()));
   if (!m_bDiagResultQueueProcessing)
   {
      ETG_TRACE_USR4(("DiagResultQueue inactive. Sending DIAG_GET_RESULT %i now.", ETG_CENUM(tenErrorSite, errorSite)));
      m_bDiagResultQueueProcessing = true;
      ID_GetDiagResult oDiagRequestMsg(errorSite);
      InternalCommunicationAdapter::POMessages->DeliverMsg(&oDiagRequestMsg);
      ETG_TRACE_USR4(("DiagResult requested."));
   }
   else
   {
      m_DiagResultQueue.push(errorSite);
      ETG_TRACE_USR4(("DiagResultQueue updated. Length: %i", m_DiagResultQueue.size()));
   }
}

tVoid fc_audiomanager_tclService_Audio_Function::vOnGetDiagResultReady()
{
ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnGetDiagResultReady() entered"));
   if (!m_DiagResultQueue.empty())
   {
      ID_GetDiagResult oDiagRequestMsg(m_DiagResultQueue.front());
      m_DiagResultQueue.pop();
      ETG_TRACE_USR4(("DiagResultQueue reduced. New length: %i Sending DIAG_GET_RESULT %i", m_DiagResultQueue.size(), ETG_CENUM(tenErrorSite, oDiagRequestMsg.enErrorSite)));
      InternalCommunicationAdapter::POMessages->DeliverMsg(&oDiagRequestMsg);
   }
   else if (m_bDiagResultQueueProcessing)
   {
      m_bDiagResultQueueProcessing = false;
      ETG_TRACE_USR4(("DiagResultQueue processing ended (nothing left to send)."));
   }
}
bool fc_audiomanager_tclService_Audio_Function::diag_gala_avail(bool availability)
   {
   if(m_SoundHandler)
    return m_SoundHandler->gala_availability_changed(availability);
  return false;
   }
/********************************************************************************
 * FUNCTION: bCheckTweeterAvailability()
 *
 * DESCRIPTION:  This function is called to check if tweeter is available
 *
 * PARAMETER:   None
 *
 * RETURNVALUE:  u8TweeterSetUp
 *******************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
tU8 fc_audiomanager_tclService_Audio_Function::u8CheckTweeterAvailability()
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::u8CheckTweeterAvailability entered"));

    tU8  u8TweeterSetUp = NO_TWEETER; //initializing with no tweeter

    //read item from the KDS key's bytes- stream

  if((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","TweeterSetup", &u8TweeterSetUp, 1)))
  {
    ETG_TRACE_USR4(("TweeterSetup value u8TweeterSetUp : %d", u8TweeterSetUp));

    return u8TweeterSetUp;
  }
  else
  {
    ETG_TRACE_ERR(("Error in diagnosis read "));
    return 0;
  }

}

/********************************************************************************
 * FUNCTION: bCheckFaderAvailability()
 *
 * DESCRIPTION:  This function is called to check if Fader is available
 *
 * PARAMETER:   None
 *
 * RETURNVALUE:  tU8
 *******************************************************************************/
tU8 fc_audiomanager_tclService_Audio_Function::bCheckFaderAvailability()
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::u8CheckFaderAvailability entered"));

    tU8 u8AmpConfig;
    //read item from the KDS key's bytes- stream

  if((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","OutputInformation", &u8AmpConfig, 1)))
  {
    ETG_TRACE_USR4(("u8FaderAvailable : %d", u8AmpConfig));
    return u8AmpConfig;
  }
  else
  {
    ETG_TRACE_ERR(("Error in diagnosis read "));
    return 0;
  }

}
#endif

/********************************************************************************
 * FUNCTION: bIsTweeterConfigured(tenErrorSite enErrorSite)
 *
 * DESCRIPTION:  This function is called to check if tweeter in errorsite is configured or not
 *
 * PARAMETER:   tenErrorSite enErrorSite
 *
 * RETURNVALUE:  u8TweeterSetUp
 *******************************************************************************/
bool fc_audiomanager_tclService_Audio_Function::bIsTweeterConfigured(tenErrorSite enErrorSite)
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  tU8 u8Tweeter = NO_TWEETER;
  switch(enErrorSite)
  {
    case EN_AUDIO_DIAG_SPEAKER_LF:
    case EN_AUDIO_DIAG_SPEAKER_RF:
      u8Tweeter = FRONT_TWEETER;
      break;
    case EN_AUDIO_DIAG_SPEAKER_LR:
    case EN_AUDIO_DIAG_SPEAKER_RR:
      u8Tweeter = REAR_TWEETER;
      break;
    default:
      break; //lint fix
  }

  if(((u8CheckTweeterAvailability()) & u8Tweeter) != 0)
    return TRUE;

  return FALSE;
#else
  (tVoid)enErrorSite; // Lint
  return TRUE;
#endif
}
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
/********************************************************************************
 * FUNCTION: bIsHandsfreeOrECNRSource(tenInternalSource inSource)
 *
 * DESCRIPTION:  This function checks and returns true if the source is Handsfree
 *               source or ECNR source.
 *
 * PARAMETER:   tenInternalSource inSource
 *
 * RETURNVALUE:  Boolean
 *******************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bIsHandsfreeOrECNRSource(tenInternalSource inSource)
{
  tBool Result = false;
  switch(inSource)
  {
    case AUD_INT_SRC_PHONE:
    case AUD_INT_SRC_PHONE_VR:
    case AUD_INT_SRC_SPI_VR:
    case AUD_INT_SRC_SPI_PHONE:
    case AUD_INT_SRC_SPI_VR_STEREO:
    case AUD_INT_SRC_VRU:
    case AUD_INT_SRC_TCU_SERVICE_CALL:
    case AUD_INT_SRC_TCU_ECALL:
      Result = true;
      break;
    default:
      break;
  }
  return Result;
}

/********************************************************************************
 * FUNCTION:     vCheckSourceAndSetTelModeGPIO(tenInternalSource inSource)
 *
 * DESCRIPTION:  This function checks source and sets the TelMode Amp GPIO to GND
                 if Handsfree or ECNR source is activated and to Open for all other
                 sources.
 *
 * PARAMETER:    tenInternalSource inSource
 *
 * RETURNVALUE:  None.
 *******************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vCheckSourceAndSetTelModeGPIO(tenInternalSource inSource)
{
  ETG_TRACE_USR4(("GPIOTelMode Incoming Source: %d", ETG_CENUM(tenInternalSource, inSource)));

  tBool bResult = false;

  if(bIsHandsfreeOrECNRSource(inSource))
  {
    //Set GPIO TelModeAmp to Ground
    bResult = aud_sinkmgr_Gpio_If::bSetTelModeGPIO(TRUE);
  }
  else
  {
    //Set GPIO TelModeAmp to Open
    bResult = aud_sinkmgr_Gpio_If::bSetTelModeGPIO(FALSE);
  }

  ETG_TRACE_USR4(("SetTelModeGPIO bResult : %d", bResult));
}
#endif

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnSetAdas_UpaSoundSet(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Adas_UpaSoundSet Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnSetAdas_UpaSoundSet(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnSetAdas_UpaSoundSet"));

  midw_mascffi_tclMsgADAS_UPASoundTypeSet inSetUPASoundType;
  fi_tclVisitorMessage oVisitorMsg(poMessage);

  if(oVisitorMsg.s32GetData(inSetUPASoundType, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
    tU8 AdasUPASndtype = (tU8)inSetUPASoundType.SoundType.enType;

    if ((AdasUPASndtype>= BIP) && (AdasUPASndtype <= SONAR))
    {  ID_ADASSoundCollection oSoundCollection(AdasUPASndtype);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundCollection);
    }
    else
      ETG_TRACE_USR4(("Received UPA sound collection is out of range, Not updating the Datapool"));

    if(!IsPremium2Connected())
    {
      if     (updateClients(MIDW_MASCFFI_C_U16_ADAS_UPASOUNDTYPE) != AIL_EN_N_NO_ERROR)
         {
       ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_UPASOUNDTYPE status"));

      }

  }
}
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnSetAdas_ParkAssitVol(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Adas_ParkAssitVol Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnSetAdas_ParkAssitVol(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnSetAdas_ParkAssitVol"));

  midw_mascffi_tclMsgADAS_ParkAssistVolumeSet inSetParkAssistVolume;
  fi_tclVisitorMessage oVisitorMsg(poMessage);

  if(oVisitorMsg.s32GetData(inSetParkAssistVolume, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
     m_ParkAssitVol = (tU8)inSetParkAssistVolume.VolumeLevel.enType;
     m_PrevParkAssitVol = m_ParkAssitVol;
    if((m_ParkAssitVol <= VOLUME_LEVEL_5))
    {
      if(!bIsBoseAmpConnected()) //updating the datapool only if MCAN Bose is not connected
      {

        ID_NotifyParkAssistVolume oNotifyPAVolume(m_ParkAssitVol);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyPAVolume);
    if(!IsPremium2Connected())
    {
          if (updateClients(MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME) != AIL_EN_N_NO_ERROR)
          {
           ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_PARKASSISTVOLUME status"));
           }
    }
  }
      else //for MCAN Bose Amp case
      {
        // The below 'if'condition is commented to resolve Coverity Warning CID : 555357
       // if((m_ParkAssitVol != VOLUME_LEVEL_2)||(m_ParkAssitVol != VOLUME_LEVEL_4)) //sending the park assist volume change to bose amp only for 1,3,5 values from HMI.
       // {
          if(m_ParkAssitVol == VOLUME_LEVEL_3) //mapping HMI 3 to midw 2
            m_ParkAssitVol = VOLUME_LEVEL_2;
          if(m_ParkAssitVol == VOLUME_LEVEL_5)//mapping HMI 5 to midw 3
            m_ParkAssitVol = VOLUME_LEVEL_3;
          ID_NotifyParkAssistVolume oNotifyPAVolume(m_ParkAssitVol);
          InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyPAVolume);
      //  }
      }
     }
    else
      ETG_TRACE_USR4(("Received Park assist/sonar level is out of range, Not updating the Datapool"));
  }
}



/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnSetAdas_LDWUSerVol(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Adas_LDWUserVol Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnSetAdas_LDWUSerVol(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnSetAdas_LDWUSerVol"));

  midw_mascffi_tclMsgADAS_LDW_UserVolumeSet inSetLDWUserVolume;
  fi_tclVisitorMessage oVisitorMsg(poMessage);

  if (oVisitorMsg.s32GetData(inSetLDWUserVolume, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
    //store persistent
    //tS32 s32Res = 0;
    tU8 LDWUserVol = (tU8)inSetLDWUserVolume.VolumeLevel.enType;


    tS32 s32Res = 0;
    ETG_TRACE_USR4(("s32Res : %d",s32Res));
    if ((LDWUserVol <= VOLUME_LEVEL_5))
    {

      ID_NotifyLDWUserVolume oNotifyLDWVolume(LDWUserVol);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyLDWVolume);
    }
    else
      ETG_TRACE_USR4(("Received LDW User Volume level is out of range, Not updating the Datapool"));

    if(!IsPremium2Connected())
    {
      if (updateClients(MIDW_MASCFFI_C_U16_ADAS_LDW_USERVOLUME) != AIL_EN_N_NO_ERROR)
      {
      ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_LDWUserVOLUME status"));
      }
    }

  }
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnSetAdas_UpaMute(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Adas_UpaMute Property Set.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnSetAdas_UpaMute(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnSetAdas_UpaMute"));

  midw_mascffi_tclMsgADAS_UPAMuteSet inSetUPAMute;
  fi_tclVisitorMessage oVisitorMsg(poMessage);

  if(oVisitorMsg.s32GetData(inSetUPAMute, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
    //store persistent
    m_bUPAUserMuteStatus = (tU8)inSetUPAMute.bMute;
    m_bPrevUPAMuteStatus = m_bUPAUserMuteStatus;
    IDCCAUPATempMute oNotifyUPATempMute(m_bUPAUserMuteStatus);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyUPATempMute);

 if(!IsPremium2Connected())
    {     if (updateClients(MIDW_MASCFFI_C_U16_ADAS_UPAMUTE) != AIL_EN_N_NO_ERROR)
      {
          ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_UPAMUTE status"));
       }
    }

  }
}
/*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnSetAdas_SRSoundNotification(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the vOnSetAdas_SRSoundNotification to read from the fi
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*/

tVoid fc_audiomanager_tclService_Audio_Function::vOnSetAdas_SRSoundNotification(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnSetAdas_SRSoundNotification"));

  tS32 s32Res = 0;
  ETG_TRACE_USR4(("s32Res : %d",s32Res));
  midw_mascffi_tclMsgSRSoundNotificationStateSet inSetAdas_SRSoundMute;
  fi_tclVisitorMessage oVisitorMsg(poMessage);

  if(oVisitorMsg.s32GetData(inSetAdas_SRSoundMute, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
    //store persistent
    bool bSRSoundActivationState = (tU8)inSetAdas_SRSoundMute.SR_SoundNotification_State;
    ETG_TRACE_USR4(("bSRSoundActivationState = %d",bSRSoundActivationState));

    MSG_Settings oSettings(EN_AUDIO_SOURCE_STREAM_MAIN, EN_AUDIO_SETTINGS_SR_SOUNDACTIVATION_STATE, (tS16)bSRSoundActivationState);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSettings);

    if(!IsPremium2Connected())
    {
        if (updateClients(MIDW_MASCFFI_C_U16_SRSOUNDNOTIFICATIONSTATE) != AIL_EN_N_NO_ERROR)
     {
      ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_SRSoundNotification status"));
      }
    }

  }
}





/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::vOnMsAdas_SettingSound(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Adas_SettingSound Method Start.
*
* PARAMETER:   amt_tclServiceData*
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::vOnMsAdas_SettingSound(amt_tclServiceData* poMessage)
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnMsAdas_SettingSound"));

  midw_mascffi_tclMsgADAS_SettingSoundMethodStart inMsSettingSound;
  fi_tclVisitorMessage oVisitorMsg(poMessage);

  if(oVisitorMsg.s32GetData(inMsSettingSound, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
  {
    tU8 Settingtype = inMsSettingSound.SettingSound.enType;
    tU8 u8BeepType = 0;
    if(Settingtype == midw_fi_tcl_e8_ADAS_Setting_Sound::FI_EN_ADAS_SETTING_SOUND_UPA)
      u8BeepType = EN_AUDIO_BEEP_UPA_SETTING_SND;

    else if(Settingtype == midw_fi_tcl_e8_ADAS_Setting_Sound::FI_EN_ADAS_SETTING_SOUND_LDW)
      u8BeepType = EN_AUDIO_BEEP_LDW_SETTING_SND;
    else
      u8BeepType = EN_AUDIO_BEEP_STOP_ADAS_SETTING_SND;

    ID_CCAStart_ADASBeep startAdasBeep(u8BeepType,0,0); //recurrence period,zone and type are not applicable for Setting sound
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&startAdasBeep);

      ETG_TRACE_USR4(("Message- startAdasBeep delivered to the beep module................................"));

  }
#else
  (void) poMessage;
#endif

}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendAdas_UpaSoundStatus(amt_tclServiceData& roOutMsg) const
*
* DESCRIPTION: bSendAdas_UpaSoundStatus
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendAdas_UpaSoundStatus(amt_tclServiceData& roOutMsg) const
{

   midw_mascffi_tclMsgADAS_UPASoundTypeStatus oUPASoundTypeStatus;
   dp_tclAudioManagerDPAdas_UPASoundtype odpAdasndtyp;

   tU8 AdasUPASndtype = (tU8)midw_fi_tcl_e8_ADAS_UPA_SoundType::FI_EN_ADAS_UPA_SOUND_UNDEF;
   tS32 s32Res = 0;
   ETG_TRACE_USR4(("s32Res : %d",s32Res));
   tBool bSuccess = FALSE;
  AUD_POINTER_CHECK_CALL(pAudUsrDpIf);
  s32Res =  pAudUsrDpIf->s32GetUPASoundtype(AdasUPASndtype);

   oUPASoundTypeStatus.SoundType.enType = (midw_fi_tcl_e8_ADAS_UPA_SoundType::tenType)AdasUPASndtype;

    // stream to new CCA message and hand over to calling function
   bSuccess = fi_tclVisitorMessage(oUPASoundTypeStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
          .bHandOver(&roOutMsg);
   ETG_TRACE_USR4(("bSendAdas_UpaSoundStatus called, AdasUPASndtype = %d ", AdasUPASndtype));
   oUPASoundTypeStatus.vDestroy();

   return bSuccess;
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendAdas_ParkAssitVolStatus(amt_tclServiceData& roOutMsg) const
*
* DESCRIPTION: bSendAdas_ParkAssitVolStatus
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendAdas_ParkAssitVolStatus(amt_tclServiceData& roOutMsg) const
{

   midw_mascffi_tclMsgADAS_ParkAssistVolumeStatus oParkAssistVolumeStatus;
   tU8 ParkAssistVol = (tU8)midw_fi_tcl_e8_ADAS_ParkAssist_Volume::FI_EN_ADAS_PA_VOL_NO_SOUND;
  tS32 s32Res = 0;
  s32Res=pAudUsrDpIf->s32GetParkAssistVolume(ParkAssistVol);
  ETG_TRACE_USR4(("s32Res : %d",s32Res));


   tBool bSuccess = FALSE;


   oParkAssistVolumeStatus.VolumeLevel.enType = (midw_fi_tcl_e8_ADAS_ParkAssist_Volume::tenType)ParkAssistVol;

    // stream to new CCA message and hand over to calling function
   bSuccess = fi_tclVisitorMessage(oParkAssistVolumeStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
          .bHandOver(&roOutMsg);
      ETG_TRACE_USR4(("bSendAdas_ParkAssitVolStatus called, ParkAssistVol = %d",ParkAssistVol));
   oParkAssistVolumeStatus.vDestroy();

   return bSuccess;
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendAdas_UpaMuteStatus(amt_tclServiceData& roOutMsg) const
*
* DESCRIPTION: bSendAdas_UpaMuteStatus
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendAdas_UpaMuteStatus(amt_tclServiceData& roOutMsg) const
{

  midw_mascffi_tclMsgADAS_UPAMuteStatus oUPAMuteStatus;

   tBool bSuccess = FALSE;

   oUPAMuteStatus.bMuted = m_bUPAUserMuteStatus;

    // stream to new CCA message and hand over to calling function
   bSuccess = fi_tclVisitorMessage(oUPAMuteStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
          .bHandOver(&roOutMsg);

   ETG_TRACE_USR4(("bSendAdas_UpaMuteStatus called, oUPAMuteStatus.bMuted = %d",oUPAMuteStatus.bMuted));
   oUPAMuteStatus.vDestroy();

   return bSuccess;
}

/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendAdas_SRSoundMuteStatus(amt_tclServiceData& roOutMsg) const
*
* DESCRIPTION: bSendAdas_SRSoundMuteStatus
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendAdas_SRSoundNotificationStatus(amt_tclServiceData& roOutMsg) const
{

  midw_mascffi_tclMsgSRSoundNotificationStateStatus oSRSoundMuteStatus;

   tBool bSuccess = FALSE;
   tU8 bSRSoundActivationState = 0;
   tS32 s32Res = 0;
  AUD_POINTER_CHECK_CALL(pAudUsrDpIf);

  s32Res = pAudUsrDpIf->s32GetSRSoundState(bSRSoundActivationState);
  ETG_TRACE_USR4(("s32Res : %d",s32Res));
   oSRSoundMuteStatus.SR_SoundNotification_State = (tBool)bSRSoundActivationState;

    // stream to new CCA message and hand over to calling function
   bSuccess = fi_tclVisitorMessage(oSRSoundMuteStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
          .bHandOver(&roOutMsg);

   ETG_TRACE_USR4(("bSendAdas_SRSoundNotificationStatus called, oSRSoundMuteStatus.SR_SoundNotification_State = %d",oSRSoundMuteStatus.SR_SoundNotification_State));
   oSRSoundMuteStatus.vDestroy();

   return bSuccess;
}



/********************************************************************************************
*
* FUNCTION:    fc_audiomanager_tclService_Audio_Function::bSendAdas_LDWUserVolStatus(amt_tclServiceData& roOutMsg) const
*
* DESCRIPTION: bSendAdas_LDWUserVolStatus
*
* PARAMETER:   amt_tclServiceData&
*
* RETURNVALUE: tBool.
*
**********************************************************************************************/
tBool fc_audiomanager_tclService_Audio_Function::bSendAdas_LDWUserVolStatus(amt_tclServiceData& roOutMsg) const
{
  midw_mascffi_tclMsgADAS_LDW_UserVolumeStatus oLDWUSerVolumeStatus;
  dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi odpLDWUserVol;

  tU8 LDWUserVol = (tU8)midw_fi_tcl_e8_ADAS_LDW_UserVolume::FI_EN_ADAS_LDW_USR_VOL_LEVEL_INVALID;
  tS32 s32Res = 0;
  tBool bSuccess = FALSE;
  s32Res = odpLDWUserVol.s32GetData(LDWUserVol);
  ETG_TRACE_USR4(("s32Res : %d",s32Res));

  oLDWUSerVolumeStatus.VolumeLevel.enType = (midw_fi_tcl_e8_ADAS_LDW_UserVolume::tenType)LDWUserVol;

  // stream to new CCA message and hand over to calling function
  bSuccess = fi_tclVisitorMessage(oLDWUSerVolumeStatus, MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION)
    .bHandOver(&roOutMsg);
  ETG_TRACE_USR4(("bSendAdas_LDWUserVolStatus called, LDWUserVol = %d", LDWUserVol));
  oLDWUSerVolumeStatus.vDestroy();

  return bSuccess;
}

/********************************************************************************************
*
* FUNCTION:    bool fc_audiomanager_tclService_Audio_Function::bIsUPAUserMuteActive()
*
**********************************************************************************************/

 bool fc_audiomanager_tclService_Audio_Function::bIsUPAUserMuteActive()
 {
    return m_bUPAUserMuteStatus;
 }
 /*******************************************************************************
 *
 * FUNCTION: void fc_audiomanager_tclService_Audio_Function::vHandleTRCGetDiagResult(tPCUChar pcu8Data)
 *
 * DESCRIPTION: Handler to send the GetDiagResult PO msg
 *
 * PARAMETERS: tPCUChar pcu8Data
 *
 * RETURN TYPE: None
 *
 *******************************************************************************/

 tVoid fc_audiomanager_tclService_Audio_Function::vHandleTRCGetDiagResult(tPCUChar pcu8Data)
 {
   ETG_TRACE_USR4(("vHandleTRCGetDiagResult()  called"));

   tU16 u16Data[2];
   u16Data[0] = AUD_GET_U16(&pcu8Data[2]);
   u16Data[1] = AUD_GET_U16(&pcu8Data[4]);


   tTestRequestList ITCList;

   ITCList.push_back(u16Data[0]);
   ITCList.push_back(u16Data[1]);

   if (InternalCommunicationAdapter::getInstance() != NULL)
   {
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poMainAppInstance->m_poClientHandlerDiagLog);
     m_poMainAppInstance->m_poClientHandlerDiagLog->vProcessTTFiscommand(ITCList);
     ETG_TRACE_USR4(("GetDiagResult - message delivered"));
   }
 }
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
 tVoid fc_audiomanager_tclService_Audio_Function::vCheckAmplifierStatus()
{
   ETG_TRACE_USR4(("vCheckAmplifierStatus() entered."));
   tU8 AmpConfig = bCheckFaderAvailability();
   if((AmpConfig == EXTERNALAMP_BOSE2CH_MCAN) ||(AmpConfig == EXTERNALAMP_BOSE_5_1CH_MCAN))
   {
    ETG_TRACE_USR4(("vCheckAmplifierStatus() MCAN Bose amplifier connected."));
    m_bBoseAmplifierStatus = true;
   }
   else
   {
    ETG_TRACE_USR4(("vCheckAmplifierStatus() MCAN Bose amplifier not connected."));
    m_bBoseAmplifierStatus = false;
   }
}
#endif




tBool fc_audiomanager_tclService_Audio_Function::IsPremium2Connected()
{
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
    tU8 u8AmpConfig;
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","OutputInformation", &u8AmpConfig, 1)))
    {
        ETG_TRACE_ERR((" Diagnosis read successfull "));
      if(u8AmpConfig== PREMIUM_2)
      {

        return true;

      }else
      {

        return false;
      }

    }
    else
    {
      ETG_TRACE_ERR(("Error in diagnosis read "));

    }

#endif
 return false;

}

tVoid fc_audiomanager_tclService_Audio_Function::vOnNewACCState(tBool bACCState)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::vOnNewACCState() entered with ACC state: %d.", bACCState));
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
   if ( m_poMCANBoseAppl )
   {
    m_poMCANBoseAppl->vOnNewACCState( bACCState );
   }
#endif
}

tVoid fc_audiomanager_tclService_Audio_Function::HFPDisplay_Active(bool HFPDisplay)
{
  m_HFPDisplay_status = HFPDisplay;
  ETG_TRACE_USR4(("m_HFPDisplay_status state updated to %d",m_HFPDisplay_status));
if(!(bIsBoseAmpConnected()))
{
  if(HFPDisplay)
  {
    m_bUPAUserMuteStatus = false;
      ETG_TRACE_USR4(("HFPDisplay_Active is ACTIVE : m_bUPAUserMuteStatus %d",m_bUPAUserMuteStatus));

        if(m_ParkAssitVol==0)
   {
        m_bflag=1;  //flag set only if parkassist volume was zero previously
        ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Park assist volume was zero : setting it to default 3"));
        m_ParkAssitVol = 3;
        }
             }

  else
  {
    m_bUPAUserMuteStatus = m_bPrevUPAMuteStatus;
    m_ParkAssitVol = m_PrevParkAssitVol;
    ETG_TRACE_USR4(("HFPDisplay_Active is INACTIVE : m_ParkAssitVol %d",m_ParkAssitVol));
    ETG_TRACE_USR4(("HFPDisplay_Active is INACTIVE : m_bUPAUserMuteStatus %d",m_bUPAUserMuteStatus));
  }
    IDCCAUPATempMute oNotifyUPATempMute(m_bUPAUserMuteStatus);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyUPATempMute);


     if(!IsPremium2Connected())
    {
       ID_NotifyParkAssistVolume oNotifyPAVolume(m_ParkAssitVol);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyPAVolume);
    if (updateClients(MIDW_MASCFFI_C_U16_ADAS_UPAMUTE) != AIL_EN_N_NO_ERROR)
       {
           ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_UPAMUTE status"));
        }
            if (updateClients(MIDW_MASCFFI_C_U16_ADAS_PARKASSISTVOLUME) != AIL_EN_N_NO_ERROR)
               {
                    ETG_TRACE_ERR(("fc_audiomanager_tclService_Audio_Function::Updating clients for ADAS_PARKASSISTVOLUME status"));
                }
       }
     else
     {   if(m_bflag==1)
        {
       ETG_TRACE_USR4((" m_ParkAssitVol %d is sent to Engine",m_ParkAssitVol));
       ID_UpdateAmpValList oNotifyVolumeList(m_ParkAssitVol);
       InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oNotifyVolumeList);
  }
  }
}
}

bool fc_audiomanager_tclService_Audio_Function::bIsHFPActive()
{
  return m_HFPDisplay_status;
}
tVoid fc_audiomanager_tclService_Audio_Function::vSetRemoveWelcomeSound(tU8 u8Status)
{

  m_updatestatus = u8Status;
}
tBool fc_audiomanager_tclService_Audio_Function::IsOEMRenault()
{
  tU8 u8VariantInfo = 0;
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding", "OEMType", &u8VariantInfo,1)))
        {
            if(OEM_TYPE_RENAULT == u8VariantInfo)  //check if OEM type is Renault
            {
              ETG_TRACE_USR4(("OEM is Renault"));
               return true;
            }
        }
      else
       {
      ETG_TRACE_ERR(("Error in read"));
        }
    return false;
}
bool fc_audiomanager_tclService_Audio_Function::IsSBRVariant()
{
        tU8 u8KDSParam=0;
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("GenericTunerParameter","MuteOrAttenuationForAbsoluteStationChangeAMFM", &u8KDSParam, 1)))
        {
           ETG_TRACE_USR4(("GenericTunerParameter value  : %d", u8KDSParam));
           if((u8KDSParam == SINK_DEV_WITHOUT_ADR) || (u8KDSParam == SINK_DEV_PASSTHRU_ADR))
           {
             return true;
           }
        }
        return false;
}

/*******************************************************************************
* FUNCTION   : fc_audiomanager_tclService_Audio_Function::u8GetOEMType()
*
* DESCRIPTION: Reads the OEMType value and returns the same
*
* PARAMETER  : None
*
* RETURNVALUE: tU8
*******************************************************************************/
tU8 fc_audiomanager_tclService_Audio_Function::u8GetOEMType()
{
  tU8 u8VariantInfo = 0;
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding", "OEMType", &u8VariantInfo,1)))
        {
            ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::u8GetOEMType()::OEMType value %d", u8VariantInfo ));       
        }
    else
       {
            ETG_TRACE_ERR(("Error in read"));
       }
    return u8VariantInfo;
}

/**********************************************************************************************
* FUNCTION   : fc_audiomanager_tclService_Audio_Function::u8GetvehicleType()
*
* DESCRIPTION: Reads the Vehicle type value into an array
*
* PARAMETER  : tU8*
*
* RETURNVALUE: tVoid
**********************************************************************************************/
tVoid fc_audiomanager_tclService_Audio_Function::u8GetvehicleType(tU8* u8VehicleType)
{
    if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "VehicleType", u8VehicleType, 2))
    {
        ETG_TRACE_USR4(("fc_audiomanager_tclService_Audio_Function::u8GetvehicleType()::VehicleType value %x %x", u8VehicleType[0],u8VehicleType[1] ));
        
    }
    else
    {
        ETG_TRACE_ERR(("Error in read"));
        
    }
}
