/*******************************************************************************
 *
 * FILE:          fc_audiomanager_main.cpp
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

#include "InternalCommunicationAdapter.h"

#include "fc_audiomanager_main.h"
#include "fc_audiomanager_clienthandler_DiagLog.h"
#include "aud_sinkmgr_main.h"
#include "aud_extampconn_timer.h"
#include "AudioProxy/aud_gio_dbus_handler.h"
#include "aud_sinkmgr_pwramp.h"
#include "Beep/Beep_Main.h"
#include "Beep/Beep_Adas.h"
#include "vd_adr3Msg_If.h"
#include "vd_adr3_If.h"
#include "InternalComponentCommunication/Messages/Startup/ID_NotifyRegular100msTicks.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/Clipping_Level.h"
#include "Clipping/clipping.h"

/**vdu1kor: Currently commented for migration to G3 Platform.*/

#include "Sound/TuningDataService.h"
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
#include "fc_audiomanager_clienthandler_Diagnostics.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
#include "Arkamys/ArkamysFeatInterface.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#include "fc_audiomanager_service_Audio_Function.h"
#include "Diagnosis/fc_audiomanager_Audio_Diagnosis.h"
//Fofi changed: the service diagnosis FI of the audio subsystem (mascd_fi) is obsolete and can be removed.
//Here will included the main diagnosis class

/**vdu1kor: Currently commented for migration to G3 Platform.*/
#include "Diagnosis/fc_audiomanager_Microphone_Diagnosis.h"
#include "fc_audiomanager_service_Client_Handler_Phone.h"
#include "fc_audiomanager_service_Client_Handler_Tel_fi.h"
#include "fc_audiomanager_componentfactory_if.h"
#include "fc_audiomanager_clienthandler_AudioManagerspm.h"
#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_APPLICATION
#include "trcGenProj/Header/fc_audiomanager_main.cpp.trc.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
#include "VehicleDomainHandlerMain.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
#include "EngineSound/EngineSoundHandler.h"
#include "EngineSound/EngineSoundADR.h"
#include "EngineSound/EngineSoundDp.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
#include "EngineSound/RNAIVI/EngineSoundHandlerIVI.h"
#include "Sound/ESETuningHandlerRNAIVI.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI

#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND


#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#include "Booster/Booster.h"
#include "Booster/BoosterDiaglogHandler.h"
#endif



#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"
#define PREMIUM_2  3
#define DP_S32_ERR 1
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

//#define FC_AUDIOMANAGER_TIMER_TIME_UNTIL_FIRST_TICK 2000
//#define FC_AUDIOMANAGER_TIMER_TICK_INTERVALL 2000

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
fc_audiomanager_tclApp* fc_audiomanager_tclApp::m_poMainAppInstance = NULL;
fc_audiomanager_tclTraceChannel* fc_audiomanager_tclApp::_poTrace = NULL;

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclApp::fc_audiomanager_tclApp()
 *
 * DESCRIPTION: Constructor.
 *
 *              Initialize static self reference to be used in function
 *              callbacks.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_audiomanager_tclApp::fc_audiomanager_tclApp()
   : ahl_tclBaseOneThreadApp()
   , m_poBeepMain(NULL)
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  ,m_poCsmHandler(NULL)
  ,m_poBooster(NULL)
  ,m_poBoosterDiaglogHandler(NULL)
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
  ,m_poClientHandlerDiagnostics(NULL)
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
   , m_poEngineSoundHandler(NULL)
#endif
   , m_poClientHandlerDiagLog(NULL)
   , m_EnableLoopbackTrace(FALSE)
   , m_poAudio_Function(NULL)
   , m_poCLientHandlerPhone(NULL)
   , m_poClientHandlerTelFi(NULL)

   , m_poAudio_Diagnosis(NULL)
   , m_poAudioManagerspm(NULL)
   , m_poClientHandlerVehicle(NULL)

   , m_poAudioClipping(NULL)
   , m_poSinkMgr(NULL)

   ,m_pGioDbusHandler(NULL)
   ,m_ploopback(NULL)
   ,m_asynccall(NULL)


#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
  , m_pVehicleDomainHandler(NULL)
#endif
#ifdef VARIANT_S_FTR_ENABLE_AUD_USR_PROFILE
   ,m_pProfileMgr(NULL)
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_PARTIAL_MUTE_INF4CV
  ,m_pVehicleData(NULL)
#endif
{
   ETG_TRACE_USR4(("fc_audiomanager_tclApp() entered."));

   fc_audiomanager_tclApp::m_poMainAppInstance = this;
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclApp::~fc_audiomanager_tclApp()
 *
 * DESCRIPTION: Destructor.
 *
 *              Invalidate static self reference.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_audiomanager_tclApp::~fc_audiomanager_tclApp()
{
   ETG_TRACE_USR4(("~fc_audiomanager_tclApp() entered."));

   fc_audiomanager_tclApp::m_poMainAppInstance = NULL;

   if(m_poAudio_Function != NULL)
   {
      delete m_poAudio_Function;
      m_poAudio_Function = NULL;
   }
   if(m_poAudio_Diagnosis != NULL)
   {
      delete m_poAudio_Diagnosis;
      m_poAudio_Diagnosis = NULL;
   }

   if (m_poCLientHandlerPhone != NULL)
   {
      OSAL_DELETE  m_poCLientHandlerPhone;
      m_poCLientHandlerPhone = NULL;
    }

  if (m_poClientHandlerTelFi != NULL)
    {
      OSAL_DELETE  m_poClientHandlerTelFi;
      m_poClientHandlerTelFi = NULL;
    }

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
   if(m_poClientHandlerDiagnostics != NULL)
   {
     OSAL_DELETE m_poClientHandlerDiagnostics;
     m_poClientHandlerDiagnostics = NULL;
   }
#endif
   if (m_poAudioManagerspm != NULL)
   {
        OSAL_DELETE m_poAudioManagerspm;
       m_poAudioManagerspm = NULL;
   }
    if (m_poAudioClipping != NULL)
    {
           OSAL_DELETE m_poAudioClipping;
         m_poAudioClipping = NULL;
    }

   if( m_poClientHandlerVehicle != NULL)
   {
     OSAL_DELETE m_poClientHandlerVehicle;
     m_poClientHandlerVehicle = NULL;
   }

   OSAL_DELETE m_poClientHandlerDiagLog;
   m_poClientHandlerDiagLog = NULL;

   OSAL_DELETE m_poBeepMain;
   m_poBeepMain = NULL;
   OSAL_DELETE m_poSinkMgr;
   m_poSinkMgr = NULL;

#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
  if(m_pVehicleDomainHandler != NULL)
  {
    OSAL_DELETE m_pVehicleDomainHandler;
    m_pVehicleDomainHandler = NULL;
  }
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
   if (m_poEngineSoundHandler != NULL)
   {
      OSAL_DELETE m_poEngineSoundHandler;
      m_poEngineSoundHandler = NULL;
   }
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   if (m_poCsmHandler != NULL)
   {
      OSAL_DELETE m_poCsmHandler;
      m_poCsmHandler = NULL;
   }
   if (m_poBooster != NULL)
   {
      OSAL_DELETE m_poBooster;
      m_poBooster = NULL;
   }
   if (m_poBoosterDiaglogHandler != NULL)
   {
      OSAL_DELETE m_poBoosterDiaglogHandler;
      m_poBoosterDiaglogHandler = NULL;
   }
#endif
   if(m_pGioDbusHandler!= NULL)
   {
     m_pGioDbusHandler->vDeInit();
     delete m_pGioDbusHandler;
     m_pGioDbusHandler = NULL;
   }
#ifdef VARIANT_S_FTR_ENABLE_AUD_USR_PROFILE
   if(NULL != m_pProfileMgr)
   {
      delete m_pProfileMgr;
      m_pProfileMgr = NULL;
   }
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_PARTIAL_MUTE_INF4CV
  if(NULL != m_pVehicleData)
  {
    delete m_pVehicleData;
    m_pVehicleData = NULL;
  }
#endif
   if(m_ploopback)
   {
     delete m_ploopback;
     m_ploopback = NULL;
   }

   if(m_asynccall)
   {
     delete m_asynccall;
     m_asynccall = NULL;
   }
}

/*******************************************************************************
 *
 * FUNCTION: tBool fc_audiomanager_tclApp::bOnInit()
 *
 * DESCRIPTION: This function is called by the CCA framework before starting any
 *              CCA message related communication action. As default this
 *              function always returns TRUE. The user has to implement all his
 *              local application initialization (create client and service
 *              handler, create worker threads, allocate application memory,...).
 *              If returns TRUE, initialization could be successfully performed
 *              and framework will register application, else, a reset of the
 *              system is forced immediately.
 *
 *              This function is the counterpart of vOnApplicationClose().
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: TRUE  = Application successfully initialized.
 *              FALSE = Application NOT successfully initialized.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::bOnInit().
 *******************************************************************************/
tBool fc_audiomanager_tclApp::bOnInit()
{
   tBool bSuccess = TRUE;
   ETG_TRACE_USR4(("bOnInit() entered."));
   //initializing the trace class to communicate with TTFis
   _poTrace = OSAL_NEW fc_audiomanager_tclTraceChannel();
   if (NULL == _poTrace)
   {
      FATAL_M_ASSERT_ALWAYS();
   }

   m_ploopback = new aud_tcl_loopback_mgr(this);

   m_asynccall = new aud_async_call_handler(m_ploopback);
   m_poAudio_Function = OSAL_NEW  fc_audiomanager_tclService_Audio_Function(this);
   ETG_TRACE_USR4(("m_poAudio_Function = %p",m_poAudio_Function));
   if (NULL == m_poAudio_Function)
   {
      bSuccess = FALSE;

      FATAL_M_ASSERT_ALWAYS();
   }

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  m_poCsmHandler = new fc_audiomanager_csmSignal_Handler(this); // to recieve the registered CAN signals
  AUD_POINTER_CHECK_CALL(m_poCsmHandler);
  m_poCsmHandler->vRegisterForCSMSignals();
  m_poCsmHandler->vForceCSMSignalRead();
#endif
   //Create instance of Booster
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
  if(NULL == m_poBoosterDiaglogHandler)
  {
    m_poBoosterDiaglogHandler = OSAL_NEW BoosterDiaglogHandler();
  }

  if(NULL == m_poBooster)
  {
    m_poBooster = OSAL_NEW Booster(this);

    m_poBooster->vInit();
  }

#endif

   m_poSinkMgr = OSAL_NEW aud_sinkmgr_main(this, m_poAudio_Function);
   ETG_TRACE_USR4(("m_poSinkMgr = %p",m_poSinkMgr));
   if (NULL == m_poSinkMgr)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

   AUD_POINTER_CHECK_CALL (m_poSinkMgr);
   m_poSinkMgr->vInit();


   //Fofi changed: the service diagnosis FI of the audio subsystem (mascd_fi) is obsolete and can be removed.
   //Here will genereted the main diagnosis class
   m_poAudio_Diagnosis = OSAL_NEW fc_audiomanager_tclAudio_Diagnosis(this);

   if (NULL == m_poAudio_Diagnosis)
   {
      bSuccess = FALSE;

      FATAL_M_ASSERT_ALWAYS();
   }


// m_poBeepMain = OSAL_NEW Beep_Main(this, m_poAudio_Function);

 tU8 u8AmpConfig;
   tS32 config = DP_S32_ERR;
#ifndef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX

 config = DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation", &u8AmpConfig, 1);
#endif
  if((DP_S32_NO_ERR == config))
  {
  if( u8AmpConfig!=PREMIUM_2)
  {
    m_poBeepMain = OSAL_NEW Beep_Main(this, m_poAudio_Function);
   ETG_TRACE_USR4(("m_poBeepMain = %p",m_poBeepMain));
   if (NULL == m_poBeepMain)
   {
    bSuccess = FALSE;
     FATAL_M_ASSERT_ALWAYS();
   }
   }
  }
   else
    {
    ETG_TRACE_ERR(("Error in diagnosis read "));

    m_poBeepMain = OSAL_NEW Beep_Main(this, m_poAudio_Function);
   ETG_TRACE_USR4(("m_poBeepMain = %p",m_poBeepMain));
   if (NULL == m_poBeepMain)
   {
    bSuccess = FALSE;
     FATAL_M_ASSERT_ALWAYS();
   }

    }


    m_poAudioManagerspm = OSAL_NEW fc_audiomanager_tclClientHandler_AudioManagerspm(this);
    if (NULL == m_poAudioManagerspm )
    {
       bSuccess = FALSE;
       FATAL_M_ASSERT_ALWAYS();
     }



#ifndef VARIANT_S_FTR_ENABLE_G3G
   m_poAudioClipping = OSAL_NEW Audio_clipping(this);
   if (NULL == m_poAudioClipping )
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
   ETG_TRACE_USR4 (("ClientHandler_Diagnostics called..."));
  m_poClientHandlerDiagnostics = OSAL_NEW fc_audiomanager_tclClientHandler_Diagnostics(this);
   if (NULL == m_poClientHandlerDiagnostics )
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
    }
#endif
   m_poClientHandlerVehicle = fc_audiomanager_IClientHandler_Vehicle::poGetInstance(this);

   m_poClientHandlerDiagLog = OSAL_NEW fc_audiomanager_tclClientHandler_DiagLog(this);
   if (NULL == m_poClientHandlerDiagLog)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

   m_poCLientHandlerPhone = OSAL_NEW fc_audiomanager_service_Client_Handler_Phone(this);
   ETG_TRACE_USR4 (("m_poCLientHandlerPhone = %p", m_poCLientHandlerPhone));
   if (NULL == m_poCLientHandlerPhone)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
  m_poClientHandlerTelFi = OSAL_NEW fc_audiomanager_service_Client_Handler_Tel_Fi(this);
  ETG_TRACE_USR4 (("m_poClientHandlerTelFi = %p", m_poClientHandlerTelFi));
  if (NULL == m_poClientHandlerTelFi)
    {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
    }
   vRegisterTraceInputs();

   if (bStartTimer(FC_AUDIOMANAGER_TIMER_ID_100MS, 100, 100))
   {
      ETG_TRACE_USR3(("100 ms Tick-Timer established"))
   }
   else
   {
      bSuccess = FALSE;
      ETG_TRACE_ERR(("100 ms Tick-Timer starting failed"))
   }


   if (TuningDataService::getInstance() -> bStartupServer())
   {
      ETG_TRACE_USR3(("TuningDataService started."));
      tBool res = TuningDataService::getInstance() -> bRegisterUser();
      if (!res)
      {
         bSuccess = FALSE;
         ETG_TRACE_ERR(("Could not register Tuning client with TuningDataService."));
      }
   }
   else
   {
    // because of CMG3G-13417 IS3444_A-IVI Tuning Interface Arkamys/ESE we no more return false here
      //bSuccess = FALSE;
      ETG_TRACE_ERR(("TuningDataService could not be started."))
   }


#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
  m_pVehicleDomainHandler = OSAL_NEW VehicleDomainHandlerMain(this);

   if (NULL == m_pVehicleDomainHandler)
   {
     bSuccess = FALSE;
     FATAL_M_ASSERT_ALWAYS();
   }
#endif // VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
   ETG_TRACE_USR3(("Init ArkamysFeatureHandler."));
   ArkamysFeatInterface::getInstance()->bStartup(this);
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
   ETG_TRACE_USR3(("Init EngineSoundHandler PSA."));
   static EngineSoundADR eseAdr;
   static EngineSoundDp eseDp;
   m_poEngineSoundHandler = OSAL_NEW EngineSoundHandler(&eseAdr, &eseDp);
   if (m_poEngineSoundHandler != OSAL_NULL) // Lint wants a check here
   {
      eseAdr.SetEseHandler(m_poEngineSoundHandler);

      if (!m_poEngineSoundHandler -> bStartup())
      {
         bSuccess = FALSE;
      }
   }
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND

#ifdef VARIANT_S_FTR_ENABLE_AUD_USR_PROFILE
   m_pProfileMgr = new fc_audiomanager_tclClientHandler_profilemanager(this);
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_PARTIAL_MUTE_INF4CV
  m_pVehicleData = new fc_audiomanager_tclClientHandler_VehicleData(this);
#endif

   ETG_TRACE_USR3(("Creating gio handler."));
   m_pGioDbusHandler = OSAL_NEW aud_gio_dbus_handler(this);
   if(m_pGioDbusHandler!= NULL)
   {
     ETG_TRACE_USR3(("Initializing gio handler."));
     bSuccess = m_pGioDbusHandler->bInit();
   }

   bSuccess = m_poSinkMgr->bLoadPlugins();

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
   //This sequence is very important due to the design limitations, that bStartup of-
   //EngineSoundHandlerIVI is called only after bLoadPlugins() is executed.
   //Otherwise, the ESE settings will not forwarded to Premium-1 ampplifier on start-up (NCG3D-89763)
   ETG_TRACE_USR3(("Init EngineSoundHandler IVI."));
   EngineSoundHandlerIVI::getInstance()->bStartup(this);
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_IVI
#endif //VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND

   //Start worker thread
   bStart();

   return bSuccess;
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclApp::vOnApplicationClose()
 *
 * DESCRIPTION: This function is called by the CCA framework to indicate the
 *              imminent shutdown of the application. The user has to implement
 *              the de-initialization of all his local application data (destroy
 *              client and service handler, destroy worker threads, free
 *              application memory, ... ). After this function call the
 *              destructor of this application will be called.
 *
 *              This function is the counterpart of bOnInit().
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
 *******************************************************************************/
 tVoid fc_audiomanager_tclApp::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   bStopTimer(FC_AUDIOMANAGER_TIMER_ID_100MS);
   bStopTimer(FC_AUDIOMANAGER_TIMER_ID_BEEP);
   bStopTimer(FC_AUDIOMANAGER_TIMER_ID_PING);
   bStopTimer(FC_AUDIOMANAGER_TIMER_ID_MIC_DIAG);

   //Stop worker thread
   bStop();

   try
   {

      if (m_poAudio_Function != NULL)
      {
         OSAL_DELETE m_poAudio_Function;
         m_poAudio_Function = NULL;
      }

      if (m_poSinkMgr != NULL)
      {
         OSAL_DELETE m_poSinkMgr;
         m_poSinkMgr = NULL;
      }


      if (m_poAudio_Diagnosis != NULL)
      {
         OSAL_DELETE m_poAudio_Diagnosis;
         m_poAudio_Diagnosis = NULL;
      }


      if(m_poClientHandlerVehicle != NULL)
      {
        OSAL_DELETE m_poClientHandlerVehicle;
        m_poClientHandlerVehicle = NULL;
      }

    if (m_poBeepMain != NULL)
      {
         OSAL_DELETE m_poBeepMain;
         m_poBeepMain = NULL;
      }

    if (NULL != m_poCLientHandlerPhone)
      {
  OSAL_DELETE m_poCLientHandlerPhone;
  m_poCLientHandlerPhone = NULL;
      }

    if (NULL != m_poClientHandlerTelFi)
      {
  OSAL_DELETE m_poClientHandlerTelFi;
  m_poClientHandlerTelFi = NULL;
      }

    if (m_poAudioClipping != NULL)
      {
         OSAL_DELETE m_poAudioClipping;
        m_poAudioClipping = NULL;
     }

#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
    if(m_pVehicleDomainHandler != NULL)
    {
      OSAL_DELETE m_pVehicleDomainHandler;
      m_pVehicleDomainHandler = NULL;
    }
#endif
    if(m_pGioDbusHandler!= NULL)
    {
      m_pGioDbusHandler->vDeInit();
      delete m_pGioDbusHandler;
      m_pGioDbusHandler = NULL;
    }
#ifdef VARIANT_S_FTR_ENABLE_AUD_USR_PROFILE
      if(NULL != m_pProfileMgr)
      {
         delete m_pProfileMgr;
         m_pProfileMgr = NULL;
      }
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_PARTIAL_MUTE_INF4CV
      if(NULL !=m_pVehicleData)
    {
      delete m_pVehicleData;
      m_pVehicleData = NULL;
      }
#endif
    if(m_asynccall)
    {
      delete m_asynccall;
      m_asynccall = NULL;
    }
    if(m_ploopback)
    {
      delete m_ploopback;
      m_ploopback = NULL;
    }

      if (_poTrace != NULL)
      {
         OSAL_DELETE _poTrace;
         _poTrace = NULL;
      }
   }
  catch(...){
    ETG_TRACE_FATAL(("ahl_tclBaseOneThreadApp::vOnApplicationClose() Exception handled"));

  }
   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclApp::vOnLoadSettings()
 *
 * DESCRIPTION: This function is called by the CCA framework to trigger the
 *              loading of last mode settings. The user has to load the
 *              previously stored last mode settings from persistent memory.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnLoadSettings().
 *******************************************************************************/
 tVoid fc_audiomanager_tclApp::vOnLoadSettings()
{
   ETG_TRACE_USR4(("vOnLoadSettings() entered."));
   if(m_poAudio_Function != NULL)
   {
      // maybe we could have this as PostOffice message object ??
      m_poAudio_Function->vOnLoadSettings();
   }
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclApp::vOnSaveSettings()
 *
 * DESCRIPTION: This function is called by the CCA framework to trigger the
 *              storage of last mode settings. The user has to store the last
 *              mode settings to persistent memory.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnSaveSettings().
 *******************************************************************************/
 tVoid fc_audiomanager_tclApp::vOnSaveSettings()
{
   ETG_TRACE_USR4(("vOnSaveSettings() entered."));
}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclApp::vOnTimer(tU16 u16TimerId)
 *
 * DESCRIPTION: This function is called by the CCA framework on the expiration
 *              of a previously via function bStartTimer() started timer. The
 *              expired timer is forwarded to the respective service or
 *              client-handler via a call of vProcessTimer().
 *
 *              The function is called from this applications context and
 *              therefore no interthread programming rules must be considered
 *              and the application methods and/or member variables can be
 *              accessed without using the static self reference
 *              'm_poMainAppInstance'.
 *
 * PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
 *******************************************************************************/
 tVoid fc_audiomanager_tclApp::vOnTimer(tU16 u16TimerId)
{
      ETG_TRACE_USR4(("vOnTimer() entered.u16TimerId = %u", u16TimerId));

      switch (u16TimerId)
      {
         case FC_AUDIOMANAGER_TIMER_ID_100MS:
         {
            ID_NotifyRegular100msTicks oTimerNotification;
            InternalCommunicationAdapter::POMessages->DeliverMsg(&oTimerNotification);
         }
            break;
     case FC_AUDIOMANAGER_TIMER_ID_BEEP:
         {
            if (NULL != m_poBeepMain)
            {
              ETG_TRACE_USR3(("On timer expiry for Beep"));
              m_poBeepMain->m_poBeepController->DoMuteBeepStream();
            }
            else
            {
               NORMAL_M_ASSERT_ALWAYS();
            }
         }
         break;
     case FC_AUDIOMANAGER_TIMER_ID_PING:
       ETG_TRACE_USR3(("On timer expiry for FC_AUDIOMANAGER_TIMER_ID_PING"));
       vd_adr3_If::vPingTimerCallback();
       break;

       //The below implementation has been moved to a different thread.
//    #ifndef VARIANT_S_FTR_ENABLE_G3G
       case FC_AUDIOMANAGER_TIMER_ID_MIC_DIAG:
       {
       //Post an event to worker thread to read the microphone current values.
       vPostEvent(FC_AUDIOMANAGER_WORKER_THREAD_EV_READ_MIC_DIAG);
          break;
       }
//   #endif
     default:
        break;
      }
}

 /********************************************************************************
  * Overrides method ahl_tclBaseOneThreadApp::vOnEvent()
  *******************************************************************************/
 tVoid fc_audiomanager_tclApp::vOnEvent(OSAL_tEventMask nEvent)
 {
     tU8 ubMuteOn;

     aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
     ETG_TRACE_USR4(("vOnEvent() nEvent = 0x%x , pPwrAmp = %p", nEvent, pPwrAmp))

     //find enabled bits, delete bit when data is processed, check for left over bits
     if (nEvent & FC_AUDIOMANAGER_AHL_EVENT_CHECK_PWR_AMP)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_CHECK_PWR_AMP nEvent = 0x%x ", nEvent));

       if (pPwrAmp)
          pPwrAmp->vCheckPwrAmp();

       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_CHECK_PWR_AMP);
     }
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_SINK_DEMUTE)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_SINK_DEMUTE nEvent = 0x%x ", nEvent));
       if (pPwrAmp)
          pPwrAmp->vCheckPwrAmpTmr();

       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_SINK_DEMUTE);
     }
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_SINK_BOOSTER_OFF)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_SINK_BOOSTER_OFF nEvent = 0x%x ", nEvent));
       if (pPwrAmp)
          pPwrAmp->vCheckPwrAmpTmr();

       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_SINK_BOOSTER_OFF);
     }
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_SINK_ADR3_STANDBY)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_SINK_ADR3_STANDBY nEvent = 0x%x ", nEvent));
       if (pPwrAmp)
          pPwrAmp->vCheckPwrAmpTmr();

       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_SINK_ADR3_STANDBY);
     }
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_SPECIAL_MUTE)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_SPECIAL_MUTE nEvent = 0x%x ", nEvent));
       ubMuteOn = 1;
       if (pPwrAmp)
          pPwrAmp->vSetSpecialMute(ubMuteOn);

       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_SPECIAL_MUTE);
     }
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_CHECK_ACC)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_CHECK_ACC nEvent = 0x%x ", nEvent));
       if (pPwrAmp)
          pPwrAmp->vCheckAccStatus();

       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_CHECK_ACC);
     }
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_BOOSTER_ON)
     {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_BOOSTER_ON nEvent = 0x%x ", nEvent));
       if (pPwrAmp)
          pPwrAmp->vCheckPwrAmpTmr();
       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_BOOSTER_ON);
     }
   //rjk2kor
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_MUTE_TIMEOUT)
   {
     ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_MUTE_TIMEOUT nEvent = 0x%x ", nEvent));
     nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_MUTE_TIMEOUT);
     if(m_poMainAppInstance != NULL)
     {
       // send a response to the mute requesters since there has been a timeout
       m_poMainAppInstance->m_poAudio_Function->m_pStreamMute->vMuteResponseTimeOut();
     }
   }
    //wie1hi
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS
     if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_ARKAMYS)
    {
       ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_ARKAMYS nEvent = 0x%x ", nEvent));
       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_ARKAMYS);
       if(m_poMainAppInstance != NULL)
       {
           ArkamysFeatInterface::getInstance()->timerExpired(OSAL_NULL);
       }
    }
#endif // VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ARKAMYS

#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
    if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_VEHICLEDOMAIN_CHECK_ALIVE)
    {
       nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_VEHICLEDOMAIN_CHECK_ALIVE);

       if(m_pVehicleDomainHandler != NULL)
          m_pVehicleDomainHandler->vCheckSccAlive();
    }
#endif //VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM

   if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_EXTAMPLIFIER_CONNECTION)
   {
     ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_EXTAMPLIFIER_CONNECTION time out occured, nEvent = 0x%x ", nEvent));
     nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_EXTAMPLIFIER_CONNECTION);
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_poSinkMgr);
     m_poSinkMgr->m_poExtAmpConnTimer->vSendDiagTurnOnStatus(); // since timer expired and no update from Amplifier, Sending DiagTurn ON status to ADR

   }
   if(nEvent & FC_AUDIOMANAGER_AHL_EVENT_LOOPBACK_MSG_AVAILABLE)
   {
     ETG_TRACE_USR3(("vOnEvent() FC_AUDIOMANAGER_AHL_EVENT_LOOPBACK_MSG_AVAILABLE Event occured, nEvent = 0x%x ", nEvent));
     nEvent = (nEvent & ~FC_AUDIOMANAGER_AHL_EVENT_LOOPBACK_MSG_AVAILABLE);
     AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_ploopback);
     m_ploopback->vDispatch(); // Process messages in loopback queue
   }
     if(nEvent != 0)
     {
       ETG_TRACE_ERR(("vOnEvent  invalid event !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
     }
 }

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_tclApp::vOnLoopback
 *                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
 *
 * DESCRIPTION: This function is called by the CCA framework if a message was
 *              sent from one if this applications services or from a
 *              callback-handler of this application (so called self or loopback
 *              messages). The message can be forwarded to the respective service
 *              via a call of vOnLoopbackService(). If there is no service
 *              registered for this message then the user has the option to
 *              directly evaluate the message in the default block of this.
 *              methods switch-clause.
 *
 * PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
 *                                message was sent.
 *
 *            [IN] poMessage = Message object.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
 *******************************************************************************/
 tVoid fc_audiomanager_tclApp::vOnLoopback(tU16 u16ServiceID,
      amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR2(("vOnLoopback() u16ServiceID = 0x%x, u16FunctionId = 0x%x,  u32Length =0x%x,\n pu8Data=0x%02x"
      , u16ServiceID, poMessage->u16GetFunctionID(), 6, ETG_LIST_LEN(6), ETG_LIST_PTR_T8(poMessage)));

   switch (u16ServiceID)
   {
      case CCA_C_U16_SRV_AUDIOFUNC:
         {
            if (m_poAudio_Function)
            {
              m_poAudio_Function->vOnLoopbackService(poMessage);
            }
            else
            {
               NORMAL_M_ASSERT_ALWAYS();
            }
         }
         break;

      case CCA_C_U16_SRV_APPINFO:
         {
            gm_tclStreamMessage oVisitorMsg(poMessage);
            tPCUChar pcu8Data = (tPCUChar)oVisitorMsg.pcocGetData();
            ETG_TRACE_USR2(("vOnLoopback() - Dispatching Loopback message to %u"
               , ETG_CENUM(TRC::tenTrcCompInput, pcu8Data[1])))
            _poTrace->vTrace_Rx (oVisitorMsg.u32GetDataSize(), pcu8Data);
         }
         break;

      default:
         {
            // Evaluate your none service related loopback messages here.
         }
         break;
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vRegisterTraceInputs(tVoid)
*
*
* DESCRIPTION: Register Trace Inputs
*
* PARAMETER:   None
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclApp::vRegisterTraceInputs(tVoid)
{
  ETG_TRACE_USR4(("vRegisterTraceInputs() entered."));

  if(_poTrace) {
     tVoid (*pCallbackFunction)(tPCUChar);
     pCallbackFunction = vRxFromOtherThreads_Callback; // To ensure function pointer type safety

    vPlugTraceIn(TR_TTFIS_AUDIOMANAGER, (OSAL_tpfCallback)pCallbackFunction);

    _poTrace->vRegisterTraceService(static_cast<tU32>(TRC::enSinkMgr), m_poSinkMgr); //sinkmanager main
    _poTrace->vRegisterTraceService(static_cast<tU32>(TRC::enAudMgrApp), this);
    _poTrace->vRegisterTraceService(static_cast<tU32>(TRC::enAudMgrServiceAudioFunc), this->m_poAudio_Function);
#ifndef VARIANT_S_FTR_ENABLE_G3G
    _poTrace->vRegisterTraceService(static_cast<tU32>(TRC::enClientHandlerPhone), this->m_poCLientHandlerPhone);
#endif

    /* +++
      add more classes using the trace input interface here
      +++ */
  }
}

tVoid fc_audiomanager_tclApp::vRegisterTraceInputs(tU32 uInputNum, fc_audiomanager_tclTraceInput* pclInput)const
{
  if(_poTrace)
  {
    _poTrace->vRegisterTraceService(uInputNum, pclInput); //sinkmanager main
  }
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_tclApp::theServer()
 *
 * DESCRIPTION: Creates new server object using the singleton pattern.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: Pointer to the instance of this application.
 *
 *******************************************************************************/
fc_audiomanager_tclApp* fc_audiomanager_tclApp::theServer()
{
   if (fc_audiomanager_tclApp::m_poMainAppInstance == NULL)
   {
      fc_audiomanager_tclApp::m_poMainAppInstance = new fc_audiomanager_tclApp();
   }
   return fc_audiomanager_tclApp::m_poMainAppInstance;
}

/************************************************************************************/
tVoid fc_audiomanager_tclApp::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
   (tVoid) size; // Lint
  ETG_TRACE_USR4((" fc_audiomanager_tclApp::vTraceRx entered."));

  if(pcu8Data == NULL) return;
  // pcu8Data[0] == tenTrcTrcClassName
  // pcu8Data[1] == tenTrcFuncInput
  // pcu8Data[2] == the 1. parameter
  // pcu8Data[3] == the 2. parameter
  // rest is defined here


  /*if (pcu8Data[0] > 2)
  {
    switch ( pcu8Data[2] )
    {

    default:
      ETG_TRACE_USR4(("default"));
      break;

    }
  }
  */
}

// -----------------------------------------------------------------------------

tVoid fc_audiomanager_tclApp :: vRxFromOtherThreads_Callback(tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vRxFromOtherThreads_Callback called. Redirecting to vRxFromOtherThreads()."));

   vRxFromOtherThreads(pcu8Data[0], &pcu8Data[1]);
}

// -----------------------------------------------------------------------------

tVoid fc_audiomanager_tclApp :: vRxFromOtherThreads (tU32 size, tPCUChar pcu8Data)
{
   // Route buffer content received from ADR3 or TTFis or any other source
   // into Loopback message input queue, in order to process it inside
   // AE0107 entry thread
   //
   // Note: Buffer should be arranged according to TTFis command layout:
   //    pcu8Data[0]     : TTFis channel (identifies recipient)
   //    pcu8Data[1]     : CommandID
   //    pcu8Data[2...]  : parameter / payload data


   // validate preconditions
   if (NULL == pcu8Data)
   {
      ETG_TRACE_FATAL(("fc_audiomanager_tclApp::vRxFromOtherThreads() - invalid message pointer"))
      return;
   }
   else if (size < 2)
   {
      ETG_TRACE_FATAL(("fc_audiomanager_tclApp::vRxFromOtherThreads() - Message too short; only %u bytes.", size))
      return;
   }
   else if (NULL == m_poMainAppInstance)
   {
      ETG_TRACE_FATAL(("fc_audiomanager_tclApp::vRxFromOtherThreads() - invalid pointer to MainAppInstance"))
      return;
   }

#ifndef VARIANT_S_FTR_ENABLE_FEAT_USE_INTERNAL_LOOPBACK

   // Create a Stream message and fill with data.
   tU16 u16MyAppID = m_poMainAppInstance->u16GetAppId();
   gm_tclStreamMessage oMsg
      (    u16MyAppID                        // Source app-ID
         , u16MyAppID                        // Dest. app-ID
         , 0                                 // Reg ID
         , 0                                 // Command counter
         , CCA_C_U16_SRV_APPINFO             // ServiceId
         , FC_AUDIOMANAGER_TRACE_STREAM_FID  // FID
         , CCA_C_U8_OPCODE_METHODSTART       // Opcode
         , size                              // Buffer Size
      );

   // Deliver the loopback message
   if (oMsg.bIsValid())
   {
      //rjk2kor: Set data only when the message is valid : Fix for SUZUKI-21609
    oMsg.vSetData((const tChar*)pcu8Data);    // Set the data from trace into the stream.
      ail_tenCommunicationError enCommError = m_poMainAppInstance->enPostMessage(&oMsg, TRUE);

      if (AIL_EN_N_NO_ERROR == enCommError)
      {
         ETG_TRACE_USR3(("fc_audiomanager_tclApp::vRxFromOtherThreads()"
             " - successfully streamed %u bytes in Loopback message"
             , size));

         ETG_TRACE_USR4(("Streamed: %02x", ETG_LIST_LEN(size), ETG_LIST_PTR_T8(pcu8Data)));

         return;   // function completed successfully
      }
      else
      {
         ETG_TRACE_ERR(("fc_audiomanager_tclApp::vRxFromOtherThreads()"
            " - Streaming %u bytes in Loopback message returned  E R R O R  %u"
            , size, ETG_ENUM(AIL_ERROR, enCommError)));
      }
   }
   else
   {
      ETG_TRACE_ERR(("fc_audiomanager_tclApp::vRxFromOtherThreads()"
         " - Streaming Loopback message  F A I L E D  delivering %u bytes"
         " - Message invalid", size));
   }
#else
   //Create a loopback message
   aud_lpmsg_ttfis_data_stream* msg = new aud_lpmsg_ttfis_data_stream(size,pcu8Data,_poTrace);
   NORMAL_M_ASSERT(m_poMainAppInstance->m_ploopback->bSendDataforLoopBack(msg));//Send message for loopback
#endif
}

// -----------------------------------------------------------------------------

tVoid fc_audiomanager_tclApp::vEventFromOtherThreads(tU16 uEvent)
{
  ETG_TRACE_USR4(("vEventFromOtherThreads: %u",uEvent));

  switch (uEvent)
  {
  case FC_AUDIOMANAGER_EVENT_ID_PING:
    (void)m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_PING, FC_AUDIOMANAGER_TIMER_PING_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_PING_INTERVAL);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_CHECK_PWR_AMP:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_CHECK_PWR_AMP);
    //m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_CHECK_PWR_AMP, FC_AUDIOMANAGER_TIMER_CHECK_PWR_AMP_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_CHECK_PWR_AMP_INTERVAL);
    break;
  /*case FC_AUDIOMANAGER_EVENT_ID_SINK_DEMUTE_NO_EXT_BOOSTER:
    m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_SINK_DEMUTE, FC_AUDIOMANAGER_TIMER_SINK_DEMUTE_NO_EXT_BOOSTER_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_SINK_DEMUTE_INTERVAL);
    break;*/
  case FC_AUDIOMANAGER_EVENT_ID_SINK_DEMUTE:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_SINK_DEMUTE);
    //m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_SINK_DEMUTE, FC_AUDIOMANAGER_TIMER_SINK_DEMUTE_WITH_EXT_BOOSTER_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_SINK_DEMUTE_INTERVAL);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_SINK_BOOSTER_OFF:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_SINK_BOOSTER_OFF);
    //m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_SINK_BOOSTER_OFF, FC_AUDIOMANAGER_TIMER_SINK_BOOSTER_OFF_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_SINK_BOOSTER_OFF_INTERVAL);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_SINK_ADR3_STANDBY:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_SINK_ADR3_STANDBY);
    //m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_SINK_ADR3_STANDBY, FC_AUDIOMANAGER_TIMER_SINK_ADR3_STANDBY_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_SINK_ADR3_STANDBY_INTERVAL);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_SPECIAL_MUTE:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_SPECIAL_MUTE);
    //m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_SPECIAL_MUTE, FC_AUDIOMANAGER_TIMER_SPECIAL_MUTE_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_SPECIAL_MUTE_INTERVAL);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_CHECK_ACC:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_CHECK_ACC);
    //m_poMainAppInstance->bStartTimer(FC_AUDIOMANAGER_TIMER_ID_CHECK_ACC, FC_AUDIOMANAGER_TIMER_CHECK_ACC_FIRST_INTERVAL, FC_AUDIOMANAGER_TIMER_CHECK_ACC_INTERVAL);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_SINK_BOOSTER_ON:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_BOOSTER_ON);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_MUTE_RESPONSE_TIMEOUT:
    m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_MUTE_TIMEOUT);
    break;
  case FC_AUDIOMANAGER_EVENT_ID_ARKAMYS:
      m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_ARKAMYS);
     break;
   case FC_AUDIOMANAGER_EVENT_ID_VEHICLEDOMAIN_CHECK_ALIVE:
      m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_VEHICLEDOMAIN_CHECK_ALIVE);
      break;
   case FC_AUDIOMANAGER_EVENT_ID_EXTAMPLIFIER_CONNECTION:
     m_poMainAppInstance->bPostEvent((tU32)FC_AUDIOMANAGER_AHL_EVENT_EXTAMPLIFIER_CONNECTION);
     break;
  default:
    break;

  }
}


/**
* Worker thread of Audio Manager.
* This thread is created to read the diagnosis values, as sometimes during error conditions, inc read is taking a lot of time.
* All regular reading of microphone current values will be done using this thread.
*/
tBool fc_audiomanager_tclApp::bThreadFunction(OSAL_tEventMask u32EventMask)
{
  ETG_TRACE_USR4(("fc_audiomanager_tclApp::bThreadFunction, Worker Thread Event Received: %u",u32EventMask));
  if(u32EventMask & FC_AUDIOMANAGER_WORKER_THREAD_EV_READ_MIC_DIAG)
  {
    if(m_poAudio_Function)
    {
      fc_audiomanager_tclMicrophone_Diagnosis * poMicrophoneDiagnosis = m_poAudio_Function->poGetMicrophoneDiagnosis();
      if(poMicrophoneDiagnosis)
      {
        poMicrophoneDiagnosis->vProcessTimer();
      }
    }
  }
  return true;
}
