/*
 * fc_audiomanager_clienthandler_sensor_pv_fi.cpp
 *
 * This client handler registers to the sensor_pv_fi ,to the property Velocity : Fkt ID: 0x02
 * to get the speed information

 *  Created on: Jul 29, 2015
 *      Author: sea6kor
 */

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

#include "fc_audiomanager_componentfactory_if.h"
#include "fc_audiomanager_clienthandler_sensor_pv_fi.h"

#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"
#include "InternalComponentCommunication/Messages/CarSetting/IDCarSetting.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "fc_audiomanager_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SDVC
#include "trcGenProj/Header/fc_audiomanager_clienthandler_sensor_pv_fi.cpp.trc.h"
#endif

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_PVFI_SERVICEINFO
#include "sensor_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#include <midw_fi_if.h>


// -----------------------------------------------------------------------------

/* constructor */ fc_audiomanager_tclClientHandler_sensor_pv_fi::
  fc_audiomanager_tclClientHandler_sensor_pv_fi(ahl_tclBaseOneThreadApp* poMainAppl)
    : fc_audiomanager_IClientHandler_Vehicle(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_PV,
      /* MajorVersion of used Service */ SENSOR_PVFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */ SENSOR_PVFI_C_U16_SERVICE_MINORVERSION   )
{

  vAddAutoRegisterForProperty(SENSOR_PVFI_C_U16_VELOCITY);

  ETG_TRACE_USR1(("ClientHandler sensor_pv_fi created"));
}


// -----------------------------------------------------------------------------

/* virtual destructor */ fc_audiomanager_tclClientHandler_sensor_pv_fi::
  ~fc_audiomanager_tclClientHandler_sensor_pv_fi (tVoid)
{
  ETG_TRACE_USR1(("ClientHandler sensor_pv_fi terminated."))
}

// -----------------------------------------------------------------------------
//
// override  ahl_tclBaseOneThreadClientHandler :: vOnStatus
//

/* virtual */ tVoid fc_audiomanager_tclClientHandler_sensor_pv_fi :: vOnStatus (tU16 u16FID, amt_tclServiceData* poMessage)
{
   if (OSAL_NULL == poMessage)
   {
      ETG_TRACE_FATAL(("vHandleGalaSpeed_Status() - invalid pointer"))
      return;
   }
   else if (SENSOR_PVFI_C_U16_VELOCITY != u16FID)
   {
      ETG_TRACE_COMP(("vHandleGalaSpeed_Status() - unhandled functionID %u", u16FID))
      return;
   }

   sensor_pvfi_tclMsgvelocityStatus oStatus;
   (void)fi_tclVisitorMessage(poMessage).s32GetData(oStatus);

   tU16 SettingValue = 0; //Speed is a unsigned value.
   tU8 VelSource = 0;
   tenCarSettingType enSettingType =  EN_AUDIO_CAR_SPEED_ID; //Car Setting Type hard coded to Speed

   VelSource = (tU8)oStatus.velocitiySource.enType;
   if(VelSource != sensor_fi_tcl_e8_velocity_source::FI_EN_SRC_V_INVALID)
   {
  SettingValue = oStatus.velocityValue;
  ETG_TRACE_USR4(("Speed = %d",SettingValue));
  ETG_TRACE_USR4(("VelSource = %d",VelSource));
   }

   oStatus.vDestroy();

   ETG_TRACE_USR4(("Delivering PO Message for GalaSpeed, Type = %d, Speed = %d"
     , enSettingType, SettingValue));

   ID_CarSetting oCarSetting(enSettingType, SettingValue);
   InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCarSetting);

}





