/*******************************************************************************
*
* FILE:          fc_audiomanager_tclClientHandler_cmbsensor.cpp
*
* SW-COMPONENT:  fc_audiomanger
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the cmb Sensor FI.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "fc_audiomanager_main.h"
#include "fc_audiomanager_clienthandler_cmbsensor.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE   // import fi_tclVisitorMessage
#include <midw_fi_if.h>

#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SDVC
#include "trcGenProj/Header/fc_audiomanager_clienthandler_cmbsensor.cpp.trc.h"
#endif

#include "fc_audiomanager_trace.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

                                             // Version defines for used service
//#define CMB_SENSORFI_C_U16_SERVICE_MAJORVERSION  0x04
//#define CMB_SENSORFI_C_U16_SERVICE_MINORVERSION  0x0e

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audiomanager_tclClientHandler_cmbsensor, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
ON_MESSAGE_SVCDATA(CMB_SENSORFI_C_U16_GALASPEED, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleGalaSpeed_Status)

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audiomanager_tclClientHandler_cmbsensor::
*             fc_audiomanager_tclClientHandler_cmbsensor(fc_audioroutemgr_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audiomanager_tclClientHandler_cmbsensor::
  fc_audiomanager_tclClientHandler_cmbsensor(fc_audiomanager_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_SENSORS,
      /* MajorVersion of used Service */ CMB_SENSORFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */ CMB_SENSORFI_C_U16_SERVICE_MINORVERSION,
                                         CCA_C_U16_APP_SENSOR)
{
  this->poCcaMainApp = poMainAppl;

  ETG_TRACE_USR4(("fc_audiomanager_tclClientHandler_cmbsensor() entered."));
}

/*******************************************************************************
*
* FUNCTION: fc_audiomanager_tclClientHandler_cmbsensor::
*             ~fc_audiomanager_tclClientHandler_cmbsensor(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audiomanager_tclClientHandler_cmbsensor::
  ~fc_audiomanager_tclClientHandler_cmbsensor(tVoid)
{
  poCcaMainApp = NULL;
 ETG_TRACE_USR4(("~fc_audiomanager_tclClientHandler_cmbsensor() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_cmbsensor::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_cmbsensor::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
                  u16GetServerAppID()));
  vAddAutoRegisterForProperty(CMB_SENSORFI_C_U16_GALASPEED);
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_cmbsensor::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_cmbsensor::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                  u16GetServerAppID()));

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_cmbsensor::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_cmbsensor::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

  if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }
}



/*******************************************************************************
*
* FUNCTION:    fc_audiomanager_tclClientHandler_cmbsensor::
*                          vHandleGalaSpeed_Status(amt_tclServiceData* poMessage)
*
*
* DESCRIPTION: Handles Gala Speed Status.
*
* PARAMETER:   Pointer- poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_cmbsensor::vHandleGalaSpeed_Status(amt_tclServiceData* poMessage) const
{
  tS16 SettingValue;
  tU8 SettingType;

  ETG_TRACE_USR4(("Entered vHandleGalaSpeed_Status()"));

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(poMessage);

  cmb_sensorfi_tclMsgGalaSpeedStatus oStatus;
  (void)fi_tclVisitorMessage(poMessage).s32GetData(oStatus);

  SettingValue = (tS16)oStatus.Speed;
  SettingType =  EN_AUDIO_CAR_SPEED_ID;//Car Setting Type hard coded to Speed

  oStatus.vDestroy();

  ETG_TRACE_USR4(("Delivering PO Message for GalaSpeed"));

  ID_CarSetting oCarSetting((tenCarSettingType)SettingType,SettingValue);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCarSetting);

}
