/*
 * fc_audiomanager_clienthandler_AudioManagerspm.cpp
 *
 *  Created on: Jan 2, 2013
 *      Author: sss4kor
 */

/*******************************************************************************
*
* FILE:          FC_Audiomanager_clienthandler_AudioManagerspm.cpp
*
* SW-COMPONENT:  FC_Audiomanager application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service AudioManagerspm.
*
* AUTHOR:
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "fc_audiomanager_main.h"
#include "fc_audiomanager_service_Audio_Function.h"
#include "fc_audiomanager_clienthandler_AudioManagerspm.h"

                             // Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of used service
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_ERRORCODES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#include "spm_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_audiomanager_trace.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/VoltageState.h"
#include "../PostOffice/PostOffice.hpp"
#include "../PostOffice/BaseMessage.h"
#include "util/Macro.h"
#include "../InternalComponentCommunication/Messages/power/ID_AudioState.h"
#include "../InternalComponentCommunication/Messages/power/ID_ResetRequest.h"
#include "../InternalComponentCommunication/Messages/power/ID_SystemState.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/fc_audiomanager_clienthandler_AudioManagerspm.cpp.trc.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"



/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

                                             // Version defines for used service
//#define CFC_SPMFI_C_U16_SERVICE_MAJORVERSION   1
//#define CFC_SPMFI_C_U16_SERVICE_MINORVERSION   0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audiomanager_tclClientHandler_AudioManagerspm, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_CVMEVENT,AMT_C_U8_CCAMSG_OPCODE_STATUS, vOnMsMuteState_HandleVoltage)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSPWRMODE,AMT_C_U8_CCAMSG_OPCODE_STATUS, vOnMsPowerState)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSTEMSTATE,AMT_C_U8_CCAMSG_OPCODE_STATUS, vOnStatusSystemState)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_AUDIOSTATE,AMT_C_U8_CCAMSG_OPCODE_STATUS, vAudioStateStatus)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleACCStatus)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audiomanager_tclClientHandler_AudioManagerspm::
*             fc_audiomanager_tclClientHandler_AudioManagerspm(fc_audiomanager_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audiomanager_tclClientHandler_AudioManagerspm::
  fc_audiomanager_tclClientHandler_AudioManagerspm(fc_audiomanager_tclApp* poMainAppl)
    : ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */ poMainAppl,
      /* ID of used Service           */ CCA_C_U16_SRV_SPM,
      /* MajorVersion of used Service */ SPM_COREFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */ SPM_COREFI_C_U16_SERVICE_MINORVERSION,CCA_C_U16_APP_SPM  ),
      IF_MessageObserver<PO_MessageConfig::enID>("Clienthandler SPM Observer")
{
  ETG_TRACE_USR4(("fc_audiomanager_tclClientHandler_AudioManagerspm() entered."));
  m_poMainAppl = poMainAppl;
  m_bACCState = false;
  InternalCommunicationAdapter::getInstance()->POMessages->AddObserver(this, PO_MessageConfig::ID_ResetRequest);
}

/*******************************************************************************
*
* FUNCTION: fc_audiomanager_tclClientHandler_AudioManagerspm::
*             ~fc_audiomanager_tclClientHandler_AudioManagerspm(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audiomanager_tclClientHandler_AudioManagerspm::
  ~fc_audiomanager_tclClientHandler_AudioManagerspm(tVoid)
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  ETG_TRACE_USR4(("~fc_audiomanager_tclClientHandler_AudioManagerspm() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
                  u16GetServerAppID()));

 vAddAutoRegisterForProperty(SPM_COREFI_C_U16_CVMEVENT);
 vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSPWRMODE);
 vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSTEMSTATE);
 vAddAutoRegisterForProperty(SPM_COREFI_C_U16_AUDIOSTATE);
 vAddAutoRegisterForProperty(SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER);
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
                  u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));
  (tVoid)u16TimerId;
 /* if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }*/
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::
*             vOnMsMuteState_HandleVoltage(amt_tclServiceData* poMessage) const
*
* DESCRIPTION: This function is called when CVM Event status is received from SPM.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnMsMuteState_HandleVoltage(amt_tclServiceData* poMessage) const
{
  ETG_TRACE_USR4(("Entered vOnMsMuteState_HandleVoltage()"));
   /* check the parameter for not NULL and then for validity of a messsage */
   if ( (poMessage != NULL) && (poMessage->bIsValid()) )
     {
        switch (poMessage->u8GetOpCode())  // get the opcode from the message
        {
        case AMT_C_U8_CCAMSG_OPCODE_STATUS:

           {
             // create an object of the class
             spm_corefi_tclMsgCvmEventStatus oStatus;
             // extract the Information
             tU32 u32CVMStatus=0;
             fi_tclVisitorMessage oVisitorMsg( poMessage );
             (void)oVisitorMsg.s32GetData(oStatus);
             u32CVMStatus=oStatus.CvmEvent.enType;
             // gm_tclU32Message oCVMStateMessage(poMessage);
             //tU32 u32CVMStatus=0;
             //tU32 u32CVMStatus = oCVMStateMessage.u32GetDWord();

             //ETG_TRACE_USR4(("Received CVM state %d ", u32CVMStatus));

             switch(u32CVMStatus)
             {
             case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
                 { ETG_TRACE_USR4(("Posting mute msg"));
                 ID_MuteState_HandleVoltage oMuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_START);
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMuteState_HandleVoltage);
                 //InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_MuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_START));
                 break;
                 }
             case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START:
             {  ETG_TRACE_USR4(("Posting mute msg"));
                 ID_MuteState_HandleVoltage oMuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_HIGH_VOLTAGE_START);
                InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMuteState_HandleVoltage);
               //InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_MuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_HIGH_VOLTAGE_START));
               break;
             }
             case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
                 { ETG_TRACE_USR4(("Posting mute msg"));
                 ID_MuteState_HandleVoltage oMuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_HIGH_VOLTAGE_START);
                 InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMuteState_HandleVoltage);
                 //InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_MuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_START));
                 break;
                 }
             case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
             { ETG_TRACE_USR4(("Posting demute msg"));
                ID_MuteState_HandleVoltage oMuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_END);
               InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMuteState_HandleVoltage);
              // InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_MuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_END));
               break;
             }
             case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END:
             { ETG_TRACE_USR4(("Posting demute msg"));
             ID_MuteState_HandleVoltage oMuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_HIGH_VOLTAGE_END);
               InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMuteState_HandleVoltage);
               //InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_MuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_HIGH_VOLTAGE_END));
               break;
             }
       case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
             { ETG_TRACE_USR4(("Posting demute msg"));
                ID_MuteState_HandleVoltage oMuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_HIGH_VOLTAGE_END);
               InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oMuteState_HandleVoltage);
              // InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&ID_MuteState_HandleVoltage(EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_END));
               break;
             }
             default :
                ETG_TRACE_USR4(("Not Handled"));
             }
             break;
           }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:

           ETG_TRACE_USR4(("Opcode Error"));
           break;
         default :
           ETG_TRACE_USR4(("Default case"));
           }
     }
        else
          ETG_TRACE_USR4(("Opcode Not Handled"));

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::
*                                  vOnMsPowerState(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called when PowerMode status is received from SPM.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnMsPowerState(amt_tclServiceData* poMessage)
{
     ETG_TRACE_USR4(("Entered vOnMsPowerState()"));
   /* check the parameter for not NULL and then for validity of a messsage */
   if ( (poMessage != NULL) && (poMessage->bIsValid()) )
     {
        switch (poMessage->u8GetOpCode())  // get the opcode from the message
        {
        case AMT_C_U8_CCAMSG_OPCODE_STATUS:
           {
           // create an object of the class
             spm_corefi_tclMsgSysPwrModeStatus oStatus;
             // extract the Information
             tU32 u32PowerModeMessage=0;
             fi_tclVisitorMessage oVisitorMsg( poMessage );
             (void)oVisitorMsg.s32GetData(oStatus);
             u32PowerModeMessage=oStatus.SysPwrMode.enType;
             //gm_tclU32Message oSysPowerModeMessage(poMessage);
             //tU32 u32PowerModeMessage = oSysPowerModeMessage.u32GetDWord();

             ETG_TRACE_USR4(("Received PowerMode %d ", u32PowerModeMessage));

             ID_SysPowerMode oSysPowerMode(u32PowerModeMessage);
             InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSysPowerMode);
         break;
       }
        case AMT_C_U8_CCAMSG_OPCODE_ERROR:
          {
         ETG_TRACE_USR4(("Opcode Error"));
           break;
         }
         default :
          {
         ETG_TRACE_USR4(("Default case"));
         break;
        }
           }
     }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::
*                               MessageNotification(PO_MessageConfig::enID MsgId)
*
* DESCRIPTION: This function is called when ResetRequest PO message is received.
*
* PARAMETER: PO_MessageConfig::enID MsgId
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::MessageNotification(PO_MessageConfig::enID MsgId)
{
   const ID_ResetRequest* pMsg = InternalCommunicationAdapter::getInstance()->POMessages->QueryMessage<ID_ResetRequest>(MsgId);

   if((NULL != pMsg) && (NULL != _poMainAppl))
   {
      spm_corefi_tclMsgRestartSystemMethodStart oFiData; //Create the (message related) FI data object

      ETG_TRACE_ERR(("FC_AudioManager request SPM to RESTARTSYSTEM , Restart Type : %d",pMsg->m_u8ResetType));

      oFiData.eRestartType.enType = (spm_fi_tcl_SPM_e32_RESTART_TYPE::tenType)(pMsg->m_u8ResetType);

      fi_tclVisitorMessage oCCAMsg(oFiData);  // The FI data object will be streamed to shared memory

      // Here the message related header information is added and by this the creation of the message is completed.
      vInitServiceData(oCCAMsg, 0, SPM_COREFI_C_U16_RESTARTSYSTEM, AMT_C_U8_CCAMSG_OPCODE_METHODSTART);

      if (_poMainAppl->enPostMessage(&oCCAMsg, TRUE) != AIL_EN_N_NO_ERROR)
      {
         ETG_TRACE_ERR(("Failed to post spm_corefi_tclMsgRestartSystemMethodStart"));
      }

      oFiData.vDestroy();
   }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::
*                             vOnStatusSystemState(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called when SystemState status is received from SPM.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vOnStatusSystemState(amt_tclServiceData* poMessage)
{
     ETG_TRACE_USR4(("Entered vOnStatusSystemState()"));
   if ( (poMessage != NULL) && (poMessage->bIsValid()) )
     {
         // create an object of the class
     spm_corefi_tclMsgSystemStateStatus inSystemStateStatus;
         // extract the Information
        fi_tclVisitorMessage oVisitorMsg( poMessage );
        oVisitorMsg.s32GetData(inSystemStateStatus);

        ETG_TRACE_USR4(("Received SystemState %d ", inSystemStateStatus.SystemState.enType));

        ID_SystemState oSystemState((tenSystemState)inSystemStateStatus.SystemState.enType);
        InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSystemState);
     }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::
*                             vAudioStateStatus(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called when AudioState MethodStart is received from SPM.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vAudioStateStatus(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Entered vAudioStateStatus()"));

   if ( (poMessage != NULL) && (poMessage->bIsValid()) )
   {
        // create an object of the class
         spm_corefi_tclMsgAudioStateStatus inAudioStateStatus;
        // extract the Information
         fi_tclVisitorMessage oVisitorMsg( poMessage );
         oVisitorMsg.s32GetData(inAudioStateStatus);

         ETG_TRACE_USR4(("Received AudioState %d ", inAudioStateStatus.AudioState.enType));

         ID_AudioState oAudioState((tenAudioState)inAudioStateStatus.AudioState.enType);
         InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAudioState);

   }

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::
*                             vHandleACCStatus(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called when ACC state is received from SPM.
*
* PARAMETER: amt_tclServiceData* poMessage.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::vHandleACCStatus(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR1(("fc_audiomanager_tclClientHandler_AudioManagerspm::vHandleACCStatus(): Entered"));
  if ( (poMessage != NULL) && (poMessage->bIsValid()) )
   {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
      {
         fi_tclVisitorMessage oVisitorMsg( poMessage );
         spm_corefi_tclMsgActiveOnOffTriggerStatus oACCStatus;

         if (oVisitorMsg.s32GetData(oACCStatus) != OSAL_ERROR)
         {
            ETG_TRACE_USR1(("fc_audiomanager_tclClientHandler_AudioManagerspm::vHandleACCStatus(): Status update message received for 'SPM_COREFI_C_U16_ACTIVEONOFFTRIGGER' (FID: 0x110f)!"));
            onActiveOnOffTriggerStatus(oACCStatus.tOnOffTriggerList);
         }
         else
         {
            ETG_TRACE_ERR(("fc_audiomanager_tclClientHandler_AudioManagerspm::vHandleACCStatus: Received message is invalid!"));
         }

         oACCStatus.vDestroy();
      }
   }
}

/*************************************************************************
 *
 * FUNCTION:    fc_audiomanager_tclClientHandler_AudioManagerspm::onActiveOnOffTriggerStatus()
 *
 * DESCRIPTION: Handles the ACC State Changes
 *
 * PARAMETER:   none
 *
 * RETURNVALUE: none
 *
 *************************************************************************/

tVoid fc_audiomanager_tclClientHandler_AudioManagerspm::onActiveOnOffTriggerStatus(std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > tOnOffTriggerList)
{
   tBool bAccessory = FALSE;
//   tBool bIGN = FALSE;//enable only if IGN is required
   std::vector<spm_fi_tcl_SPM_e32_SubStateType, std::allocator<spm_fi_tcl_SPM_e32_SubStateType> > ::iterator it;
   for (it = tOnOffTriggerList.begin(); it != tOnOffTriggerList.end();it++)
   {
       if (it->enType == spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_S_CONTACT) {
           ETG_TRACE_USR1( ( "onActiveOnOffTriggerStatus::onActiveOnOffTriggerStatus(): ACC active" ) );
           bAccessory = TRUE;
       }

       if (it->enType == spm_fi_tcl_SPM_e32_SubStateType::FI_EN_SPM_U32_SUBSTATE_IGNITION) {
         ETG_TRACE_USR1( ( "onActiveOnOffTriggerStatus::onActiveOnOffTriggerStatus(): IGN active" ) );
      //   bIGN = TRUE;//enable only if IGN is required
       }

   }


   if(m_poMainAppl->pGetAudioFunctionptr())
   {
     if(m_bACCState!=bAccessory)
     {
       m_bACCState = bAccessory;
       m_poMainAppl->pGetAudioFunctionptr()->vOnNewACCState(m_bACCState);
     }

   }
}
