/*
 * fc_audiomanager_DpBinContainerElement.cpp
 *
 *  Created on: Dec 16, 2013
 *      Author: kma4hi
 */

// system headers
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

// audio persistent data pool
#define DP_S_IMPORT_INTERFACE_FI
#include <dp_audio_if.h>


#include "fc_audiomanager_DpBinContainerElement.h"


// -----------------------------------------------------------------------------

/* constructor */ fc_audiomanager_tclDpBinContainerElement :: fc_audiomanager_tclDpBinContainerElement (tU16 _u16PoolId, tU16 _u16PoolSubId, tCString pcElementName)
   : dp_tclBaseElement(pcElementName, s32CalcHashSilently(pcElementName))
   , u16AccessId(_u16PoolId)
   , u16SubId(_u16PoolSubId)
   , u32FullPoolId((_u16PoolId << 16) + _u16PoolSubId)
   , s32Status(DP_s32GetElement(u32FullPoolId, this, u16AccessId))
{
}

// -----------------------------------------------------------------------------

tS32 fc_audiomanager_tclDpBinContainerElement :: s32GetData (tU8* pau8Destination, tU32 u32BufSize, tU32 u32DpStartOffset)
{
   // Copy data from datapool element into given destination array.
   //
   // Can copy only part of data in pool: if optional 3rd parameter is given and non-zero,
   // copy starts at u32DpStartOffset and comprises u32BufSize bytes, as long as
   // end of pool element is not exceeded.
   //
   // Returns either error code (negative) or number of bytes copied

   tS32 s32RetVal = u32BufSize;
   tS32 s32DataLength = (tS32)u32GetDataLength();
   if ((NULL == pau8Destination) || (0u == u32BufSize))
      return DP_S32_ERR_WR_BUF_LEN;
   else if (NULL == pvGetData())
      return DP_S32_ERR_WR_BUF_LEN;
   else if (DP_S32_NO_ERR != s32Status)
      return s32Status;
   else if ((tS32)u32DpStartOffset >= s32DataLength)
      return 0;

   if (s32DataLength < (tS32)(u32DpStartOffset + u32BufSize))
       s32RetVal = s32DataLength - (tS32)u32DpStartOffset;

   (tVoid)memcpy(pau8Destination, (tU8*)pvGetData() + u32DpStartOffset, (tU32)s32RetVal);
   return s32RetVal;
}

// -----------------------------------------------------------------------------

tS32 fc_audiomanager_tclDpBinContainerElement :: s32SetData (tU8* pau8Buffer, tU32 u32BufSize)
{
   (tVoid)bFillData((tVoid*)pau8Buffer, u32BufSize);
   tS32 s32RetVal = DP_s32SetElement(u32FullPoolId, this, u16AccessId);

   return s32RetVal;
}

// -----------------------------------------------------------------------------

/* static */ tS32 fc_audiomanager_tclDpBinContainerElement :: s32CalcHashSilently(tCString sDpElementName)
{
   // redo the calculation of private dp_tclBaseElement::s32CalcHash function,
   // which complains with a fatal trace if directly used

   tS32 hash = 0;
   for (unsigned int i=0; i < strlen(sDpElementName); i++)
      hash = 5*hash + sDpElementName[i];

   return hash;
}

// -----------------------------------------------------------------------------

