/*
 * AudioUserDpBase.h
 *
 * Base implementation of AudioUserDpIf interface
 * Can be directly used by G3G, Suzuki etc. (where there is no "multi" user storage is needed)
 *
 * Author : prm4kor
 */
#ifndef AUDIOUSERDPBASE_H_
#define AUDIOUSERDPBASE_H_

#include "AudioUserDpIf.h"

class AudioUserDpBase : public AudioUserDpIf
{
public:
   virtual ~AudioUserDpBase() {}

   virtual tS32 s32GetTreble(tS8& s8Value);
   virtual tS32 s32GetBass(tS8& s8Value);
   virtual tS32 s32GetMidRange(tS8& s8Value);
   virtual tS32 s32GetBalance(tS8& s8Value);
   virtual tS32 s32GetFader(tS8& s8Value);
   virtual tS32 s32GetBeepLevel(tU8& u8Value);
   virtual tS32 s32GetEquPreset(tU8& u8Value);
   virtual tS32 s32GetOptimization(tU8& u8Value);
   virtual tS32 s32GetGala(tU8& u8Value);
   virtual tS32 s32GetLoudness(tU8& u8Value);
   virtual tS32 s32GetSurroundLevel(tU8& u8Value);
   virtual tS32 s32GetCenterGain(tS16& s16Value);
   virtual tS32 s32GetSubwoofer(tS16& s16Value);
   virtual tS32 s32GetAutomaticGainControl(tBool& bValue);
   virtual tS32 s32GetRoomEffect(tU8& u8Value);
   virtual tS32 s32GetSoundStaging(tU8& u8Value);
   virtual tS32 s32GetGeometryMode(tU8& u8Value);
   virtual tS32 s32GetUPASoundtype(tU8& u8Value);
   virtual tS32 s32GetSRSoundState(tU8& u8Value);
   virtual tS32 s32GetAudioPilotMode(tBool& u8Value);
   virtual tS32 s32GetAudioPilotIntensity(tU8& u8Value);
   virtual tS32 s32GetParkAssistVolume(tU8& u8Value);

   virtual tS32 s32SetTreble(tS8 s8Value);
   virtual tS32 s32SetBass(tS8 s8Value);
   virtual tS32 s32SetMidRange(tS8 s8Value);
   virtual tS32 s32SetBalance(tS8 s8Value);
   virtual tS32 s32SetFader(tS8 s8Value);
   virtual tS32 s32SetBeepLevel(tU8 u8Value);
   virtual tS32 s32SetEquPreset(tU8 u8Value);
   virtual tS32 s32SetOptimization(tU8 u8Value);
   virtual tS32 s32SetGala(tU8 u8Value);
   virtual tS32 s32SetLoudness(tU8 u8Value);
   virtual tS32 s32SetSurroundLevel(tU8 u8Value);
   virtual tS32 s32SetCenterGain(tS16 s16Value);
   virtual tS32 s32SetSubwoofer(tS16 s16Value);
   virtual tS32 s32SetAutomaticGainControl(tBool bValue);
   virtual tS32 s32SetRoomEffect(tU8 u8Value);
   virtual tS32 s32SetSoundStaging(tU8 u8Value);
   virtual tS32 s32SetGeometryMode(tU8 u8Value);
   virtual tS32 s32SetUPASoundtype(tU8 u8Value);
   virtual tS32 s32SetSRSoundState(tU8 u8Value);
   virtual tS32 s32SetAudioPilotMode(tBool bValue);
   virtual tS32 s32SetAudioPilotIntensity(tU8 u8Value);
   virtual tS32 s32SetParkAssistVolume(tU8 u8Value);
};

#endif //AUDIOUSERDPBASE_H_
