/*
 * AudioUserDpBase.h
 *
 * Generic implementation of AudioUserDpIf interface
 * Can be used by G3G, Suzuki etc. (where there is no "multi" user storage is needed)
 *
 * Author : prm4kor
 */

#include "AudioUserDpBase.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

/*****************GET FUNCTIONS**********************/

tS32 AudioUserDpBase::s32GetTreble(tS8& s8Value)
{
   dp_tclAudioManagerDPTreble oTreble;
   return oTreble.s32GetData(s8Value);
}

tS32 AudioUserDpBase::s32GetBass(tS8& s8Value)
{
   dp_tclAudioManagerDPBass oBass;
   return oBass.s32GetData(s8Value);
}

tS32 AudioUserDpBase::s32GetMidRange(tS8& s8Value)
{
   dp_tclAudioManagerDPMidRange oMidRange;
   return oMidRange.s32GetData(s8Value);
}

tS32 AudioUserDpBase::s32GetBalance(tS8& s8Value)
{
   dp_tclAudioManagerDPBalance oBalance;
   return oBalance.s32GetData(s8Value);
}
tS32 AudioUserDpBase::s32GetFader(tS8& s8Value)
{
   dp_tclAudioManagerDPFader oFader;
   return oFader.s32GetData(s8Value);
}
tS32 AudioUserDpBase::s32GetBeepLevel(tU8& u8Value)
{
   dp_tclAudioManagerDPBeepLevel oDPBeepLevel;
   return oDPBeepLevel.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetEquPreset(tU8& u8Value)
{
   dp_tclAudioManagerDPEquPreset oEquPreset;
   return oEquPreset.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetOptimization(tU8& u8Value)
{
   dp_tclAudioManagerDPOptimization oOptimization;
   return oOptimization.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetGala(tU8& u8Value)
{
   dp_tclAudioManagerDPGala oGala;
   return oGala.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetLoudness(tU8& u8Value)
{
   dp_tclAudioManagerDPLoudness oLoudness;
   return oLoudness.s32GetData(u8Value);
}

tS32 AudioUserDpBase::s32GetSurroundLevel(tU8& u8Value)
{
   dp_tclAudioManagerDPSurroundLevel oSurroundLevel;
   return oSurroundLevel.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetCenterGain(tS16& s16Value)
{
   dp_tclAudioManagerDPCenterGain oDPCenter;
   return oDPCenter.s32GetData(s16Value);
}
tS32 AudioUserDpBase::s32GetSubwoofer(tS16& s16Value)
{
   dp_tclAudioManagerDPSubWoofer oDPSubWoof;
   return oDPSubWoof.s32GetData(s16Value);
}
tS32 AudioUserDpBase::s32GetAutomaticGainControl(tBool& bValue)
{
  dp_tclAudioManagerDPArkamys_AutomaticGainControl oDPAGC;
  return oDPAGC.s32GetData(bValue);
}
tS32 AudioUserDpBase::s32GetRoomEffect(tU8& u8Value)
{
  dp_tclAudioManagerDPRoomEffect oDPRoomEffect;
  return oDPRoomEffect.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetSoundStaging(tU8& u8Value)
{
  dp_tclAudioManagerDPSoundStaging oDPSoundStage;
  return oDPSoundStage.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetGeometryMode(tU8& u8Value)
{
  dp_tclAudioManagerDPGeometryMode oDPGeoMode;
  return oDPGeoMode.s32GetData(u8Value);
}

tS32 AudioUserDpBase::s32GetUPASoundtype(tU8& u8Value)
{
    dp_tclAudioManagerDPAdas_UPASoundtype odpAdasndtype;
    return  odpAdasndtype.s32GetData(u8Value);
}


tS32 AudioUserDpBase::s32GetSRSoundState(tU8& u8Value)
 {
    dp_tclAudioManagerDPAdas_SRSoundState odpSRSound;
    return odpSRSound.s32GetData(u8Value);

 }

 tS32 AudioUserDpBase::s32GetAudioPilotMode(tBool& bValue)
{
  dp_tclAudioManagerDPAudioPilotMode oDPAudPilotMode;
  return oDPAudPilotMode.s32GetData(bValue);
}
tS32 AudioUserDpBase::s32GetAudioPilotIntensity(tU8& u8Value)
{
  dp_tclAudioManagerDPAudioPilotIntensity oDPAudPilotIntensity;
  return oDPAudPilotIntensity.s32GetData(u8Value);
}
tS32 AudioUserDpBase::s32GetParkAssistVolume(tU8& u8Value)
{
  dp_tclAudioManagerDPAdas_ParkAssitVol odpParkAssitVol;
  return odpParkAssitVol.s32GetData(u8Value);

}


/*****************SET FUNCTIONS**********************/

tS32 AudioUserDpBase::s32SetTreble(tS8 s8Value)
{
   dp_tclAudioManagerDPTreble oTreble;
   return oTreble.s32SetData(s8Value);
}
tS32 AudioUserDpBase::s32SetBass(tS8 s8Value)
{
   dp_tclAudioManagerDPBass oBass;
   return oBass.s32SetData(s8Value);
}
tS32 AudioUserDpBase::s32SetMidRange(tS8 s8Value)
{
   dp_tclAudioManagerDPMidRange oMidRange;
   return oMidRange.s32SetData(s8Value);
}
tS32 AudioUserDpBase::s32SetBalance(tS8 s8Value)
{
   dp_tclAudioManagerDPBalance oBalance;
   return oBalance.s32SetData(s8Value);
}
tS32 AudioUserDpBase::s32SetFader(tS8 s8Value)
{
   dp_tclAudioManagerDPFader oFader;
   return oFader.s32SetData(s8Value);
}
tS32 AudioUserDpBase::s32SetBeepLevel(tU8 u8Value)
{
   dp_tclAudioManagerDPBeepLevel oDPBeepLevel;
   return oDPBeepLevel.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetEquPreset(tU8 u8Value)
{
   dp_tclAudioManagerDPEquPreset oEquPreset;
   return oEquPreset.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetOptimization(tU8 u8Value)
{
   dp_tclAudioManagerDPOptimization oOptimization;
   return oOptimization.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetGala(tU8 u8Value)
{
   dp_tclAudioManagerDPGala oGala;
   return oGala.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetLoudness(tU8 u8Value)
{
   dp_tclAudioManagerDPLoudness oLoudness;
   return oLoudness.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetSurroundLevel(tU8 u8Value)
{
   dp_tclAudioManagerDPSurroundLevel oSurroundLevel;
   return oSurroundLevel.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetCenterGain(tS16 s16Value)
{
   dp_tclAudioManagerDPCenterGain oDPCenter;
   return oDPCenter.s32SetData(s16Value);
}
tS32 AudioUserDpBase::s32SetSubwoofer(tS16 s16Value)
{
   dp_tclAudioManagerDPSubWoofer oDPSubWoof;
   return oDPSubWoof.s32SetData(s16Value);
}
tS32 AudioUserDpBase::s32SetAutomaticGainControl(tBool bValue)
{
  dp_tclAudioManagerDPArkamys_AutomaticGainControl oDPAGC;
  return oDPAGC.s32SetData(bValue);
}
tS32 AudioUserDpBase::s32SetRoomEffect(tU8 u8Value)
{
  dp_tclAudioManagerDPRoomEffect oDPRoomEffect;
  return oDPRoomEffect.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetSoundStaging(tU8 u8Value)
{
  dp_tclAudioManagerDPSoundStaging oDPSoundStage;
  return oDPSoundStage.s32SetData(u8Value);
}
tS32 AudioUserDpBase::s32SetGeometryMode(tU8 u8Value)
{
  dp_tclAudioManagerDPGeometryMode oDPGeoMode;
  return oDPGeoMode.s32SetData(u8Value);
}

tS32 AudioUserDpBase::s32SetUPASoundtype(tU8 u8Value)
{
    dp_tclAudioManagerDPAdas_UPASoundtype odpAdasndtype;
    return  odpAdasndtype.s32SetData(u8Value);
}

 tS32 AudioUserDpBase::s32SetSRSoundState(tU8 u8Value)
 {
    dp_tclAudioManagerDPAdas_SRSoundState odpSRSound;
    return odpSRSound.s32SetData(u8Value);

 }
tS32 AudioUserDpBase::s32SetAudioPilotMode(tBool bValue)
{
  dp_tclAudioManagerDPAudioPilotMode oDPAudPilotMode;
  return oDPAudPilotMode.s32SetData(bValue);
}

tS32 AudioUserDpBase::s32SetAudioPilotIntensity(tU8 u8Value)
{
  dp_tclAudioManagerDPAudioPilotIntensity oDPAudPilotIntensity;
  return oDPAudPilotIntensity.s32SetData(u8Value);
}

tS32 AudioUserDpBase::s32SetParkAssistVolume(tU8 u8Value)
{
  dp_tclAudioManagerDPAdas_ParkAssitVol odpParkAssitVol;
  return odpParkAssitVol.s32SetData(u8Value);
}
