/*
 * AudioUserDpAIVI.h
 *
 * AIVI specific implementation of AudioUserDpIf interface
 *
 * Author : prm4kor
 */

#include "AudioUserDpAIVI.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

/*****************GET FUNCTIONS**********************/

tS32 AudioUserDpAIVI::s32GetTreble(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPTreble_Multi oTreble;
   return oTreble.s32GetData(s8Value);
}

tS32 AudioUserDpAIVI::s32GetBass(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPBass_Multi oBass;
   return oBass.s32GetData(s8Value);
}

tS32 AudioUserDpAIVI::s32GetMidRange(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPMidRange_Multi oMidRange;
   return oMidRange.s32GetData(s8Value);
}

tS32 AudioUserDpAIVI::s32GetBalance(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPBalance_Multi oBalance;
   return oBalance.s32GetData(s8Value);
}
tS32 AudioUserDpAIVI::s32GetFader(tS8& s8Value)
{
   dp_tclAudioManagerUsrDPFader_Multi oFader;
   return oFader.s32GetData(s8Value);
}
tS32 AudioUserDpAIVI::s32GetGala(tU8& u8Value)
{
   dp_tclAudioManagerUsrDPGala_Multi oGala;
   return oGala.s32GetData(u8Value);
}
tS32 AudioUserDpAIVI::s32GetSubwoofer(tS16& s16Value)
{
   dp_tclAudioManagerUsrDPSubWoofer_Multi oDPSubWoof;
   return oDPSubWoof.s32GetData(s16Value);
}
tS32 AudioUserDpAIVI::s32GetAutomaticGainControl(tBool& bValue)
{
  dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi oDPAGC;
  return oDPAGC.s32GetData(bValue);
}
tS32 AudioUserDpAIVI::s32GetRoomEffect(tU8& u8Value)
{
  dp_tclAudioManagerUsrDPRoomEffect_Multi oDPRoomEffect;
  return oDPRoomEffect.s32GetData(u8Value);
}
tS32 AudioUserDpAIVI::s32GetSoundStaging(tU8& u8Value)
{
  dp_tclAudioManagerUsrDPSoundStaging_Multi oDPSoundStage;
  return oDPSoundStage.s32GetData(u8Value);
}
tS32 AudioUserDpAIVI::s32GetGeometryMode(tU8& u8Value)
{
  dp_tclAudioManagerUsrDPGeometryMode_Multi oDPGeoMode;
  return oDPGeoMode.s32GetData(u8Value);
}

tS32 AudioUserDpAIVI::s32GetUPASoundtype(tU8& u8Value)
{
     dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi odpAdasndtype;
    return  odpAdasndtype.s32GetData(u8Value);
}

tS32 AudioUserDpAIVI::s32GetSRSoundState(tU8& u8Value)
 {
    dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi odpSRSound;
    return odpSRSound.s32GetData(u8Value);

 }
tS32 AudioUserDpAIVI::s32GetAudioPilotMode(tBool& bValue)
{
  dp_tclAudioManagerUsrDPAudioPilotMode_Multi oDPAudPilotMode;
  return oDPAudPilotMode.s32GetData(bValue);
}
tS32 AudioUserDpAIVI::s32GetAudioPilotIntensity(tU8& u8Value)
{
  dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi oDPAudPilotIntensity;
  return oDPAudPilotIntensity.s32GetData(u8Value);
}

tS32 AudioUserDpAIVI::s32GetParkAssistVolume(tU8& u8Value)
{
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  return odpParkAssitVol.s32GetData(u8Value);
}

/*****************SET FUNCTIONS**********************/

tS32 AudioUserDpAIVI::s32SetTreble(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPTreble_Multi oTreble;
   return oTreble.s32SetData(s8Value);
}
tS32 AudioUserDpAIVI::s32SetBass(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPBass_Multi oBass;
   return oBass.s32SetData(s8Value);
}
tS32 AudioUserDpAIVI::s32SetMidRange(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPMidRange_Multi oMidRange;
   return oMidRange.s32SetData(s8Value);
}
tS32 AudioUserDpAIVI::s32SetBalance(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPBalance_Multi oBalance;
   return oBalance.s32SetData(s8Value);
}
tS32 AudioUserDpAIVI::s32SetFader(tS8 s8Value)
{
   dp_tclAudioManagerUsrDPFader_Multi oFader;
   return oFader.s32SetData(s8Value);
}
tS32 AudioUserDpAIVI::s32SetGala(tU8 u8Value)
{
   dp_tclAudioManagerUsrDPGala_Multi oGala;
   return oGala.s32SetData(u8Value);
}
tS32 AudioUserDpAIVI::s32SetSubwoofer(tS16 s16Value)
{
   dp_tclAudioManagerUsrDPSubWoofer_Multi oDPSubWoof;
   return oDPSubWoof.s32SetData(s16Value);
}
tS32 AudioUserDpAIVI::s32SetAutomaticGainControl(tBool bValue)
{
  dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi oDPAGC;
  return oDPAGC.s32SetData(bValue);
}
tS32 AudioUserDpAIVI::s32SetRoomEffect(tU8 u8Value)
{
  dp_tclAudioManagerUsrDPRoomEffect_Multi oDPRoomEffect;
  return oDPRoomEffect.s32SetData(u8Value);
}
tS32 AudioUserDpAIVI::s32SetSoundStaging(tU8 u8Value)
{
  dp_tclAudioManagerUsrDPSoundStaging_Multi oDPSoundStage;
  return oDPSoundStage.s32SetData(u8Value);
}
tS32 AudioUserDpAIVI::s32SetGeometryMode(tU8 u8Value)
{
  dp_tclAudioManagerUsrDPGeometryMode_Multi oDPGeoMode;
  return oDPGeoMode.s32SetData(u8Value);
}
tS32 AudioUserDpAIVI::s32SetUPASoundtype(tU8 u8Value)
{
     dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi odpAdasndtype;
    return  odpAdasndtype.s32SetData(u8Value);
}
tS32 AudioUserDpAIVI::s32SetSRSoundState(tU8 u8Value)
 {
    dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi odpSRSound;
    return odpSRSound.s32SetData(u8Value);
 }
tS32 AudioUserDpAIVI::s32SetAudioPilotMode(tBool bValue)
{
  dp_tclAudioManagerUsrDPAudioPilotMode_Multi oDPAudPilotMode;
  return oDPAudPilotMode.s32SetData(bValue);
}

tS32 AudioUserDpAIVI::s32SetAudioPilotIntensity(tU8 u8Value)
{
  dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi oDPAudPilotIntensity;
  return oDPAudPilotIntensity.s32SetData(u8Value);
}


tS32 AudioUserDpAIVI::s32SetParkAssistVolume(tU8 u8Value)
{
  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi odpParkAssitVol;
  return odpParkAssitVol.s32SetData(u8Value);
}
