/*******************************************************************************
*
* FILE:          Gen3G_fc_audiomanager_componentfactory.cpp
*
* SW-COMPONENT:  FC_AudioManager application
*
* DESCRIPTION:   project-specific component loaders
*
*******************************************************************************/


// *****************************************************************************
//
//                                INCLUDES
//

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links osal_if.h

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include <ahl_if.h>

#include "../../fc_audiomanager_componentfactory_if.h"
#include "../../fc_audiomanager_clienthandler_sensor_pv_fi.h"

#include "../../Sound/SoundToolClient.h"

// *****************************************************************************
//
//     IClientHandler_Vehicle   F a c t o r y - F u n c t i o n
//

/* static */ fc_audiomanager_IClientHandler_Vehicle*
   fc_audiomanager_IClientHandler_Vehicle :: poGetInstance (ahl_tclBaseOneThreadApp*  poMainApp)
{

   return new fc_audiomanager_tclClientHandler_sensor_pv_fi (poMainApp);
}

fc_audiomanager_IClientHandler_Soundtool* fc_audiomanager_IClientHandler_Soundtool::poInstance =NULL;
fc_audiomanager_IClientHandler_Soundtool* fc_audiomanager_IClientHandler_Soundtool::poGetInstance(fc_audiomanager_tclApp*  poMainApp, fc_audiomanager_tclService_Audio_Function* poService)
{
  if(poInstance==NULL)
  {
    poInstance = new SoundToolClient(poMainApp, poService);
  }
  return poInstance;
}
fc_audiomanager_IClientHandler_Soundtool::~fc_audiomanager_IClientHandler_Soundtool()
{
  poInstance=NULL;
}
// -----------------------------------------------------------------------------
//
//    add other project-specific loaders ...
//
