/*
 * plugin-receiver.cpp
 *
 *  Created on: Jan 20, 2014
 *      Author: rjk2kor
 */

#include "vd_amp_plugin_loader.h"
#include "vd_amp_plugin_tx_rx.h"
#include "../vd_adr3/vd_adr3_main.h"
#include "../aud_sinkmgr_main.h"
#include "../aud_sinkmgr_pwramp.h"
//#include "vdamp-plugin-send.h"
//#include <iostream>
#include "../../InternalComponentCommunication/Messages/SoundConfig/IDSetSoundSystemConfig.h"
#include "../vd_amp_Msg/vd_amp_msg_mute.h"
#include "../vd_amp_Msg/vd_amp_msg_Beep.h"
#include "../vd_amp_Msg/vd_amp_msg_BeepParam.h"
#include "../vd_amp_Msg/vd_amp_msg_CarSettings.h"
#include "../vd_amp_Msg/vd_amp_msg_GraphFilter.h"
#include "../vd_amp_Msg/vd_amp_msg_InputVolumeOffset.h"
#include "../vd_amp_Msg/vd_amp_msg_ParamFilter.h"
#include "../vd_amp_Msg/vd_amp_msg_powerstate.h"
#include "../vd_amp_Msg/vd_amp_msg_Settings.h"
#include "../vd_amp_Msg/vd_amp_msg_source.h"
#include "../vd_amp_Msg/vd_amp_msg_surround.h"
#include "../vd_amp_Msg/vd_amp_msg_volume.h"
#include "../vd_amp_Msg/vd_amp_msg_VolumeOffset.h"
#include "../vd_adr3/vd_adr3Msg_volume.h"
#include "../vd_adr3/vd_adr3_Config_Types.h"
#include "../vd_adr3/vd_adr3_Config.h"
#include "../vd_adr3/vd_adr3Msg_If.h"
#include "../vd_amp_Msg/vd_amp_msg_PDC_VolumeOffset.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_plugin_tx_rx.cpp.trc.h"
#endif

//using namespace std;
using namespace std;

/********************************************************************************
 * Constructor
 *******************************************************************************/

vd_amp_if_tx_rx::vd_amp_if_tx_rx(plugin_loader* x, vd_adr3_main* povdadr3main)
:m_ptrloader(x),
 m_ptrvdadr3main(povdadr3main),
 m_active_plugin(0xFFFF)
{
  m_po_vd_ampmsg_mute= NULL;
  m_po_vd_ampmsg_power= NULL;
  m_po_vd_ampmsg_settings= NULL;
  m_po_vd_ampmsg_graphfilter= NULL;
  m_po_vd_ampmsg_beep= NULL;
  m_po_vd_ampmsg_beepparam= NULL;
  m_po_vd_ampmsg_carsettings= NULL;
  m_po_vd_ampmsg_inputvoloffset= NULL;
  m_po_vd_ampmsg_source= NULL;
  m_po_vd_ampmsg_surround= NULL;
  m_po_vd_ampmsg_volume= NULL;
  m_po_vd_ampmsg_volumeoffset= NULL;
  m_po_vd_ampmsg_paramfilter= NULL;
  m_po_ampmsg_PDCVolumeOffset = NULL;
   Stream = EN_AUDIO_SOURCE_STREAM_DEFAULT;
   VolStep = 0;
   VoldB = 0;
   RampLin = 0;
   RampdB = 0;
  Obj_VolumeData.m_enStream = (tenStream)0;
  Obj_VolumeData.m_VolStep = 0;
  Obj_VolumeData.m_VoldB = 0;
  Obj_VolumeData.m_RampLin = 0;
  Obj_VolumeData.m_VoldB = 0;
    m_extAmpconnected = true; // setting as true and changing to false when plugin is not compatible
}

/********************************************************************************
 * Destructor
 *******************************************************************************/
vd_amp_if_tx_rx::~vd_amp_if_tx_rx()
{
  delete m_po_vd_ampmsg_mute;
  delete m_po_vd_ampmsg_power;
  delete m_po_vd_ampmsg_settings;
  delete m_po_vd_ampmsg_graphfilter;
  delete m_po_vd_ampmsg_beep;
  delete m_po_vd_ampmsg_beepparam;
  delete m_po_vd_ampmsg_carsettings;
  delete m_po_vd_ampmsg_inputvoloffset;
  delete m_po_vd_ampmsg_source;
  delete m_po_vd_ampmsg_surround;
  delete m_po_vd_ampmsg_volume;
  delete m_po_vd_ampmsg_volumeoffset;
  delete m_po_vd_ampmsg_paramfilter;
  delete m_po_ampmsg_PDCVolumeOffset;
  m_ptrloader = NULL;
  m_ptrvdadr3main = NULL;
}

/**********************************************************************************************
 * Pluginconnect: Will be called from the plugin and notifies if the plugin is compatible or not
 **********************************************************************************************/

void vd_amp_if_tx_rx::vPluginConnect(vdamp_pluginID_t  pluginID, bool bCompatible)
{

  ETG_TRACE_USR4(("vd_amp_if_tx_rx::vPluginConnect entered for pluginID %4x  ",pluginID));
  if(m_ptrloader == NULL)
    return;

  //Check if active plugin exists
  if(m_active_plugin != 0xFFFF)
  {
    vdamp_plugin_sender* target = m_ptrloader->poGetPluginSender(m_active_plugin);
    if(target == NULL)
    {
      m_active_plugin = 0xFFFF;
    }
    else
    {
      ETG_TRACE_USR4(("vd_amp_if_tx_rx::vPluginConnect connection already exists for plugin %4x",m_active_plugin));
      return;
    }
  }

  vdamp_plugin_sender* target = m_ptrloader->poGetPluginSender(pluginID);
  if(target == NULL)
    return;

  if(!bCompatible)
  {
      vChangeConfig(EXTAMP_DISCONNECTED);
    m_extAmpconnected = false; // setting the external amplifier connection as false
    ETG_TRACE_USR4((" bCompatible returned FALSE,Returning.... "));
    return;
  }
  else if(m_active_plugin == 0xFFFF)//Only set as active plugin when there is no other
  {
    m_active_plugin = pluginID;
  }

  vSenderFunctionInit(target);
  vChangeConfig(EXTAMP_CONNECTED);
}


/********************************************************************************
 * The indication messages from the plugin for all the functionalities
 *******************************************************************************/
void vd_amp_if_tx_rx::vAmp_IndPowerState(vdamp_pluginID_t  PluginID, amp_tenPowerStatus Status, amp_tenPowerState State)
{
  if(m_po_vd_ampmsg_power!=NULL)
   {
  m_po_vd_ampmsg_power->vd_Amp_Msg_IndPower(PluginID,Status,State);
   }
}

void vd_amp_if_tx_rx::vAmp_ErrPowerState(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)
{

  if(m_po_vd_ampmsg_power!=NULL)
  {
    m_po_vd_ampmsg_power->vd_Amp_Msg_ErrPower(PluginID,ErrorCode);
  }
}

void vd_amp_if_tx_rx::vAmp_IndSource(vdamp_pluginID_t  pluginID, amp_tenStream enStream,amp_tenSource enSource)
{
   if(m_po_vd_ampmsg_source!=NULL)
   {
     m_po_vd_ampmsg_source->vd_Amp_Msg_IndSource(pluginID,enStream,enSource);
   }
}

void  vd_amp_if_tx_rx::vAmp_IndSource_UnMapped(vdamp_pluginID_t  pluginID, amp_tenStream enStream,amp_tenSource_unmapped enSource)
{
   if(m_po_vd_ampmsg_source!=NULL)
   {
     m_po_vd_ampmsg_source->vd_Amp_Msg_IndSource_UnMapped(pluginID,enStream,enSource);
   }
}

void vd_amp_if_tx_rx::vAmp_ErrSource(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
   if(m_po_vd_ampmsg_source!=NULL)
   {
     m_po_vd_ampmsg_source->vd_Amp_Msg_ErrSource(pluginID,ubErrorCode);
   }
}

void vd_amp_if_tx_rx::vAmp_IndVolume(vdamp_pluginID_t  pluginID, amp_tenStream enStream, uint8_t ubStep, int16_t swdB, amp_tenVolumeState enState)
{
   if(m_po_vd_ampmsg_volume!=NULL)
   {
     m_po_vd_ampmsg_volume->vd_Amp_Msg_IndVolume(pluginID,enStream,ubStep,swdB,enState);

   }
}

void vd_amp_if_tx_rx::vAmp_IndVolumePrem2(vdamp_pluginID_t  pluginID, uint8_t VolumeStep, amp_tenExtAmpVolumeType enVolGroup)
{
   if(m_po_vd_ampmsg_volume!=NULL)
   {
     m_po_vd_ampmsg_volume->vd_Amp_Msg_IndVolumePrem2(pluginID, VolumeStep, enVolGroup);
   }
}

void vd_amp_if_tx_rx::vAmp_IndVolumeListPrem2(vdamp_pluginID_t  PluginID, uint8_t* List)
{
  if(m_po_vd_ampmsg_volume!=NULL)
    {
      m_po_vd_ampmsg_volume->vd_Amp_Msg_IndVolumeListPrem2(PluginID, List);
    }
}

void vd_amp_if_tx_rx::vAmp_ErrVolume(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
   if(m_po_vd_ampmsg_volume!=NULL)
   {
     m_po_vd_ampmsg_volume->vd_Amp_Msg_ErrVolume(pluginID,ubErrorCode);
   }
}

void vd_amp_if_tx_rx::vAmp_SetFixAdrVolume (vdamp_pluginID_t  pluginID,amp_tenStream enStream, uint8_t ubStep,int16_t swdB,uint16_t uwRampLin,uint16_t uwRampdB)
{
  (tVoid)pluginID;

  ETG_TRACE_USR4((" vAmp_SetFixAdrVolume called from pluginID : 0x%4x.",pluginID));
  ETG_TRACE_USR4((" Stream = 0x%4x.",enStream));
  ETG_TRACE_USR4((" Step = 0x%4x.",ubStep));
  ETG_TRACE_USR4((" VoldB = 0x%4x.",swdB));
  ETG_TRACE_USR4((" RampLin = 0x%4x.",uwRampLin));
  ETG_TRACE_USR4((" RampdB= 0x%4x.",uwRampdB));

  Obj_VolumeData.m_enStream = (tenStream)enStream;
  Obj_VolumeData.m_VolStep = ubStep;
  Obj_VolumeData.m_VoldB = swdB;
  Obj_VolumeData.m_RampLin = uwRampLin;
  Obj_VolumeData.m_RampdB = uwRampdB;

    if(m_po_vd_ampmsg_volume!=NULL)
         {
      ETG_TRACE_USR4(("Calling vReloadADRData_Volume"));
        m_po_vd_ampmsg_volume->vReloadADRData_Volume(EXTAMP_CONNECTED,Obj_VolumeData.m_enStream ,Obj_VolumeData.m_VolStep,
          Obj_VolumeData.m_VoldB,Obj_VolumeData.m_RampLin,Obj_VolumeData.m_RampdB);

         }

}
void vd_amp_if_tx_rx::vAmp_IndVolumeOffset(vdamp_pluginID_t  pluginID, int16_t swOffset, amp_tenVolumeOffsetStatus enStatus)
{
  if(m_po_vd_ampmsg_volumeoffset!=NULL)
  {
    m_po_vd_ampmsg_volumeoffset->vd_Amp_Msg_IndVolumeOffset(pluginID,swOffset,enStatus);
  }
}
void vd_amp_if_tx_rx::vamp_ErrVolumeOffset(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
    if(m_po_vd_ampmsg_volumeoffset!=NULL)
    {
      m_po_vd_ampmsg_volumeoffset->vd_Amp_Msg_ErrVolumeOffset(pluginID,ubErrorCode);
    }
}
void vd_amp_if_tx_rx::vAmp_IndInputVolumeOffset(vdamp_pluginID_t  pluginID, amp_tenStream enStream, uint16_t uwOffset, amp_tenVolumeOffsetStatus enStatus)
{
    if(m_po_vd_ampmsg_inputvoloffset!=NULL)
    {
      m_po_vd_ampmsg_inputvoloffset->vd_Amp_Msg_IndInputVolumeOffset(pluginID,enStream,uwOffset,enStatus);
    }
}
void vd_amp_if_tx_rx::vAmp_ErrInputVolumeOffset(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
    if(m_po_vd_ampmsg_inputvoloffset!=NULL)
    {
      m_po_vd_ampmsg_inputvoloffset->vd_Amp_Msg_ErrInputVolumeOffset(pluginID,ubErrorCode);
    }
}
void vd_amp_if_tx_rx::vAmp_IndSettings(vdamp_pluginID_t  pluginID, amp_tenStream enStream, amp_tenSettingType enSettingType, int16_t swSteps)
{
 if(m_po_vd_ampmsg_settings!=NULL)
 {
   m_po_vd_ampmsg_settings->vd_Amp_Msg_IndSettings(pluginID,enStream,enSettingType,swSteps);
 }
}
void vd_amp_if_tx_rx::vAmp_ErrSettings(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
 if(m_po_vd_ampmsg_settings!=NULL)
 {
   m_po_vd_ampmsg_settings->vd_Amp_Msg_ErrSettings(pluginID,ubErrorCode) ;
 }
}

void vd_amp_if_tx_rx::vAmp_AvailSettings(vdamp_pluginID_t  pluginID, uint16_t swValue)
{
 if(m_po_vd_ampmsg_settings!=NULL)
 {
   m_po_vd_ampmsg_settings->vd_Amp_Msg_AvailSetting(pluginID,swValue) ;
 }
}

void vd_amp_if_tx_rx::vAmp_IndSetParamFilter(vdamp_pluginID_t  pluginID, uint8_t ubFilterID, amp_tenParamFilterChar enChar,uint8_t ubOrder, uint16_t uwFreq, int16_t swGain,uint8_t ubQ)
{
   if(m_po_vd_ampmsg_paramfilter!=NULL)
   {
     m_po_vd_ampmsg_paramfilter->vd_Amp_Msg_IndParamFilter(pluginID,ubFilterID,enChar,ubOrder,uwFreq,swGain,ubQ);
   }
}
void vd_amp_if_tx_rx::vAmp_ErrSetParamFilter(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
     if(m_po_vd_ampmsg_paramfilter!=NULL)
     {
       m_po_vd_ampmsg_paramfilter->vd_Amp_Msg_ErrParamFilter(pluginID,ubErrorCode);
     }
}
void vd_amp_if_tx_rx::vAmp_IndSetGraphFilter(vdamp_pluginID_t  pluginID, uint8_t ubEqID, uint8_t ubBand, int16_t swGain, amp_tenFrequencyIndex enFreqIndex)
{
     if(m_po_vd_ampmsg_graphfilter!=NULL)
     {
       m_po_vd_ampmsg_graphfilter->vd_Amp_Msg_IndGraphFilter(pluginID,ubEqID,ubBand,swGain,enFreqIndex);
     }
}
void vd_amp_if_tx_rx::vAmpErr_SetGraphFilter(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode)
{
     if(m_po_vd_ampmsg_graphfilter!=NULL)
     {
       m_po_vd_ampmsg_graphfilter->vd_Amp_Msg_ErrGraphFilter(pluginID,ubErrorCode);
     }
}
void vd_amp_if_tx_rx::vAmp_IndMute(vdamp_pluginID_t  pluginID, amp_tenStream enStream,amp_tenMuteStatus enMuteStatus)
{
  if(m_po_vd_ampmsg_mute!=NULL)
  {
     m_po_vd_ampmsg_mute->vd_Amp_Msg_IndMute(pluginID,enStream,enMuteStatus);
    }

}
void vd_amp_if_tx_rx::vAmp_ErrMute(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode)
{
  if(m_po_vd_ampmsg_mute!=NULL)
    m_po_vd_ampmsg_mute->vd_Amp_Msg_ErrMute(pluginID,ubErrorCode);

}
void vd_amp_if_tx_rx::vAmp_IndBeepParam(vdamp_pluginID_t  pluginID, amp_tenBeepID enSignalBeepID, uint8_t ubSignalToneID,uint16_t uwFreq,int16_t swGain)
{
    if(m_po_vd_ampmsg_beepparam!=NULL)
      m_po_vd_ampmsg_beepparam->vd_Amp_Msg_IndBeepParam(pluginID,enSignalBeepID,ubSignalToneID,uwFreq,swGain);
}
void vd_amp_if_tx_rx::vAmp_ErrBeepParam(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode)
{
    if(m_po_vd_ampmsg_beepparam!=NULL)
      m_po_vd_ampmsg_beepparam->vd_Amp_Msg_ErrBeepParam(pluginID,ubErrorCode);
}
void vd_amp_if_tx_rx::vAmp_IndBeep(vdamp_pluginID_t  pluginID, amp_tenBeepID enSignalBeepID, amp_tenBeepState  enBeepState)
{
  if(m_po_vd_ampmsg_beep !=NULL)
    m_po_vd_ampmsg_beep->vd_Amp_Msg_IndBeep(pluginID,enSignalBeepID,enBeepState);
}
void vd_amp_if_tx_rx::vAmp_ErrBeep(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode)
{
    if(m_po_vd_ampmsg_beep!=NULL)
      m_po_vd_ampmsg_beep->vd_Amp_Msg_ErrBeep(pluginID,ubErrorCode);
}
void vd_amp_if_tx_rx::vAmp_ErrCarSetting(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
     if(m_po_vd_ampmsg_carsettings!=NULL)
       m_po_vd_ampmsg_carsettings->vd_Amp_Msg_ErrCarSettings(pluginID,ubErrorCode);
}
void vd_amp_if_tx_rx::vAmp_IndSurround(vdamp_pluginID_t  pluginID,uint8_t ubMode, int8_t sbLevel, int8_t sbCenterLevel)
{
    if(m_po_vd_ampmsg_surround!=NULL)
      m_po_vd_ampmsg_surround->vd_Amp_Msg_IndSurround(pluginID,ubMode,sbLevel,sbCenterLevel);
}
void vd_amp_if_tx_rx::vAmp_ErrSurround(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)
{
  if(m_po_vd_ampmsg_surround!=NULL)
    m_po_vd_ampmsg_surround->vd_Amp_Msg_ErrSurround(pluginID,ubErrorCode);
}


void vd_amp_if_tx_rx::vAmp_IndPDCVolOffset(vdamp_pluginID_t  pluginID, int16_t swSteps)
{
  if(m_po_ampmsg_PDCVolumeOffset!=NULL)
    m_po_ampmsg_PDCVolumeOffset->vd_Amp_Msg_IndPDCVolOffset(pluginID,swSteps);
}

void vd_amp_if_tx_rx::vAmp_ErrPDCVolOffset(vdamp_pluginID_t pluginID, uint8_t ErrorCode)
{
  if(m_po_ampmsg_PDCVolumeOffset!= NULL)
    m_po_ampmsg_PDCVolumeOffset->vd_Amp_Msg_ErrPDCVolOffset(pluginID,ErrorCode);
}

void vd_amp_if_tx_rx::vAmp_ConnectionState(vdamp_pluginID_t pluginID, uint8_t state)
{
  if(m_po_vd_ampmsg_power!= NULL)
    m_po_vd_ampmsg_power->vd_Amp_Msg_ConnectionState(pluginID,state);
}

void vd_amp_if_tx_rx::vAmp_MainAudioAttenuation(vdamp_pluginID_t  pluginID, int8_t dbValue)
{
    if(m_po_vd_ampmsg_volume!=NULL)
      m_po_vd_ampmsg_volume->vd_Amp_Msg_MainAudioAttenuation(pluginID, dbValue);
}
/**********************************************************************************************
 * Context switcher : Switches from messages of other thread to CCA
 *********************************************************************************************/
void vd_amp_if_tx_rx::vAmp_Tx_ToCCALoopback (vdamp_pluginID_t  pluginID, uint8_t *    ptrStream, size_t datalength)
{
  ETG_TRACE_USR4((" vd_amp_If::vAmp_Tx_ToCCALoopback for plugin_ID %4x.",pluginID));
  ETG_TRACE_USR4((" datalength %4x.",datalength));

  size_t mod_datalength = (ptrStream == NULL) ? 0 :datalength;

  tPU8 pu8DataCpy = new tU8[mod_datalength+4];
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pu8DataCpy);
  pu8DataCpy[0] = TRC::enAmpIf;    // ToDo      add in fc_audiomanager_trace.h
  pu8DataCpy[1] = TRC::enAmpResponse; // ToDo   add in fc_audiomanager_trace.h
  pu8DataCpy[2] = (tU8) (pluginID>>8) ;
  pu8DataCpy[3] = (tU8) (pluginID) ;
  if(ptrStream != NULL)
  {
    memcpy(pu8DataCpy+4, ptrStream, mod_datalength);//lint !e826
  }

  fc_audiomanager_tclApp::vRxFromOtherThreads((tU32)(mod_datalength + 4), pu8DataCpy);
  delete []pu8DataCpy;
}

/*****************************************************************
 * vSenderFunctionInit : Creates the objects for all the functionalities
 ****************************************************************/
void vd_amp_if_tx_rx::vSenderFunctionInit(vdamp_plugin_sender* Target)
{

    vdamp_plugin_sender_interfaces obj = Target->oGetInterfaceData();

    //creation of pointers for all the function senders
    if(obj.m_ptrBeepParamSender != NULL)
    {
      m_po_vd_ampmsg_beep = OSAL_NEW vd_amp_msg_beep(m_ptrloader,this) ;
    }


    if(obj.m_ptrsourceSender!=NULL)
    {
      m_po_vd_ampmsg_source = OSAL_NEW vd_amp_msg_source(m_ptrloader,this) ;
    }
    if(obj.m_ptrBeepParamSender!=NULL)
    {
       m_po_vd_ampmsg_beepparam = OSAL_NEW vd_amp_msg_beepparam(m_ptrloader,this) ;
    }

    if(obj.m_ptrCarSettingSender!=NULL)
    {
      m_po_vd_ampmsg_carsettings = OSAL_NEW vd_amp_msg_CarSettings(m_ptrloader,this) ;
    }

    if(obj.m_ptrInputVolumeOffsetSender!=NULL)
    {
         m_po_vd_ampmsg_inputvoloffset = OSAL_NEW vd_amp_msg_InputVolumeOffset(m_ptrloader,this) ;
    }

    if(obj.m_ptrSetGraphFilterSender!=NULL)
    {
      m_po_vd_ampmsg_graphfilter  = OSAL_NEW vd_amp_msg_GraphFilter(m_ptrloader,this) ;
    }

    if(obj.m_ptrSetParamFilterSender!=NULL)
    {
      m_po_vd_ampmsg_paramfilter   = OSAL_NEW vd_amp_msg_ParamFilter(m_ptrloader,this) ;
    }

    if(obj.m_ptrSurroundSender!=NULL)
    {
      m_po_vd_ampmsg_surround    = OSAL_NEW vd_amp_msg_Surround(m_ptrloader,this) ;
    }

    if(obj.m_ptrVolumeOffsetSender!=NULL)
    {
      m_po_vd_ampmsg_volumeoffset     = OSAL_NEW vd_amp_msg_VolumeOffset(m_ptrloader,this) ;
    }

    if(obj.m_ptrmuteSenderIF!=NULL)
    {
      m_po_vd_ampmsg_mute      = OSAL_NEW vd_amp_msg_mute(m_ptrloader,this) ;
    }

    if(obj.m_ptrpowerSender!=NULL)
    {
      m_po_vd_ampmsg_power       = OSAL_NEW vd_amp_msg_power(m_ptrloader,this) ;
    }

    if(obj.m_ptrsettingsSender!=NULL)
    {
      m_po_vd_ampmsg_settings        = OSAL_NEW vd_amp_msg_Settings(m_ptrloader,this) ;
    }

    if(obj.m_ptrvolumeSender!=NULL)
    {
      m_po_vd_ampmsg_volume    = OSAL_NEW vd_amp_msg_Volume(m_ptrloader,this,m_ptrvdadr3main) ;
    }

    if(obj.m_ptrPDCVolumeOffsetSender!=NULL)
    {
      m_po_ampmsg_PDCVolumeOffset = OSAL_NEW vd_amp_msg_PDC_VolumeOffset(m_ptrloader,this);
    }

}

/******************************************************************************************
 * vAmp_SetADRSoundConfigItem : Sends the SoundConfig item from the plugin to ADR
 ******************************************************************************************/
void vd_amp_if_tx_rx::vAmp_SetADRSoundConfigItem(tU8 ubSoundSystem)
{
  ETG_TRACE_USR4((" vAmp_SetADRSoundConfigItem  received SoundSystem : %4x.",ubSoundSystem));

  vd_adr3_config::vSetConfigItem(SOUND_CONFIG_ITEM_VALUE_UNDEF,ubSoundSystem,
      SOUND_CONFIG_ITEM_VALUE_UNDEF,SOUND_CONFIG_ITEM_VALUE_UNDEF);

  aud_sinkmgr_pwramp* pPwrAmp = aud_sinkmgr_main::poGetPowerAmp();
  if (pPwrAmp)
     pPwrAmp->SetSoundConfig(ubSoundSystem);

  IDSetSoundSystemConfig oSoundSys(ubSoundSystem);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oSoundSys);
}

/******************************************************************************************
 * vAmp_SetADRSpeakerSoundConfigItem : Sends the SoundConfig item from the plugin to ADR
 ******************************************************************************************/
void vd_amp_if_tx_rx::vAmp_SetADRSpeakerSoundConfigItem(tU8 ubSpeakerSoundSystem)
{
  ETG_TRACE_USR4((" vAmp_SetADRSpeakerSoundConfigItem  received SpeakerSoundSystem : %4x.",ubSpeakerSoundSystem));

  vd_adr3_config::vSetConfigItem(ubSpeakerSoundSystem,SOUND_CONFIG_ITEM_VALUE_UNDEF,
      SOUND_CONFIG_ITEM_VALUE_UNDEF,SOUND_CONFIG_ITEM_VALUE_UNDEF);

}
/*********************************************************************************************
 * vChangeConfig : interface for the plugin,will be called if an amplifier gets disconnected or connected
 *****************************************************************************************/
void vd_amp_if_tx_rx::vChangeConfig(tU8 AmplifierConfig)
{
  ETG_TRACE_USR4((" vChangeConfig called with Amplifier configuration %4x.",AmplifierConfig));
  vReloadData(AmplifierConfig);
}

/************************************************************************************
 * ReloadData() : Resends the values to ADR and the external plugin based on the amplifier configuration
 *                whether it is connected or disconnected.
 ************************************************************************************/

void vd_amp_if_tx_rx::vReloadData(tU8 AmpConfig)
{
  ETG_TRACE_USR4((" vReloadData() called "));

  if(m_po_vd_ampmsg_volume!=NULL)
     m_po_vd_ampmsg_volume->vReloadADRData_Volume(AmpConfig,Obj_VolumeData.m_enStream ,Obj_VolumeData.m_VolStep,
         Obj_VolumeData.m_VoldB,Obj_VolumeData.m_RampLin,Obj_VolumeData.m_RampdB);

  if(m_po_vd_ampmsg_mute!=NULL)
  m_po_vd_ampmsg_mute->vReloadExtAmpData_Mute(AmpConfig);

  if(m_po_vd_ampmsg_power!=NULL)
  m_po_vd_ampmsg_power->vReloadExtAmpData_Power(AmpConfig);

  if(m_po_vd_ampmsg_settings!=NULL)
  m_po_vd_ampmsg_settings->vReloadExtAmpData_Settings(AmpConfig);

  if(m_po_vd_ampmsg_graphfilter!=NULL)
  m_po_vd_ampmsg_graphfilter->vReloadExtAmpData_GraphFilter(AmpConfig);

  if(m_po_vd_ampmsg_beepparam!=NULL)
  m_po_vd_ampmsg_beepparam->vReloadExtAmpData_BeepParam(AmpConfig);

  if(m_po_vd_ampmsg_carsettings!=NULL)
  m_po_vd_ampmsg_carsettings->vReloadExtAmpData_CarSettings(AmpConfig);

  if(m_po_vd_ampmsg_inputvoloffset!=NULL)
  m_po_vd_ampmsg_inputvoloffset->vReloadExtAmpData_InputVolumeOffset(AmpConfig);

  if(m_po_vd_ampmsg_source!=NULL)
  m_po_vd_ampmsg_source->vReloadExtAmpData_Source(AmpConfig);

  if(m_po_vd_ampmsg_surround!=NULL)
  m_po_vd_ampmsg_surround->vReloadExtAmpData_Surround(AmpConfig);

  if(m_po_vd_ampmsg_volume!=NULL)
  m_po_vd_ampmsg_volume->vReloadExtAmpData_Volume(AmpConfig);

  if(m_po_vd_ampmsg_volumeoffset!=NULL)
  m_po_vd_ampmsg_volumeoffset->vReloadExtAmpData_VolumeOffset(AmpConfig);

  if(m_po_vd_ampmsg_paramfilter!=NULL)
  m_po_vd_ampmsg_paramfilter->vReloadExtAmpData_ParamFilter(AmpConfig);

  if(m_po_ampmsg_PDCVolumeOffset!=NULL)
    m_po_ampmsg_PDCVolumeOffset->vReloadExtAmpData_PDCVolOffset(AmpConfig);
}
