/*
 * vd_amp_msg_surround.h
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_SURROUND_H_
#define VD_AMP_MSG_SURROUND_H_

#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/Surround/IDSurroundSetting.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"


class vd_amp_msg_Surround : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_Surround(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndSurround(vdamp_pluginID_t  PluginID,uint8_t Mode, int8_t Level, int8_t CenterLevel)const;
  void vd_Amp_Msg_ErrSurround(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
    virtual ~vd_amp_msg_Surround()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;

    }
    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vReloadExtAmpData_Surround(tU8 ampconfig);
    void vLoadSurroundDPAndSend();

private:
    void vAddObserver();
    void sendSurroundMessage();
    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;
    midw_fi_tcl_e8_SurroundSetting::tenType SurroundSetting;
    int8_t level;
    int8_t Centerlevel;
};

#endif /* VD_AMP_MSG_SURROUND_H_ */
