/*
 * vd_amp_msg_surround.cpp
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_surround.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_surround.cpp.trc.h"
#endif

#include "config/dp/AudioUserDpIfSelect.h"

vd_amp_msg_Surround::vd_amp_msg_Surround(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_Surround")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  level = 0x00;
  Centerlevel = 0x00;
  SurroundSetting = midw_fi_tcl_e8_SurroundSetting::FI_EN_AUDIO_SURROUND_OFF;
  ETG_TRACE_USR4(("vd_amp_msg_Surround::vd_amp_msg_Surround constructor. "));

  vAddObserver();

}

void vd_amp_msg_Surround::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_Surround::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_Surround::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SurroundSetting);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
  }

}

void vd_amp_msg_Surround::sendSurroundMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrSurroundSender);
  ETG_TRACE_USR4(("vAmp_VolumeOffset called"));

  ETG_TRACE_USR4(("SurroundSetting = %d",SurroundSetting));

  tmp.m_ptrSurroundSender->vAmp_Surround(SurroundSetting,level,Centerlevel);
}


void vd_amp_msg_Surround::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_Surround::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);

  switch (MsgId)
  {
  case (PO_MessageConfig::ID_SurroundSetting):
  {
    const ID_SurroundSetting*     pMsg = pPO->POMessages->QueryMessage<ID_SurroundSetting>(MsgId);

    ETG_TRACE_USR4(("vd_amp_msg_Surround  received Surround mode as : 0x%4x.", pMsg->Surround.enType));

    SurroundSetting = pMsg->Surround.enType;

    ETG_TRACE_USR4(("vd_amp_msg_Surround::Update new surround value DP =%d",SurroundSetting));
    sendSurroundMessage();//level and centre level hardcoded
    break;
  }
  case (PO_MessageConfig::ID_DiagDefSet):
  {
        // Obtaining the Diag DefSet
        const ID_DiagDefSet* pMsgDefSet = pPO->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
        ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));

        tenDiagDefSetType enDefSetType = pMsgDefSet->enDiagDefSetType;
        tenDiagDefSetPhase enDefSetPhase = pMsgDefSet->enDiagDefSetPhase;

        if(enDefSetType == EN_DEFSET_HMI || enDefSetType == EN_USER_CHANGE || enDefSetType == EN_DEFSET_TEF)
        {
           if(enDefSetPhase == EN_DEFSET_FINISH)
           {
              ETG_TRACE_USR4(("DefSet HMI received EN_DEFSET_FINISH -> vOnLoadSettings()"));
              vLoadSurroundDPAndSend();
           }
        }
    break;
  }
  default :
    break;
  }
}


void  vd_amp_msg_Surround::vd_Amp_Msg_IndSurround(vdamp_pluginID_t  PluginID,uint8_t Mode, int8_t Level, int8_t CenterLevel)const
{
  ETG_TRACE_USR4(("vd_amp_msg_Surround:Received Mode: 0x%4x  ", Mode));
  ETG_TRACE_USR4(("vd_amp_msg_Surround:Received Level 0x%4x ", Level));
  ETG_TRACE_USR4(("vd_amp_msg_Surround:Received CenterLevel Id 0x%4x .", CenterLevel));
  ETG_TRACE_USR4(("vd_amp_msg_Surround:Received PluginID 0x%4x .", PluginID));
}


void vd_amp_msg_Surround::vd_Amp_Msg_ErrSurround(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_Surround:Received errorcode 0x%4x from plugin : 0x%4x amp_mute_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_Surround::vReloadExtAmpData_Surround(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Surround() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    vLoadSurroundDPAndSend();
  }
  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}

void vd_amp_msg_Surround::vLoadSurroundDPAndSend()
{
  //Reload the latest received Post Office message values
  tU8 u8SurroundLevel = 0;

   if(AudioUserDpIfSelect::pGetAudUsrDpIf())
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetSurroundLevel(u8SurroundLevel);

  SurroundSetting = (midw_fi_tcl_e8_SurroundSetting::tenType)u8SurroundLevel ;
  sendSurroundMessage();
}
