/*
 * vd_amp_msg_powerstate.h
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_POWERSTATE_H_
#define VD_AMP_MSG_POWERSTATE_H_

#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/power/IDPowerState.h"
//#include "../../InternalComponentCommunication/Messages/power/ID_SysPowerMode.h"
#include "../../InternalComponentCommunication/Messages/power/ID_ApplicationStatus.h"
#include "../../InternalComponentCommunication/Messages/vd_AmpResponses/IDAmpResponse_Power.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ApplicationStateDefines.h"
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#include "util/Macro.h"



class vd_amp_msg_power : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_power(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
    virtual ~vd_amp_msg_power()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;

    };
    void vd_Amp_Msg_IndPower(vdamp_pluginID_t  pluginID, amp_tenPowerStatus enStatus, amp_tenPowerState enState)const;

    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vd_Amp_Msg_ErrPower(vdamp_pluginID_t  pluginID, uint8_t ubErrorCode)const;
    void vReloadExtAmpData_Power(tU8 ampconfig);

    void vd_Amp_Msg_ConnectionState(vdamp_pluginID_t  pluginID, uint8_t ubState)const;
private:
    void vAddObserver();
    void sendPowerStateMessage();
    void sendApplicationStateMessage();
    void vSendAmpResponse(amp_tenPowerStatus enstatus, amp_tenPowerState enstate)const;
  void vUpdateExtAmpState(tenAdrPowerState AdrPowerState);

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;
    tenAmpPowerMode ExtAmpState;
    tenApplicationStates ApplicationState;
    //tBool Appstate_Flag;
    tU32 powerstate;
};


#endif /* VD_AMP_MSG_POWERSTATE_H_ */
