/*
 * vd_amp_msg_volume.h
 *
 *  Created on: Jan 8, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_MUTE_H_
#define VD_AMP_MSG_MUTE_H_

#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "util/Macro.h"
#include "../../../PostOffice/PostOffice.hpp"

#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"

#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/vd_AmpResponses/IDAmpResponse_Mute.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"
#include "../../InternalComponentCommunication/Messages/mute/IDSetMute.h"


class vd_amp_if_tx_rx;
class plugin_loader;

class vd_amp_msg_mute : public IF_MessageObserver<PO_MessageConfig::enID>
{

public:
  vd_amp_msg_mute();
  vd_amp_msg_mute(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  virtual ~vd_amp_msg_mute()
  {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
    m_ptrloader = NULL;
    m_ptrreceiver = NULL;
   }

  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  void vd_Amp_Msg_IndMute(vdamp_pluginID_t  PluginID, amp_tenStream Stream,amp_tenMuteStatus MuteStatus)const;
  void vSendAmpResponse(amp_tenStream stream , amp_tenMuteStatus mutestatus)const;
  void vd_Amp_Msg_ErrMute(vdamp_pluginID_t  pluginID,uint8_t ubErrorCode)const;
  void vReloadExtAmpData_Mute(tU8 ampconfig);

private:

  void sendMuteMessage();
  void vAddObserver();

  plugin_loader* m_ptrloader ;
  vd_amp_if_tx_rx* m_ptrreceiver;
  tenStream enStream;
  tenMuteAction enMuteAction;


};
#endif /* VD_AMP_MSG_VOLUME_H_ */
