/*
 * vd_amp_msg_VolumeOffset.cpp
 *
 *  Created on: Jan 13, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_VolumeOffset.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#define VOLOFFSET_RESOLUTION  4

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_VolumeOffset.cpp.trc.h"
#endif

#include "config/dp/AudioUserDpIfSelect.h"

vd_amp_msg_VolumeOffset::vd_amp_msg_VolumeOffset(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_VolumeOffset")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset::vd_amp_msg_VolumeOffset constructor. "));

  vAddObserver();

}

void vd_amp_msg_VolumeOffset::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetVolumeOffset);
  }
}

void vd_amp_msg_VolumeOffset::sendVolumeOffsetMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

    if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
    {
      ETG_TRACE_USR4(("m_ptrMain!=NULL"));
        ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
    }

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

    ETG_TRACE_USR4(("oGetInterfaceData called"));
    vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrVolumeOffsetSender);
    ETG_TRACE_USR4(("vAmp_VolumeOffset called"));

    tmp.m_ptrVolumeOffsetSender->vAmp_VolumeOffset((amp_tenStream)OffsetValues.m_enStream,
                                                     (int16_t) OffsetValues.s16Offset_LF,
                                                     (int16_t) OffsetValues.s16Offset_RF,
                                                     (int16_t) OffsetValues.s16Offset_LR,
                                                     (int16_t) OffsetValues.s16Offset_RR,
                                                     (int16_t) OffsetValues.s16Offset_CE,
                                                     (int16_t) OffsetValues.s16Offset_SUB);
}


void vd_amp_msg_VolumeOffset::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_Volume::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  const MSG_SetVolumeOffset*     pMsg = pPO->POMessages->QueryMessage<MSG_SetVolumeOffset>(MsgId);

  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Stream: 0x%4x.", pMsg->values.m_enStream));
  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Offset in CE speaker: 0x%4x.", pMsg->values.s16Offset_CE));
  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Offset in LF speaker: 0x%4x.", pMsg->values.s16Offset_LF));
  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Offset in LR speaker: 0x%4x.", pMsg->values.s16Offset_LR));
  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Offset in RF speaker: 0x%4x.", pMsg->values.s16Offset_RF));
  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Offset in RR speaker: 0x%4x.", pMsg->values.s16Offset_RR));
  ETG_TRACE_USR4(("Audio VolumeOffset Observer received Offset in SUB speaker: 0x%4x.", pMsg->values.s16Offset_SUB));


  OffsetValues.m_enStream = pMsg->values.m_enStream;
  OffsetValues.s16Offset_CE = pMsg->values.s16Offset_CE;
  OffsetValues.s16Offset_LF = pMsg->values.s16Offset_LF;
  OffsetValues.s16Offset_LR = pMsg->values.s16Offset_LR;
  OffsetValues.s16Offset_RF = pMsg->values.s16Offset_RF;
  OffsetValues.s16Offset_RR = pMsg->values.s16Offset_RR;
  OffsetValues.s16Offset_SUB = pMsg->values.s16Offset_SUB;

  sendVolumeOffsetMessage();
}


void  vd_amp_msg_VolumeOffset::vd_Amp_Msg_IndVolumeOffset(vdamp_pluginID_t  PluginID, int16_t Offset, amp_tenVolumeOffsetStatus Status)const
{
  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset:Received swOffset: 0x%4x  ", Offset));
  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset:Received enStatus 0x%4x ", Status));
  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset:Received Plugin Id 0x%4x .", PluginID));
}


void vd_amp_msg_VolumeOffset::vd_Amp_Msg_ErrVolumeOffset(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset:Received errorcode 0x%4x from plugin : 0x%4x amp_VolumeOffset_sender.", ErrorCode,PluginID));
}


void vd_amp_msg_VolumeOffset::vReloadExtAmpData_VolumeOffset(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_VolumeOffset() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    vReadOffsetDataFromDP();
    sendVolumeOffsetMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}

void vd_amp_msg_VolumeOffset::vReadOffsetDataFromDP()
{
  ETG_TRACE_USR4(("vd_amp_msg_VolumeOffset::vReadOffsetDataFromDP"));

  tU8 CenterGainPerStepValue;
  tU8 SubWooferGainPerStepValue;

   if(AudioUserDpIfSelect::pGetAudUsrDpIf())
   {
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetCenterGain(OffsetValues.s16Offset_CE);
      AudioUserDpIfSelect::pGetAudUsrDpIf()->s32GetSubwoofer(OffsetValues.s16Offset_SUB);
   }

  dp_tclAudioManagerDPCenter_GainPerStep oCenterGainPerStep;
  tS32 s32Res = oCenterGainPerStep.s32GetData(CenterGainPerStepValue);
   ETG_TRACE_USR4(("CanterGainPerStepValue = %x",CenterGainPerStepValue ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  dp_tclAudioManagerDPSubWoofer_GainPerStep oSubWooferGainPerStep;
  s32Res = oSubWooferGainPerStep.s32GetData(SubWooferGainPerStepValue);
   ETG_TRACE_USR4(("SubWooferGainPerStepValue = %x",SubWooferGainPerStepValue ));
  ETG_TRACE_USR4(("REsult = %x",s32Res ));

  OffsetValues.s16Offset_CE = (short)(VOLOFFSET_RESOLUTION * OffsetValues.s16Offset_CE * CenterGainPerStepValue);
  OffsetValues.s16Offset_SUB = (short)(VOLOFFSET_RESOLUTION * OffsetValues.s16Offset_SUB * SubWooferGainPerStepValue);
  ETG_TRACE_USR4(("vReadOffsetDataFromDP():CenterGainDP=%d, SubWooferDP = %d", OffsetValues.s16Offset_CE, OffsetValues.s16Offset_SUB));
}
