/*
 * vd_amp_msg_Settings.cpp
 *
 *  Created on: Jan 11, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_Settings.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_AvailSettings.h"
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_ExtAmpSettingsStatus.h"
#include "../../InternalComponentCommunication/Messages/BOSE_Amp/ID_ExtAmpSettingsList.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_Settings.cpp.trc.h"
#endif


vd_amp_msg_Settings::vd_amp_msg_Settings(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_Settings")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  m_AmplifierConfig = 0;
  stream = EN_AUDIO_SOURCE_STREAM_DEFAULT;
  SettingType = (tenSettingType)EN_AUDIO_SETTINGS_UNKNOWN;
  Steps = 0;
  ETG_TRACE_USR4(("vd_amp_msg_Settings::vd_amp_msg_Settings constructor. "));
  vAddObserver();
}

void vd_amp_msg_Settings::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_Settings::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_Settings::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Settings);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_ExtAmpSettingsList);
  }

}

void vd_amp_msg_Settings::sendSettingsMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
      ETG_TRACE_USR4(("Active Plugin : %d", m_ptrreceiver->u16GetActivePlugin()));
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrsettingsSender);

  ETG_TRACE_USR4(("vAmp_Settings called"));
  tmp.m_ptrsettingsSender->vAmp_Settings((amp_tenStream)stream,
                                   (amp_tenSettingType) SettingType,Steps);
}


void vd_amp_msg_Settings::sendSettingsListMessage(tU8* u8Data, tU16 u16Len)
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL) && (u8Data != NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
      ETG_TRACE_USR4(("Active Plugin : %d", m_ptrreceiver->u16GetActivePlugin()));
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrsettingsSender);

  ETG_TRACE_USR4(("vAmp_Settings_list called"));
  tmp.m_ptrsettingsSender->vAmp_Settings_List(u8Data, u16Len);
}

void vd_amp_msg_Settings::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_Settings::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  switch(MsgId)
  {
  case PO_MessageConfig::ID_Settings:
  {
    const MSG_Settings*     pMsg = pPO->POMessages->QueryMessage<MSG_Settings>(MsgId);

  ETG_TRACE_USR4(("PSettings SettinType: 0x%4x.", pMsg->enSettingType));
  ETG_TRACE_USR4(("PSettings Stream: 0x%4x.", pMsg->enStream));
  ETG_TRACE_USR4(("PSettings Step : 0x%4x.", pMsg->s16Steps));

  stream = pMsg->enStream;
  SettingType = pMsg->enSettingType;
  Steps  = pMsg->s16Steps;

    if(m_AmplifierConfig == EXTAMP_CONNECTED)
    {
      //Send Settings only if External amplifier is connected.
      sendSettingsMessage();
    }
    break;
  }
  case PO_MessageConfig::ID_ExtAmpSettingsList:
  {
    const ID_ExtAmpSettingsList*     pMsg = pPO->POMessages->QueryMessage<ID_ExtAmpSettingsList>(MsgId);
    ETG_TRACE_USR4(("ExtAmpSettings Length : 0x%4x.", pMsg->u16Length));
    if(m_AmplifierConfig == EXTAMP_CONNECTED)
    {
      sendSettingsListMessage(pMsg->u8SettingValues, pMsg->u16Length);
    }
    break;
  }
  default :
    break;
  }
}
void  vd_amp_msg_Settings::vd_Amp_Msg_IndSettings(vdamp_pluginID_t  pluginID, amp_tenStream enStream, amp_tenSettingType enSettingType, int16_t swSteps)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSettings:Received Stream: 0x%4x  ", enStream));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSettings:Received SettingsType 0x%4x ", enSettingType));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSettings:Received swSteps 0x%4x ", swSteps));
  ETG_TRACE_USR4(("vd_Amp_Msg_IndSettings:Received pluginID 0x%4x .", pluginID));

  ID_ExtAmpSettingsStatus oExtAmpSettingsStatus((tU8)enSettingType, (tS8)swSteps);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oExtAmpSettingsStatus);
}


void vd_amp_msg_Settings::vd_Amp_Msg_ErrSettings(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_Settings:Received errorcode 0x%4x from plugin : 0x%4x amp_settings_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_Settings::vd_Amp_Msg_AvailSetting(vdamp_pluginID_t  PluginID, uint16_t swValue)const
{
  ETG_TRACE_USR4(("vd_Amp_Msg_AvailSetting:Received Avail-settings 0x%4x from plugin : 0x%4x amp_settings_sender.", swValue,PluginID));
  ID_AvailSettings oAvailSetting(swValue);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oAvailSetting);
}

void vd_amp_msg_Settings::vReloadExtAmpData_Settings(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Settings() called"));

  m_AmplifierConfig = ampconfig;
  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendSettingsMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}
