/*
 * vd_amp_ParamFilter.h
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_PARAMFILTER_H_
#define VD_AMP_PARAMFILTER_H_

#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../InternalComponentCommunication/Messages/Equ_Filter/IDSetFilter.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_ParamFilter : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_ParamFilter(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndParamFilter(vdamp_pluginID_t  PluginID, uint8_t FilterID, amp_tenParamFilterChar Char,
            uint8_t Order, uint16_t Freq, int16_t Gain,uint8_t Qfactor)const;
  void vd_Amp_Msg_ErrParamFilter(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
    virtual ~vd_amp_msg_ParamFilter()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;

    }

    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vReloadExtAmpData_ParamFilter(tU8 ampconfig);
private:

    void vAddObserver();
    void sendParamFilterMessage();

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;
    SetFilterData filterdata;
};

#endif /* VD_AMP_PARAMFILTER_H_ */
