/*
 * vd_amp_ParamFilter.cpp
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_ParamFilter.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_ParamFilter.cpp.trc.h"
#endif



vd_amp_msg_ParamFilter::vd_amp_msg_ParamFilter(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_ParamFilter")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter::vd_amp_msg_ParamFilter constructor. "));

  vAddObserver();

}

void vd_amp_msg_ParamFilter::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_ParamFilter::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetFilter);
  }

}

void vd_amp_msg_ParamFilter::sendParamFilterMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrSetParamFilterSender);
  ETG_TRACE_USR4(("vAmp_ParamFilter called"));
  tmp.m_ptrSetParamFilterSender->vAmp_SetParamFilter(filterdata.u8FilterID,(amp_tenParamFilterChar)filterdata.u8FilterCharacteristic,
                                                filterdata.u8Order, filterdata.u16Frequency,
                                                filterdata.s16Gain, filterdata.u8QFactor);


}
void vd_amp_msg_ParamFilter::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter::MessageNotification entered. "));

  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  const MSG_SetFilter*     pMsg = pPO->POMessages->QueryMessage<MSG_SetFilter>(MsgId);

  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter  received u8FilterID: 0x%4x.", pMsg->values.u8FilterID));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter received u8FilterCharacteristic: 0x%4x.", pMsg->values.u8FilterCharacteristic));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter received u8Order: 0x%4x.", pMsg->values.u8Order));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter received u16Frequency: 0x%4x.", pMsg->values.u16Frequency));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter received s16Gain: 0x%4x.", pMsg->values.s16Gain));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter received u8QFactor: 0x%4x.", pMsg->values.u8QFactor));

  filterdata.u8FilterID = pMsg->values.u8FilterID ;
  filterdata.u8FilterCharacteristic = pMsg->values.u8FilterCharacteristic;
  filterdata.u8Order =   pMsg->values.u8Order;
  filterdata.u16Frequency = pMsg->values.u16Frequency;
  filterdata.s16Gain =    pMsg->values.s16Gain;
  filterdata.u8QFactor = pMsg->values.u8QFactor;

  sendParamFilterMessage();
}


void  vd_amp_msg_ParamFilter::vd_Amp_Msg_IndParamFilter(vdamp_pluginID_t  PluginID, uint8_t FilterID, amp_tenParamFilterChar Char,
                                                       uint8_t Order, uint16_t Freq, int16_t Gain,uint8_t Qfactor)const
{
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received FilterID 0x%4x ",   FilterID));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received Characteristic 0x%4x .", Char));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received Order 0x%4x .", Order));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received Frequency 0x%4x .", Freq));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received QFactor 0x%4x .", Qfactor));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received Gain: 0x%4x  ", Gain));
  ETG_TRACE_USR4(("vd_amp_msg_ParamFilter:Received PluginID: 0x%4x  ", PluginID));
}

void vd_amp_msg_ParamFilter::vd_Amp_Msg_ErrParamFilter(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_ParamFilter:Received errorcode 0x%4x from plugin : 0x%4x amp_ParamFilter_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_ParamFilter::vReloadExtAmpData_ParamFilter(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_ParamFilter() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendParamFilterMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));

}
