/*
 * vd_amp_msg_PDC_VolumeOffset.cpp
 *
 *  Created on: Apr 4, 2017
 *      Author: pmh7kor
 */

#include "vd_amp_msg_PDC_VolumeOffset.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "../../InternalComponentCommunication/Messages/power/ID_AudioState.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/PowerState.h"
#include "../../InternalComponentCommunication/Messages/Diag/IDDiagDefSet.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/DiagDefSetType.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "../../Beep/Beep_defines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_PDC_VolumeOffset.cpp.trc.h"
#endif

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"


/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::vd_amp_msg_PDC_VolumeOffset(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
 * Constructor
 *******************************************************************************/

vd_amp_msg_PDC_VolumeOffset::vd_amp_msg_PDC_VolumeOffset(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_PDC_VolumeOffset")
{
  m_s16DBValue = 0;
  m_AmplifierConfig = 0;
  m_ptrloader = ptrloader;
    m_ptrreceiver = ptrx;
  m_AudioState = EN_AUDIO_STATE_OFF;
  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset::vd_amp_msg_PDC_VolumeOffset constructor. "));
  vAddObserver();
  pAudUsrDpIf   = AudioUserDpIfSelect::pGetAudUsrDpIf();
}

/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::vAddObserver()
 *******************************************************************************/
void vd_amp_msg_PDC_VolumeOffset::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyParkAssistVolume);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_AudioState);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_DiagDefSet);
  }

}

/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::sendPDCVolumeOffset()
 * Sending PDC Volume offset to Amplifier if it is connected
 *******************************************************************************/
void vd_amp_msg_PDC_VolumeOffset::sendPDCVolumeOffset()
{
  ETG_TRACE_USR4(("sendPDCVolumeOffset() called"));
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
      ETG_TRACE_USR4(("Active Plugin : %d", m_ptrreceiver->u16GetActivePlugin()));
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  int API_Version = ptr_plugin_sender->iGetPluginSenderAPIVersion();
  if(API_Version > 3)
  {
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrPDCVolumeOffsetSender);
    tU8 u8ParkAssistVol = 0;
  tS32 s32Res = 0;
    s32Res=pAudUsrDpIf->s32GetParkAssistVolume(u8ParkAssistVol);
    ETG_TRACE_USR4((" s32Res: %d", s32Res));

    ETG_TRACE_USR4((" PDC Volume Level read from Datapool : %d", u8ParkAssistVol));
    m_s16DBValue  = s16GetVolumeOffset(u8ParkAssistVol);

    tmp.m_ptrPDCVolumeOffsetSender->vAmp_PDCVolumeLevel(m_s16DBValue);
  }
}


/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::MessageNotification(PO_MessageConfig::enID MsgId)
 *******************************************************************************/
void vd_amp_msg_PDC_VolumeOffset::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);
  switch(MsgId)
   {
  case PO_MessageConfig::ID_NotifyParkAssistVolume:
    {
      const ID_NotifyParkAssistVolume* pMsg = pPO->POMessages->QueryMessage<ID_NotifyParkAssistVolume>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("Received Park Assist Volume : %d", pMsg->m_volume));
    tS32 s32Res = 0;
      s32Res=pAudUsrDpIf->s32SetParkAssistVolume(pMsg->m_volume);
      ETG_TRACE_USR4((" s32Res: %d", s32Res));
      if(m_AmplifierConfig == EXTAMP_CONNECTED)
      {
         //Send PDC Volume offset only if External amplifier is connected.
         sendPDCVolumeOffset();
      }
    }
    break;
    case PO_MessageConfig::ID_AudioState:
    {
      const ID_AudioState* pMsg = pPO->POMessages->QueryMessage<ID_AudioState>(MsgId);
      AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);
      ETG_TRACE_USR4(("AudioState status: 0x%4x.", pMsg->AudioState));
      m_AudioState = pMsg->AudioState;
       if(pMsg->AudioState == EN_AUDIO_STATE_ON)
         sendPDCVolumeOffset();
    }
    break;
    case PO_MessageConfig::ID_DiagDefSet:
    {
      // Obtaining the Diag DefSet
      const ID_DiagDefSet* pMsgDefSet = pPO->POMessages->QueryMessage<ID_DiagDefSet>(MsgId);
      ETG_TRACE_USR4(("DefSet received Type = %x, Phase =%x", pMsgDefSet->enDiagDefSetType, pMsgDefSet->enDiagDefSetPhase));

      //sending the default value of PDC Volume offset when factory reset is done
      if(pMsgDefSet->enDiagDefSetPhase == EN_DEFSET_FINISH)
        sendPDCVolumeOffset();
    }
    break;

    default:
      break;
  }
}
/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::vd_Amp_Msg_IndPDCVolOffset(vdamp_pluginID_t  pluginID,int16_t swSteps)const
 *******************************************************************************/

void  vd_amp_msg_PDC_VolumeOffset::vd_Amp_Msg_IndPDCVolOffset(vdamp_pluginID_t  pluginID,int16_t swSteps)const
{
  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset:Received swSteps 0x%4x ", swSteps));
  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset:Received pluginID 0x%4x .", pluginID));

}

/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::vd_Amp_Msg_ErrPDCVolOffset(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
 *******************************************************************************/
void vd_amp_msg_PDC_VolumeOffset::vd_Amp_Msg_ErrPDCVolOffset(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset:Received errorcode 0x%4x from plugin : 0x%4x amp_PDCVolumeoffsets_sender.", ErrorCode,PluginID));
}

/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::vReloadExtAmpData_PDCVolOffset(tU8 ampconfig)
 *******************************************************************************/
void vd_amp_msg_PDC_VolumeOffset::vReloadExtAmpData_PDCVolOffset(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_Settings() called"));

  m_AmplifierConfig = ampconfig;
  if((ampconfig == EXTAMP_CONNECTED) && (m_AudioState == EN_AUDIO_STATE_ON))
  {
    //Reload the latest received Post Office message values
    sendPDCVolumeOffset();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}

/*******************************************************************************
 *
 * FUNCTION: vd_amp_msg_PDC_VolumeOffset::s16GetVolumeOffset(tU8 PDCVolumeLvl)
 *******************************************************************************/

tS16 vd_amp_msg_PDC_VolumeOffset::s16GetVolumeOffset(tU8 PDCVolumeLvl)
{
  ETG_TRACE_USR4(("vd_amp_msg_PDC_VolumeOffset::s16GetVolumeOffset() called"));

  tS16 ret = 0;
  switch (PDCVolumeLvl)
  {
    case VOLUME_LEVEL_0:
      ret = VOLOFFSET_LVL0;
      break;
    case VOLUME_LEVEL_1:
      ret = VOLOFFSET_LVL1;
      break;
    case VOLUME_LEVEL_2:
      ret = VOLOFFSET_LVL2;
      break;

    case VOLUME_LEVEL_3:
      ret = VOLOFFSET_LVL3;
      break;

    case VOLUME_LEVEL_4:
      ret = VOLOFFSET_LVL4;
      break;

    case VOLUME_LEVEL_5:
      ret = VOLOFFSET_LVL5;
      break;

    default:
      break;
  }
  return ret;
}
