/*
 * vd_amp_msg_InputVolumeOffset.h
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_INPUTVOLUMEOFFSET_H_
#define VD_AMP_MSG_INPUTVOLUMEOFFSET_H_


#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/Messages/Volume/IDSetInputVolumeOffset.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_InputVolumeOffset : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_InputVolumeOffset(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndInputVolumeOffset(vdamp_pluginID_t  PluginID, amp_tenStream stream, uint16_t offset, amp_tenVolumeOffsetStatus Status)const;
  void vd_Amp_Msg_ErrInputVolumeOffset(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
    virtual ~vd_amp_msg_InputVolumeOffset()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;
      }
  virtual void MessageNotification(PO_MessageConfig::enID MsgId);
  void vReloadExtAmpData_InputVolumeOffset(tU8 ampconfig);

private:
    void vAddObserver();
    void sendInputVolOffsetMessage();

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;

    tenStream Stream;
    tS16 Offset;
};

#endif /* VD_AMP_MSG_INPUTVOLUMEOFFSET_H_ */
