/*
 * vd_amp_msg_InputVolumeOffset.cpp
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */


#include "vd_amp_msg_InputVolumeOffset.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_InputVolumeOffset.cpp.trc.h"
#endif


vd_amp_msg_InputVolumeOffset::vd_amp_msg_InputVolumeOffset(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_InputVolumeOffset")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset::vd_amp_msg_InputVolumeOffset constructor. "));

  Stream = EN_AUDIO_SOURCE_STREAM_DEFAULT;
  Offset = 0x00;
  vAddObserver();

}

void vd_amp_msg_InputVolumeOffset::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetInputVolumeOffset);
  }

}


void vd_amp_msg_InputVolumeOffset::sendInputVolOffsetMessage()
{

  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrInputVolumeOffsetSender);
  ETG_TRACE_USR4(("vAmp_InputVolumeOffset called"));

  tmp.m_ptrInputVolumeOffsetSender->vAmp_InputVolumeOffset((amp_tenStream)Stream,(uint16_t)Offset);

}

void vd_amp_msg_InputVolumeOffset::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_InputVolume::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);

  const MSG_SetInputVolumeOffset*     pMsg = pPO->POMessages->QueryMessage<MSG_SetInputVolumeOffset>(MsgId);

  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset received Stream: 0x%4x.", pMsg->values.m_enStream));
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset reveived in Offset: 0x%4x.", pMsg->values.s16Offset));
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset Offset in ramplin: 0x%4x.", pMsg->values.u16RampLin));
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset Offset in rampdB: 0x%4x.", pMsg->values.u16RampdB));

  Stream = pMsg->values.m_enStream;
  Offset = pMsg->values.s16Offset;
  sendInputVolOffsetMessage();
}


void  vd_amp_msg_InputVolumeOffset::vd_Amp_Msg_IndInputVolumeOffset(vdamp_pluginID_t  PluginID, amp_tenStream stream, uint16_t offset, amp_tenVolumeOffsetStatus Status)const
{
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset:Received Stream: 0x%4x  ", stream));
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset:Received Offset 0x%4x ", offset));
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset:Received status Id 0x%4x .", Status));
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset:Received Plugin ID Id 0x%4x .", PluginID));
}


void vd_amp_msg_InputVolumeOffset::vd_Amp_Msg_ErrInputVolumeOffset(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_InputVolumeOffset:Received errorcode 0x%4x from plugin : 0x%4x amp_mute_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_InputVolumeOffset::vReloadExtAmpData_InputVolumeOffset(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_InputVolumeOffset() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendInputVolOffsetMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));

}
