/*
 * vd_amp_GraphFilter.cpp
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_GraphFilter.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_GraphFilter.cpp.trc.h"
#endif



vd_amp_msg_GraphFilter::vd_amp_msg_GraphFilter(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_GraphFilter")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter::vd_amp_msg_GraphFilter constructor. "));

  EquID = 0x00;
  EquBand = 0x00;
  Gain = (tS16)0xFF88; //gen4 prio3 compiler warning fix
  FrequencyIndex = 0x14;

  vAddObserver();

}

void vd_amp_msg_GraphFilter::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_GraphFilter::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_EquSetting);
  }

}
void vd_amp_msg_GraphFilter::sendGraphFilterMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrSetGraphFilterSender);
  ETG_TRACE_USR4(("vAmp_GraphFilter called"));
  tmp.m_ptrSetGraphFilterSender->vAmp_SetGraphFilter(EquID,EquBand,
                                              Gain , (amp_tenFrequencyIndex)FrequencyIndex);
}

void vd_amp_msg_GraphFilter::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter::MessageNotification entered. "));

  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);

  const MSG_EquSetting*     pMsg = pPO->POMessages->QueryMessage<MSG_EquSetting>(MsgId);

  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter  received u8EquID: 0x%4x.", pMsg->values.u8EquID));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter received u8EquBand: 0x%4x.", pMsg->values.u8EquBand));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter received s16Gain: 0x%4x.", pMsg->values.s16Gain));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter received u8FrequencyIndex: 0x%4x.", pMsg->values.u8FrequencyIndex));

  EquID = pMsg->values.u8EquID ;
  EquBand = pMsg->values.u8EquBand;
  Gain = pMsg->values.s16Gain;
  FrequencyIndex = pMsg->values.u8FrequencyIndex;

  sendGraphFilterMessage();
}


void  vd_amp_msg_GraphFilter::vd_Amp_Msg_IndGraphFilter(vdamp_pluginID_t  PluginID, uint8_t EqID, uint8_t Band,
                                                      int16_t gain, amp_tenFrequencyIndex FreqIndex)const
{
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter:Received FilterID 0x%4x ",   EqID));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter:Received Characteristic 0x%4x .", Band));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter:Received Order 0x%4x .", gain));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter:Received Frequency 0x%4x .", FreqIndex));
  ETG_TRACE_USR4(("vd_amp_msg_GraphFilter:Received PluginID: 0x%4x  ", PluginID));
}

void vd_amp_msg_GraphFilter::vd_Amp_Msg_ErrGraphFilter(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_GraphFilter:Received errorcode 0x%4x from plugin : 0x%4x amp_graphfiolter_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_GraphFilter::vReloadExtAmpData_GraphFilter(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_GraphFilter() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendGraphFilterMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));

}

