/*
 * vd_amp_msg_CarSettings.cpp
 *
 *  Created on: Jan 27, 2014
 *      Author: sea6kor
 */

#include "vd_amp_msg_CarSettings.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "fc_audiomanager_trace.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/vd_amp_msg_CarSettings.cpp.trc.h"
#endif


vd_amp_msg_CarSettings::vd_amp_msg_CarSettings(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx)
:IF_MessageObserver<PO_MessageConfig::enID>("vd_amp_msg_CarSettings")
{
  m_ptrloader = ptrloader;
  m_ptrreceiver = ptrx;
  ETG_TRACE_USR4(("vd_amp_msg_CarSettings::vd_amp_msg_CarSettings constructor. "));

  CarSettingType = EN_AUDIO_CAR_SPEED_ID;
  Value = 0x00;
  vAddObserver();

}

void vd_amp_msg_CarSettings::vAddObserver()
{

  ETG_TRACE_USR4(("vd_amp_msg_CarSettings::vAddObserver"));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_amp_msg_CarSettings::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CarSetting);
  }

}

void vd_amp_msg_CarSettings::sendCarSettingMessage()
{
  vdamp_plugin_sender* ptr_plugin_sender = NULL;

  if((m_ptrreceiver!=NULL)&&(m_ptrloader!=NULL))
  {
    ETG_TRACE_USR4(("m_ptrMain!=NULL"));
      ptr_plugin_sender  =   m_ptrloader->poGetPluginSender(m_ptrreceiver->u16GetActivePlugin());
  }

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (ptr_plugin_sender);

  ETG_TRACE_USR4(("oGetInterfaceData called"));
  vdamp_plugin_sender_interfaces tmp = ptr_plugin_sender->oGetInterfaceData();

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (tmp.m_ptrCarSettingSender);

  ETG_TRACE_USR4(("vAmp_Carettings called"));
  tmp.m_ptrCarSettingSender->vAmp_CarSetting((amp_tenCarSettingType)CarSettingType , Value);

}

void vd_amp_msg_CarSettings::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("vd_amp_msg_CarSettings::MessageNotification entered. "));
  InternalCommunicationAdapter* pPO; // Pointer for post office access
  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE (pPO);

  const ID_CarSetting*     pMsg = pPO->POMessages->QueryMessage<ID_CarSetting>(MsgId);

  ETG_TRACE_USR4(("vd_amp_msg_CarSettings enCarSettingType: 0x%4x.", pMsg->enCarSettingType));
  ETG_TRACE_USR4(("vd_amp_msg_CarSettings s16Value: 0x%4x.", pMsg->s16Value));

  CarSettingType = pMsg->enCarSettingType;
  Value = pMsg->s16Value;
  sendCarSettingMessage();
}

void vd_amp_msg_CarSettings::vd_Amp_Msg_ErrCarSettings(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const
{
  ETG_TRACE_USR4(("vd_amp_msg_CarSettings:Received errorcode 0x%4x from plugin : 0x%4x amp_carsetting_sender.", ErrorCode,PluginID));
}

void vd_amp_msg_CarSettings::vReloadExtAmpData_CarSettings(tU8 ampconfig)
{
  ETG_TRACE_USR4(("vReloadExtAmpData_CarSettings() called"));

  if(ampconfig == EXTAMP_CONNECTED)
  {
    //Reload the latest received Post Office message values
    sendCarSettingMessage();
  }

  else
  ETG_TRACE_USR4(("External amplifier not present.."));
}

