/*
 * vd_amp_msg_BeepParam.h
 *
 *  Created on: Jan 25, 2014
 *      Author: sea6kor
 */

#ifndef VD_AMP_MSG_BEEPPARAM_H_
#define VD_AMP_MSG_BEEPPARAM_H_

#include "InternalCommunicationAdapter.h"
#include "../../../PostOffice/PostOffice.hpp"
#include "../vd_amp_if/vd_amp_plugin_loader.h"
#include "../vd_amp_if/vd_amp_plugin_tx_rx.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDSignalToneParameters.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDCCAUPATempMute.h"
#include "../../InternalComponentCommunication/Messages/Beep/ID_ADASSoundCollection.h"
#include "../../InternalComponentCommunication/Messages/Beep/ID_NotifyParkAssistVolume.h"
#include "../../InternalComponentCommunication/Messages/Beep/ID_NotifyLDWUserVolume.h"
#include "../../InternalComponentCommunication/Messages/Beep/ID_NotifyBeepName.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-send.h"
#include "../../../ext_amp_plugins/template/interface/vdamp-plugin-receive.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Ext_Amp_ConnectionState.h"
#include "util/Macro.h"

class vd_amp_msg_beepparam : public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
  vd_amp_msg_beepparam(plugin_loader* ptrloader, vd_amp_if_tx_rx *ptrx);
  void vd_Amp_Msg_IndBeepParam(vdamp_pluginID_t  PluginID, amp_tenBeepID SignalBeepID, uint8_t SignalToneID,uint16_t Freq,int16_t Gain)const;
  void vd_Amp_Msg_ErrBeepParam(vdamp_pluginID_t  PluginID, uint8_t ErrorCode)const;
    virtual ~vd_amp_msg_beepparam()
    {
    InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
      m_ptrloader = NULL;
      m_ptrreceiver = NULL;

    }

    virtual void MessageNotification(PO_MessageConfig::enID MsgId);
    void vReloadExtAmpData_BeepParam(tU8 ampconfig);
private:
    void vAddObserver();
    void sendBeepParamMessage();
   void  vd_Amp_Msg_SendSettingsMessage(amp_tenSettingType enSettingType, int16_t swSteps);

    plugin_loader* m_ptrloader ;
    vd_amp_if_tx_rx* m_ptrreceiver;

  tU8 tU8_SignalToneID;
  tU8 tU8_SignalBeepID;
  tU16 tU16_Frequency;
  tS16 tS16_Gain;


};


#endif /* VD_AMP_MSG_BEEPPARAM_H_ */
