/*
 * FunctionID_Defines.h
 *
 *  Created on: Jul 25, 2014
 *      Author: sea6kor
 */

#ifndef FUNCTIONID_DEFINES_H_
#define FUNCTIONID_DEFINES_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "trace_if.h"

#define CONFIGURATION                 0x001
#define  VOLUME                        0x140
#define  BASS                          0x141
#define  MIDDLE                        0x142
#define  TREBLE                        0x143
#define  BALANCE                       0x144
#define  FADER                         0x145
#define  AUDIOPILOT_MODE               0x120
#define  SOUNDSHAKIT_MODE              0x130
#define  SSV_SETTING                   0x131
#define  SPEED                         0x132
#define  SURROUND_VOL                  0x110
#define  SURROUND_MODE                 0x111
#define  INTERRUPT_MODE                0x150
#define  TEL_NAVI_MUTE                 0x158
#define  SPEAKER_TEST_REQ             0x028
#define  AMP_SELF_DIAGNOSTIC          0x020
#define AMP_SOFTWARE_VERSION         0x011
#define  AMP_PARAMETER_VERSION           0x012
#define  AMP_HARDWARE_VERSION            0x010
#define  DESTINATION                     0x031
#define  AMP_SETTING                     0x029
#define  AMP_AVAILABLE_FUNCTION          0x100
#define  AMP_SETTING_VALUE               0x14A
#define  AMP_VOLUME_VALUE                0x14B
#define  AMP_CHANNEL                     0x485
#define  FR_RR_MUTE                      0x109
#define  SWRC_MUTE                       0x613
#define  AMP_DOWNMIX_MODE                0x112
#define  SOUND_STAGE_OPTIMISATION         0x614
#define  RESET_SETTINGS_FUNCTION          0x615
#define  OPEN_TOP_STATUS                  0x113
#define  GENERAL_SPEAKERTEST_REQ          0x027
#define  GENERAL_AMP_SELF_DIAGNOSTIC     0x021
#define  AMP_AVAILABLE_FUNCTION_EXT      0x101
#define  CUSTOM_PRESET                   0x133
#define  DRIVER_SOUND_MODE               0x114
#define  REAR_SOUND_MODE                 0x115
#define  AMP_2CH_INPUT_SURROUND_LINE_MODE    0x032
#define  INTERRUPT_SONAR_MODE             0x151
#define  AUX_GAIN                         0x134
#define DIGITAL_ASSISTANT_REQUEST        0x129
#define  AMP_VOLUME_VALUE_ITGEN5          0x14C
#define  ANC_SOFTWARE_VERSION           0x013
#define  ASC_SOFTWARE_VERSION           0x014
#define  ANC_ASC_SETTING                 0x02A
#define  ANC_ASC_SELF_DIAGNOSTIC           0x02B
#define  ANC_ASC_ACTIVE_TEST              0x02C
#define USER_DATA_COPY                   0x136
#define  USER_DATA_DELETE                 0x137
#define  MUTE_CONTROL                     0x200
#define  FORCED_MUTE                      0x203
#define SURROUND_AMP_GENERAL_VEHICLE            1
#define STEREO_AMP_GENERAL_VEHICLE              2

//MCAN optypes
#define MCAN_OP_TYPE_INCREMENT     0x02
#define MCAN_OP_TYPE_DECREMENT     0x03
#define MCAN_OP_TYPE_STATUS        0x0c
#define MCAN_OP_TYPE_INDICATION    0x0d

//timer interval
#define MASTER_AMPLIFIER_TIME_INTERVAL 1500
#define MASTER_AMPLIFIER_TIME_INTERVAL_1 2500
#define MASTER_AMPLIFIER_TIME_INTERVAL_ISM 3300 //for interrupt sonar mode

// for TRC lines

#define MCAN_MASTER_CHANNEL_ID 0x06
#define MCAN_AUDIO_CHANNEL_ID 0x30
#define MCAN_MSG_TX    0x10
#define MCAN_MSG_RX    0x20


//Trace for Audio Amplifier
#define ET_TRACE_INFO_AUDIOAMP_TX(u16Command,DataLen,au8Data)     \
  ET_TRACE_INFO_BIN( TR_CLASS_BOSE_AMPLIFIER,             \
    ET_EN_T8 _ MCAN_AUDIO_CHANNEL_ID _              \
    ET_EN_T8 _ MCAN_MSG_TX _                  \
    ET_EN_T16 _ MCAN_EXTRACT_MSG_ID(u16Command) _        \
    ET_EN_T8 _ MCAN_EXTRACT_OP_TYPE(u16Command) _        \
    ET_EN_T8LIST _ DataLen _ au8Data _              \
    ET_EN_DONE );

#define ET_TRACE_INFO_AUDIOAMP_RX(u16MsgId,u8OpTypeCode,u16Length,pu8Data)     \
    ET_TRACE_INFO_BIN( TR_CLASS_BOSE_AMPLIFIER,          \
    ET_EN_T8 _ MCAN_AUDIO_CHANNEL_ID _              \
    ET_EN_T8 _ MCAN_MSG_RX _                  \
    ET_EN_T16 _ u16MsgId _                    \
    ET_EN_T8 _ u8OpTypeCode _                  \
    ET_EN_T8LIST _ u16Length _ pu8Data _            \
    ET_EN_DONE );



//Trace for Master Amplifier
#define ET_TRACE_INFO_MASTERAMP_TX(u16Command,DataLen,au8Data)     \
  ET_TRACE_INFO_BIN( TR_CLASS_BOSE_AMPLIFIER,             \
    ET_EN_T8 _ MCAN_MASTER_CHANNEL_ID _              \
    ET_EN_T8 _ MCAN_MSG_TX _                  \
    ET_EN_T16 _ MCAN_EXTRACT_MSG_ID(u16Command) _        \
    ET_EN_T8 _ MCAN_EXTRACT_OP_TYPE(u16Command) _        \
    ET_EN_T8LIST _ DataLen _ au8Data _              \
    ET_EN_DONE );

#define ET_TRACE_INFO_MASTERAMP_RX(u16MsgId,u8OpTypeCode,u16Length,pu8Data)     \
    ET_TRACE_INFO_BIN( TR_CLASS_BOSE_AMPLIFIER,          \
    ET_EN_T8 _ MCAN_MASTER_CHANNEL_ID _              \
    ET_EN_T8 _ MCAN_MSG_RX _                  \
    ET_EN_T16 _ u16MsgId _                    \
    ET_EN_T8 _ u8OpTypeCode _                  \
    ET_EN_T8LIST _ u16Length _ pu8Data _            \
    ET_EN_DONE );

//max range for relative values
#define MAX_STEP_RANGE 6
union BasicFunction_Union
{
    tU8 BasicFunctionValue;
  struct BasicFunction_Bits
    {
      tBool TestTone : 1 ;//2(pow,0)..LSB
      tBool Fader : 1;
      tBool Balance : 1;
      tBool Treble : 1;
      tBool Middle : 1;
      tBool Bass : 1;
      tBool Reserved :2;//2(pow,7)...MSB

    }BasicFunction_Bits_Obj;

};//BasicFunction;For Amp_Available_Function(100h)


union HighEndFunction_Union
{
    tU8 HighEndFunctionValue;
  struct HighEndFunction_Bits
    {
        tBool AmpSelfDiag : 1 ;//2(pow,0)..LSB
        tBool SurroundMODE : 1;
        tBool SSV : 1;
        tBool SoundShakit : 1;
        tBool AudioPILOT : 1;
        tBool SurroundVOL : 1;
        tBool DownMix :1;
        tBool FF_FR_Mute :1;//2(pow,7)...MSB

    }HighEndFunction_Bits_Obj;

};//HighEndFunction;For Amp_Available_Function(100h)

union ExtendedFunction_Union
{
  tU16 ExtendedFunctionValue;
  struct ExtendedFunction_Bits
  {
        tU8 Reserved1 : 1 ;//2(pow,0)..LSB
        tU8 DriverSoundMode : 1;//2(pow,1)..LSB
        tU8 Reserved2 : 1;//2(pow,2)..LSB
        tU8 Reserved3 : 1;//2(pow,3)..LSB
        tU8 CustomPreset : 1;//2(pow,4)..LSB
        tU8 GeneralDiag : 1;//2(pow,5)..LSB
        tU8 RearSoundMode :1;//2(pow,6)..LSB
        tU8 BOSEStudioSurround :1;//2(pow,7)...MSB
        tU8 SurroundInfoDisp : 1 ;//2(pow,8)..LSB
        tU8 ParkAssistant : 1;//2(pow,9)..LSB
        tU8 SonarVolFun : 1;//2(pow,10)..LSB
        tU8 VolumeRangeMAX40 : 1;//2(pow,11)..LSB
        tU8 DigitalAssistant : 1;//2(pow,12)..LSB
        tU8 ANC :1;//2(pow,13)..LSB
        tU8 ASC :1;//2(pow,14)...MSB
        tU8 CenterPoint :1;//2(pow,15)...MSB
  }ExtendedFunction_Bits_obj;

};//Extended_Function;For Amp_Available_Function_Ext(101h)

union MsgVersionUnion
{
  tU32 MsgVersionVal;
  struct MsgVersionBits
  {
    tU8 Reserve:8;
    tU8 Middle:8;
    tU8 Upper:8;
  }MsgVersionBits_obj;

};//Msg_Version;


union AvailSettingsUnion
{
  tU16 AvailSettingsValue;
  struct AvailSettingsBits
  {
      tBool Bass : 1;
      tBool Middle: 1;
      tBool Treble: 1;
      tBool Balance: 1;
      tBool Fader: 1;
      tBool AmpDownMix: 1;
      tBool SurroundVol: 1;
      tBool AudioPilot: 1;
      tBool Gala: 1;
      tBool SurroundMode: 1;
      tBool RearSoundMode: 1;
      tBool DrivenSoundMode: 1;
      tBool ANC:1;
      tBool ASC:1;
  }AvailSettingsBits_obj;

};

enum enStartUpSequenceState
{
  DEFAULT_STATE,
  CONFIGURATION_STATUS_RECEIVED,
  DESTINATION_GET_RECEIVED,
  DESTINATION_STATUS_SENT,
  AMP_AVAIL_FUNC_INDICATION_RCVD,
  AMP_AVAIL_FUNC_INDICATION_EXT_RCVD,
  CUSTOMER_PRESET_SET_SEND,
  CUSTOMER_PRESET_STATUS_RECEIVED,
  STARTUP_SEQ_COMPLETED
};

enum tenAudioSoundType
{
  EN_AUDIO_SND_TYPE_ABS       = 0x01,
  EN_AUDIO_SND_TYPE_INC       = 0x02,
  EN_AUDIO_SND_TYPE_DEC       = 0x03,
  EN_AUDIO_SND_TYPE_NOT_DEF   = 0xFF
};


enum tenAudioVolumeType
{
  EN_VOLUME_TYPE_ABS       = 0x01,
  EN_VOLUME_TYPE_INC       = 0x02,
  EN_VOLUME_TYPE_DEC       = 0x03,
  EN_VOLUME_TYPE_NOT_DEF   = 0xFF
};

enum tenAudioResourceType
{
  EN_AUDIO_RESOURCE_NOT_DEF       = 0x00,
  EN_AUDIO_RESOURCE_LS            = 0x01,
  EN_AUDIO_RESOURCE_HP            = 0x02
};
enum tenAudioChannelType
{
  EN_AUDIO_CHANNEL_NOT_DEF        = 0xFF,
  EN_AUDIO_CHANNEL_EXC            = 0x01,
  EN_AUDIO_CHANNEL_MIX            = 0x02,
  EN_AUDIO_CHANNEL_MIX2           = 0x03
};
enum tenSourceVolumeType
{
  EN_SOURCE_AUDIO        = 0x01,
  EN_SOURCE_PTY_TA      = 0x02,
  EN_SOURCE_TELEPHONE      = 0x03,
  EN_SOURCE_TELEPHONE_RING  = 0x04,
  EN_SOURCE_NAVIGATION_A    = 0x05,
  EN_SOURCE_NAVIGATION_B    = 0x06,
  EN_SOURCE_AUTO_DJ      = 0x07,
  EN_SOURCE_SONAR        = 0x08,
  EN_SOURCE_PARK_ASSIST    = 0x09,
  EN_SOURCE_TYPE_NOT_DEF      = 0xFF
};

enum InterruptSonarMode
{
  Normal_Mode = 0,
  NaviSource_AudioOn_Mode =1 ,
  NaviSource_AudioOff_Mode =2,
  AutoDJ_Mode = 3,
  TEL_Comm_Mode = 4,
  TEL_Ring_Mode = 5,
  Navi_TEL_Comm_Mode = 6,
  Navi_TEL_Ring_Mode = 7,
  TEL_ImitaionRing_Mode = 8,
  NAVI_TELImitationRing_Mode = 9,
  AutoDj_AudioOn_Mode = 10,
  Sonar_AudioOn_Mode = 11,
  Sonar_TEL_Comm_Mode = 12,
  Sonar_TEL_Ring_Mode = 13,
  Sonar_TEL_Imitaion_Mode = 14,
  ParkAssistant_Mode = 15,
  ParkAssistant_Sonar_Mode = 16,
  CarPlay_Ducking_Mode = 17,
  Undef

};

enum enDestination
{
  NONE=0 ,
  JAPAN = 1,
  USA = 2,
  CANADA = 3,
  EUROPE_R =4,
  EUROPE_L = 5,
  AUSTRALIA = 6,
  MIDDLEEAST = 7,
  OTHER = 0x0FF

};

enum KDS_Vehicle_Information_Region
{
   US = 0x0,
   CAN,
   MEX,
   UK,
   TKY,
   RUS,
   other_EUR,
   PRC,
   TWN,
   HKG_Macau,
   GCC,
   EGP,
   ASR_NZE,
   BRA,
   AGT,
   other_LAC,
   SAF,
   THI,
   SGP,
   MLY,
   BRN,
   INN,
   VNM,
   PHL,
   IND,
   JPN,
   KOR,
   other_GOM,
   ISR
};

enum SteeringPosition
{
  LHD = 0,
  RHD = 1
};
enum SourceGroup
{
    SRC_NONE = 0,
  SRC_TUN_MEDIA = 1,
  SRC_PHONE   = 2,
  SRC_RINGTONE = 3,
  SRC_NAVI_TTS = 4,
  SRC_SMS_VR_TTS_PHONE = 5,
  SRC_SONAR = 6,
  SRC_TCU_TTS = 7,
  SRC_IPA_TTS_FAP = 8,
  SRC_AUDIOOFF = 9,
  SRC_CARPLAY_DUCKING = 10,
  SRC_UNDEF
};

enum tenTelNaviMuteState
{
    Mute_Off = 0,
    Tel_MuteOn = 1,
    Navi_MuteOn = 2,
    Tel_Navi_MuteOn = 3
};


enum AmpConnectionState
{
  AMP_NOT_CONNECTED         = 0x00,
  AMP_CONNECTED           = 0x01
};

enum tenSoundSettingType
{
EN_AUDIO_SOUND_VOLUME         = 0x00,
EN_AUDIO_SOUND_BASS           = 0x01,
EN_AUDIO_SOUND_TREBLE         = 0x02,
EN_AUDIO_SOUND_BALANCE         = 0x03,
EN_AUDIO_SOUND_FADER         = 0x04,
EN_AUDIO_SOUND_LOUDNESS         = 0x05,
EN_AUDIO_SOUND_SUBW           = 0x06,
EN_AUDIO_SOUND_MID           = 0x07,
EN_AUDIO_SOUND_HPAS           = 0x08,
EN_AUDIO_SOUND_GALA           = 0x09,
EN_AUDIO_SOUND_AUDPILOT         = 0x10,
EN_AUDIO_SOUND_VOLOFFSET       = 0x11,
EN_AUDIO_SOUND_DYNCOMP               = 0x12,
EN_AUDIO_SOUND_OPTIMIZATION       = 0x13,
EN_AUDIO_SOUND_PDC_ATTENUATION_LEVEL = 0x14,
EN_AUDIO_SOUND_EQ_PRESET       = 0x15,
EN_AUDIO_SOUND_SURROUND_VOL       = 0x16,
EN_AUDIO_SOUND_SURROUND_MODE     = 0x17,
EN_AUDIO_SOUND_AMP_DOWNMIX_MODE     = 0x18,
EN_AUDIO_SOUND_DRIVER_SOUND_MODE   = 0x19,
EN_AUDIO_SOUND_REAR_SOUND_MODE     = 0x20,
EN_AUDIO_SOUND_REAR_MUTE           = 0x21,
EN_AUDIO_SOUND_NOT_DEF               = 0xFF
};

struct VersionInfo
{
  tU8 Higher;
  tU8 Middle;
  tU8 Lower;
};

enum tensonarLocation
{
  None = 0x00,
  LR = 0x01,
  RR = 0x02,
  LR_RR = 0x03,
  LF = 0x04,
  LF_RF = 0x0c,
  RF = 0x08

};

enum te8SoundRequestAndDirection
{
  No_Sound_Request = 0,
  FrontLeft = 1,
  FrontCentre = 2,
  FrontRight =3 ,
  RearLeft = 4,
  RearCentre = 5 ,
  RearRight = 6,
  Reserve = 7
};

struct ANCASCSelfDiagResult
{
  tU8 m_u8diagResultSummary;

  tU8 Mic1Connection;
  tU8 Mic1Result;

  tU8 Mic2Connection;
  tU8 Mic2Result;

  tU8 Mic3Connection;
  tU8 Mic3Result;

  tU8 Mic4Connection;
  tU8 Mic4Result;

  tU8 m_u8DoorOpenClose;
  tU8 m_u8EnginePulse;
  tString m_ANCASCConfigInfo;

  inline ANCASCSelfDiagResult():
    m_u8diagResultSummary(0),
    Mic1Connection(0),
    Mic1Result(0),
    Mic2Connection(0),
    Mic2Result(0),
    Mic3Connection(0),
    Mic3Result(0),
    Mic4Connection(0),
    Mic4Result(0),
    m_u8DoorOpenClose(0),
    m_u8EnginePulse(0),
    m_ANCASCConfigInfo(NULL){};
};

enum SonarState
{
  SONAR_ON = 0,
  SONAR_OFF = 1
};

enum MicrophoneResult
{
  EN_MIC_NORMAL        = 0x00,
  EN_MIC_OPEN          = 0x01,
  EN_MIC_SHORT         = 0x02,
  EN_MIC_SHORT_BAT     = 0x03,
  EN_MIC_SHORT_GND     = 0x04,
  EN_MIC_AMP_OVER_TEMP = 0x05
};


enum TestResult
{
  EN_TEST_PASSED        = 1,
  EN_TEST_FAILED        = 0,
  EN_TEST_NORESULT      = -1
};

enum DiagResultSummary
{
  EN_DIAG_TEST_NOTTESTED     = 0,
  EN_DIAG_TEST_PASSED        = 1,
  EN_DIAG_TEST_FAILED        = 2
};

enum DefectType
{
  EN_DEFECT_OPEN = 01,
  EN_DEFECT_SHORT = 02,
  EN_DEFECT_SHORT_TO_BATTERY = 03,
  EN_DEFECT_SHORT_TO_GROUND = 04,
  EN_DEFECT_AMP_OVER_TEMP = 05,
  EN_DEFECT_UNDEF
};


typedef enum
{
  AUDIOAMPLIFIER_MCANUNIT,
  MASTERAMPLIFIER_MCANUNIT
} bose_TenMCAN_Unit;


typedef enum
{
   EN_TEST_RESULT_UNKNOWN,
   EN_TEST_RESULT_PASSED,
   EN_TEST_RESULT_FAILED
} BOSE_tenTestResult;

typedef enum
{
Comm_Conn_ErrorTest,
CConf_ErrorTest,
DConf_ErrorTest
}BOSE_tenTestType;

typedef enum
{
  GUEST = 0x00,
  USER1,
  USER2,
  USER3,
  USER4
}tenCustomPreset;


//OEMType
#define OEM_TYPE_NISSAN       0x06
#define OEM_TYPE_INFINITI     0x16

#endif /* FUNCTIONID_DEFINES_H_ */
