/************************************************************************
 * FILE:         vd_adr3_thread.cpp
 * PROJECT:      NissanLCN
 * SW-COMPONENT: fc_audiomanager
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  workthread
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2009 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author   | Modification
 * 30.07.08  | Hessling | initial
 * 02.03.09  | Liebanas | adaption for fc_ipod
 *************************************************************************/


// +++ trace identifier ------- define this value for every class new
#ifdef CLASS_NUMBER
#undef CLASS_NUMBER
#endif
//#define CLASS_NUMBER TRC::TR_CLASS_VD_ADR3_MAIN
// +++ trace identifier ------- define this value for every file new
#ifdef FILE_NUMBER
#undef FILE_NUMBER
#endif
//#define FILE_NUMBER TRC::vd_adr3_thread_cpp

/*#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#include "../../fc_audiomanager_main.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
#include "trcGenProj/Header/vd_adr3Msg_thread.cpp.trc.h"
#endif*/

// --- trace identifier ------- end
//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "vd_adr3_thread.h"
#include "vd_adr3Msg_If.h"
#include "vd_adr3_main.h"
#include "aud_sinkmgr_main.h"


//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------
vd_adr3_main*            vd_adr3_thread::m_povd_adr3_main = NULL;

/*************************************************************************
*
* FUNCTION:   vd_adr3_thread
*
* DESCRIPTION: Constructor
*              A thread is created with ThreadID = CCA_C_U16_APP_AUDIO,
 *             Thread Name = "vd_adr3_thread" and stack size of 1024 and priority of 110.
*
*************************************************************************/
vd_adr3_thread::vd_adr3_thread(vd_adr3_main* povd_adr3_main):
    ahl_tclEventThread(CCA_C_U16_APP_AUDIO,"vd_adr3_thread",1024,110)
{
   //ETG_TRACE_USR4(("vd_adr3_thread() entered."));
  (tVoid)povd_adr3_main;
}

/*************************************************************************
*
* FUNCTION:   ~vd_adr3_thread
*
* DESCRIPTION: Destructor
*
* PARAMETER:  None
*
* RETURNVALUE: None
*
*************************************************************************/

vd_adr3_thread::~vd_adr3_thread()
{

}

/*************************************************************************
*
* FUNCTION:   bThreadFunction
*
* DESCRIPTION: Thread entry function for the thread vd_adr3_thread
*
* PARAMETER:  OSAL_tEventMask u32EventMask
*
* RETURNVALUE: TRUE / FALSE (tBool shall be false if thread shall leave the loop)
*
*************************************************************************/
//void threadtrace();

tBool vd_adr3_thread::bThreadFunction(OSAL_tEventMask u32EventMask)
{
  //ETG_TRACE_USR4(("bThreadFunction() entered."));
  //threadtrace();
  if((u32EventMask & EVENT_VD_ADR3_CHECK_NEXT_MESSAGE)!= FALSE)
  {
    //check flag array and send next message to ADR
    vd_adr3Msg_If::vCheckForNewRequestedMessages();
  }

  return TRUE;
}


// EOF
