#ifndef VD_ADR_IF_H
#define VD_ADR_IF_H

#include "system_types.h"
#include "vd_adr3_main.h"

/**vdu1kor: Currently commented for migration to G3 Platform.*/
#ifndef VARIANT_S_FTR_ENABLE_G3G
#include "ssi_if.h"
#endif

#ifndef E_OK
#define E_OK        0               /* Completed successfully */
#endif

#define TRACE_MSG_LEN                         (u32Length + 2)
#define AUD_ADR_MAX_PAYLOAD 9980
#define AUD_MAX_ADR_OUT_LEN ((tU16)enAdrMsgOffset_PAYLOAD_DATA + AUD_ADR_MAX_PAYLOAD)

typedef enum {
    enAdrMsgOffset_CLIENT_ID    = 0,
    enAdrMsgOffset_FBLOCK_ID    = 2,
    enAdrMsgOffset_INSTANCE_ID  = 4,
    enAdrMsgOffset_FKT_ID       = 5,
    enAdrMsgOffset_OP_TYPE      = 7,
    enAdrMsgOffset_PAYLOAD_LEN  = 8,
    enAdrMsgOffset_PAYLOAD_DATA = 10
} tenAdrMsgOffsets;


struct trMsgAdrOutput
{
    tU32 u32MsgLen;
    tU8 au8AdrMsg[(tU16)AUD_MAX_ADR_OUT_LEN];
};

typedef enum {
    enComState_Off              = 0x00,
    enComState_WaitForStartup   = 0x01,
    enComState_Run              = 0x02,
    enComState_DiagnoseSession  = 0x03
}vd_adr3_tenComState;

typedef enum{
    enADR3State_INIT             = 0x00,
    enADR3State_DEAD             = 0x01,
    enADR3State_ALIVE            = 0x02,
    enADR3State_DNL              = 0x03,
    enADR3State_Unknown          = 0xFF
}vd_adr3_tenADR3State;



class vd_adr3_main;

class vd_adr3_If
{
protected:
    vd_adr3_main *m_vd_adr3_main;

public:
    //vd_adr3_If(tVoid);
    vd_adr3_If(vd_adr3_main *poAdr3Main);
    virtual ~vd_adr3_If();


    static tBool bSend(trMsgAdrOutput  * poMsgAdrOutput);

#ifdef VARIANT_S_FTR_ENABLE_G3G
    static void vDataCon();
    static void vDataInd(tU8 * pu8Data, tU32 u32Length);
    static void vSetCommunicationState(vd_adr3_tenComState enCommunicationState);
#else
/**vdu1kor: Currently commented for migration to G3 Platform.*/
    static void vDataCon(void * pvHandle, enSsiConfState enState);
    static void vDataInd(void * pvHandle, tU8 * pu8Data, tU32 u32Length);
#endif

    static void vDeInit(void);
           void vInit(void) const;
    static tBool bGetSsiBusyState(void);
    static tBool bGetAdr3StateRunning(void);
    static void vRxStartup(void);
    static void vCallBackADRState( tU32 u32State);


    static void vClearCommunicationLostCounter(void);
    static void vStartPingTimer(void);
    static void vPingTimerCallback(tVoid);
    static void vSetLoopbackStartupMessageLost(void);
    static void vSetSystemStateDownload(void);
    static void vClearSystemStateDownload(void);
    static tBool isSBRVariant(void);

private:

    static tBool bSystemstateDownload;
    static void vOpenChannel(void);
    static void vCloseChannel(void);
    static void vOpenAdr3CtrlDevice(void);

    static void vResetAdr3(void);
    static void vResendStartupMessage(void);
};


#endif //VD_ADR_IF_H
