
// system headers
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>






#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

// component-specific headers
#include "vd_adr3_Config_Types.h"
#include "vd_adr3_Config_Streamers.h"

#include "vd_adr3_Config_MappingSection.h"

// ETG trace
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
   #include "trcGenProj/Header/vd_adr3_Config_MappingSection.cpp.trc.h"
#endif


// =============================================================================
//
//                    adr3 tcl  M a p p i n g  S e c t i o n
//
// Helper class for reading, writing, modifying and logging the mapping section
// (upper section) of an ADR3-formatted file
//
// Martin Koch, Fa. ESE, 2013 August
//

// -----------------------------------------------------------------------------

/* destructor */ adr3_tclMappingSection :: ~adr3_tclMappingSection ()
{
   try
   {
      for (size_t i = 0; i < oNames.size(); ++i)
         OSAL_DELETE[] oNames[i];
      oNames.clear();
   }
   catch (...)
   {
   }
}

// -----------------------------------------------------------------------------

tVoid adr3_tclMappingSection :: vParse (adr3_tclParser& oIn)
{
   // reading function to populate this structure from ADR3-formatted binary buffer

   tU16 contentID = oIn.u16Read();
   tU16 u16FID = oIn.u16Read();
   tU16 nodeCount = oIn.u16Read();
   tU16 mapCount = oIn.u16Read();

   if (contentID != MAP_ID)
   {
      fprintf(stderr, "improper file format: contentID = %d, u16FID = %d, nodeCount = %d, mapCount = %d"
          , contentID, u16FID, nodeCount, mapCount);
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_FATAL(("improper file format for functionID %d (usually ADR3_DATA_FUNCTION_ID + 100)"
         , u16FID))
      #endif

      oIn.vDumpHex(stderr);
      return;
   }

   tU16 HighestSetIndex = 0;
   mappingLines.resize(mapCount);
   for (size_t i = 0; i < mapCount; i++)
   {
      mappingLines[i] = oIn.u16Read();
      if (mappingLines[i] > HighestSetIndex)
         HighestSetIndex = mappingLines[i];
   }

   nodes.resize(nodeCount);
   for (size_t i = 0; i < nodeCount; i++)
   {
      nodes[i].line = oIn.u16Read();
      nodes[i].column = oIn.u16Read();
      nodes[i].item = oIn.u16Read();
   }

   oNames.resize(HighestSetIndex);
   for (size_t i = 0; i < oNames.size(); ++i)
   {
      (tVoid) oIn.u16Read();  // SetID
      oNames[i] = oIn.sRead();
   }
}

// -----------------------------------------------------------------------------

tVoid adr3_tclMappingSection :: vSerialize (adr3_tclSerializer& oOut) const
{
   // writing function to fill this structure into ADR3-formatted binary buffer

   oOut.vWriteU16 ((tU16)nodes.size());
   oOut.vWriteU16 ((tU16)mappingLines.size());
   for (size_t i = 0; i < mappingLines.size(); ++i)
      oOut.vWriteU16 (mappingLines[i]);

   for (size_t i = 0; i < nodes.size(); ++i)
   {
      oOut.vWriteU16 (nodes[i].line);
      oOut.vWriteU16 (nodes[i].column);
      oOut.vWriteU16 (nodes[i].item);
   }

   for (size_t i = 0; i < oNames.size(); ++i)
   {
      oOut.vWriteU16 ((tU16)(1 + i));
      oOut.vWriteString(oNames[i]);
   }
}

// -----------------------------------------------------------------------------

tU32 adr3_tclMappingSection :: u32SerializedSize () const
{
   // returns number of bytes required to serialize this object

   tU32 u32Size = 4;  // nodeCount + lineCount
   u32Size += (tU32)(sizeof(tU16) * (3 * nodes.size() + mappingLines.size()));

   for (size_t i = 0; i < oNames.size(); ++i)
   {
      size_t length = 0;
      if (oNames[i])
         length = strlen(oNames[i]);
      u32Size += (tU32)(sizeof(tU16) * (2 + length));
   }

   return u32Size;
}

// -----------------------------------------------------------------------------


tVoid adr3_tclMappingSection :: vPrintLog (FILE* pLog) const
{
  if (pLog)
  {
      fprintf(pLog, "\n---   Mapping Section   ---\n\n");
      fprintf(pLog, "functionID = %d, %u nodes and %u mapping lines\n", u16ConfigFID, (tUInt)(nodes.size()), (tUInt)(mappingLines.size()));

      for (size_t i = 0; i < mappingLines.size(); i++)
         fprintf(pLog, "%d, ", mappingLines[i]);
      fprintf(pLog, "\n");

      fprintf(pLog, "node information:\nmapping line, config item, value\n");
      for (size_t i = 0; i < nodes.size(); i++)
         fprintf(pLog, "\t%d\t%d\t%d\n", nodes[i].line, nodes[i].column, nodes[i].item);

      fprintf(pLog, "\nmapping line names\n");
      for (size_t i = 0; i < oNames.size(); ++i)
         fprintf(pLog, "\tSet %u:\t%s\n", (tUInt)(1 + i), oNames[i]);
  }

   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_FATAL(("\t\t\t\t\t\t\t\t\t"))
      ETG_TRACE_FATAL(("\t\t\t---   Mapping Section   ---\t\t\t\t"))
      ETG_TRACE_FATAL(("\t\t\t\t\t\t\t\t\t"))
      ETG_TRACE_FATAL(("\tfunctionID = %d, %d nodes and %d mapping lines\t\t\t", u16ConfigFID, nodes.size(), mappingLines.size()))
      for (size_t i = 0; i < mappingLines.size(); i++)
         ETG_TRACE_FATAL(("\tline %d:\tuses data set %d,\t\t\t\t\t\t", i + 1, mappingLines[i]))

      ETG_TRACE_FATAL(("\t--- node information:\t\t\t\t\t\t"))
      for (size_t i = 0; i < nodes.size(); i++)
         ETG_TRACE_FATAL(("\tmapping line %d,\tconfig item %d\tvalue: %d\t\t\t\t", nodes[i].line, nodes[i].column, nodes[i].item))

      ETG_TRACE_FATAL(("\t--- mapping line names\t\t\t\t\t\t"))
      for (size_t i = 0; i < oNames.size(); ++i)
         ETG_TRACE_FATAL(("\tSet %d:\t%s\t\t\t\t\t", 1 + i, oNames[i]))
   #endif
}

// -----------------------------------------------------------------------------

