
// system headers
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>





#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



// component-specific headers
#include "vd_adr3_Config_Types.h"
#include "vd_adr3_Config_Streamers.h"
#include "vd_adr3_Config_MappingSection.h"
#include "vd_adr3_Config_DataSection.h"

#include "vd_adr3_Config_File.h"


// ETG trace
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
   #include "trcGenProj/Header/vd_adr3_Config_File.cpp.trc.h"
#endif


// =============================================================================
//
//                              A u d i o  F i l e


/* constructor */ adr3_tclFile :: adr3_tclFile (const adr3_tenDataFunctionID enDataFID, adr3_tclParser& oParser)
   : sName(oParser.sGetName())
   , oVersion()
   , poMap(new adr3_tclMappingSection(enDataFID))
   , poData(new adr3_tclDataSection(enDataFID))
{
   // read default configuration
   oParser.vRewind();
   try
   {
      vParse(oParser);
   }
   catch (...)
   {
      oParser.vDumpHex(NULL);
   }
}

// -----------------------------------------------------------------------------

/* constructor */ adr3_tclFile :: adr3_tclFile (adr3_tenDataFunctionID enDataFID)
   : sName(adr3_tclParser::sGetDpElementName(enDataFID))
   , oVersion()
   , poMap(new adr3_tclMappingSection(enDataFID))
   , poData(new adr3_tclDataSection(enDataFID))
{
   // read default configuration
   adr3_tclParser P(enDataFID);
   try
   {
      vParse(P);
   }
   catch (...)
   {
      P.vDumpHex(NULL);
   }
}

// -----------------------------------------------------------------------------

/* destructor */ adr3_tclFile :: ~adr3_tclFile()
{
   try
   {
      delete poMap;
      delete poData;
   }
   catch (...)
   {
   }
   sName = NULL;
}

// -----------------------------------------------------------------------------

tVoid adr3_tclFile :: vParse (adr3_tclParser& oIn)
{
   oVersion = oIn.oReadVersion();
   poMap->vParse(oIn);
   poData->vParse(oIn);
}

// -----------------------------------------------------------------------------

adr3_tDataDimensions adr3_tclFile :: oGetDataSetDimensions() const
{
   return poData->oGetDimensions();
}


// -----------------------------------------------------------------------------

tVoid adr3_tclFile :: vSerialize (adr3_tclSerializer& oOut) const
{
   // common identifiers
   oOut.vWriteU16(MAP_ID);
   oOut.vWriteU16((tU16)(poData->enDataFunctionID));
   oOut.vUpdateVersion(oVersion);

   // mapping table section
   poMap->vSerialize(oOut);

   // data section headers
   const tU16 setLength = 3;
   oOut.vWriteU16(CONF_ID);
   oOut.vWriteU16(poMap->u16ConfigFID);
   oOut.vWriteU16(setLength);

   // data section
   poData->vSerialize(oOut);

   // checksum
   oOut.vUpdateCRC();
}

// -----------------------------------------------------------------------------

tU32 adr3_tclFile :: u32SerializedSize() const
{
   tU32 u32Size = 8;    //  Version + common header
   u32Size += poMap->u32SerializedSize();
   u32Size += 6;  // common data section header
   u32Size += poData->u32SerializedSize();
   u32Size += 4;   // CRC checksum

   return u32Size;
}

// -----------------------------------------------------------------------------


tVoid adr3_tclFile :: vPrintLog (FILE* pLog) const
{
   if (pLog)
      fprintf(pLog, "File Version %d, dated 20%02d-%d-%d\n"
        , oVersion.majorVersion, oVersion.year, oVersion.month, oVersion.day);

   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_FATAL(("--------------------------------------------------------------------------------------------"))
      ETG_TRACE_FATAL(("\tName = %s\t\t\t", sName))
      ETG_TRACE_FATAL(("\tFile Version %d, dated 20%02d-%d-%d\t"
         , oVersion.majorVersion, oVersion.year, oVersion.month, oVersion.day))
   #endif

   poMap->vPrintLog(pLog);
   poData->vPrintLog(pLog);

   #if defined VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_FATAL(("--------------------------------------------------------------------------------------------"))
   #endif
}

// -----------------------------------------------------------------------------

tVoid adr3_tclFile :: vUpdateDataPoolElement() const
{
   // persistence support

   adr3_tclSerializer(*this).vUpdateDatapoolElement();
}

// -----------------------------------------------------------------------------

tBool adr3_tclFile :: bSendToADR3() const
{
   // validate preconditions
   if (NULL == poData)
   {
      ETG_TRACE_ERR(("adr3_tclFile::vSendToADR3() - invalid pointer poData"))
      return FALSE;
   }

   // make changes effective
   return adr3_tclSerializer(*this).bSendToADR(poData->enDataFunctionID);

}

// -----------------------------------------------------------------------------

tU32 adr3_tclFile :: u32FindDataSetIndexFromName(tCString sSearchName) const
{
   if (sSearchName && strlen(sSearchName))
   {
      for (tU32 i = 0; i < poData->oDataSets.size(); ++i)
         if ((poMap->oNames.size() > i) && (0 == strcmp(sSearchName, poMap->oNames[i])))
         {
            ETG_TRACE_USR3(("u32FindDataSetIndexFromName() returned %u for %s"
               , i, sSearchName))
            return i;  // OK, we have found the given name
         }
   }

   // bad, no match found
   if (sSearchName)
   {
      ETG_TRACE_COMP(("u32FindDataSetIndexFromName() returned INVALID_HANDLE for %s"
         , sSearchName))
      for (tU32 i = 0; i < poData->oDataSets.size(); ++i)
         ETG_TRACE_USR2(("\tpoMap->oNames[%u] = %s ", i, poMap->oNames[i]))
   }
   else
      ETG_TRACE_ERR(("u32FindDataSetIndexFromName() - Name not given - returning INVALID_HANDLE"))

   return OSAL_C_INVALID_HANDLE;
}

// -----------------------------------------------------------------------------

adr3_tclDataSet& adr3_tclFile :: roAddDataSet()
{
   poData->oDataSets.resize(1 + poData->size());
   poData->oDataSets.back().vAllocate(poData->oGetDimensions());
   return poData->oDataSets.back();
}

// -----------------------------------------------------------------------------

adr3_tclDataSet& adr3_tclFile :: roAddMappedDataSet(tCString sRefName)
{
   if (NULL == sRefName)
      sRefName = "";   // make sure we have at least an empty string

   // add new data set mapping line and insert its name into name list
   tU16 u16NewMappingLineIndex = (tU16)poMap->oNames.size();
   poMap->oNames.push_back(new char[1 + strlen(sRefName)]);
   if (poMap->oNames.back())
      strcpy(poMap->oNames.back(), sRefName);

   // scan nodes for references to last mapping line index
   tBool bAlreadyReferenced = FALSE;
   for (tU32 i = 0; i < poMap->nodes.size(); ++i)
      if (poMap->mappingLines.size() && (poMap->nodes[i].line == poMap->mappingLines.back()))
         bAlreadyReferenced = TRUE;

   if ((0 == poMap->mappingLines.size()) || bAlreadyReferenced)
      poMap->mappingLines.push_back((tU16)(u16NewMappingLineIndex + 1));
   else
      poMap->mappingLines.back() = (tU16)(u16NewMappingLineIndex + 1);

   // insert new data set behind last previously mapped data set,
   // but before all unmapped sets
   if (poData->size() > u16NewMappingLineIndex)
      (tVoid) poData->oDataSets.insert(poData->oDataSets.begin() + u16NewMappingLineIndex , adr3_tclDataSet());
   else
      poData->oDataSets.push_back(adr3_tclDataSet());

   (*poData)[u16NewMappingLineIndex].vAllocate(poData->oGetDimensions());
   return poData->oDataSets[u16NewMappingLineIndex];
}

// -----------------------------------------------------------------------------

tVoid adr3_tclFile :: vRemoveDataSet(tU32 u32Index)
{
   if (poData->size() <= u32Index)
   {
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
         ETG_TRACE_FATAL(("ERROR: invalid index %d for erase\n", u32Index))
      #else
         printf("ERROR: invalid index %d for erase\n", u32Index);
      #endif
      return;
   }

   poData->oDataSets.erase(poData->oDataSets.begin() + u32Index);

   // if this has been a mapped data set, also remove mapping entries
   if (poMap->oNames.size() > u32Index)
   {
      // delete name
      delete[] poMap->oNames[u32Index];
      poMap->oNames.erase(poMap->oNames.begin() + u32Index);

      // delete references in mapping lines
      for (tMappingLineIterator it = poMap->mappingLines.begin(); it != poMap->mappingLines.end(); /* ++it */)
      {
         if (*it == (u32Index + 1))
         {
            vRemoveReferencingNodes((tU32)(it - poMap->mappingLines.begin()));
            it = poMap->mappingLines.erase(it);
            continue;  // skip incrementing iterator
         }
         else if (*it > (u32Index + 1))
         {
            *it = (tU16)(*it - 1);
         }

         ++it;
      }
   }
   ETG_TRACE_USR4(("vRemoveDataSet %u, now %u mapping lines", u32Index, poMap->mappingLines.size()))
}

// -----------------------------------------------------------------------------

tVoid adr3_tclFile :: vRemoveAllDataSets()
{
   // remove all elements
   while (poData->size())
      vRemoveDataSet(0);
}

tVoid adr3_tclFile :: vRemoveAllDataSets(const adr3_tDataDimensions& roNewDimensions)
{
   if (poData)
   {
      vRemoveAllDataSets();
      poData->oDimensions = roNewDimensions;
   }
}

// -----------------------------------------------------------------------------

tVoid adr3_tclFile :: vRemoveReferencingNodes(tU32 u32LineID)
{
   for (tNodeIterator it = poMap->nodes.begin(); it != poMap->nodes.end(); /* ++it */)
   {
      if (it->line == (u32LineID + 1))
      {
         it = poMap->nodes.erase(it);
         continue;  // skip incrementing iterator
      }
      else if (it->line > (u32LineID + 1))
         it->line = (tU16)(it->line - 1);

      ++it;
   }
}

// -----------------------------------------------------------------------------

tVoid  adr3_tclFile :: vAddMappedNode(tU16 u16DataSetIndex, tU16 line, tU16 column, tU16 item)
{
   // validate that referenced data set exists
   if ((NULL == poData) || (NULL == poMap))
   {
      ETG_TRACE_ERR(("vAddMappedNode: invalid pointer  poData = %p, poMap %p"
         , poData, poMap))
      return;
   }
   if (poData->size() < u16DataSetIndex)
   {
      ETG_TRACE_ERR(("vAddMappedNode: u16DataSetIndex parameter out of range: %u, limit %u"
         ,  u16DataSetIndex, poData->size()))
      return;
   }
   else if ((line < 1) || (line > poMap->mappingLines.size() + 1))
   {
      ETG_TRACE_ERR(("vAddMappedNode: line parameter out of range: 1 <= %u <= %u"
         , line, poMap->mappingLines.size() + 1))
      return;
   }

   // find out, whether the requested mapping line is already there
   tBool bMappingLineExists = FALSE;
   for (tU32 i = 0; i < poMap->nodes.size(); ++i)
      if (line == poMap->nodes[i].line)
         bMappingLineExists = TRUE;

   // add mapping line reference
   if (bMappingLineExists)
   {
      ETG_TRACE_USR4(("vAddMappedNode: mapping line %u already exists", line))
   }
   else if (line < poMap->mappingLines.size() + 1)
   {
      ETG_TRACE_USR4(("vAddMappedNode: inserting %u. mapping line %u for data set %u"
         , poMap->mappingLines.size() + 1, line, u16DataSetIndex))
      (tVoid) poMap->mappingLines.insert(poMap->mappingLines.begin() + line - 1, u16DataSetIndex);
   }
   else
   {
      ETG_TRACE_USR4(("vAddMappedNode: appending %u. mapping line %u for data set %u"
            , poMap->mappingLines.size() + 1, line, u16DataSetIndex))
      poMap->mappingLines.push_back(u16DataSetIndex);
   }

   // add new node
   poMap->nodes.push_back(adr3_tMappingNode(line, column, item));
}

// -----------------------------------------------------------------------------

