
// system headers
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>




#include <vector>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#include "vd_adr3_Config_Types.h"
#include "vd_adr3_Config_Streamers.h"
#include "vd_adr3_Config_DataSection.h"


// ETG trace
#include "fc_audiomanager_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
   #include "trcGenProj/Header/vd_adr3_Config_DataSection.cpp.trc.h"
#endif


// =============================================================================
//
// dummy objects to provide writing locations in case the operator[]
// are called with invalid index arguments

adr3_tclDataSet oDummySet;
adr3_tclDataRow oDummyRow(oDummySet, 0);
tS16  s16DummyData  = 0;

// =============================================================================
//
//                               tcl  D a t a  S e t
//
// -----------------------------------------------------------------------------

/* default constructor */ adr3_tclDataSet :: adr3_tclDataSet ()
   : oDimensions()
   , poData(NULL)
{
}

// -----------------------------------------------------------------------------

/* constructor */ adr3_tclDataSet :: adr3_tclDataSet (const adr3_tDataDimensions& roDimensions)
   : oDimensions(roDimensions)
   , poData(new tS16[oDimensions.u16Columns * oDimensions.u16Rows()])
{
}

// -----------------------------------------------------------------------------

/* copy constructor */ adr3_tclDataSet :: adr3_tclDataSet (const adr3_tclDataSet& coRef)
   : oDimensions(coRef.oDimensions)
   , poData(NULL)
{
   tU32 u32Size = oDimensions.u16Columns * oDimensions.u16Rows();
   if (0 < u32Size)
      poData = new tS16[u32Size];

   if (poData)
      (tVoid) memcpy(poData, coRef.poData, sizeof(tS16) * u32Size);
}

// -----------------------------------------------------------------------------

/* virtual destructor */ adr3_tclDataSet :: ~adr3_tclDataSet ()
{
   if (poData)
      delete[] poData;
}

// -----------------------------------------------------------------------------

tVoid adr3_tclDataSet :: vAllocate(const adr3_tDataDimensions& roDimensions)
{

   oDimensions = roDimensions;

   if (poData)
      delete[] poData;
   poData = NULL;

   tU32 u32Dim = oDimensions.u16Columns * oDimensions.u16Rows();
   if (0 < u32Dim)
      poData = new tS16[u32Dim];

   if (poData)
      memset(poData, 0, sizeof(tS16) * u32Dim);
}

// -----------------------------------------------------------------------------

tVoid adr3_tclDataSet :: vParse (adr3_tclParser& oIn)
{
   if (NULL == poData)
      return;

   // ---   data section data  ---
   for (size_t j = 0; j < (size_t)oDimensions.u16Rows(); ++j)
   {
      tS16* paDataLine = &poData[j * oDimensions.u16Columns];
      for (size_t k = 0; k < oDimensions.u16Columns; ++k)
         paDataLine[k] = oIn.s16Read();
   }
}

// -----------------------------------------------------------------------------

tVoid  adr3_tclDataSet :: vSerialize(adr3_tclSerializer& oOut) const
{
   if (NULL == poData)
      return;

   for (tU32 j = 0; j < (tU32)(oDimensions.u16Rows() * oDimensions.u16Columns); ++j)
      oOut.vWriteS16(poData[j]);
}

// -----------------------------------------------------------------------------


tVoid adr3_tclDataSet :: vPrintLog(FILE* pLog) const
{
   for (tS16 j = 0; j < (tS16)oDimensions.u16Rows(); ++j)
   {
      if (NULL == poData)
         continue;

      tS16* paDataLine = &poData[j * oDimensions.u16Columns];

      char u8Line[239] = "\t";  // maximum length of ETG trace
      sprintf(u8Line + strlen(u8Line), "%d:\t", oDimensions.s16Min + j);
      for (size_t k = 0; k < oDimensions.u16Columns; ++k)
         if (strlen(u8Line) < 228) // assume max 10 bytes for this entry
         {
            sprintf(u8Line + strlen(u8Line), "%d\t", paDataLine[k]);
         }
         else
         {  // not enough space left in line
            if (strlen(u8Line) < 234) // add truncation ellipsis if possible
               sprintf(u8Line + strlen(u8Line), "...\t");
            break;  // stop further printing anyway
         }

      if (pLog)
          fprintf(pLog, "%s\n", u8Line);

      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
         ETG_TRACE_FATAL(("%s", u8Line))
      #endif
   }
}


//tVoid adr3_tclDataSet :: vPrintLog(FILE* pLog) const
//{
//   for (size_t j = 0; j < (size_t)oDimensions.u16Rows(); ++j)
//   {
//      fprintf(pLog, "%d:\t", oDimensions.s16Min + j);
//      tS16* paDataLine = &poData[j * oDimensions.u16Columns];
//      for (size_t k = 0; k < oDimensions.u16Columns; ++k)
//         fprintf(pLog, "%d\t", paDataLine[k]);
//      fprintf(pLog, "\n");
//   }
//}


// -----------------------------------------------------------------------------

adr3_tclDataSet& adr3_tclDataSet :: operator=(const adr3_tclDataSet& roRef)
{
   // assignment operator

   if (&roRef == this)
      return *this;

   oDimensions = roRef.oDimensions;

   if (poData)
      delete[] poData;
   poData = NULL;

   if (roRef.poData)
   {
      poData = new tS16[oDimensions.u16Columns * oDimensions.u16Rows()];
      if (poData)
         memcpy(poData, roRef.poData, sizeof(tS16) * oDimensions.u16Columns * oDimensions.u16Rows());
   }

   return *this;
}

// -----------------------------------------------------------------------------

adr3_tclDataRow  adr3_tclDataSet :: operator[] (tU32 u32RowIndex) const
{
   if (oDimensions.u16Rows() && (u32RowIndex < oDimensions.u16Rows()))
      return adr3_tclDataRow(*this, u32RowIndex);
   else
      return oDummyRow;
}

// =============================================================================
//
//                               D a t a  R o w
//

/* constructor */ adr3_tclDataRow :: adr3_tclDataRow(const adr3_tclDataSet& roParent, tU32 u32RowOffset)
   : u32RowLength(roParent.oDimensions.u16Columns)
   , ps16Data(roParent.poData + u32RowOffset * u32RowLength)
{

}

// -----------------------------------------------------------------------------

tS16& adr3_tclDataRow :: operator[] (tU16 u16ColumnIndex)
{
   if (u16ColumnIndex < u32RowLength)
      return ps16Data[u16ColumnIndex];
   else
      return s16DummyData;
}

// =============================================================================
//
//                               D a t a  S e c t i o n
//

// -----------------------------------------------------------------------------

size_t adr3_tclDataSection :: size() const
{
   return oDataSets.size();
}

// -----------------------------------------------------------------------------

adr3_tclDataSet&  adr3_tclDataSection :: operator[](size_t DataSetIndex)
{
   if (DataSetIndex < oDataSets.size())
      return oDataSets[DataSetIndex];
   else
      return oDummySet;
}

// -----------------------------------------------------------------------------

const adr3_tclDataSet& adr3_tclDataSection :: operator[](size_t DataSetIndex) const
{
   if (DataSetIndex < oDataSets.size())
      return oDataSets[DataSetIndex];
   else
      return oDummySet;
}

// -----------------------------------------------------------------------------

tVoid adr3_tclDataSection :: vParse (adr3_tclParser& oIn)
{
   // parsing operator

   // ---   data section header  ---
   (tVoid) oIn.u16Read();  // content ID
   (tVoid) oIn.u16Read();  // configuration function ID
   (tVoid) oIn.u16Read();  // setlength
   (tVoid) oIn.u16Read();  // another content ID
   oDimensions.s16Min = oIn.s16Read();
   oDimensions.s16Max = oIn.s16Read();
   oDimensions.u16Columns = oIn.u16Read();
   (tVoid) oIn.u16Read();  // another content ID
   (tVoid) oIn.u16Read();  // dataFunctionID

   (tVoid) oIn.u16Read();  // dataSetLength
   tU16 setCount = oIn.u16Read();

   oDataSets.resize(setCount, adr3_tclDataSet());
   for (size_t i = 0; i < setCount; i++)
   {
      adr3_tclDataSet& roDataSet = (*this)[i];
      roDataSet.vAllocate(oDimensions);
      roDataSet.vParse(oIn);
   }
}

// -----------------------------------------------------------------------------

tVoid adr3_tclDataSection :: vSerialize (adr3_tclSerializer& oOut) const
{
   oOut.vWriteU16 (MAP_ID);
   oOut.vWriteS16 (oDimensions.s16Min);
   oOut.vWriteS16 (oDimensions.s16Max);
   oOut.vWriteU16 (oDimensions.u16Columns);

   oOut.vWriteU16 (CONF_ID);
   oOut.vWriteU16 ((tU16)enDataFunctionID);
   oOut.vWriteU16 ((tU16)(oDimensions.u16Rows() * oDimensions.u16Columns));
   oOut.vWriteU16 ((tU16)oDataSets.size());

   for (tU32 i = 0; i < oDataSets.size(); ++i)
      oDataSets[i].vSerialize(oOut);
}

// -----------------------------------------------------------------------------

tU32  adr3_tclDataSection :: u32SerializedSize () const
{
   tU32 u32Size = 0;  // common data section header

   u32Size += 16;  // common data section header
   u32Size += (tU32)(oDataSets.size() * sizeof(tS16) * oDimensions.u16Rows() * oDimensions.u16Columns);

   return u32Size;
}

// -----------------------------------------------------------------------------

tVoid adr3_tclDataSection :: vPrintLog (FILE* pLog) const
{
   if (pLog)
   {
      fprintf(pLog, "\n---   Data Section   ---\n\n");
      fprintf (pLog, "%u sets with %u bytes; lines from %d to %d, having %u columns"
         , (tUInt)(oDataSets.size()), oDimensions.u16Rows() * oDimensions.u16Columns, oDimensions.s16Min, oDimensions.s16Max, oDimensions.u16Columns);
   }

   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_TRACE_FATAL(("\t\t\t\t\t\t\t\t\t"))
      ETG_TRACE_FATAL(("\t\t\t---   Data Section   ---\t\t\t\t"))
      ETG_TRACE_FATAL(("\t\t\t\t\t\t\t\t\t"))
      ETG_TRACE_FATAL(("\t%d sets with %u values each; lines from %d to %d, having %u columns\t"
         , oDataSets.size(), oDimensions.u16Rows() * oDimensions.u16Columns, oDimensions.s16Min, oDimensions.s16Max, oDimensions.u16Columns))
   #endif

   for (size_t i = 0; i < oDataSets.size(); ++i)
   {
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
         ETG_TRACE_FATAL(("\tSet %d\t\t\t\t\t\t", 1 + i))
      #endif
      oDataSets[i].vPrintLog(pLog);
   }
}

// -----------------------------------------------------------------------------

