///////////////////////////////////////////////////////////
//  vd_adr3_Config.h
//  Implementation of the Class vd_adr3Msg_source
//  Created on:      22-Nov-2012 15:00:00
//  Original author: daw2hi
//  Redesigner     : kma4hi
///////////////////////////////////////////////////////////

#ifndef VD_ADR3_CONFIG_H
#define VD_ADR3_CONFIG_H


class ID_NotifySoundConfigVersion;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#include "vd_amp_MCANBose_MasterAmplifier_Defines.h"
#endif
//observer class
class vd_adr3_config : public IF_MessageObserver<PO_MessageConfig::enID>
{
   // member variables
private:
   static tU8 u8ItemValueSpeaker;
   static tU8 u8ItemValueSystem;
   static tU8 u8ItemValueRegion;
   static tU8 u8ItemValueVehicle;
   static adr3_tenDataFunctionID enFileInSynchronization;  // ID of ADR3 sound file requested in initial synchronization sequence

public:
   vd_adr3_config();
   virtual ~vd_adr3_config();

   // PostOffice callback
   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

   static void vPrintSoundConfigFile(tU8 u8FileID, FILE* pLog) ;

   // modify current configuration items. Parameters left at UNDEF will be ignored
   static void vSetConfigItem(tU8 u8ItemValueSpeaker = SOUND_CONFIG_ITEM_VALUE_UNDEF
         , tU8 u8ItemValueSystem = SOUND_CONFIG_ITEM_VALUE_UNDEF
         , tU8 u8ItemValueRegion = SOUND_CONFIG_ITEM_VALUE_UNDEF
         , tU8 u8ItemValueVehicle = SOUND_CONFIG_ITEM_VALUE_UNDEF);

private:
   // methods
   static void vCheckSoundConfigVersion(const ID_NotifySoundConfigVersion* pMsgSoundConfigVersion);
   static void vRequestSoundConfigVersion(adr3_tenDataFunctionID enFileID);
   static adr3_tenDataFunctionID enGetNextConfigFileID (adr3_tenDataFunctionID enCurrentFileID);
   static void vSendConfigFile(adr3_tenDataFunctionID enFileID, const tU8* pu8FileBuf, tU32 u32Length, tBool bSave = FALSE);
   static void vSendSoundConfigItem(void);
   static void vSendSoundConfigSave(adr3_tenDataFunctionID enFileID);
#if 0 // just for testing
   void vGetConfigFile(tU8 u8FileID);
#endif

   static tBool bIsSoundToolFlagSet(void);
};


#endif // !defined(VD_ADR3_CONFIG_H)
