///////////////////////////////////////////////////////////
//  vd_adr3_config.cpp
//  Implementation of the Class vd_adr3_conifg
//  Created on:      22-Nov-2012 15:01:00
//  Original author: daw2hi
///////////////////////////////////////////////////////////

// OSAL framework
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include <etrace_if.h> // implicitly links "osal_if.h"

#include "vd_adr3Msg_If.h"
#include "InternalCommunicationAdapter.h"
#include "Messages/power/ID_ApplicationStatus.h"
#include "Messages/Startup/IDNotifyStartup.h"    // implicitly links PostOffice.hpp
#include "Messages/SoundConfig/IDNotifySoundConfigVersion.h"
#include "Messages/SoundConfig/IDNotifySendSoundConfigFile.h"
#include "Messages/SoundConfig/IDNotifyADRSoundSystem.h"
#include "vd_adr3_Config_Types.h"
#include "vd_adr3_Config_File.h"
#include "vd_adr3_Config_Streamers.h"
#include "vd_adr3_Config.h"
#include "fc_audiomanager_trace.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_audio_if.h"

#define MICROPHONE_TYPE_HDM   0X03
#define OEM_TYPE_NISSAN       0x06

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define DEACTIVE 0
#define ERROR 2
#define US 0
#define CAN 1
#define MEX 2
#define UK 3
#define TKY 4
#define EUR 6
#define TWN 8
#define HKG 9
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
   //#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_CONFIG
   #include "trcGenProj/Header/vd_adr3_Config.cpp.trc.h"
#endif

// =============================================================================
//
//                     class  vd_adr3  C o n f i g
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#include "Messages/BOSE_Amp/ID_BOSE_Amplifier_ConnectionStatus.h"
#endif

#include "../../fc_audiomanager_service_Audio_Function.h"
/********************************************************************************
 * static members
 *******************************************************************************/

/* static */ adr3_tenDataFunctionID vd_adr3_config :: enFileInSynchronization = UNDEFINED; // ID of ADR3 sound file requested in initial synchronization sequence
/* static */ tU8 vd_adr3_config :: u8ItemValueSpeaker = SOUND_CONFIG_ITEM_VALUE_4SPEAKER;
/* static */ tU8 vd_adr3_config :: u8ItemValueSystem = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM1;
/* static */ tU8 vd_adr3_config :: u8ItemValueRegion = SOUND_CONFIG_ITEM_VALUE_EUROPE;
/* static */ tU8 vd_adr3_config :: u8ItemValueVehicle = SOUND_CONFIG_ITEM_VALUE_UNDEF;


/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3_config :: vd_adr3_config ()
   : IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3_config")
{

   ETG_TRACE_USR4(("vd_adr3_config::vd_adr3_config constructor. "));

   PostOffice<PO_MessageConfig::enID>* POMessages = InternalCommunicationAdapter::POMessages;
   if (NULL == POMessages)
   {
      ETG_TRACE_FATAL(("vd_adr3_config::constructor  POMessages == NULL"));
      FATAL_M_ASSERT_ALWAYS();
      return;
   }
   POMessages->AddObserver(this, PO_MessageConfig::ID_ApplicationStatus);
   POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyStartup);
   POMessages->AddObserver(this, PO_MessageConfig::ID_NotifySoundConfigVersion);
   POMessages->AddObserver(this, PO_MessageConfig::ID_NotifySendSoundConfigFile);

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    POMessages->AddObserver(this, PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus);
#endif
   vSetupCustomerSoundConfiguration();
}

/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3_config::~vd_adr3_config()
{
   vReleaseCustomerSoundConfiguration();
   InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
}

// -----------------------------------------------------------------------------

void vd_adr3_config :: MessageNotification (PO_MessageConfig::enID MsgId)
{
   PostOffice<PO_MessageConfig::enID>* POMessages = InternalCommunicationAdapter::POMessages;
   if (NULL == POMessages)
   {
      ETG_TRACE_FATAL(("vd_adr3_config::cMessageNotification  POMessages == NULL"));
      FATAL_M_ASSERT_ALWAYS();
      return;
   }

   switch(MsgId)
   {
      case PO_MessageConfig::ID_ApplicationStatus:   // launched by  PowerStateHandler.cpp
      {
         static tenApplicationStates enOldAppState = AUD_APP_PWR_EVENT_DEFAULT;
         tenApplicationStates enNewAppState
            = POMessages->QueryMessage<ID_ApplicationStatus>(MsgId)->value.m_State;
         ETG_TRACE_USR3(("ADR3 AppState Observer received state change %u -> %u"
               , ETG_ENUM(enAudioAppState, enOldAppState), ETG_ENUM(enAudioAppState, enNewAppState)));

         if ((enOldAppState == AUD_APP_PWR_EVENT_APP_OFF) && (enNewAppState == AUD_APP_PWR_EVENT_APP_NORMAL))
         {
            ETG_TRACE_USR1(("intermediate AppState OFF detected - reloading customer sound configuration ...  "))
            vSetupCustomerSoundConfiguration();

            // Re-trigger the sound configuration file comparing sequence as on ID_NotifyStartup below
            enFileInSynchronization = BASS_DATA_ID;
            vRequestSoundConfigVersion(BASS_DATA_ID);
         }

         enOldAppState = enNewAppState;
         break;
      }

      case PO_MessageConfig::ID_NotifyStartup:   // launched by    vd_adr3Msg_startup.cpp
      {
         // Obtaining the ADR3 Startup Message from PostOffice handler
         const ID_NotifyStartup* pMsgStartup = POMessages->QueryMessage<ID_NotifyStartup>(MsgId);
         ETG_TRACE_USR3(("ADR3 Startup Observer received state= %x", pMsgStartup->enOn));

         // Request the first Sound Config Version information from ADR3
         // Answers from ADR3 will be received in the next case below
         enFileInSynchronization = BASS_DATA_ID;
         vRequestSoundConfigVersion(enFileInSynchronization);
         break;
      }

      case PO_MessageConfig::ID_NotifySoundConfigVersion:  // launched by vd_adr3Msg_soundConfigVersion.cpp
      {
         // Obtaining the Sound Config Version Message from PostOffice handler
         const ID_NotifySoundConfigVersion* pMsgSoundConfigVersion = POMessages->QueryMessage<ID_NotifySoundConfigVersion>(MsgId);
         ETG_TRACE_USR4(("ADR3 SoundConfigVersion Observer received fileID = %x", pMsgSoundConfigVersion->u8FileID));
         vCheckSoundConfigVersion(pMsgSoundConfigVersion);
         break;
      }

      case PO_MessageConfig::ID_NotifySendSoundConfigFile:  // launched by  Sound\SoundToolClient.cpp
      {
         // Obtaining a SoundConfigFile to be sent to ADR3
         const ID_NotifySendSoundConfigFile* pMsgSoundConfigFile = POMessages->QueryMessage<ID_NotifySendSoundConfigFile>(MsgId);
         adr3_tenDataFunctionID enFileID = adr3_tenDataFunctionID(pMsgSoundConfigFile->u8FileID);
         ETG_TRACE_USR3(("ADR3 SendSoundConfigFile Observer received fileID= %x", enFileID));
         vSendConfigFile(enFileID,
               pMsgSoundConfigFile->pu8File, pMsgSoundConfigFile->u32Length);
         // just for a test, we save a Balance file here to see if ADR3 could take it
         //vSendSoundConfigSave(VD_ADR3_FKT_ID_FILE_ID_BAL_DATA_ID);

         break;
      }
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
      case PO_MessageConfig::ID_BOSE_Amplifier_ConnectionStatus:
      {
        //get the connection state of the BOSEAMplife
        const ID_BOSE_Amplifier_ConnectionStatus* pMsgBoseAmp_ConnectionStatus = POMessages->QueryMessage<ID_BOSE_Amplifier_ConnectionStatus>(MsgId);
        AmpConnectionState ConnectionState = (AmpConnectionState)pMsgBoseAmp_ConnectionStatus->connectionstate;
        ETG_TRACE_USR3(("ADR3 SendSoundConfigFile Observer received BOSE Amplifier cOnnection State = %x",ConnectionState));
        vSendSoundConfigItem();
      break;
      }
#endif
      default:
         ETG_TRACE_COMP(("vd_adr3_config::MessageNotification unknown Message %x",MsgId));
         break;
   }

}

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config :: vCheckSoundConfigVersion (const ID_NotifySoundConfigVersion* pMsgSoundConfigVersion)
{
   // validate preconditions
   if (NULL == pMsgSoundConfigVersion)
   {
      ETG_TRACE_FATAL(("vCheckSoundConfigVersion: invalid message pointer: pMsgSoundConfigVersion"))
      return;
   }

   // process response
   adr3_tenDataFunctionID enFileID = adr3_tenDataFunctionID(pMsgSoundConfigVersion->u8FileID);
   adr3_tenDataFunctionID enExpectedFileID = (enFileID ? enFileID :enFileInSynchronization);
   adr3_tenDataFunctionID enNextFileID = enGetNextConfigFileID (enExpectedFileID);
   if (ID_NotifySoundConfigVersion::enUnhandledFileID == pMsgSoundConfigVersion->enIsValid)
   {
      ETG_TRACE_ERR(("vCheckSoundConfigVersion: FileID %u not handled by ADR3"
            , ETG_CENUM(adr3_tenDataFunctionID,  enExpectedFileID)))

      if (enNextFileID)
         vRequestSoundConfigVersion(enNextFileID);   // Request the next
      return;
   }
   tCString sDpElementName = adr3_tclParser::sGetDpElementName(enFileID);
   if (0U == adr3_tclParser::u32GetDatapoolElementSize(sDpElementName))
   {
      ETG_TRACE_ERR(("vCheckSoundConfigVersion unknown FileID: %d (%s)", enFileID, sDpElementName))

      if (enNextFileID)
         vRequestSoundConfigVersion(enNextFileID);   // Request the next
      return;
   }

   adr3_tclParser oParser(enFileID);               // data from pool
   adr3_tclSerializer* poSerializer = NULL;        // modified data
   adr3_tclStreamerBase* poStreamer = &oParser;    // either pool or modified data

   // modify sound configuration file, if project provides modifier function
   pfnADRFileModifier pfnFileModifier = pfnGetModifierFunction(enFileID);
   if (pfnFileModifier)
   {
      ETG_TRACE_USR1(("now modifying File: %s", oParser.sGetName()))

      // parse into structured file object
      adr3_tclFile oFile(enFileID , oParser);

      // call modifier function provided by project
      (*pfnFileModifier)(oFile);

      if (et_bIsTraceActive((tU16)TR_CLASS_VD_ADR3_MAIN, (tU16)TR_LEVEL_USER_3))
         oFile.vPrintLog(NULL);

      // stream back to linear buffer
      poSerializer = new adr3_tclSerializer (oFile);
      if (poSerializer)
      {
         poStreamer = poSerializer; // use modified data
         if (oParser.oReadCRC() != poSerializer->oReadCRC())
            poSerializer->vUpdateDatapoolElement();
      }
      else
      {
         ETG_TRACE_FATAL(("vd_adr3_config :: vCheckSoundConfigVersion():  poSerializer is NULL"))
      }
   }

   // compare CRC from ADR with (modified) local file
   tU32           u32LocalCRC    = poStreamer->oReadCRC();
   tBool          bFileMatches   = u32LocalCRC && (pMsgSoundConfigVersion->u32CRC == u32LocalCRC);
   if (bFileMatches)
   {
      ETG_TRACE_USR2(("%d - match CRC (%08X), keeping ... "
         , ETG_ENUM(ADR_ConfigFile, enFileID), u32LocalCRC))
   }
   else
   {
      // Send the file
      ETG_TRACE_USR1(("Sending  %s  to ADR3 "
         , poStreamer->sGetName()));
      if (et_bIsTraceActive((tU16)TR_CLASS_VD_ADR3_MAIN, (tU16)TR_LEVEL_USER_3))
         poStreamer->vDumpHex(NULL);

      (tVoid) poStreamer->bSendToADR(enFileID);
      vSendSoundConfigSave(enFileID);
   }

   // clean-up
   if (poSerializer)
      delete poSerializer;

   // Request the next
   if (enNextFileID)
      vRequestSoundConfigVersion(enNextFileID);

}

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config :: vSendConfigFile (adr3_tenDataFunctionID enFileID, const tU8* pu8FileBuf, tU32 u32Length, tBool bSave)
{
  if (NULL == pu8FileBuf)
   {
    ETG_TRACE_ERR(("vd_adr3_config::vSendConfigFile pu8FileBuf == NULL for FileID %u", enFileID));
    return;
   }

   tCString sDpElementName = adr3_tclParser::sGetDpElementName(enFileID);
   adr3_tclParser oParser(sDpElementName, pu8FileBuf, u32Length);
   adr3_tclFile oFile(enFileID, oParser);

   if (et_bIsTraceActive(TR_CLASS_VD_ADR3_MAIN, TR_LEVEL_USER_3))
      oFile.vPrintLog(NULL);

   oFile.vUpdateDataPoolElement();
   oFile.bSendToADR3();

   // save configuration
   if (bSave)
      vSendSoundConfigSave(enFileID);

}

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config :: vPrintSoundConfigFile (tU8 u8FileID, FILE* pLog)
{
   adr3_tenDataFunctionID enDataFunctionID = adr3_enDataFunctionID(u8FileID);
   if (UNDEFINED != enDataFunctionID)
   {
      adr3_tclFile oFile(enDataFunctionID);
      oFile.vPrintLog(pLog);
   }
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   else
      ETG_TRACE_FATAL(("ADR3 configuration print-out not supported for FileID %d\t", u8FileID))
   #endif
}

// -----------------------------------------------------------------------------

#if 0 //this is just for test purpose to read back a config file
void vd_adr3_config::vGetConfigFile(tU8 u8FileID)
{
   trMsgOut oMsgOut;
   //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
   oMsgOut.u8InstId  = VD_ADR3_INST_ID_LS_1;
   oMsgOut.u16FktId  = VD_ADR3_FKT_ID_SOUND_CONFIG_SET;
   oMsgOut.enOpType  = VD_ADR3_OPTYPE_GET;
   oMsgOut.u16MsgLen = 1;
   oMsgOut.au8MsgData[0] = u8FileID;

   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}
#endif

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config :: vRequestSoundConfigVersion(adr3_tenDataFunctionID enFileID)
{
   // send a SoundConfigVersion.Get message (FID = 0xFA5) for given configuration file ID to ADR3

   ETG_TRACE_USR3(("Request Sound ConfigFile Version for %x", ETG_ENUM(ADR_ConfigFile, enFileID)))

   trMsgOut oMsgOut;
   oMsgOut.u8InstId  = VD_ADR3_INST_ID_LS_1;
   oMsgOut.u16FktId  = VD_ADR3_FKT_ID_SOUND_CONFIG_VERSION;
   oMsgOut.enOpType  = VD_ADR3_OPTYPE_GET;
   oMsgOut.u16MsgLen = 1;
   oMsgOut.au8MsgData[0] = enFileID;

   switch (enFileID)
   {
      case BASS_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_BASS;
         break;

      case MID_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_MIDRANGE;
         break;

      case TREB_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_TREBLE;
         break;

      case LOUD_LOW_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_LOUDNESS;
         break;

      case LOUD_HIGH_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_LOUDNESSHIGH;
         break;

      case BAL_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_BALANCE;
         break;

      case FAD_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_FADER;
         break;

      case CAR_EQU_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_CAREQU;
         break;

      case SRCOFF_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SOURCEOFFSET;
         break;

      case DELAY_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_DELAY;
         break;

      case SDVC_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SDVC;
         break;

      case SDVC_FILTER_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SDVC_FILTER;
         break;

      case INPUT_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SOURCEOFFSETIN;
         break;

      case OUTPUT_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SOURCEOFFSETOUT;
         break;

      case PREMIX_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_PREMIX;
         break;

      case SDDC_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SDDC;
         break;

      case OUTPUTPHASE_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_OUTPUTPHASE;
         break;

      case SD_BASS_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SD_BASS;
         break;

      case SD_TREBLE_DATA_ID:
         oMsgOut.u8ThreadMessageType = (tU8)SOUNDCONFIG_VERSION_SD_TREBLE;
         break;

      default:
         ETG_TRACE_ERR(("!!! vRequestSoundConfigVersion for undefined ConfigFileID  : %d.", enFileID));
         return;
   }

   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);

}

// -----------------------------------------------------------------------------

/* static */ adr3_tenDataFunctionID  vd_adr3_config :: enGetNextConfigFileID (adr3_tenDataFunctionID enCurrentFileID)
{
   // Control the sequence of ADR configuration file validation.

   // check for single request
   if (UNDEFINED == enFileInSynchronization)
      return UNDEFINED;

   // find next in sequence
   switch (enCurrentFileID)
   {
      case BASS_DATA_ID:         // bass -> middle
         enFileInSynchronization = MID_DATA_ID;
         break;

      case MID_DATA_ID:         // middle -> treble
         enFileInSynchronization = TREB_DATA_ID;
         break;

      case TREB_DATA_ID:         // treble -> loudness
         enFileInSynchronization = LOUD_LOW_DATA_ID;
         break;

      case LOUD_LOW_DATA_ID:     // loudness -> balance
         enFileInSynchronization = BAL_DATA_ID;
         break;

      case BAL_DATA_ID:          // balance -> fader
         enFileInSynchronization = FAD_DATA_ID;
         break;

      case FAD_DATA_ID:          // fader -> equalizer
         enFileInSynchronization = CAR_EQU_DATA_ID;
         break;

      case CAR_EQU_DATA_ID:      // equalizer -> source offset
         enFileInSynchronization = SRCOFF_DATA_ID;
         break;

      case SRCOFF_DATA_ID:       // source offset -> delay
         enFileInSynchronization = DELAY_DATA_ID;
         break;

      case DELAY_DATA_ID:        // delay -> speed dependent volume
         enFileInSynchronization = SDVC_DATA_ID;
         break;

      case SDVC_DATA_ID:         // speed dependent volume -> speed dependent dynamic compression
         enFileInSynchronization = SDDC_DATA_ID;
         break;

      case SDDC_DATA_ID:         // speed dependent dynamic compression -> source offset in
         enFileInSynchronization = INPUT_DATA_ID;
         break;

      case INPUT_DATA_ID:        // source offset in -> out
         enFileInSynchronization = OUTPUT_DATA_ID;
         break;

      case OUTPUT_DATA_ID:       // source offset out -> loudness high
         enFileInSynchronization = LOUD_HIGH_DATA_ID;
         break;

      case LOUD_HIGH_DATA_ID:    // loudness high -> output phase
         enFileInSynchronization = OUTPUTPHASE_DATA_ID;
         break;

      case OUTPUTPHASE_DATA_ID:  // output phase -> premix
         enFileInSynchronization = PREMIX_DATA_ID;
         break;

      case PREMIX_DATA_ID:       // premix -> speed dependent filter
         enFileInSynchronization = SDVC_FILTER_DATA_ID;
         break;

      case SDVC_FILTER_DATA_ID:  // speed-dependent filter -> speed-dependent bass
         enFileInSynchronization = SD_BASS_DATA_ID;
         break;

      case SD_BASS_DATA_ID:      // speed-dependent bass -> speed-dependent treble
         enFileInSynchronization = SD_TREBLE_DATA_ID;
         break;

      case SD_TREBLE_DATA_ID:    // we are done
         ETG_TRACE_USR2(("sound-file initializing sequence complete"));
         enFileInSynchronization = UNDEFINED;
         break;

      default:
         ETG_TRACE_FATAL(("next sequenced FileID requested for undefined ConfigFileID  : %d.", enCurrentFileID));
         enFileInSynchronization = UNDEFINED;
         break;
   }

   return enFileInSynchronization;
}

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config::vSetConfigItem (tU8 _u8ItemValueSpeaker, tU8 _u8ItemValueSystem
      , tU8 _u8ItemValueRegion, tU8 _u8ItemValueVehicle)
{
   // copy parameters (if not UNDEF) to member variables
   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != _u8ItemValueSpeaker)
      u8ItemValueSpeaker = _u8ItemValueSpeaker;
   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != _u8ItemValueSystem)
      u8ItemValueSystem = _u8ItemValueSystem;
   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != _u8ItemValueRegion)
      u8ItemValueRegion = _u8ItemValueRegion;
   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != _u8ItemValueVehicle)
      u8ItemValueVehicle = _u8ItemValueVehicle;

   ETG_TRACE_USR3(("vd_adr3_config::vSetConfigItem() "
      "called with parameters: Speaker %u, System %u, Region %u, Vehicle %u - "
      " State is now: Speaker %u, System %u, Region %u, Vehicle %u"
      , _u8ItemValueSpeaker, _u8ItemValueSystem, _u8ItemValueRegion, _u8ItemValueVehicle
      ,  u8ItemValueSpeaker,  u8ItemValueSystem,  u8ItemValueRegion,  u8ItemValueVehicle))

   vSendSoundConfigItem();
}

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config::vSendSoundConfigItem ()
{
   //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
   trMsgOut oMsgOut;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
    tU8 u8AmpConfig;
    //read item from the KDS key's bytes- stream
  /*if(ConnectionState == AMP_CONNECTED)*/
  {
    if((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1","OutputInformation", &u8AmpConfig, 1)))
    {
      ETG_TRACE_USR4(("Amplifier configuration from Datapool : %d", u8AmpConfig));
    }
    else
    {
      ETG_TRACE_ERR(("Error in diagnosis read "));
    }

    if (u8AmpConfig == EXTERNALAMP_BOSE2CH_MCAN)
    {
       u8ItemValueSystem = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM7;
       tU8 u8RegionType   = SOUND_CONFIG_ITEM_VALUE_UNDEF;
     if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &u8RegionType, 1))
        {
            ETG_TRACE_USR4(("Configured Region Type : %d", u8RegionType))

            switch(u8RegionType)
            {
                case US:
                case CAN:
                case MEX:
                {
                    u8ItemValueRegion = SOUND_CONFIG_ITEM_VALUE_NAR;
                    break;
                }
                case UK:
                case TKY:
                case EUR:
                {
                    u8ItemValueRegion = SOUND_CONFIG_ITEM_VALUE_EUROPE;
                    break;
                }
                case TWN:
                case HKG:
                {
                    u8ItemValueRegion = SOUND_CONFIG_ITEM_VALUE_ASIA;
                    break;
                }
                default:
                    u8ItemValueRegion = SOUND_CONFIG_ITEM_VALUE_ROW;
                    break;
            }
        }
    }
    else if(u8AmpConfig == EXTERNALAMP_BOSE_5_1CH_MCAN)
      u8ItemValueSystem = SOUND_CONFIG_ITEM_VALUE_SOUNDSYSTEM7;
    else
    {
    }
  }
#endif

  tU8 u8MicroPhoneInfo = 0x00;
#if !defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX) && !defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_INF4CV)&& !defined(VARIANT_S_FTR_ENABLE_FEAT_AUDIO_SMART)
  if(DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "Microphone", &u8MicroPhoneInfo, 1))
    {
      if(MICROPHONE_TYPE_HDM == u8MicroPhoneInfo)
        {
            u8ItemValueVehicle = SOUND_CONFIG_ITEM_VALUE_VEHICLE2;
            ETG_TRACE_USR4(("u8ItemValueVehicle = SOUND_CONFIG_ITEM_VALUE_VEHICLE2"));
        }
    }


    tU8 u8_L42N_vehicleType[] = {0x42,0x4E};
	tU8 u8VehicleType[] = {0,0};
	AUD_POINTER_CHECK_CALL_NO_RET_VALUE(fc_audiomanager_tclApp::theServer());
    fc_audiomanager_tclService_Audio_Function *pServiceAudioFct = fc_audiomanager_tclApp::theServer()-> pGetAudioFunctionptr();
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pServiceAudioFct);
	pServiceAudioFct->u8GetvehicleType(u8VehicleType);
    tU8 u8VariantInfo = pServiceAudioFct->u8GetOEMType();
    if((u8VariantInfo == OEM_TYPE_NISSAN) && (u8VehicleType[0] == u8_L42N_vehicleType[0]) && (u8VehicleType[1] == u8_L42N_vehicleType[1]))
    {
        ETG_TRACE_USR4(("L42N configured sending vehicle 3"));
        u8ItemValueVehicle = SOUND_CONFIG_ITEM_VALUE_VEHICLE3;
    }
	
 #endif  
   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != u8ItemValueRegion)
   {
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = SOUND_CONFIG_ITEM_TYPE_REGION;
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = u8ItemValueRegion;
   }

   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != u8ItemValueSystem)
   {
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = SOUND_CONFIG_ITEM_TYPE_SOUNDSYSTEM;
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = u8ItemValueSystem;
   }

   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != u8ItemValueSpeaker)
   {
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = SOUND_CONFIG_ITEM_TYPE_SPEAKER;
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = u8ItemValueSpeaker;
   }

   if (SOUND_CONFIG_ITEM_VALUE_UNDEF != u8ItemValueVehicle)
   {
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = SOUND_CONFIG_ITEM_TYPE_VEHICLE;
      oMsgOut.au8MsgData[oMsgOut.u16MsgLen++] = u8ItemValueVehicle;
   }

   ETG_TRACE_USR3(("vd_adr3_config::vSendSoundConfigItem() sending %u config item bytes to ADR3"
         , oMsgOut.u16MsgLen))

   oMsgOut.u8InstId  = VD_ADR3_INST_ID_LS_1;
   oMsgOut.u16FktId  = VD_ADR3_FKT_ID_SOUND_CONFIG_ITEM;
   oMsgOut.enOpType  = VD_ADR3_OPTYPE_SET;
   oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_ITEM;
   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
    ID_NotifyADRSoundSystem soundSystem(u8ItemValueSystem);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&soundSystem);
}

// -----------------------------------------------------------------------------

/* static */ void vd_adr3_config::vSendSoundConfigSave(adr3_tenDataFunctionID enFileID)
{
   ETG_TRACE_USR3(("Send Sound ConfigFile Save for  %x", ETG_ENUM(ADR_ConfigFile, enFileID)))

   trMsgOut oMsgOut;
   //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
   oMsgOut.u8InstId  = VD_ADR3_INST_ID_LS_1;
   oMsgOut.u16FktId  = VD_ADR3_FKT_ID_SOUND_CONFIG_SAVE;
   oMsgOut.enOpType  = VD_ADR3_OPTYPE_SET;
   oMsgOut.u16MsgLen = 1;
   oMsgOut.au8MsgData[0] = enFileID;

   switch(enFileID)
   {
   case BASS_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_BASS;
     break;
   case SD_BASS_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SD_BASS;
     break;
   case MID_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_MIDRANGE;
     break;
   case TREB_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_TREBLE;
     break;
   case SD_TREBLE_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SD_TREBLE;
     break;
   case LOUD_LOW_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_LOUDNESS;
     break;
   case LOUD_HIGH_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_LOUDNESSHIGH;
     break;
   case BAL_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_BALANCE;
     break;
   case FAD_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_FADER;
     break;
   case CAR_EQU_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_CAREQU;
     break;
   case SRCOFF_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SOURCEOFFSET;
     break;
   case DELAY_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_DELAY;
     break;
   case SDVC_DATA_ID:
     oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SDVC;
     break;
   case SDVC_FILTER_DATA_ID:
      oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SDVC_FILTER;
      break;
   case INPUT_DATA_ID:
      oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SOURCEOFFSETIN;
      break;
   case OUTPUT_DATA_ID:
      oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SOURCEOFFSETOUT;
      break;
   case PREMIX_DATA_ID:
      oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_PREMIX;
      break;
   case SDDC_DATA_ID:
      oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_SDDC;
      break;
   case OUTPUTPHASE_DATA_ID:
      oMsgOut.u8ThreadMessageType = (tU16)SOUNDCONFIG_SAVE_OUTPUTPHASE;
      break;
   default:
     ETG_TRACE_ERR(("!!! vSendSoundConfigSave for undefined configfileID   : 0x%4x.", enFileID));
     break;
   }

   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}
