///////////////////////////////////////////////////////////
//  vd_adr3Msg_volume.h
//  Implementation of the Class vd_adr3Msg_volume
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#ifndef VD_ADR3MSG_VOLUME_H
#define VD_ADR3MSG_VOLUME_H

#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Volume/ID_ADRSetVolume.h"

#include "vd_adr3Msg_If.h"

class vd_adr3Msg_volume: public IF_MessageObserver<PO_MessageConfig::enID>
{
public:
   vd_adr3Msg_volume();
   virtual ~vd_adr3Msg_volume();
   // handle changes in external amplifier connection state
   void vHandleObserver_AmpConfig(tU8 AmpConfig);

   tVoid setVolume(AmpVolumeData VolumeDataSet);

   virtual void MessageNotification(PO_MessageConfig::enID MsgId);

   static void vSendADRResponse(trMsgOut *poAdrResponse);
   static void vSendADRResponseSDVCState(trMsgOut *poAdrResponse);
private :
   static tS16 m_s16VolGain;
   static tU16 m_u16SpeedVolGain;

   static tU16 u16GetCurVolAttenuation();
   void vSendVolDataToAudProc(tU8 u8VolumeSteps);

};
#endif // !defined(VD_ADR3MSG_VOLUME_H)
