///////////////////////////////////////////////////////////
//  vd_adr3Msg_startup.cpp
//  Implementation of the Class vd_adr3Msg_startup
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_startup.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_STARTUP
#include "trcGenProj/Header/vd_adr3Msg_startup.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Startup/IDNotifyStartup.h"
#include "../../InternalComponentCommunication/Messages/power/IDNotification.h"
#include "../../util/Macro.h"


/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_startup::vd_adr3Msg_startup(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_startup")
{
  ETG_TRACE_USR4(("vd_adr3Msg_startup::vd_adr3Msg_startup constructor. "));
    (tVoid)pAdr3Main;
   pPO = InternalCommunicationAdapter::getInstance();//for solving lint error
   AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);//for solving lint error
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_startup::~vd_adr3Msg_startup()
{
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_startup::vAddObserver()const
{

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_startup::MessageNotification(PO_MessageConfig::enID MsgId)
{
  (tVoid)MsgId;
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_startup::vSendADRResponse(trMsgOut *poAdrResponse)
{
  tU8 ubOn;

  ubOn    = poAdrResponse->au8MsgData[0];
  ETG_TRACE_USR4(("vSendADRResponse received ubOn   : 0x%4x.", ubOn));

  //Delivering the ID_NotifyStartup  Message
  ID_NotifyStartup notifyStartup(static_cast<tenOn>(ubOn));
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifyStartup);

}


