///////////////////////////////////////////////////////////
//  vd_adr3Msg_soundMode.cpp
//  Implementation of the Class vd_adr3Msg_soundMode
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_soundMode.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_SOUNDMODE
#include "trcGenProj/Header/vd_adr3Msg_soundMode.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Source/IDSoundMode.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_soundMode::vd_adr3Msg_soundMode(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_soundMode")
{
  ETG_TRACE_USR4(("vd_adr3Msg_soundMode::vd_adr3Msg_soundMode constructor. "));
    (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_soundMode::~vd_adr3Msg_soundMode()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_soundMode::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_soundMode::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_soundMode::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SoundMode);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_soundMode::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_soundMode::MessageNotification entered. "));
  // Obtaining the AudiosoundMode Message from PostOffice handler by Source
  const MSG_SoundMode*     pMsg = pPO->POMessages->QueryMessage<MSG_SoundMode>(MsgId);

  ETG_TRACE_USR4(("SoundMode Observer received Stream: 0x%4x.", pMsg->enStream));
  ETG_TRACE_USR4(("SoundMode Observer received u8SoundModeMask: 0x%4x.", pMsg->u8SoundModeMask));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SOUND_MODE;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 2;
  pu8Payload[0]     = pMsg->enStream;
  pu8Payload[1]     = pMsg->u8SoundModeMask;

   //vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut, vd_adr3Msg_If::trMsgSendInfo trMsgSendInfo);
   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

