///////////////////////////////////////////////////////////
//  vd_adr3Msg_signalToneParameters.cpp
//  Implementation of the Class vd_adr3Msg_signalToneParameters
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_signalToneParameters.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_SIGNALTONEPARAMETERS
#include "trcGenProj/Header/vd_adr3Msg_signalToneParameters.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDSignalToneParameters.h"
#include "../../InternalComponentCommunication/Messages/Beep/IDNotifySignalToneParameters.h"
#include "../../InternalComponentCommunication/DataTypes/MessageDataTypes/SignalToneParameterData.h"
#include "../../util/Macro.h"

#include "Beep_defines.h"

/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_signalToneParameters::vd_adr3Msg_signalToneParameters(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_signalToneParameters")
{
  ETG_TRACE_USR4(("vd_adr3Msg_signalToneParameters::vd_adr3Msg_signalToneParameters constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_signalToneParameters::~vd_adr3Msg_signalToneParameters()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_signalToneParameters::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_signalToneParameters::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_signalToneParameters::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SignalToneParameters);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_signalToneParameters::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_signalToneParameters::MessageNotification entered. "));
  // Obtaining the AudiosignalToneParameters Message from PostOffice handler by Beep
  const MSG_SignalToneParameters*     pMsg = pPO->POMessages->QueryMessage<MSG_SignalToneParameters>(MsgId);

  ETG_TRACE_USR4(("SignalToneParam Observer received SignalToneID: 0x%4x.", pMsg->values.SignalToneID));
  ETG_TRACE_USR4(("SignalToneParam Observer received Frequency: 0x%4x.", pMsg->values.Frequency));
  ETG_TRACE_USR4(("SignalToneParam Observer received Gain: 0x%4x.", pMsg->values.Gain));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SIGNAL_TONE_PARAM;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 6;
  pu8Payload[0]     = 0x01; //pMsg->values.SignalBeepID; use fixed ID in Nissan LCN2kai
  pu8Payload[1]     = pMsg->values.SignalToneID; //0x01
  pu8Payload[2]       = (tU8) (((pMsg->values.Frequency) & 0xFF00)>>8);
  pu8Payload[3]       = (tU8) ((pMsg->values.Frequency) & 0x00FF);
  pu8Payload[4]       = (tU8) (((pMsg->values.Gain) & 0xFF00)>>8);
  pu8Payload[5]       = (tU8) ((pMsg->values.Gain) & 0x00FF);


  if(pu8Payload[1] == TRIANGULAR)
    oMsgOut.u8ThreadMessageType = SIGNALTONEPARAMETERS_TRIANGLEGEN;
  else
       oMsgOut.u8ThreadMessageType = SIGNALTONEPARAMETERS_SINUSOIDALGEN;
   vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

/********************************************************************************
 * vSendADRResponse()
 *******************************************************************************/
void vd_adr3Msg_signalToneParameters::vSendADRResponse(trMsgOut *poAdrResponse)
{
  SignalToneParameterData Values;

  Values.SignalToneID = poAdrResponse->au8MsgData[1];
  Values.Frequency   = AUD_GET_U16(&poAdrResponse->au8MsgData[2]);
  Values.Gain     = AUD_GET_U16(&poAdrResponse->au8MsgData[4]);

  ETG_TRACE_USR4(("vSendADRResponse received Values.SignalToneID   : 0x%4x.", Values.SignalToneID));
  ETG_TRACE_USR4(("vSendADRResponse received Values.Frequency: 0x%4x.", Values.Frequency));
  ETG_TRACE_USR4(("vSendADRResponse received Values.Gain: 0x%4x.", Values.Gain));


  //Delivering the ID_NotifyMute  Message back to Service Function
  ID_NotifySignalToneParameters notifySignalToneParameters(Values);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&notifySignalToneParameters);

}
