///////////////////////////////////////////////////////////
//  vd_adr3Msg_settings.cpp
//  Implementation of the Class vd_adr3Msg_settings
//  Created on:      08-Jun-2012 10:34:13
//  Original author: hag2hi
///////////////////////////////////////////////////////////

#include "vd_adr3Msg_settings.h"
#include "vd_adr3Msg_If.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3_MAIN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_ADR3MSG_SETTINGS
#include "trcGenProj/Header/vd_adr3Msg_settings.cpp.trc.h"
#endif

#include "../../../PostOffice/PostOffice.hpp"
#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/settings/IDSettings.h"
#include "../../util/Macro.h"



/********************************************************************************
 * constructor
 *******************************************************************************/

vd_adr3Msg_settings::vd_adr3Msg_settings(vd_adr3_main* pAdr3Main):
  IF_MessageObserver<PO_MessageConfig::enID>("vd_adr3Msg_settings")
{
  ETG_TRACE_USR4(("vd_adr3Msg_settings::vd_adr3Msg_settings constructor. "));
  (tVoid)pAdr3Main;
  pPO = InternalCommunicationAdapter::getInstance();
  vAddObserver();
}


/********************************************************************************
 * destructor
 *******************************************************************************/
vd_adr3Msg_settings::~vd_adr3Msg_settings()
{
  InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
  pPO = NULL;
}

/********************************************************************************
 * vAddObserver()
 *******************************************************************************/
void vd_adr3Msg_settings::vAddObserver()
{

  ETG_TRACE_USR4(("vd_adr3Msg_settings::vAddObserver"));

  if(pPO != NULL)
  {
    ETG_TRACE_USR4(("vd_adr3Msg_settings::vAddObserver  pPO != NULL"));
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_Settings);
  }
  else
  {
    FATAL_M_ASSERT_ALWAYS();
  }

}

/********************************************************************************
 * MessageNotification()
 *******************************************************************************/
void vd_adr3Msg_settings::MessageNotification(PO_MessageConfig::enID MsgId)
{
  trMsgOut oMsgOut;
  tU8 *pu8Payload = oMsgOut.au8MsgData;
  ETG_TRACE_USR4(("vd_adr3Msg_settings::MessageNotification entered. "));
  // Obtaining the settings Message from PostOffice handler by settings
  const MSG_Settings*     pMsg = pPO->POMessages->QueryMessage<MSG_Settings>(MsgId);

  ETG_TRACE_USR4(("Audio settings Observer received Stream: 0x%4x.", pMsg->enStream));
  ETG_TRACE_USR4(("Audio settings Observer received type: 0x%4x."  , pMsg->enSettingType));
  ETG_TRACE_USR4(("Audio settings Observer received Steps: 0x%4x." , pMsg->s16Steps));

  //Deliver message to vd_adr3Msg_If::vSendAdr3Msg
  oMsgOut.u8InstId   = VD_ADR3_INST_ID_LS_1;
  oMsgOut.u16FktId   = VD_ADR3_FKT_ID_SETTINGS;
  oMsgOut.enOpType   = VD_ADR3_OPTYPE_SETGET;
  oMsgOut.u16MsgLen  = 4;
  pu8Payload[0]     = pMsg->enStream;
  pu8Payload[1]     = pMsg->enSettingType;
  AUD_SET_U16(&pu8Payload[2], pMsg->s16Steps);
  ETG_TRACE_USR4(("pu8Payload=0x%02x",ETG_LIST_LEN(oMsgOut.u16MsgLen), ETG_LIST_PTR_T8(pu8Payload)));

  switch(pMsg->enSettingType)
  {
  case EN_AUDIO_SETTINGS_BASS:
    oMsgOut.u8ThreadMessageType = SETTINGS_BASS;
    break;
  case EN_AUDIO_SETTINGS_TREBLE:
    oMsgOut.u8ThreadMessageType = SETTINGS_TREBLE;
    break;
  case EN_AUDIO_SETTINGS_BALANCE:
    oMsgOut.u8ThreadMessageType = SETTINGS_BALANCE;
    break;
  case EN_AUDIO_SETTINGS_FADER:
    oMsgOut.u8ThreadMessageType = SETTINGS_FADER;
    break;
  case EN_AUDIO_SETTINGS_SDVC:
    oMsgOut.u8ThreadMessageType = SETTINGS_SDVC;
    break;
  case EN_AUDIO_SETTINGS_MID:
    oMsgOut.u8ThreadMessageType = SETTINGS_MID;
    break;
  case EN_AUDIO_SETTINGS_LOUDNESS:
    oMsgOut.u8ThreadMessageType = SETTINGS_LOUDNESS;
    break;
  case EN_AUDIO_SETTINGS_EQUPRESET:
    oMsgOut.u8ThreadMessageType = SETTINGS_EQUPRESET;
    break;
  case EN_AUDIO_SETTINGS_DYNAMIC_COMPRESSION:
    oMsgOut.u8ThreadMessageType = SETTINGS_DYNAMIC_COMPRESSION;
    break;
  case EN_AUDIO_SETTINGS_OPTIMIZATION:
    //oMsgOut.u8ThreadMessageType = SETTINGS_OPTIMIZATION;
    //break;
    ETG_TRACE_USR4(("MessageNotification for optimization, not sending to ADR3, should be send to external amplifier !!!!"));
    return;
  default:
    ETG_TRACE_USR4(("!!! MessageNotification for undefined setting type. Will not be sent to ADR3   : 0x%4x.", pMsg->enSettingType));
    return;
  }

  vd_adr3Msg_If::vSendAdr3Msg(&oMsgOut);
}

